/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream.internal;

import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import ratpack.stream.internal.PushPublisher;
import ratpack.stream.internal.PushStream;

public class SimpleNonConcurrentPushPublisher<T>
implements PushPublisher<T> {
    private Subscriber<? super T> subscriber;
    private boolean cancelled;
    private final PushStream<T> pushStream = new PushStream<T>(){

        @Override
        public void push(T item) {
            if (SimpleNonConcurrentPushPublisher.this.subscriber != null && !SimpleNonConcurrentPushPublisher.this.cancelled) {
                SimpleNonConcurrentPushPublisher.this.subscriber.onNext(item);
            }
        }

        @Override
        public void complete() {
            if (SimpleNonConcurrentPushPublisher.this.subscriber != null && !SimpleNonConcurrentPushPublisher.this.cancelled) {
                SimpleNonConcurrentPushPublisher.this.subscriber.onComplete();
            }
        }

        @Override
        public void error(Throwable throwable) {
            if (SimpleNonConcurrentPushPublisher.this.subscriber != null && !SimpleNonConcurrentPushPublisher.this.cancelled) {
                SimpleNonConcurrentPushPublisher.this.subscriber.onComplete();
            }
        }
    };

    public void subscribe(Subscriber<? super T> subscriber) {
        if (this.subscriber == null) {
            this.subscriber = subscriber;
            subscriber.onSubscribe(new Subscription(){

                public void request(long n) {
                }

                public void cancel() {
                    SimpleNonConcurrentPushPublisher.this.cancelled = true;
                }
            });
        } else {
            subscriber.onError((Throwable)new IllegalStateException("publisher is single use"));
        }
    }

    @Override
    public PushStream<T> getStream() {
        return this.pushStream;
    }
}

