/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream.internal;

import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import ratpack.stream.TransformablePublisher;

public class MergingPublisher<T>
implements TransformablePublisher<T> {
    private final ConcurrentLinkedDeque<Publisher<? extends T>> upstreamPublishers = new ConcurrentLinkedDeque();
    private final ConcurrentLinkedDeque<Subscription> upstreamPublisherSubscriptions = new ConcurrentLinkedDeque();
    private Subscriber<? super T> downstreamSubscriber;

    @SafeVarargs
    public MergingPublisher(Publisher<? extends T> ... publishers) {
        if (publishers.length < 2) {
            throw new IllegalArgumentException("At least 2 publishers must be supplied to merge");
        }
        for (Publisher<? extends T> publisher : publishers) {
            this.upstreamPublishers.add(publisher);
        }
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        this.downstreamSubscriber = subscriber;
        for (final Publisher<? extends T> publisher : this.upstreamPublishers) {
            publisher.subscribe(new Subscriber<T>(){
                final AtomicBoolean finished = new AtomicBoolean();
                Subscription subscription;

                public void onSubscribe(Subscription s) {
                    this.subscription = s;
                    MergingPublisher.this.upstreamPublisherSubscriptions.add(s);
                }

                public void onNext(T t) {
                    MergingPublisher.this.downstreamSubscriber.onNext(t);
                }

                public void onError(Throwable t) {
                    if (this.finished.compareAndSet(false, true)) {
                        MergingPublisher.this.upstreamPublisherSubscriptions.stream().filter(upstreamPublisherSubscription -> upstreamPublisherSubscription != this.subscription).forEach(Subscription::cancel);
                        MergingPublisher.this.upstreamPublisherSubscriptions.clear();
                        MergingPublisher.this.upstreamPublishers.clear();
                        MergingPublisher.this.downstreamSubscriber.onError(t);
                    }
                }

                public void onComplete() {
                    if (this.finished.compareAndSet(false, true)) {
                        MergingPublisher.this.upstreamPublishers.remove(publisher);
                        MergingPublisher.this.upstreamPublisherSubscriptions.remove(this.subscription);
                        MergingPublisher.this.tryComplete();
                    }
                }
            });
        }
        subscriber.onSubscribe(new Subscription(){

            public void request(long n) {
                for (Subscription upstreamPublisherSubscription : MergingPublisher.this.upstreamPublisherSubscriptions) {
                    upstreamPublisherSubscription.request(n);
                }
            }

            public void cancel() {
                for (Subscription upstreamPublisherSubscription : MergingPublisher.this.upstreamPublisherSubscriptions) {
                    upstreamPublisherSubscription.cancel();
                    MergingPublisher.this.upstreamPublisherSubscriptions.remove(this);
                }
                MergingPublisher.this.upstreamPublishers.clear();
                MergingPublisher.this.downstreamSubscriber = null;
            }
        });
    }

    private void tryComplete() {
        if (this.upstreamPublishers.isEmpty()) {
            this.downstreamSubscriber.onComplete();
        }
    }
}

