/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.ArrayList;
import java.util.List;
import ratpack.exec.Downstream;
import ratpack.exec.Promise;
import ratpack.func.Block;
import ratpack.http.RequestBodyAlreadyReadException;
import ratpack.server.internal.DefaultResponseTransmitter;
import ratpack.server.internal.RequestBodyAccumulator;
import ratpack.server.internal.RequestBodyReader;

public class RequestBody
implements RequestBodyReader,
RequestBodyAccumulator {
    private final List<ByteBuf> byteBufs = new ArrayList<ByteBuf>();
    private final long advertisedLength;
    private final ChannelHandlerContext ctx;
    private boolean read;
    private boolean done;
    private long maxContentLength = -1L;
    private Block onTooLarge;
    private int length;
    private Downstream<? super ByteBuf> downstream;
    private ByteBuf compositeBuffer;

    public RequestBody(long advertisedLength, ChannelHandlerContext ctx) {
        this.advertisedLength = advertisedLength;
        this.ctx = ctx;
    }

    @Override
    public void add(HttpContent httpContent) {
        if (httpContent != LastHttpContent.EMPTY_LAST_CONTENT) {
            ByteBuf byteBuf = httpContent.content();
            this.length += byteBuf.readableBytes();
            if (this.maxContentLength > 0L && this.maxContentLength < (long)this.length) {
                assert (this.downstream != null);
                this.tooLarge(this.downstream);
                return;
            }
            this.byteBufs.add(byteBuf);
        }
        if (httpContent instanceof LastHttpContent) {
            this.done = true;
            if (this.downstream != null) {
                this.complete(this.downstream);
            }
        } else if (this.downstream != null) {
            this.ctx.read();
        }
    }

    @Override
    public boolean isComplete() {
        return this.done;
    }

    @Override
    public void close() {
        if (this.compositeBuffer == null) {
            for (ByteBuf byteBuf : this.byteBufs) {
                byteBuf.release();
            }
            this.byteBufs.clear();
        } else if (this.compositeBuffer.refCnt() > 0) {
            this.compositeBuffer.release();
        }
    }

    private void tooLarge(Downstream<? super ByteBuf> downstream) {
        this.close();
        try {
            ((DefaultResponseTransmitter)this.ctx.attr(DefaultResponseTransmitter.ATTRIBUTE_KEY).get()).forceCloseConnection();
            this.onTooLarge.execute();
            downstream.complete();
        }
        catch (Throwable t) {
            downstream.error(t);
        }
    }

    private void complete(Downstream<? super ByteBuf> downstream) {
        if (this.byteBufs.isEmpty()) {
            downstream.success((ByteBuf)Unpooled.EMPTY_BUFFER);
        } else {
            ByteBuf[] byteBufsArray = this.byteBufs.toArray(new ByteBuf[this.byteBufs.size()]);
            this.byteBufs.clear();
            this.compositeBuffer = Unpooled.unmodifiableBuffer((ByteBuf[])byteBufsArray);
            downstream.success((ByteBuf)this.compositeBuffer);
        }
    }

    @Override
    public Promise<ByteBuf> read(long maxContentLength, Block onTooLarge) {
        return Promise.of(downstream -> {
            if (this.read) {
                downstream.error(new RequestBodyAlreadyReadException());
                return;
            }
            this.read = true;
            this.onTooLarge = onTooLarge;
            if (this.advertisedLength > maxContentLength || (long)this.length > maxContentLength) {
                this.tooLarge(downstream);
            } else if (this.done) {
                this.complete(downstream);
            } else {
                this.maxContentLength = maxContentLength;
                this.downstream = downstream;
                this.ctx.read();
            }
        });
    }
}

