/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;
import ratpack.registry.Registry;
import ratpack.server.RatpackServerSpec;
import ratpack.server.ServerConfig;

public final class RatpackServerDefinition {
    private final ServerConfig serverConfig;
    private final Function<? super Registry, ? extends Registry> registry;
    private final Function<? super Registry, ? extends Handler> handler;

    private RatpackServerDefinition(ServerConfig serverConfig, Function<? super Registry, ? extends Registry> registry, Function<? super Registry, ? extends Handler> handler) {
        this.serverConfig = serverConfig;
        this.registry = registry;
        this.handler = handler;
    }

    public static RatpackServerDefinition build(Action<? super RatpackServerSpec> config) throws Exception {
        SpecImpl spec = new SpecImpl();
        config.execute(spec);
        return new RatpackServerDefinition(spec.serverConfig, spec.registry, spec.handler);
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public Function<? super Registry, ? extends Registry> getRegistry() {
        return this.registry;
    }

    public Function<? super Registry, ? extends Handler> getHandler() {
        return this.handler;
    }

    private static class SpecImpl
    implements RatpackServerSpec {
        private ServerConfig serverConfig = ServerConfig.builder().build();
        private Function<? super Registry, ? extends Registry> registry = r -> Registry.empty();
        private Function<? super Registry, ? extends Handler> handler = r -> Handlers.notFound();

        private SpecImpl() {
        }

        @Override
        public RatpackServerSpec registry(Function<? super Registry, ? extends Registry> registry) {
            this.registry = registry;
            return this;
        }

        @Override
        public RatpackServerSpec serverConfig(ServerConfig serverConfig) {
            this.serverConfig = serverConfig;
            return this;
        }

        @Override
        public RatpackServerSpec handler(Function<? super Registry, ? extends Handler> handlerFactory) {
            this.handler = handlerFactory;
            return this;
        }
    }
}

