/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.exec.ExecController;
import ratpack.func.Action;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;
import ratpack.handling.internal.ChainHandler;
import ratpack.handling.internal.DefaultContext;
import ratpack.handling.internal.DescribingHandler;
import ratpack.handling.internal.DescribingHandlers;
import ratpack.http.internal.DefaultRequest;
import ratpack.http.internal.DefaultResponse;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.http.internal.NettyHeadersBackedHeaders;
import ratpack.http.internal.NettyHeadersBackedMutableHeaders;
import ratpack.registry.Registry;
import ratpack.render.internal.DefaultRenderController;
import ratpack.server.ServerConfig;
import ratpack.server.internal.DefaultResponseTransmitter;
import ratpack.server.internal.RequestBody;
import ratpack.server.internal.RequestBodyAccumulator;

@ChannelHandler.Sharable
public class NettyHandlerAdapter
extends ChannelInboundHandlerAdapter {
    private static final AttributeKey<Action<Object>> CHANNEL_SUBSCRIBER_ATTRIBUTE_KEY = AttributeKey.valueOf((String)"ratpack.subscriber");
    private static final AttributeKey<RequestBodyAccumulator> BODY_ACCUMULATOR_KEY = AttributeKey.valueOf((String)RequestBodyAccumulator.class.getName());
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyHandlerAdapter.class);
    private final Handler[] handlers;
    private final DefaultContext.ApplicationConstants applicationConstants;
    private final Registry serverRegistry;
    private final boolean development;

    public NettyHandlerAdapter(Registry serverRegistry, Handler handler) throws Exception {
        this.handlers = ChainHandler.unpack(handler);
        this.serverRegistry = serverRegistry;
        this.applicationConstants = new DefaultContext.ApplicationConstants(this.serverRegistry, new DefaultRenderController(), serverRegistry.get(ExecController.class), Handlers.notFound());
        this.development = serverRegistry.get(ServerConfig.class).isDevelopment();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
        super.channelActive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            this.newRequest(ctx, (HttpRequest)msg);
        } else if (msg instanceof HttpContent) {
            RequestBodyAccumulator bodyAccumulator = (RequestBodyAccumulator)ctx.attr(BODY_ACCUMULATOR_KEY).get();
            if (bodyAccumulator != null) {
                bodyAccumulator.add((HttpContent)msg);
            }
            if (msg instanceof LastHttpContent) {
                ctx.read();
            }
        } else {
            Action subscriber = (Action)ctx.attr(CHANNEL_SUBSCRIBER_ATTRIBUTE_KEY).get();
            if (subscriber == null) {
                super.channelRead(ctx, msg);
            } else {
                subscriber.execute(msg);
            }
        }
    }

    private void newRequest(ChannelHandlerContext ctx, HttpRequest nettyRequest) throws Exception {
        RequestBody requestBody;
        if (!nettyRequest.decoderResult().isSuccess()) {
            NettyHandlerAdapter.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        if (HttpUtil.is100ContinueExpected((HttpMessage)nettyRequest)) {
            DefaultFullHttpResponse continueResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);
            ChannelFutureListener listener = future -> {
                if (!future.isSuccess()) {
                    ctx.fireExceptionCaught(future.cause());
                }
            };
            ctx.writeAndFlush((Object)continueResponse).addListener((GenericFutureListener)listener);
            ctx.read();
            return;
        }
        RequestBody requestBody2 = requestBody = NettyHandlerAdapter.canHaveBody(nettyRequest.method()) ? new RequestBody(HttpUtil.getContentLength((HttpMessage)nettyRequest, (int)-1), ctx) : null;
        if (requestBody != null) {
            ctx.attr(BODY_ACCUMULATOR_KEY).set((Object)requestBody);
        }
        Channel channel = ctx.channel();
        InetSocketAddress remoteAddress = (InetSocketAddress)channel.remoteAddress();
        InetSocketAddress socketAddress = (InetSocketAddress)channel.localAddress();
        DefaultRequest request = new DefaultRequest(Instant.now(), new NettyHeadersBackedHeaders(nettyRequest.headers()), nettyRequest.method(), nettyRequest.protocolVersion(), nettyRequest.uri(), remoteAddress, socketAddress, this.serverRegistry.get(ServerConfig.class), requestBody);
        DefaultHttpHeaders nettyHeaders = new DefaultHttpHeaders(false);
        NettyHeadersBackedMutableHeaders responseHeaders = new NettyHeadersBackedMutableHeaders((HttpHeaders)nettyHeaders);
        AtomicBoolean transmitted = new AtomicBoolean(false);
        DefaultResponseTransmitter responseTransmitter = new DefaultResponseTransmitter(transmitted, channel, nettyRequest, request, (HttpHeaders)nettyHeaders, requestBody);
        ctx.attr(DefaultResponseTransmitter.ATTRIBUTE_KEY).set((Object)responseTransmitter);
        Action<Action<Object>> subscribeHandler = thing -> {
            transmitted.set(true);
            ctx.attr(CHANNEL_SUBSCRIBER_ATTRIBUTE_KEY).set(thing);
        };
        DefaultContext.RequestConstants requestConstants = new DefaultContext.RequestConstants(this.applicationConstants, request, channel, responseTransmitter, subscribeHandler);
        DefaultResponse response = new DefaultResponse(responseHeaders, ctx.alloc(), responseTransmitter);
        requestConstants.response = response;
        DefaultContext.start(channel.eventLoop(), requestConstants, this.serverRegistry, this.handlers, execution -> {
            if (requestBody != null) {
                requestBody.close();
            }
            channel.attr(BODY_ACCUMULATOR_KEY).remove();
            if (!transmitted.get()) {
                ByteBuf body;
                Handler lastHandler = requestConstants.handler;
                StringBuilder description = new StringBuilder();
                description.append("No response sent for ").append(request.getMethod().getName()).append(" request to ").append(request.getUri());
                if (lastHandler != null) {
                    description.append(" (last handler: ");
                    if (lastHandler instanceof DescribingHandler) {
                        ((DescribingHandler)lastHandler).describeTo(description);
                    } else {
                        DescribingHandlers.describeTo(lastHandler, description);
                    }
                    description.append(")");
                }
                String message = description.toString();
                LOGGER.warn(message);
                response.getHeaders().clear();
                if (this.development) {
                    CharBuffer charBuffer = CharBuffer.wrap(message);
                    body = ByteBufUtil.encodeString((ByteBufAllocator)ctx.alloc(), (CharBuffer)charBuffer, (Charset)CharsetUtil.UTF_8);
                    response.contentType(HttpHeaderConstants.PLAIN_TEXT_UTF8);
                } else {
                    body = Unpooled.EMPTY_BUFFER;
                }
                response.getHeaders().set(HttpHeaderConstants.CONTENT_LENGTH, body.readableBytes());
                responseTransmitter.transmit(HttpResponseStatus.INTERNAL_SERVER_ERROR, body);
            }
        });
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!this.isIgnorableException(cause)) {
            LOGGER.error("", cause);
            if (ctx.channel().isActive()) {
                NettyHandlerAdapter.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
        }
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        ((DefaultResponseTransmitter)ctx.attr(DefaultResponseTransmitter.ATTRIBUTE_KEY).get()).writabilityChanged();
    }

    private boolean isIgnorableException(Throwable throwable) {
        return throwable instanceof IOException && throwable.getMessage().endsWith("Connection reset by peer");
    }

    public static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)("Failure: " + status.toString() + "\r\n"), (Charset)CharsetUtil.UTF_8));
        response.headers().set(HttpHeaderConstants.CONTENT_TYPE, (Object)HttpHeaderConstants.PLAIN_TEXT_UTF8);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static boolean canHaveBody(HttpMethod method) {
        return method == HttpMethod.POST || method == HttpMethod.PUT || method == HttpMethod.PATCH;
    }
}

