/*
 * Decompiled with CFR 0.152.
 */
package ratpack.render;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import ratpack.render.RenderableDecorator;
import ratpack.util.Types;
import ratpack.util.internal.InternalRatpackError;

public abstract class RenderableDecoratorSupport<T>
implements RenderableDecorator<T> {
    private final Class<T> type;

    protected RenderableDecoratorSupport() {
        TypeToken typeToken = new TypeToken<T>(this.getClass()){};
        Type type = typeToken.getType();
        if (type instanceof Class) {
            this.type = (Class)Types.cast(typeToken.getRawType());
        } else if (type instanceof ParameterizedType) {
            List<Type> typeArgs = Arrays.asList(((ParameterizedType)type).getActualTypeArguments());
            if (Iterables.any(typeArgs, (Predicate)Predicates.not(t -> t.getTypeName().equals("?")))) {
                throw new IllegalArgumentException("Invalid renderable type " + type + ": due to type erasure, type parameter T of RenderableDecorator must be a Class or a parameterized type with '?' for all type variables (e.g. List<?>)");
            }
            this.type = (Class)Types.cast(typeToken.getRawType());
        } else {
            throw new InternalRatpackError("Unhandled type for RenderableDecorator: " + type.getClass());
        }
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }
}

