/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling.internal;

import com.google.common.base.Joiner;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Map;
import ratpack.func.Block;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;
import ratpack.http.HttpMethod;
import ratpack.http.internal.HttpHeaderConstants;

public class MultiMethodHandler
implements Handler {
    private static final Handler NO_METHOD_HANDLER = Handlers.clientError(HttpResponseStatus.METHOD_NOT_ALLOWED.code());
    private final Map<String, Block> blocks;

    public MultiMethodHandler(Map<String, Block> blocks) {
        this.blocks = blocks;
    }

    @Override
    public void handle(Context context) throws Exception {
        HttpMethod method = context.getRequest().getMethod();
        if (method.isOptions()) {
            String methods = Joiner.on((String)",").join(this.blocks.keySet());
            context.getResponse().getHeaders().add(HttpHeaderConstants.ALLOW, methods);
            context.getResponse().status(200).send();
        } else {
            for (Map.Entry<String, Block> entry : this.blocks.entrySet()) {
                String key = entry.getKey();
                if (!method.name(key)) continue;
                entry.getValue().execute();
                return;
            }
            NO_METHOD_HANDLER.handle(context);
        }
    }
}

