/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file.internal;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import ratpack.file.BaseDirRequiredException;
import ratpack.file.FileSystemBinding;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.handling.internal.ChainHandler;
import ratpack.registry.Registry;
import ratpack.server.ServerConfig;
import ratpack.util.internal.BoundedConcurrentHashMap;

public class FileSystemBindingHandler
implements Handler {
    private final String path;
    private final Handler[] handler;
    private static final ConcurrentMap<FileSystemBinding, Registry> CACHE = new BoundedConcurrentHashMap<FileSystemBinding, Registry>(1024, Runtime.getRuntime().availableProcessors());

    public FileSystemBindingHandler(ServerConfig serverConfig, String path, Handler handler) {
        if (!serverConfig.isHasBaseDir()) {
            throw new BaseDirRequiredException("An application base directory is required to use this handler");
        }
        this.path = path;
        this.handler = ChainHandler.unpack(handler);
    }

    @Override
    public void handle(Context context) throws ExecutionException {
        FileSystemBinding parentBinding = context.get(FileSystemBinding.class);
        FileSystemBinding binding = parentBinding.binding(this.path);
        if (binding == null) {
            context.clientError(404);
        } else {
            context.insert(CACHE.computeIfAbsent(binding, FileSystemBindingHandler::registry), this.handler);
        }
    }

    private static Registry registry(FileSystemBinding binding) {
        return Registry.single(FileSystemBinding.class, binding);
    }
}

