/*
 * Decompiled with CFR 0.152.
 */
package ratpack.config.internal.source;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import ratpack.config.ConfigSource;
import ratpack.file.FileSystemBinding;
import ratpack.func.Function;
import ratpack.func.Pair;

public abstract class AbstractPropertiesConfigSource
implements ConfigSource {
    private final Optional<String> prefix;

    protected AbstractPropertiesConfigSource(Optional<String> prefix) {
        this.prefix = prefix;
    }

    protected abstract Properties loadProperties() throws Exception;

    @Override
    public ObjectNode loadConfigData(ObjectMapper objectMapper, FileSystemBinding fileSystemBinding) throws Exception {
        ObjectNode rootNode = objectMapper.createObjectNode();
        Properties properties = this.loadProperties();
        Stream<Pair> pairs = properties.stringPropertyNames().stream().map(key -> Pair.of(key, properties.getProperty((String)key)));
        if (this.prefix.isPresent()) {
            pairs = pairs.filter(p -> ((String)p.left).startsWith(this.prefix.get())).map(((Function<Pair, Pair>)p -> p.mapLeft(s -> s.substring(this.prefix.get().length()))).toFunction());
        }
        pairs.forEach(p -> this.populate(rootNode, (String)p.left, (String)p.right));
        return rootNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void populate(ObjectNode node, String key, String value) {
        boolean hasIndexing;
        int nextDot = key.indexOf(46);
        int nextOpenBracket = key.indexOf(91);
        boolean hasDelimiter = nextDot != -1;
        boolean bl = hasIndexing = nextOpenBracket != -1;
        if (hasDelimiter && (!hasIndexing || nextDot < nextOpenBracket)) {
            String fieldName = key.substring(0, nextDot);
            String remainingKey = key.substring(nextDot + 1);
            ObjectNode childNode = (ObjectNode)node.get(fieldName);
            if (childNode == null) {
                childNode = node.putObject(fieldName);
            }
            this.populate(childNode, remainingKey, value);
            return;
        } else if (hasIndexing) {
            int nextCloseBracket = key.indexOf(93, nextOpenBracket + 1);
            if (nextCloseBracket == -1) {
                throw new IllegalArgumentException("Invalid remaining key: " + key);
            }
            String fieldName = key.substring(0, nextOpenBracket);
            int index = Integer.valueOf(key.substring(nextOpenBracket + 1, nextCloseBracket));
            String remainingKey = key.substring(nextCloseBracket + 1);
            ArrayNode arrayNode = (ArrayNode)node.get(fieldName);
            if (arrayNode == null) {
                arrayNode = node.putArray(fieldName);
            }
            AbstractPropertiesConfigSource.padToLength(arrayNode, index + 1);
            if (remainingKey.isEmpty()) {
                arrayNode.set(index, (JsonNode)TextNode.valueOf((String)value));
                return;
            } else {
                ObjectNode childNode;
                if (!remainingKey.startsWith(".")) throw new IllegalArgumentException("Unknown key format: " + key);
                remainingKey = remainingKey.substring(1);
                if (arrayNode.hasNonNull(index)) {
                    childNode = (ObjectNode)arrayNode.get(index);
                } else {
                    childNode = arrayNode.objectNode();
                    arrayNode.set(index, (JsonNode)childNode);
                }
                this.populate(childNode, remainingKey, value);
            }
            return;
        } else {
            node.set(key, (JsonNode)TextNode.valueOf((String)value));
        }
    }

    private static void padToLength(ArrayNode arrayNode, int length) {
        while (arrayNode.size() < length) {
            arrayNode.addNull();
        }
    }
}

