/*
 * Decompiled with CFR 0.152.
 */
package ratpack.config.internal.module;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import ratpack.ssl.SSLContexts;
import ratpack.util.Exceptions;

public class SSLContextDeserializer
extends JsonDeserializer<SSLContext> {
    public SSLContext deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectNode node = (ObjectNode)jp.readValueAsTree();
        try {
            String keyStoreFile = node.path("keystoreFile").asText();
            String keyStorePassword = node.path("keystorePassword").asText();
            return SSLContexts.sslContext(Paths.get(keyStoreFile, new String[0]), keyStorePassword);
        }
        catch (GeneralSecurityException ex) {
            throw Exceptions.uncheck(ex);
        }
    }
}

