/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.exportchooser;

import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.exportchooser.AbstractExportFileType;

public class ImageExportFileType
extends AbstractExportFileType {
    protected String format;
    protected ImageWriterSpi spi;
    protected ImageWriteParam param;

    protected ImageExportFileType(String format) {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(format);
        if (iterator.hasNext()) {
            ImageWriter writer = iterator.next();
            this.format = format;
            this.spi = writer.getOriginatingProvider();
            this.param = writer.getDefaultWriteParam();
            return;
        }
        throw new IllegalArgumentException(this.getClass() + ": Format not valid: " + format);
    }

    public ImageExportFileType(ImageWriterSpi spi) {
        this.format = spi.getFormatNames()[0];
        this.spi = spi;
        try {
            this.param = spi.createWriterInstance().getDefaultWriteParam();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create Writer instance", e);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ImageExportFileType) {
            ImageExportFileType type = (ImageExportFileType)obj;
            return this.spi.getClass().equals(type.spi.getClass());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.spi.getClass().hashCode();
    }

    public static ImageExportFileType getInstance(String format) {
        if ((format = format.toLowerCase()).equals("GIF".toLowerCase())) {
            return ImageExportFileType.exportFileType("org.freehep.graphicsio.gif.GIFExportFileType");
        }
        if (format.equals("PNG".toLowerCase())) {
            return ImageExportFileType.exportFileType("org.freehep.graphicsio.png.PNGExportFileType");
        }
        if (format.equals("JPG".toLowerCase())) {
            return ImageExportFileType.exportFileType("org.freehep.graphicsio.jpg.JPGExportFileType");
        }
        if (format.equals("RAW".toLowerCase())) {
            return ImageExportFileType.exportFileType("org.freehep.graphicsio.raw.RawExportFileType");
        }
        if (format.equals("BMP".toLowerCase())) {
            return ImageExportFileType.exportFileType("org.freehep.graphicsio.bmp.BMPExportFileType");
        }
        if (format.equals("WBMP".toLowerCase())) {
            return ImageExportFileType.exportFileType("org.freehep.graphicsio.wbmp.WBMPExportFileType");
        }
        return null;
    }

    private static ImageExportFileType exportFileType(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (ImageExportFileType)clazz.newInstance();
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public String getDescription() {
        return this.spi.getDescription(Locale.getDefault());
    }

    public String[] getExtensions() {
        return this.spi.getFileSuffixes();
    }

    public String[] getMIMETypes() {
        return this.spi.getMIMETypes();
    }

    public boolean hasOptionPanel() {
        return true;
    }

    public JPanel createOptionPanel(Properties user) {
        return new JPanel();
    }

    public VectorGraphics getGraphics(OutputStream os, Component target) throws IOException {
        return new ImageGraphics2D(os, target, this.format);
    }

    public VectorGraphics getGraphics(OutputStream os, Dimension dimension) throws IOException {
        return new ImageGraphics2D(os, dimension, this.format);
    }

    public String toString() {
        return super.toString() + " for " + this.format + " using " + this.spi;
    }
}

