/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.titledtab;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.PanelUI;
import net.infonode.gui.DimensionProvider;
import net.infonode.gui.InsetsUtil;
import net.infonode.gui.RotatableLabel;
import net.infonode.gui.TranslatingShape;
import net.infonode.gui.border.FocusBorder;
import net.infonode.gui.hover.HoverEvent;
import net.infonode.gui.hover.HoverListener;
import net.infonode.gui.hover.hoverable.HoverManager;
import net.infonode.gui.hover.hoverable.Hoverable;
import net.infonode.gui.icon.IconProvider;
import net.infonode.gui.layout.StackableLayout;
import net.infonode.gui.panel.SimplePanel;
import net.infonode.gui.shaped.panel.ShapedPanel;
import net.infonode.properties.base.Property;
import net.infonode.properties.gui.InternalPropertiesUtil;
import net.infonode.properties.gui.util.ComponentProperties;
import net.infonode.properties.gui.util.ShapedPanelProperties;
import net.infonode.properties.propertymap.PropertyMapTreeListener;
import net.infonode.properties.propertymap.PropertyMapWeakListenerManager;
import net.infonode.properties.util.PropertyChangeListener;
import net.infonode.tabbedpanel.Tab;
import net.infonode.tabbedpanel.TabAdapter;
import net.infonode.tabbedpanel.TabEvent;
import net.infonode.tabbedpanel.TabRemovedEvent;
import net.infonode.tabbedpanel.TabSelectTrigger;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.TabbedUtils;
import net.infonode.tabbedpanel.titledtab.TitledTabBorderSizePolicy;
import net.infonode.tabbedpanel.titledtab.TitledTabProperties;
import net.infonode.tabbedpanel.titledtab.TitledTabSizePolicy;
import net.infonode.tabbedpanel.titledtab.TitledTabStateProperties;
import net.infonode.util.Alignment;
import net.infonode.util.Direction;
import net.infonode.util.ValueChange;

public class TitledTab
extends Tab
implements IconProvider {
    private static PanelUI UI = new PanelUI(){};
    private final TitledTabProperties properties = TitledTabProperties.getDefaultProperties();
    private HoverListener hoverListener = this.properties.getHoverListener();
    private final HoverablePanel eventPanel = new HoverablePanel((LayoutManager)new BorderLayout()){

        @Override
        public boolean contains(int x, int y) {
            return this.getComponentCount() > 0 && this.getComponent(0).contains(x, y);
        }

        @Override
        public boolean inside(int x, int y) {
            return this.getComponentCount() > 0 && this.getComponent(0).inside(x, y);
        }
    };
    private final StatePanel normalStatePanel;
    private final StatePanel highlightedStatePanel;
    private final StatePanel disabledStatePanel;
    private ArrayList mouseListeners;
    private ArrayList mouseMotionListeners;
    private final StackableLayout layout;
    private StatePanel currentStatePanel;
    private final FocusBorder focusBorder;
    private Direction lastTabAreaOrientation = Direction.UP;
    private final PropertyMapTreeListener propertiesListener = new PropertyMapTreeListener(){

        @Override
        public void propertyValuesChanged(Map changes) {
            TitledTab.this.doUpdateTab(changes);
        }
    };
    private final PropertyChangeListener tabbedPanelPropertiesListener = new PropertyChangeListener(){

        @Override
        public void propertyChanged(Property property, Object valueContainer, Object oldValue, Object newValue) {
            TitledTab.this.updateTabAreaOrientation((Direction)newValue);
        }
    };

    @Override
    public boolean contains(int x, int y) {
        Point p = SwingUtilities.convertPoint(this, new Point(x, y), this.eventPanel);
        return this.eventPanel.contains(p.x, p.y);
    }

    @Override
    public boolean inside(int x, int y) {
        Point p = SwingUtilities.convertPoint(this, new Point(x, y), this.eventPanel);
        return this.eventPanel.inside(p.x, p.y);
    }

    public TitledTab(String text, Icon icon, JComponent contentComponent, JComponent titleComponent) {
        super(contentComponent);
        super.setOpaque(false);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                TitledTab.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                TitledTab.this.repaint();
            }
        });
        this.focusBorder = new FocusBorder(this);
        this.normalStatePanel = new StatePanel(this.focusBorder);
        this.highlightedStatePanel = new StatePanel(this.focusBorder);
        this.disabledStatePanel = new StatePanel(this.focusBorder);
        this.layout = new StackableLayout(this){

            @Override
            public void layoutContainer(Container parent) {
                super.layoutContainer(parent);
                StatePanel visibleStatePanel = (StatePanel)this.getVisibleComponent();
                visibleStatePanel.activateTitleComponent();
            }
        };
        this.setLayout(this.layout);
        this.add(this.normalStatePanel);
        this.add(this.highlightedStatePanel);
        this.add(this.disabledStatePanel);
        this.setText(text);
        this.setIcon(icon);
        this.setTitleComponent(titleComponent);
        this.eventPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.updateFocus(TabSelectTrigger.MOUSE_PRESS);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.updateFocus(TabSelectTrigger.MOUSE_RELEASE);
            }

            private void updateFocus(TabSelectTrigger trigger) {
                if (TitledTab.this.isEnabled() && TitledTab.this.properties.getFocusable() && TitledTab.this.getTabbedPanel() != null && TitledTab.this.getTabbedPanel().getProperties().getTabSelectTrigger() == trigger) {
                    Component focusedComponent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    if (focusedComponent instanceof TitledTab && ((TitledTab)focusedComponent).getTabbedPanel() == TitledTab.this.getTabbedPanel()) {
                        TitledTab.this.requestFocusInWindow();
                    } else if (TitledTab.this.isSelected() || TabbedUtils.getParentTabbedPanel(focusedComponent) != TitledTab.this.getTabbedPanel()) {
                        TitledTab.this.requestFocusInWindow();
                    }
                }
            }
        });
        this.setEventComponent(this.eventPanel);
        MouseListener mouseListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (TitledTab.this.mouseListeners != null) {
                    MouseEvent event = TitledTab.this.convertMouseEvent(e);
                    Object[] l = TitledTab.this.mouseListeners.toArray();
                    int i = 0;
                    while (i < l.length) {
                        ((MouseListener)l[i]).mouseClicked(event);
                        ++i;
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (TitledTab.this.mouseListeners != null) {
                    MouseEvent event = TitledTab.this.convertMouseEvent(e);
                    Object[] l = TitledTab.this.mouseListeners.toArray();
                    int i = 0;
                    while (i < l.length) {
                        ((MouseListener)l[i]).mousePressed(event);
                        ++i;
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (TitledTab.this.mouseListeners != null) {
                    MouseEvent event = TitledTab.this.convertMouseEvent(e);
                    Object[] l = TitledTab.this.mouseListeners.toArray();
                    int i = 0;
                    while (i < l.length) {
                        ((MouseListener)l[i]).mouseReleased(event);
                        ++i;
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (TitledTab.this.mouseListeners != null) {
                    MouseEvent event = TitledTab.this.convertMouseEvent(e);
                    Object[] l = TitledTab.this.mouseListeners.toArray();
                    int i = 0;
                    while (i < l.length) {
                        ((MouseListener)l[i]).mouseEntered(event);
                        ++i;
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (TitledTab.this.mouseListeners != null) {
                    MouseEvent event = TitledTab.this.convertMouseEvent(e);
                    Object[] l = TitledTab.this.mouseListeners.toArray();
                    int i = 0;
                    while (i < l.length) {
                        ((MouseListener)l[i]).mouseExited(event);
                        ++i;
                    }
                }
            }
        };
        MouseMotionListener mouseMotionListener = new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (TitledTab.this.mouseMotionListeners != null) {
                    MouseEvent event = TitledTab.this.convertMouseEvent(e);
                    Object[] l = TitledTab.this.mouseMotionListeners.toArray();
                    int i = 0;
                    while (i < l.length) {
                        ((MouseMotionListener)l[i]).mouseDragged(event);
                        ++i;
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (TitledTab.this.mouseMotionListeners != null) {
                    MouseEvent event = TitledTab.this.convertMouseEvent(e);
                    Object[] l = TitledTab.this.mouseMotionListeners.toArray();
                    int i = 0;
                    while (i < l.length) {
                        ((MouseMotionListener)l[i]).mouseMoved(event);
                        ++i;
                    }
                }
            }
        };
        this.eventPanel.addMouseListener(mouseListener);
        this.eventPanel.addMouseMotionListener(mouseMotionListener);
        PropertyMapWeakListenerManager.addWeakTreeListener(this.properties.getMap(), this.propertiesListener);
        this.addTabListener(new TabAdapter(){

            @Override
            public void tabAdded(TabEvent event) {
                PropertyMapWeakListenerManager.addWeakPropertyChangeListener(TitledTab.this.getTabbedPanel().getProperties().getMap(), TabbedPanelProperties.TAB_AREA_ORIENTATION, TitledTab.this.tabbedPanelPropertiesListener);
                TitledTab.this.updateTabAreaOrientation(TitledTab.this.getTabbedPanel().getProperties().getTabAreaOrientation());
            }

            @Override
            public void tabRemoved(TabRemovedEvent event) {
                PropertyMapWeakListenerManager.removeWeakPropertyChangeListener(event.getTabbedPanel().getProperties().getMap(), TabbedPanelProperties.TAB_AREA_ORIENTATION, TitledTab.this.tabbedPanelPropertiesListener);
            }
        });
        this.doUpdateTab(null);
        this.updateCurrentStatePanel();
    }

    public JComponent getNormalStateTitleComponent() {
        return this.normalStatePanel.getTitleComponent();
    }

    public JComponent getHighlightedStateTitleComponent() {
        return this.highlightedStatePanel.getTitleComponent();
    }

    public JComponent getDisabledStateTitleComponent() {
        return this.disabledStatePanel.getTitleComponent();
    }

    public void setTitleComponent(JComponent titleComponent) {
        this.normalStatePanel.setTitleComponent(titleComponent, this.properties.getNormalProperties());
        this.highlightedStatePanel.setTitleComponent(titleComponent, this.properties.getHighlightedProperties());
        this.disabledStatePanel.setTitleComponent(titleComponent, this.properties.getDisabledProperties());
    }

    public void setNormalStateTitleComponent(JComponent titleComponent) {
        this.normalStatePanel.setTitleComponent(titleComponent, this.properties.getNormalProperties());
    }

    public void setHighlightedStateTitleComponent(JComponent titleComponent) {
        this.highlightedStatePanel.setTitleComponent(titleComponent, this.properties.getHighlightedProperties());
    }

    public void setDisabledStateTitleComponent(JComponent titleComponent) {
        this.disabledStatePanel.setTitleComponent(titleComponent, this.properties.getDisabledProperties());
    }

    @Override
    public void setHighlighted(boolean highlighted) {
        super.setHighlighted(highlighted);
        this.updateCurrentStatePanel();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateCurrentStatePanel();
    }

    public String getText() {
        return this.properties.getNormalProperties().getText();
    }

    public void setText(String text) {
        this.properties.getNormalProperties().setText(text);
    }

    @Override
    public Icon getIcon() {
        return this.properties.getNormalProperties().getIcon();
    }

    public void setIcon(Icon icon) {
        this.properties.getNormalProperties().setIcon(icon);
    }

    public TitledTabProperties getProperties() {
        return this.properties;
    }

    @Override
    public String toString() {
        return this.getText();
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        if (this.mouseListeners == null) {
            this.mouseListeners = new ArrayList(2);
        }
        this.mouseListeners.add(l);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener l) {
        if (this.mouseListeners != null) {
            this.mouseListeners.remove(l);
            if (this.mouseListeners.size() == 0) {
                this.mouseListeners = null;
            }
        }
    }

    @Override
    public synchronized MouseListener[] getMouseListeners() {
        MouseListener[] listeners = new MouseListener[]{};
        if (this.mouseListeners != null) {
            Object[] l = this.mouseListeners.toArray();
            listeners = new MouseListener[l.length];
            int i = 0;
            while (i < l.length) {
                listeners[i] = (MouseListener)l[i];
                ++i;
            }
        }
        return listeners;
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        if (this.mouseMotionListeners == null) {
            this.mouseMotionListeners = new ArrayList(2);
        }
        this.mouseMotionListeners.add(l);
    }

    @Override
    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        if (this.mouseMotionListeners != null) {
            this.mouseMotionListeners.remove(l);
            if (this.mouseMotionListeners.size() == 0) {
                this.mouseMotionListeners = null;
            }
        }
    }

    @Override
    public synchronized MouseMotionListener[] getMouseMotionListeners() {
        MouseMotionListener[] listeners = new MouseMotionListener[]{};
        if (this.mouseMotionListeners != null) {
            Object[] l = this.mouseMotionListeners.toArray();
            listeners = new MouseMotionListener[l.length];
            int i = 0;
            while (i < l.length) {
                listeners[i] = (MouseMotionListener)l[i];
                ++i;
            }
        }
        return listeners;
    }

    @Override
    public Shape getShape() {
        Shape shape = this.currentStatePanel.getShape();
        if (shape == null) {
            return null;
        }
        Point p = SwingUtilities.convertPoint(this.currentStatePanel, 0, 0, this);
        return new TranslatingShape(shape, p.x, p.y);
    }

    @Override
    protected void setTabbedPanel(TabbedPanel tabbedPanel) {
        if (tabbedPanel == null) {
            HoverManager.getInstance().removeHoverable(this.eventPanel);
        }
        super.setTabbedPanel(tabbedPanel);
        if (tabbedPanel != null) {
            HoverManager.getInstance().addHoverable(this.eventPanel);
        }
    }

    private Insets getBorderInsets(Border border) {
        return border == null ? InsetsUtil.EMPTY_INSETS : border.getBorderInsets(this);
    }

    private void updateBorders() {
        Direction tabAreaOrientation = this.getTabAreaOrientation();
        int raised = this.properties.getHighlightedRaised();
        Insets notRaised = InsetsUtil.setInset(InsetsUtil.EMPTY_INSETS, tabAreaOrientation, raised);
        EmptyBorder normalBorder = new EmptyBorder(notRaised);
        Insets maxInsets = this.properties.getBorderSizePolicy() == TitledTabBorderSizePolicy.INDIVIDUAL_SIZE ? null : InsetsUtil.max(this.getBorderInsets(this.properties.getNormalProperties().getComponentProperties().getBorder()), InsetsUtil.max(this.getBorderInsets(this.properties.getHighlightedProperties().getComponentProperties().getBorder()), this.getBorderInsets(this.properties.getDisabledProperties().getComponentProperties().getBorder())));
        Insets normalInsets = InsetsUtil.rotate(this.properties.getNormalProperties().getDirection(), this.properties.getNormalProperties().getComponentProperties().getInsets());
        Insets disabledInsets = InsetsUtil.rotate(this.properties.getDisabledProperties().getDirection(), this.properties.getDisabledProperties().getComponentProperties().getInsets());
        int edgeInset = Math.min(InsetsUtil.getInset(normalInsets, tabAreaOrientation.getOpposite()), InsetsUtil.getInset(disabledInsets, tabAreaOrientation.getOpposite()));
        int normalLowered = Math.min(edgeInset, raised);
        Border innerNormalBorder = this.getInnerBorder(this.properties.getNormalProperties(), tabAreaOrientation, -normalLowered, maxInsets);
        Border innerHighlightBorder = this.getInnerBorder(this.properties.getHighlightedProperties(), tabAreaOrientation, raised - normalLowered, maxInsets);
        Border innerDisabledBorder = this.getInnerBorder(this.properties.getDisabledProperties(), tabAreaOrientation, -normalLowered, maxInsets);
        this.normalStatePanel.setBorders(normalBorder, innerNormalBorder);
        this.highlightedStatePanel.setBorders(null, innerHighlightBorder);
        this.disabledStatePanel.setBorders(normalBorder, innerDisabledBorder);
    }

    private void doUpdateTab(Map changes) {
        boolean updateBorders = false;
        if (changes == null) {
            updateBorders = true;
            this.setFocusableComponent(this.properties.getFocusable() ? this : null);
            this.focusBorder.setEnabled(this.properties.getFocusMarkerEnabled());
            this.updateHoverListener(this.properties.getHoverListener());
            this.layout.setUseSelectedComponentSize(this.properties.getSizePolicy() == TitledTabSizePolicy.INDIVIDUAL_SIZE);
        } else {
            Map m = (Map)changes.get(this.properties.getMap());
            if (m != null) {
                Set keySet = m.keySet();
                if (keySet.contains(TitledTabProperties.FOCUSABLE)) {
                    this.setFocusableComponent(this.properties.getFocusable() ? this : null);
                }
                if (keySet.contains(TitledTabProperties.FOCUS_MARKER_ENABLED)) {
                    this.focusBorder.setEnabled(this.properties.getFocusMarkerEnabled());
                    this.currentStatePanel.getLabel().repaint();
                }
                if (keySet.contains(TitledTabProperties.HOVER_LISTENER)) {
                    this.updateHoverListener((HoverListener)((ValueChange)m.get(TitledTabProperties.HOVER_LISTENER)).getNewValue());
                }
                if (keySet.contains(TitledTabProperties.SIZE_POLICY)) {
                    this.layout.setUseSelectedComponentSize((TitledTabSizePolicy)((ValueChange)m.get(TitledTabProperties.SIZE_POLICY)).getNewValue() == TitledTabSizePolicy.INDIVIDUAL_SIZE);
                }
                if (keySet.contains(TitledTabProperties.HIGHLIGHTED_RAISED_AMOUNT) || keySet.contains(TitledTabProperties.BORDER_SIZE_POLICY)) {
                    updateBorders = true;
                }
                if (keySet.contains(TitledTabProperties.ENABLED)) {
                    this.doSetEnabled(this.properties.getEnabled());
                }
            }
        }
        updateBorders = this.normalStatePanel.updateState(changes, this.properties.getNormalProperties()) || updateBorders;
        updateBorders = this.highlightedStatePanel.updateState(changes, this.properties.getHighlightedProperties()) || updateBorders;
        boolean bl = updateBorders = this.disabledStatePanel.updateState(changes, this.properties.getDisabledProperties()) || updateBorders;
        if (updateBorders) {
            this.updateBorders();
        }
    }

    private void updateHoverListener(HoverListener newHoverListener) {
        HoverListener oldHoverListener = this.hoverListener;
        this.hoverListener = newHoverListener;
        if (HoverManager.getInstance().isHovered(this.eventPanel)) {
            if (oldHoverListener != null) {
                oldHoverListener.mouseExited(new HoverEvent(this));
            }
            if (this.hoverListener != null) {
                this.hoverListener.mouseEntered(new HoverEvent(this));
            }
        }
    }

    private Border getInnerBorder(TitledTabStateProperties properties, Direction tabOrientation, int raised, Insets maxInsets) {
        Direction tabDir = properties.getDirection();
        Insets insets = InsetsUtil.rotate(tabDir, properties.getComponentProperties().getInsets());
        if (maxInsets != null) {
            insets = InsetsUtil.add(insets, InsetsUtil.sub(maxInsets, this.getBorderInsets(properties.getComponentProperties().getBorder())));
        }
        Border border = properties.getComponentProperties().getBorder();
        EmptyBorder innerBorder = new EmptyBorder(InsetsUtil.add(insets, InsetsUtil.setInset(InsetsUtil.EMPTY_INSETS, tabOrientation.getOpposite(), raised)));
        return border == null ? innerBorder : new CompoundBorder(border, innerBorder);
    }

    private Direction getTabAreaOrientation() {
        return this.getTabbedPanel() == null ? this.lastTabAreaOrientation : this.getTabbedPanel().getProperties().getTabAreaOrientation();
    }

    private void updateTabAreaOrientation(Direction newDirection) {
        if (this.lastTabAreaOrientation != newDirection) {
            this.lastTabAreaOrientation = newDirection;
            this.updateBorders();
            this.normalStatePanel.updateShapedPanel(this.properties.getNormalProperties());
            this.highlightedStatePanel.updateShapedPanel(this.properties.getHighlightedProperties());
            this.disabledStatePanel.updateShapedPanel(this.properties.getDisabledProperties());
        }
    }

    private void updateCurrentStatePanel() {
        StatePanel newStatePanel = this.normalStatePanel;
        if (!this.isEnabled()) {
            newStatePanel = this.disabledStatePanel;
        } else if (this.isHighlighted()) {
            newStatePanel = this.highlightedStatePanel;
        }
        this.eventPanel.setToolTipText(newStatePanel.getToolTipText());
        if (this.currentStatePanel != newStatePanel) {
            if (this.currentStatePanel != null) {
                this.currentStatePanel.deactivate();
            }
            this.currentStatePanel = newStatePanel;
            this.currentStatePanel.activate();
        }
        this.layout.showComponent(this.currentStatePanel);
    }

    private MouseEvent convertMouseEvent(MouseEvent e) {
        Point p = SwingUtilities.convertPoint((JComponent)e.getSource(), e.getPoint(), this);
        return new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiers(), (int)p.getX(), (int)p.getY(), e.getClickCount(), !e.isConsumed() && e.isPopupTrigger(), e.getButton());
    }

    private void doSetEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateCurrentStatePanel();
    }

    @Override
    public void setUI(PanelUI ui) {
        if (this.getUI() != UI) {
            super.setUI(UI);
        }
    }

    @Override
    public void updateUI() {
        this.setUI(UI);
    }

    @Override
    public void setOpaque(boolean opaque) {
    }

    private class HoverablePanel
    extends SimplePanel
    implements Hoverable {
        public HoverablePanel(LayoutManager l) {
            super(l);
        }

        @Override
        public void hoverEnter() {
            if (TitledTab.this.hoverListener != null && TitledTab.this.getTabbedPanel() != null) {
                TitledTab.this.hoverListener.mouseEntered(new HoverEvent(TitledTab.this));
            }
        }

        @Override
        public void hoverExit() {
            if (TitledTab.this.hoverListener != null) {
                TitledTab.this.hoverListener.mouseExited(new HoverEvent(TitledTab.this));
            }
        }

        @Override
        public boolean acceptHover(ArrayList enterableHoverables) {
            return true;
        }
    }

    private class StatePanel
    extends SimplePanel {
        private final ShapedPanel panel;
        private final SimplePanel titleComponentPanel;
        private final RotatableLabel label;
        private JComponent titleComponent;
        private Direction currentLayoutDirection;
        private int currentLayoutGap;
        private Alignment currentLayoutAlignment;
        private String toolTipText;
        private Icon icon;

        public StatePanel(Border focusBorder) {
            super(new BorderLayout());
            this.panel = new ShapedPanel();
            this.titleComponentPanel = new SimplePanel();
            this.label = new RotatableLabel(null, null){

                @Override
                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    String text = this.getText();
                    Icon tmpIcon = this.getIcon();
                    if (text == null || tmpIcon == null) {
                        this.setText(" ");
                        this.setIcon(StatePanel.this.icon);
                        d = this.getDirection().isHorizontal() ? new Dimension(d.width, super.getPreferredSize().height) : new Dimension(super.getPreferredSize().width, d.height);
                        this.setText(text);
                        this.setIcon(tmpIcon);
                    }
                    return d;
                }
            };
            this.currentLayoutGap = -1;
            this.label.setBorder(focusBorder);
            this.label.setMinimumSize(new Dimension(0, 0));
            this.panel.add((Component)this.label, "Center");
            this.add((Component)this.panel, "Center");
        }

        @Override
        public String getToolTipText() {
            return this.toolTipText;
        }

        public JComponent getTitleComponent() {
            return this.titleComponent;
        }

        public Shape getShape() {
            return this.panel.getShape();
        }

        public JLabel getLabel() {
            return this.label;
        }

        public void setTitleComponent(JComponent titleComponent, TitledTabStateProperties stateProps) {
            JComponent oldTitleComponent = this.titleComponent;
            this.titleComponent = null;
            if (oldTitleComponent != null && oldTitleComponent.getParent() == this.titleComponentPanel) {
                this.titleComponentPanel.remove(oldTitleComponent);
            }
            this.titleComponent = titleComponent;
            this.updateLayout(stateProps, true);
        }

        public void activateTitleComponent() {
            if (this.titleComponent != null) {
                if (this.titleComponent.getParent() != this.titleComponentPanel) {
                    if (this.titleComponent.getParent() != null) {
                        this.titleComponent.getParent().remove(this.titleComponent);
                    }
                    this.titleComponentPanel.add((Component)this.titleComponent, "Center");
                }
            } else {
                this.titleComponentPanel.removeAll();
            }
        }

        public void activate() {
            this.remove(this.panel);
            TitledTab.this.eventPanel.add((Component)this.panel, "Center");
            this.add((Component)TitledTab.this.eventPanel, "Center");
        }

        public void deactivate() {
            this.remove(TitledTab.this.eventPanel);
            TitledTab.this.eventPanel.remove(this.panel);
            this.add((Component)this.panel, "Center");
        }

        @Override
        public Dimension getPreferredSize() {
            this.activateTitleComponent();
            return this.getAdjustedSize(super.getPreferredSize());
        }

        @Override
        public Dimension getMinimumSize() {
            this.activateTitleComponent();
            return this.getAdjustedSize(super.getMinimumSize());
        }

        @Override
        public Dimension getMaximumSize() {
            this.activateTitleComponent();
            return super.getMaximumSize();
        }

        private Dimension getAdjustedSize(Dimension d) {
            DimensionProvider prov = TitledTab.this.properties.getMinimumSizeProvider();
            if (prov == null) {
                return d;
            }
            Dimension min = TitledTab.this.properties.getMinimumSizeProvider().getDimension(this);
            if (min == null) {
                return d;
            }
            return new Dimension(Math.max(min.width, d.width), Math.max(min.height, d.height));
        }

        public JComponent getFocusableComponent() {
            return this.label;
        }

        private void updateLayout(TitledTabStateProperties stateProperties, boolean titleComponentChanged) {
            if (this.titleComponent != null && stateProperties.getTitleComponentVisible()) {
                Direction d = stateProperties.getDirection();
                int gap = stateProperties.getIconVisible() || stateProperties.getTextVisible() ? stateProperties.getTextTitleComponentGap() : 0;
                Alignment alignment = stateProperties.getTitleComponentTextRelativeAlignment();
                if (this.titleComponentPanel.getComponentCount() == 0 || this.titleComponentPanel.getComponentCount() > 0 && this.titleComponentPanel.getComponent(0) != this.titleComponent || titleComponentChanged || gap != this.currentLayoutGap || alignment != this.currentLayoutAlignment || d != this.currentLayoutDirection) {
                    titleComponentChanged = false;
                    this.currentLayoutDirection = d;
                    this.currentLayoutGap = gap;
                    this.currentLayoutAlignment = alignment;
                    this.panel.remove(this.titleComponentPanel);
                    if (d == Direction.UP) {
                        this.panel.add((Component)this.titleComponentPanel, alignment == Alignment.LEFT ? "South" : "North");
                        this.titleComponentPanel.setBorder(new EmptyBorder(alignment == Alignment.LEFT ? gap : 0, 0, alignment == Alignment.LEFT ? 0 : gap, 0));
                    } else if (d == Direction.LEFT) {
                        this.panel.add((Component)this.titleComponentPanel, alignment == Alignment.LEFT ? "East" : "West");
                        this.titleComponentPanel.setBorder(new EmptyBorder(0, alignment == Alignment.LEFT ? gap : 0, 0, alignment == Alignment.LEFT ? 0 : gap));
                    } else if (d == Direction.DOWN) {
                        this.panel.add((Component)this.titleComponentPanel, alignment == Alignment.LEFT ? "North" : "South");
                        this.titleComponentPanel.setBorder(new EmptyBorder(alignment == Alignment.LEFT ? 0 : gap, 0, alignment == Alignment.LEFT ? gap : 0, 0));
                    } else {
                        this.panel.add((Component)this.titleComponentPanel, alignment == Alignment.LEFT ? "West" : "East");
                        this.titleComponentPanel.setBorder(new EmptyBorder(0, alignment == Alignment.LEFT ? 0 : gap, 0, alignment == Alignment.LEFT ? gap : 0));
                    }
                    this.panel.revalidate();
                }
            } else {
                this.panel.remove(this.titleComponentPanel);
                this.titleComponentPanel.removeAll();
                this.panel.revalidate();
            }
        }

        public void updateShapedPanel(TitledTabStateProperties stateProperties) {
            Direction tabAreaOrientation = TitledTab.this.getTabAreaOrientation();
            ShapedPanelProperties shapedPanelProperties = stateProperties.getShapedPanelProperties();
            InternalPropertiesUtil.applyTo(shapedPanelProperties, this.panel, tabAreaOrientation.getNextCW());
            this.panel.setHorizontalFlip(tabAreaOrientation == Direction.DOWN || tabAreaOrientation == Direction.LEFT ? !shapedPanelProperties.getHorizontalFlip() : shapedPanelProperties.getHorizontalFlip());
        }

        public void setBorders(Border outerBorder, Border innerBorder) {
            this.setBorder(outerBorder);
            this.panel.setBorder(innerBorder);
        }

        public boolean updateState(Map changes, TitledTabStateProperties stateProperties) {
            boolean updateBorders = false;
            if (changes == null) {
                this.label.setText(stateProperties.getTextVisible() ? stateProperties.getText() : null);
                this.icon = stateProperties.getIcon();
                this.label.setIcon(stateProperties.getIconVisible() ? stateProperties.getIcon() : null);
                this.label.setIconTextGap(stateProperties.getIconTextGap());
                this.label.setDirection(stateProperties.getDirection());
                Alignment alignment = stateProperties.getIconTextRelativeAlignment();
                this.label.setHorizontalTextPosition(alignment == Alignment.LEFT ? 4 : 2);
                alignment = stateProperties.getHorizontalAlignment();
                this.label.setHorizontalAlignment(alignment == Alignment.LEFT ? 2 : (alignment == Alignment.CENTER ? 0 : 4));
                alignment = stateProperties.getVerticalAlignment();
                this.label.setVerticalAlignment(alignment == Alignment.TOP ? 1 : (alignment == Alignment.CENTER ? 0 : 3));
                String string = this.toolTipText = stateProperties.getToolTipEnabled() ? stateProperties.getToolTipText() : null;
                if (this.toolTipText != null && this.toolTipText.length() == 0) {
                    this.toolTipText = null;
                }
                if (TitledTab.this.currentStatePanel == this) {
                    TitledTab.this.eventPanel.setToolTipText(this.toolTipText);
                }
                this.updateLayout(stateProperties, true);
                ComponentProperties componentProperties = stateProperties.getComponentProperties();
                this.label.setFont(componentProperties.getFont());
                Color c = componentProperties.getForegroundColor();
                this.label.setForeground(c);
                this.setForeground(c);
                this.updateShapedPanel(stateProperties);
                updateBorders = true;
            } else {
                Set keySet;
                Map m = (Map)changes.get(stateProperties.getMap());
                if (m != null) {
                    Alignment alignment;
                    keySet = m.keySet();
                    if (keySet.contains(TitledTabStateProperties.TEXT) || keySet.contains(TitledTabStateProperties.TEXT_VISIBLE)) {
                        this.label.setText(stateProperties.getTextVisible() ? stateProperties.getText() : null);
                    }
                    if (keySet.contains(TitledTabStateProperties.ICON) || keySet.contains(TitledTabStateProperties.ICON_VISIBLE)) {
                        this.icon = stateProperties.getIcon();
                        this.label.setIcon(stateProperties.getIconVisible() ? stateProperties.getIcon() : null);
                    }
                    if (keySet.contains(TitledTabStateProperties.ICON_TEXT_GAP)) {
                        this.label.setIconTextGap((Integer)((ValueChange)m.get(TitledTabStateProperties.ICON_TEXT_GAP)).getNewValue());
                    }
                    if (keySet.contains(TitledTabStateProperties.ICON_TEXT_RELATIVE_ALIGNMENT)) {
                        alignment = (Alignment)((ValueChange)m.get(TitledTabStateProperties.ICON_TEXT_RELATIVE_ALIGNMENT)).getNewValue();
                        this.label.setHorizontalTextPosition(alignment == Alignment.LEFT ? 4 : 2);
                    }
                    if (keySet.contains(TitledTabStateProperties.HORIZONTAL_ALIGNMENT)) {
                        alignment = (Alignment)((ValueChange)m.get(TitledTabStateProperties.HORIZONTAL_ALIGNMENT)).getNewValue();
                        this.label.setHorizontalAlignment(alignment == Alignment.LEFT ? 2 : (alignment == Alignment.CENTER ? 0 : 4));
                    }
                    if (keySet.contains(TitledTabStateProperties.VERTICAL_ALIGNMENT)) {
                        alignment = (Alignment)((ValueChange)m.get(TitledTabStateProperties.VERTICAL_ALIGNMENT)).getNewValue();
                        this.label.setVerticalAlignment(alignment == Alignment.TOP ? 1 : (alignment == Alignment.CENTER ? 0 : 3));
                    }
                    if (keySet.contains(TitledTabStateProperties.TOOL_TIP_TEXT) || keySet.contains(TitledTabStateProperties.TOOL_TIP_ENABLED)) {
                        String string = this.toolTipText = stateProperties.getToolTipEnabled() ? stateProperties.getToolTipText() : null;
                        if (this.toolTipText != null && this.toolTipText.length() == 0) {
                            this.toolTipText = null;
                        }
                        if (TitledTab.this.currentStatePanel == this) {
                            TitledTab.this.eventPanel.setToolTipText(this.toolTipText);
                        }
                    }
                    if (keySet.contains(TitledTabStateProperties.DIRECTION) || keySet.contains(TitledTabStateProperties.TITLE_COMPONENT_TEXT_RELATIVE_ALIGNMENT) || keySet.contains(TitledTabStateProperties.TITLE_COMPONENT_VISIBLE) || keySet.contains(TitledTabStateProperties.TEXT_TITLE_COMPONENT_GAP) || keySet.contains(TitledTabStateProperties.ICON_VISIBLE) || keySet.contains(TitledTabStateProperties.TEXT_VISIBLE)) {
                        this.label.setDirection(stateProperties.getDirection());
                        this.updateLayout(stateProperties, keySet.contains(TitledTabStateProperties.TITLE_COMPONENT_VISIBLE));
                    }
                    if (keySet.contains(TitledTabStateProperties.DIRECTION)) {
                        updateBorders = true;
                    }
                }
                if ((m = (Map)changes.get(stateProperties.getComponentProperties().getMap())) != null) {
                    Color c;
                    keySet = m.keySet();
                    if (keySet.contains(ComponentProperties.FONT)) {
                        this.label.setFont((Font)((ValueChange)m.get(ComponentProperties.FONT)).getNewValue());
                    }
                    if (keySet.contains(ComponentProperties.FOREGROUND_COLOR)) {
                        c = (Color)((ValueChange)m.get(ComponentProperties.FOREGROUND_COLOR)).getNewValue();
                        this.label.setForeground(c);
                        this.setForeground(c);
                    }
                    if (keySet.contains(ComponentProperties.BACKGROUND_COLOR)) {
                        c = (Color)((ValueChange)m.get(ComponentProperties.BACKGROUND_COLOR)).getNewValue();
                        this.panel.setBackground(c);
                    }
                    if (keySet.contains(ComponentProperties.INSETS) || keySet.contains(ComponentProperties.BORDER)) {
                        updateBorders = true;
                    }
                }
                if ((m = (Map)changes.get(stateProperties.getShapedPanelProperties().getMap())) != null) {
                    this.updateShapedPanel(stateProperties);
                }
            }
            return updateBorders;
        }
    }
}

