/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.infonode.gui.ComponentPaintChecker;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.DimensionUtil;
import net.infonode.gui.EventUtil;
import net.infonode.gui.ScrollButtonBox;
import net.infonode.gui.draggable.DraggableComponent;
import net.infonode.gui.draggable.DraggableComponentBox;
import net.infonode.gui.draggable.DraggableComponentBoxEvent;
import net.infonode.gui.draggable.DraggableComponentBoxListener;
import net.infonode.gui.hover.HoverListener;
import net.infonode.gui.hover.panel.HoverableShapedPanel;
import net.infonode.gui.layout.DirectionLayout;
import net.infonode.gui.panel.BaseContainerUtil;
import net.infonode.gui.shaped.panel.ShapedPanel;
import net.infonode.properties.gui.InternalPropertiesUtil;
import net.infonode.properties.gui.util.ButtonProperties;
import net.infonode.properties.gui.util.ComponentProperties;
import net.infonode.properties.gui.util.ShapedPanelProperties;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapTreeListener;
import net.infonode.properties.propertymap.PropertyMapWeakListenerManager;
import net.infonode.tabbedpanel.Tab;
import net.infonode.tabbedpanel.TabAreaComponentsProperties;
import net.infonode.tabbedpanel.TabAreaProperties;
import net.infonode.tabbedpanel.TabAreaVisiblePolicy;
import net.infonode.tabbedpanel.TabContentPanel;
import net.infonode.tabbedpanel.TabDepthOrderPolicy;
import net.infonode.tabbedpanel.TabDragEvent;
import net.infonode.tabbedpanel.TabDropDownListVisiblePolicy;
import net.infonode.tabbedpanel.TabEvent;
import net.infonode.tabbedpanel.TabLayoutPolicy;
import net.infonode.tabbedpanel.TabListener;
import net.infonode.tabbedpanel.TabRemovedEvent;
import net.infonode.tabbedpanel.TabSelectTrigger;
import net.infonode.tabbedpanel.TabStateChangedEvent;
import net.infonode.tabbedpanel.TabbedPanelButtonProperties;
import net.infonode.tabbedpanel.TabbedPanelContentPanel;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.TabbedUIDefaults;
import net.infonode.tabbedpanel.internal.ShadowPainter;
import net.infonode.tabbedpanel.internal.TabDropDownList;
import net.infonode.tabbedpanel.internal.TabbedHoverUtil;
import net.infonode.util.Direction;
import net.infonode.util.ValueChange;

public class TabbedPanel
extends JPanel {
    private int shadowSize = 4;
    private ComponentPaintChecker shadowRepaintChecker;
    private TabDropDownList dropDownList;
    private JComponent contentPanel;
    private JComponent[] tabAreaComponents;
    private Direction tabAreaOrientation;
    private TabDropDownListVisiblePolicy listVisiblePolicy = TabDropDownListVisiblePolicy.NEVER;
    private TabLayoutPolicy listTabLayoutPolicy = TabLayoutPolicy.SCROLLING;
    private DraggableComponentBox draggableComponentBox = new DraggableComponentBox(TabbedUIDefaults.getButtonIconSize(), false);
    private ArrayList listeners;
    private TabbedPanelProperties properties = new TabbedPanelProperties(TabbedPanelProperties.getDefaultProperties());
    private Tab highlightedTab;
    private boolean settingHighlighted;
    private boolean mouseEntered = false;
    private boolean removingSelected = false;
    private TabAreaVisiblePolicy areaVisiblePolicy = TabAreaVisiblePolicy.ALWAYS;
    private ShadowPanel componentsPanel = new ShadowPanel();
    private ScrollButtonBox scrollButtonBox;
    private GridBagConstraints constraints = new GridBagConstraints();
    private GridBagLayout tabAreaLayoutManager = new GridBagLayout(){

        @Override
        public void layoutContainer(Container parent) {
            TabbedPanel.this.setTabAreaComponentsButtonsVisible();
            super.layoutContainer(parent);
            if (TabbedPanel.this.tabAreaComponentsPanel.isVisible()) {
                if (TabbedPanel.this.tabAreaOrientation.isHorizontal()) {
                    if ((double)TabbedPanel.this.tabAreaContainer.getHeight() < TabbedPanel.this.tabAreaComponentsPanel.getPreferredSize().getHeight()) {
                        TabbedPanel.this.draggableComponentBox.setSize(TabbedPanel.this.draggableComponentBox.getWidth(), 0);
                        TabbedPanel.this.tabAreaComponentsPanel.setSize(TabbedPanel.this.tabAreaComponentsPanel.getWidth(), TabbedPanel.this.tabAreaContainer.getHeight());
                    }
                } else if ((double)TabbedPanel.this.tabAreaContainer.getWidth() < TabbedPanel.this.tabAreaComponentsPanel.getPreferredSize().getWidth()) {
                    TabbedPanel.this.draggableComponentBox.setSize(0, TabbedPanel.this.draggableComponentBox.getHeight());
                    TabbedPanel.this.tabAreaComponentsPanel.setSize(TabbedPanel.this.tabAreaContainer.getWidth(), TabbedPanel.this.tabAreaComponentsPanel.getHeight());
                }
            }
            TabbedPanel.this.updateShadow();
        }
    };
    private HoverableShapedPanel tabAreaContainer = new HoverablePanel(this.tabAreaLayoutManager, this.properties.getTabAreaProperties().getHoverListener()){

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            if (TabbedPanel.this.getTabCount() == 0) {
                Insets insets = this.getInsets();
                Dimension d2 = TabbedPanel.this.tabAreaComponentsPanel.getPreferredSize();
                d = new Dimension(insets.left + insets.right + d2.width, insets.top + insets.bottom + d2.height);
            }
            return d;
        }
    };
    private HoverableShapedPanel tabAreaComponentsPanel = new HoverablePanel(new DirectionLayout(), this.properties.getTabAreaComponentsProperties().getHoverListener()){

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            Insets insets = this.getInsets();
            if (ComponentUtil.hasVisibleChildren(this)) {
                if (TabbedPanel.this.tabAreaOrientation.isHorizontal()) {
                    int maxWidth = ComponentUtil.getPreferredMaxWidth(this.getComponents()) + insets.left + insets.right;
                    return new Dimension(maxWidth, d.height);
                }
                int maxHeight = ComponentUtil.getPreferredMaxHeight(this.getComponents()) + insets.top + insets.bottom;
                return new Dimension(d.width, maxHeight);
            }
            return new Dimension(0, 0);
        }
    };
    private DraggableComponentBoxListener draggableComponentBoxListener = new DraggableComponentBoxListener(){
        private boolean selectedMoved;

        @Override
        public void componentSelected(DraggableComponentBoxEvent event) {
            if (event.getDraggableComponent() == event.getOldDraggableComponent()) {
                if (!this.selectedMoved && TabbedPanel.this.properties.getTabDeselectable()) {
                    TabbedPanel.this.draggableComponentBox.selectDraggableComponent(null);
                }
            } else {
                Tab tab = TabbedPanel.this.findTab(event.getDraggableComponent());
                TabbedPanel.this.setHighlightedTab(tab);
                Tab oldTab = TabbedPanel.this.findTab(event.getOldDraggableComponent());
                TabbedPanel.this.fireSelectedEvent(tab, oldTab);
                if (TabbedPanel.this.removingSelected) {
                    TabbedPanel.this.removingSelected = false;
                    if (oldTab != null) {
                        oldTab.setTabbedPanel(null);
                    }
                }
            }
            TabbedPanel.this.tabAreaContainer.repaint();
        }

        @Override
        public void componentRemoved(DraggableComponentBoxEvent event) {
            Tab tab = TabbedPanel.this.findTab(event.getDraggableComponent());
            if (TabbedPanel.this.highlightedTab == tab) {
                TabbedPanel.this.highlightedTab = null;
            }
            TabbedPanel.this.setTabAreaComponentsButtonsVisible();
            TabbedPanel.this.updateTabAreaVisibility();
            TabbedPanel.this.tabAreaContainer.repaint();
            TabbedPanel.this.fireRemovedEvent(tab);
        }

        @Override
        public void componentAdded(DraggableComponentBoxEvent event) {
            TabbedPanel.this.updateTabAreaVisibility();
            TabbedPanel.this.tabAreaContainer.repaint();
            TabbedPanel.this.fireAddedEvent(TabbedPanel.this.findTab(event.getDraggableComponent()));
        }

        @Override
        public void componentDragged(DraggableComponentBoxEvent event) {
            TabbedPanel.this.fireDraggedEvent(TabbedPanel.this.findTab(event.getDraggableComponent()), event.getDraggableComponentEvent().getMouseEvent());
        }

        @Override
        public void componentDropped(DraggableComponentBoxEvent event) {
            if (!TabbedPanel.this.draggableComponentBox.contains(event.getDraggableComponentBoxPoint())) {
                TabbedPanel.this.setHighlightedTab(TabbedPanel.this.findTab(TabbedPanel.this.draggableComponentBox.getSelectedDraggableComponent()));
            }
            TabbedPanel.this.fireDroppedEvent(TabbedPanel.this.findTab(event.getDraggableComponent()), event.getDraggableComponentEvent().getMouseEvent());
        }

        @Override
        public void componentDragAborted(DraggableComponentBoxEvent event) {
            TabbedPanel.this.fireNotDroppedEvent(TabbedPanel.this.findTab(event.getDraggableComponent()));
        }

        @Override
        public void changed(DraggableComponentBoxEvent event) {
            if (event.getDraggableComponentEvent() != null) {
                int type = event.getDraggableComponentEvent().getType();
                if (type == 1 && TabbedPanel.this.properties.getHighlightPressedTab()) {
                    if (TabbedPanel.this.highlightedTab != null) {
                        TabbedPanel.this.setHighlightedTab(TabbedPanel.this.findTab(event.getDraggableComponent()));
                    }
                } else if (type == 2) {
                    this.selectedMoved = false;
                    TabbedPanel.this.setHighlightedTab(TabbedPanel.this.getSelectedTab());
                } else if (type == 4 && TabbedPanel.this.highlightedTab != null && TabbedPanel.this.highlightedTab.getDraggableComponent() == event.getDraggableComponent()) {
                    TabbedPanel.this.setHighlightedTab(null);
                } else if (type == 3 && TabbedPanel.this.draggableComponentBox.getSelectedDraggableComponent() == event.getDraggableComponent()) {
                    TabbedPanel.this.setHighlightedTab(TabbedPanel.this.findTab(event.getDraggableComponent()));
                } else if (type == 0) {
                    TabbedPanel.this.tabAreaContainer.repaint();
                    this.selectedMoved = event.getDraggableComponent() == TabbedPanel.this.draggableComponentBox.getSelectedDraggableComponent();
                    TabbedPanel.this.fireTabMoved(TabbedPanel.this.findTab(event.getDraggableComponent()));
                }
            } else {
                TabbedPanel.this.tabAreaContainer.repaint();
            }
            TabbedPanel.this.updateShadow();
        }
    };
    private PropertyMapTreeListener propertyChangedListener = new PropertyMapTreeListener(){

        @Override
        public void propertyValuesChanged(Map changes) {
            TabbedPanel.this.updateProperties(changes);
            TabbedPanel.this.updatePropertiesForTabArea(changes);
            TabbedPanel.this.updatePropertiesForTabAreaComponentsArea(changes);
            TabbedPanel.this.updatePropertiesForTabAreaComponentsButtons(changes);
            TabbedPanel.this.updateScrollButtons();
            TabbedPanel.this.checkIfOnlyOneTab(true);
        }
    };

    private void updatePropertiesForTabAreaComponentsButtons(Map changes) {
        TabbedPanelButtonProperties buttonProps = this.properties.getButtonProperties();
        Map m = (Map)changes.get(buttonProps.getTabDropDownListButtonProperties().getMap());
        if (m != null && this.dropDownList != null) {
            AbstractButton b = this.dropDownList.getButton();
            if (m.keySet().contains(ButtonProperties.FACTORY)) {
                b = this.properties.getButtonProperties().getTabDropDownListButtonProperties().getFactory().createButton(this);
                this.dropDownList.setButton(b);
            }
            this.properties.getButtonProperties().getTabDropDownListButtonProperties().applyTo(b);
        }
        if (this.scrollButtonBox != null) {
            AbstractButton[] buttons = new AbstractButton[]{this.scrollButtonBox.getUpButton(), this.scrollButtonBox.getDownButton(), this.scrollButtonBox.getLeftButton(), this.scrollButtonBox.getRightButton()};
            ButtonProperties[] props = new ButtonProperties[]{buttonProps.getScrollUpButtonProperties(), buttonProps.getScrollDownButtonProperties(), buttonProps.getScrollLeftButtonProperties(), buttonProps.getScrollRightButtonProperties()};
            int i = 0;
            while (i < buttons.length) {
                m = (Map)changes.get(props[i].getMap());
                if (m != null) {
                    if (m.keySet().contains(ButtonProperties.FACTORY)) {
                        buttons[i] = props[i].getFactory().createButton(this);
                    }
                    props[i].applyTo(buttons[i]);
                }
                ++i;
            }
            this.scrollButtonBox.setButtons(buttons[0], buttons[1], buttons[2], buttons[3]);
        }
    }

    private void updateAllDefaultValues() {
        this.updateAllTabsProperties();
        this.draggableComponentBox.setScrollEnabled(this.properties.getTabLayoutPolicy() == TabLayoutPolicy.SCROLLING);
        this.updateTabDropDownList();
        this.draggableComponentBox.setScrollOffset(this.properties.getTabScrollingOffset());
        this.draggableComponentBox.setEnsureSelectedVisible(this.properties.getEnsureSelectedTabVisible());
        this.tabAreaOrientation = this.properties.getTabAreaOrientation();
        this.updatePropertiesForTabAreaLayoutConstraints();
        this.componentsPanel.add((Component)this.tabAreaContainer, ComponentUtil.getBorderLayoutOrientation(this.tabAreaOrientation));
        this.componentsPanel.revalidate();
        this.draggableComponentBox.setComponentSpacing(this.properties.getTabSpacing());
        this.draggableComponentBox.setDepthSortOrder(this.properties.getTabDepthOrderPolicy() == TabDepthOrderPolicy.DESCENDING);
        this.draggableComponentBox.setAutoSelect(this.properties.getAutoSelectTab());
        this.shadowSize = this.properties.getShadowSize();
        this.componentsPanel.setBorder(this.contentPanel != null && this.properties.getShadowEnabled() ? new EmptyBorder(0, 0, this.shadowSize, this.shadowSize) : null);
        this.componentsPanel.setHoverListener(this.properties.getHoverListener());
        this.tabAreaContainer.setHoverListener(this.properties.getTabAreaProperties().getHoverListener());
        ShapedPanelProperties shapedProps = this.properties.getTabAreaProperties().getShapedPanelProperties();
        this.properties.getTabAreaProperties().getComponentProperties().applyTo(this.tabAreaContainer);
        this.updateIntelligentInsets(this.tabAreaContainer, this.properties.getTabAreaProperties().getComponentProperties());
        this.updateShapedPanelProperties(this.tabAreaContainer, this.properties.getTabAreaProperties().getShapedPanelProperties());
        this.tabAreaComponentsPanel.setHoverListener(this.properties.getTabAreaComponentsProperties().getHoverListener());
        this.updatePropertiesForTabAreaLayoutConstraints();
        shapedProps = this.properties.getTabAreaComponentsProperties().getShapedPanelProperties();
        this.properties.getTabAreaComponentsProperties().getComponentProperties().applyTo(this.tabAreaComponentsPanel);
        this.updateIntelligentInsets(this.tabAreaComponentsPanel, this.properties.getTabAreaComponentsProperties().getComponentProperties());
        this.updateShapedPanelProperties(this.tabAreaComponentsPanel, shapedProps);
        this.tabAreaComponentsPanel.setHorizontalFlip(this.tabAreaOrientation == Direction.DOWN || this.tabAreaOrientation == Direction.LEFT ? !shapedProps.getHorizontalFlip() : shapedProps.getHorizontalFlip());
        this.tabAreaComponentsPanel.setVerticalFlip(shapedProps.getVerticalFlip());
        this.updatePanelOpaque();
    }

    private void updateProperties(Map changes) {
        Map m = this.getMap(changes, this.properties.getMap());
        if (m != null) {
            Set keySet = m.keySet();
            if (keySet.contains(TabbedPanelProperties.TAB_REORDER_ENABLED) || m.keySet().contains(TabbedPanelProperties.ABORT_DRAG_KEY) || m.keySet().contains(TabbedPanelProperties.TAB_SELECT_TRIGGER)) {
                this.updateAllTabsProperties();
            }
            if (keySet.contains(TabbedPanelProperties.TAB_LAYOUT_POLICY) && this.getTabCount() > 1) {
                this.draggableComponentBox.setScrollEnabled((TabLayoutPolicy)((ValueChange)m.get(TabbedPanelProperties.TAB_LAYOUT_POLICY)).getNewValue() == TabLayoutPolicy.SCROLLING);
            }
            if (keySet.contains(TabbedPanelProperties.TAB_DROP_DOWN_LIST_VISIBLE_POLICY)) {
                this.updateTabDropDownList();
            }
            if (keySet.contains(TabbedPanelProperties.TAB_SCROLLING_OFFSET)) {
                this.draggableComponentBox.setScrollOffset((Integer)((ValueChange)m.get(TabbedPanelProperties.TAB_SCROLLING_OFFSET)).getNewValue());
            }
            if (keySet.contains(TabbedPanelProperties.ENSURE_SELECTED_VISIBLE)) {
                this.draggableComponentBox.setEnsureSelectedVisible((Boolean)((ValueChange)m.get(TabbedPanelProperties.ENSURE_SELECTED_VISIBLE)).getNewValue());
            }
            if (keySet.contains(TabbedPanelProperties.TAB_AREA_ORIENTATION)) {
                this.tabAreaOrientation = (Direction)((ValueChange)m.get(TabbedPanelProperties.TAB_AREA_ORIENTATION)).getNewValue();
                this.updatePropertiesForTabAreaLayoutConstraints();
                this.componentsPanel.remove(this.tabAreaContainer);
                this.componentsPanel.add((Component)this.tabAreaContainer, ComponentUtil.getBorderLayoutOrientation(this.tabAreaOrientation));
                this.componentsPanel.revalidate();
                this.properties.getTabAreaComponentsProperties().getComponentProperties().applyTo(this.tabAreaComponentsPanel);
                this.updateIntelligentInsets(this.tabAreaContainer, this.properties.getTabAreaProperties().getComponentProperties());
                this.tabAreaComponentsPanel.setDirection(this.tabAreaOrientation.getNextCW());
                this.updateIntelligentInsets(this.tabAreaComponentsPanel, this.properties.getTabAreaComponentsProperties().getComponentProperties());
            }
            if (keySet.contains(TabbedPanelProperties.TAB_SPACING)) {
                this.draggableComponentBox.setComponentSpacing((Integer)((ValueChange)m.get(TabbedPanelProperties.TAB_SPACING)).getNewValue());
            }
            if (keySet.contains(TabbedPanelProperties.TAB_DEPTH_ORDER)) {
                this.draggableComponentBox.setDepthSortOrder((TabDepthOrderPolicy)((ValueChange)m.get(TabbedPanelProperties.TAB_DEPTH_ORDER)).getNewValue() == TabDepthOrderPolicy.DESCENDING);
            }
            if (keySet.contains(TabbedPanelProperties.AUTO_SELECT_TAB)) {
                this.draggableComponentBox.setAutoSelect((Boolean)((ValueChange)m.get(TabbedPanelProperties.AUTO_SELECT_TAB)).getNewValue());
            }
            if (keySet.contains(TabbedPanelProperties.SHADOW_ENABLED) || m.keySet().contains(TabbedPanelProperties.SHADOW_STRENGTH) || m.keySet().contains(TabbedPanelProperties.SHADOW_COLOR) || m.keySet().contains(TabbedPanelProperties.SHADOW_BLEND_AREA_SIZE) || m.keySet().contains(TabbedPanelProperties.SHADOW_SIZE) || m.keySet().contains(TabbedPanelProperties.PAINT_TAB_AREA_SHADOW)) {
                this.shadowSize = this.properties.getShadowSize();
                this.componentsPanel.setBorder(this.contentPanel != null && this.properties.getShadowEnabled() ? new EmptyBorder(0, 0, this.shadowSize, this.shadowSize) : null);
            }
            if (keySet.contains(TabbedPanelProperties.HOVER_LISTENER)) {
                this.componentsPanel.setHoverListener((HoverListener)((ValueChange)m.get(TabbedPanelProperties.HOVER_LISTENER)).getNewValue());
            }
        }
        this.updatePanelOpaque();
    }

    private void updatePropertiesForTabArea(Map changes) {
        Map m = this.getMap(changes, this.properties.getTabAreaProperties().getMap());
        if (m != null) {
            if (m.keySet().contains(TabAreaProperties.HOVER_LISTENER)) {
                this.tabAreaContainer.setHoverListener((HoverListener)((ValueChange)m.get(TabAreaProperties.HOVER_LISTENER)).getNewValue());
            }
            this.areaVisiblePolicy = this.getProperties().getTabAreaProperties().getTabAreaVisiblePolicy();
            this.updateTabAreaVisibility();
        }
        m = this.getMap(changes, this.properties.getTabAreaProperties().getComponentProperties().getMap());
        Map m2 = this.getMap(changes, this.properties.getTabAreaProperties().getShapedPanelProperties().getMap());
        if (m != null || m2 != null) {
            this.properties.getTabAreaProperties().getComponentProperties().applyTo(this.tabAreaContainer);
            this.updateIntelligentInsets(this.tabAreaContainer, this.properties.getTabAreaProperties().getComponentProperties());
            this.updateShapedPanelProperties(this.tabAreaContainer, this.properties.getTabAreaProperties().getShapedPanelProperties());
            this.repaint();
        }
    }

    private void updateIntelligentInsets(JComponent c, ComponentProperties props) {
        Direction d = this.properties.getTabAreaOrientation();
        Insets insets = props.getInsets();
        if (insets != null) {
            if (d == Direction.RIGHT) {
                insets = new Insets(insets.left, insets.bottom, insets.right, insets.top);
            } else if (d == Direction.DOWN) {
                insets = new Insets(insets.bottom, insets.left, insets.top, insets.right);
            } else if (d == Direction.LEFT) {
                insets = new Insets(insets.left, insets.top, insets.right, insets.bottom);
            }
            Border b = props.getBorder();
            c.setBorder(b != null ? new CompoundBorder(b, new EmptyBorder(insets)) : new EmptyBorder(insets));
        }
    }

    private void updatePropertiesForTabAreaComponentsArea(Map changes) {
        Map m = this.getMap(changes, this.properties.getTabAreaComponentsProperties().getMap());
        if (m != null) {
            if (m.keySet().contains(TabAreaComponentsProperties.HOVER_LISTENER)) {
                this.tabAreaComponentsPanel.setHoverListener((HoverListener)((ValueChange)m.get(TabAreaComponentsProperties.HOVER_LISTENER)).getNewValue());
            }
            if (m.keySet().contains(TabAreaComponentsProperties.STRETCH_ENABLED)) {
                this.updatePropertiesForTabAreaLayoutConstraints();
            }
        }
        m = this.getMap(changes, this.properties.getTabAreaComponentsProperties().getComponentProperties().getMap());
        Map m2 = this.getMap(changes, this.properties.getTabAreaComponentsProperties().getShapedPanelProperties().getMap());
        if (m != null || m2 != null) {
            ShapedPanelProperties shapedProps = this.properties.getTabAreaComponentsProperties().getShapedPanelProperties();
            this.properties.getTabAreaComponentsProperties().getComponentProperties().applyTo(this.tabAreaComponentsPanel);
            this.updateIntelligentInsets(this.tabAreaComponentsPanel, this.properties.getTabAreaComponentsProperties().getComponentProperties());
            this.updateShapedPanelProperties(this.tabAreaComponentsPanel, shapedProps);
            this.tabAreaComponentsPanel.setHorizontalFlip(this.tabAreaOrientation == Direction.DOWN || this.tabAreaOrientation == Direction.LEFT ? !shapedProps.getHorizontalFlip() : shapedProps.getHorizontalFlip());
            this.tabAreaComponentsPanel.setVerticalFlip(shapedProps.getVerticalFlip());
        }
    }

    private void updatePropertiesForTabAreaLayoutConstraints() {
        boolean stretch = this.properties.getTabAreaComponentsProperties().getStretchEnabled();
        if (this.tabAreaOrientation == Direction.UP) {
            this.setTabAreaLayoutConstraints(this.draggableComponentBox, 0, 0, 2, 1.0, 1.0, 15);
            this.setTabAreaLayoutConstraints(this.tabAreaComponentsPanel, 1, 0, stretch ? 3 : 0, 0.0, 1.0, 15);
            this.updateTabAreaComponentsPanel(Direction.RIGHT, 0, 1);
        } else if (this.tabAreaOrientation == Direction.DOWN) {
            this.setTabAreaLayoutConstraints(this.draggableComponentBox, 0, 0, 2, 1.0, 1.0, 11);
            this.setTabAreaLayoutConstraints(this.tabAreaComponentsPanel, 1, 0, stretch ? 3 : 0, 0.0, 0.0, 11);
            this.updateTabAreaComponentsPanel(Direction.RIGHT, 0, 0);
        } else if (this.tabAreaOrientation == Direction.LEFT) {
            this.setTabAreaLayoutConstraints(this.draggableComponentBox, 0, 0, 3, 1.0, 1.0, 13);
            this.setTabAreaLayoutConstraints(this.tabAreaComponentsPanel, 0, 1, stretch ? 2 : 0, 0.0, 0.0, 13);
            this.updateTabAreaComponentsPanel(Direction.DOWN, 0, 0);
        } else {
            this.setTabAreaLayoutConstraints(this.draggableComponentBox, 0, 0, 3, 1.0, 1.0, 17);
            this.setTabAreaLayoutConstraints(this.tabAreaComponentsPanel, 0, 1, stretch ? 2 : 0, 0.0, 0.0, 17);
            this.updateTabAreaComponentsPanel(Direction.DOWN, 0, 1);
        }
        this.draggableComponentBox.setComponentDirection(this.tabAreaOrientation);
    }

    private Map getMap(Map changes, PropertyMap map) {
        return changes != null ? (Map)changes.get(map) : null;
    }

    private void updateTabAreaVisibility() {
        if (this.areaVisiblePolicy == TabAreaVisiblePolicy.ALWAYS) {
            this.tabAreaContainer.setVisible(true);
        } else if (this.areaVisiblePolicy == TabAreaVisiblePolicy.NEVER) {
            this.tabAreaContainer.setVisible(false);
        } else if (this.areaVisiblePolicy == TabAreaVisiblePolicy.MORE_THAN_ONE_TAB) {
            this.tabAreaContainer.setVisible(this.getTabCount() > 1);
        } else if (this.areaVisiblePolicy == TabAreaVisiblePolicy.TABS_EXIST) {
            this.tabAreaContainer.setVisible(this.getTabCount() > 0);
        }
        if (!this.tabAreaContainer.isVisible()) {
            this.tabAreaContainer.setSize(0, 0);
        }
    }

    public TabbedPanel() {
        this.initialize(new TabbedPanelContentPanel(this, new TabContentPanel(this)));
    }

    public TabbedPanel(JComponent contentAreaComponent) {
        this(contentAreaComponent, false);
    }

    public TabbedPanel(JComponent contentAreaComponent, boolean useProperties) {
        if (useProperties) {
            this.initialize(new TabbedPanelContentPanel(this, contentAreaComponent));
        } else {
            this.initialize(contentAreaComponent);
        }
    }

    public boolean tabAreaContainsPoint(Point p) {
        if (!this.tabAreaContainer.isVisible()) {
            return false;
        }
        return this.tabAreaContainer.contains(SwingUtilities.convertPoint(this, p, this.tabAreaContainer));
    }

    public boolean contentAreaContainsPoint(Point p) {
        return this.contentPanel != null ? this.contentPanel.contains(SwingUtilities.convertPoint(this, p, this.contentPanel)) : false;
    }

    public boolean isTabAreaVisible() {
        return this.tabAreaContainer.isVisible();
    }

    public void addTab(Tab tab) {
        this.doInsertTab(tab, null, -1);
    }

    public void insertTab(Tab tab, int index) {
        this.doInsertTab(tab, null, index);
    }

    public void insertTab(Tab tab, Point p) {
        this.doInsertTab(tab, p, -1);
    }

    public void removeTab(Tab tab) {
        if (tab != null && tab.getTabbedPanel() == this) {
            if (this.getSelectedTab() != tab) {
                tab.setTabbedPanel(null);
            } else {
                this.removingSelected = true;
            }
            this.draggableComponentBox.removeDraggableComponent(tab.getDraggableComponent());
        }
        this.checkIfOnlyOneTab(false);
    }

    public void moveTab(Tab tab, Point p) {
        this.draggableComponentBox.dragDraggableComponent(tab.getDraggableComponent(), SwingUtilities.convertPoint(this, p, this.draggableComponentBox));
    }

    public void setSelectedTab(Tab tab) {
        if (this.getSelectedTab() == tab) {
            return;
        }
        if (tab != null) {
            if (tab.isEnabled() && this.getTabIndex(tab) > -1) {
                if (tab.getDraggableComponent() == this.draggableComponentBox.getSelectedDraggableComponent()) {
                    this.setHighlightedTab(tab);
                } else {
                    tab.setSelected(true);
                }
            }
        } else {
            this.draggableComponentBox.selectDraggableComponent(null);
        }
    }

    public Tab getSelectedTab() {
        return this.findTab(this.draggableComponentBox.getSelectedDraggableComponent());
    }

    public void setHighlightedTab(Tab highlightedTab) {
        if (!this.settingHighlighted) {
            this.settingHighlighted = true;
            Tab oldTab = this.highlightedTab;
            Tab newTab = null;
            if (oldTab != highlightedTab) {
                this.draggableComponentBox.setTopComponent(highlightedTab != null ? highlightedTab.getDraggableComponent() : null);
            }
            if (highlightedTab != null) {
                if (this.getTabIndex(highlightedTab) > -1) {
                    this.highlightedTab = highlightedTab;
                    if (oldTab != null && oldTab != highlightedTab) {
                        oldTab.setHighlighted(false);
                    }
                    if (oldTab != highlightedTab) {
                        if (highlightedTab.isEnabled()) {
                            highlightedTab.setHighlighted(true);
                        } else {
                            highlightedTab.setHighlighted(false);
                            this.highlightedTab = null;
                        }
                    }
                    if (highlightedTab.isEnabled() && highlightedTab != oldTab) {
                        newTab = highlightedTab;
                    }
                    if (oldTab != highlightedTab) {
                        this.fireHighlightedEvent(newTab, oldTab);
                    }
                }
            } else if (oldTab != null) {
                this.highlightedTab = null;
                oldTab.setHighlighted(false);
                this.fireHighlightedEvent(null, oldTab);
            }
            this.updateShadow();
            this.settingHighlighted = false;
        }
    }

    public Tab getHighlightedTab() {
        return this.highlightedTab;
    }

    public int getTabCount() {
        return this.draggableComponentBox.getDraggableComponentCount();
    }

    public Tab getTabAt(int index) {
        DraggableComponent component = this.draggableComponentBox.getDraggableComponentAt(index);
        return component == null ? null : (Tab)component.getComponent();
    }

    public int getTabIndex(Tab tab) {
        return tab == null ? -1 : this.draggableComponentBox.getDraggableComponentIndex(tab.getDraggableComponent());
    }

    public void scrollTabToVisibleArea(Tab tab) {
        if (tab.getTabbedPanel() == this) {
            this.draggableComponentBox.scrollToVisible(tab.getDraggableComponent());
        }
    }

    public void setTabAreaComponents(JComponent[] tabAreaComponents) {
        int i;
        if (this.tabAreaComponents != null) {
            i = 0;
            while (i < this.tabAreaComponents.length) {
                this.tabAreaComponentsPanel.remove(this.tabAreaComponents[i]);
                ++i;
            }
        }
        JComponent[] jComponentArray = this.tabAreaComponents = tabAreaComponents == null ? null : (JComponent[])tabAreaComponents.clone();
        if (tabAreaComponents != null) {
            i = 0;
            while (i < tabAreaComponents.length) {
                this.tabAreaComponentsPanel.add(tabAreaComponents[i]);
                ++i;
            }
        }
        this.setTabAreaComponentsButtonsVisible();
        this.tabAreaComponentsPanel.revalidate();
    }

    public boolean isTabAreaComponentsVisible() {
        return this.tabAreaComponentsPanel.isVisible();
    }

    public JComponent[] getTabAreaComponents() {
        return this.tabAreaComponents == null ? null : (JComponent[])this.tabAreaComponents.clone();
    }

    public void addTabListener(TabListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(listener);
    }

    public void removeTabListener(TabListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
    }

    public TabbedPanelProperties getProperties() {
        return this.properties;
    }

    public boolean hasContentArea() {
        return this.contentPanel != null;
    }

    DraggableComponentBox getDraggableComponentBox() {
        return this.draggableComponentBox;
    }

    private void initialize(JComponent contentPanel) {
        this.setLayout(new BorderLayout());
        this.shadowRepaintChecker = new ComponentPaintChecker(this);
        this.setOpaque(false);
        this.draggableComponentBox.setOuterParentArea(this.tabAreaContainer);
        this.tabAreaContainer.add(this.tabAreaComponentsPanel);
        this.tabAreaContainer.add(this.draggableComponentBox);
        this.contentPanel = contentPanel;
        this.draggableComponentBox.addListener(this.draggableComponentBoxListener);
        if (contentPanel != null) {
            this.componentsPanel.add((Component)contentPanel, "Center");
        }
        this.add((Component)this.componentsPanel, "Center");
        this.updateAllDefaultValues();
        PropertyMapWeakListenerManager.addWeakTreeListener(this.properties.getMap(), this.propertyChangedListener);
    }

    private void updateTabDropDownList() {
        TabDropDownListVisiblePolicy newListVisiblePolicy = this.properties.getTabDropDownListVisiblePolicy();
        TabLayoutPolicy newListTabLayoutPolicy = this.properties.getTabLayoutPolicy();
        if (newListVisiblePolicy != this.listVisiblePolicy || newListTabLayoutPolicy != this.listTabLayoutPolicy) {
            if (this.dropDownList != null) {
                this.tabAreaComponentsPanel.remove(this.dropDownList);
                this.dropDownList.dispose();
                this.dropDownList = null;
            }
            if (newListVisiblePolicy == TabDropDownListVisiblePolicy.MORE_THAN_ONE_TAB || newListVisiblePolicy == TabDropDownListVisiblePolicy.TABS_NOT_VISIBLE && newListTabLayoutPolicy == TabLayoutPolicy.SCROLLING) {
                this.dropDownList = new TabDropDownList(this, this.properties.getButtonProperties().getTabDropDownListButtonProperties().applyTo(this.properties.getButtonProperties().getTabDropDownListButtonProperties().getFactory().createButton(this)));
                this.tabAreaComponentsPanel.add((Component)this.dropDownList, this.scrollButtonBox == null ? 0 : 1);
                if (newListVisiblePolicy == TabDropDownListVisiblePolicy.TABS_NOT_VISIBLE) {
                    this.dropDownList.setVisible(false);
                }
            }
        }
        this.listVisiblePolicy = newListVisiblePolicy;
        this.listTabLayoutPolicy = newListTabLayoutPolicy;
        if (this.dropDownList != null && !this.draggableComponentBox.isScrollEnabled() && this.listVisiblePolicy == TabDropDownListVisiblePolicy.TABS_NOT_VISIBLE) {
            this.dropDownList.setVisible(false);
        }
        this.tabAreaComponentsPanel.revalidate();
    }

    private void updateAllTabsProperties() {
        Component[] components = this.draggableComponentBox.getBoxComponents();
        int i = 0;
        while (i < components.length) {
            this.updateTabProperties((Tab)components[i]);
            ++i;
        }
    }

    private void updateTabProperties(Tab tab) {
        tab.getDraggableComponent().setAbortDragKeyCode(this.properties.getAbortDragKey());
        tab.getDraggableComponent().setReorderEnabled(this.properties.getTabReorderEnabled());
        tab.getDraggableComponent().setSelectOnMousePress(this.properties.getTabSelectTrigger() == TabSelectTrigger.MOUSE_PRESS);
    }

    private void updateTabAreaComponentsPanel(Direction direction, int alignmentX, int alignmentY) {
        ((DirectionLayout)this.tabAreaComponentsPanel.getLayout()).setDirection(direction);
    }

    private void updateShapedPanelProperties(ShapedPanel panel, ShapedPanelProperties shapedPanelProperties) {
        InternalPropertiesUtil.applyTo(shapedPanelProperties, panel, this.properties.getTabAreaOrientation().getNextCW());
    }

    private void setTabAreaLayoutConstraints(JComponent c, int gridx, int gridy, int fill, double weightx, double weighty, int anchor) {
        this.constraints.gridx = gridx;
        this.constraints.gridy = gridy;
        this.constraints.fill = fill;
        this.constraints.weightx = weightx;
        this.constraints.weighty = weighty;
        this.constraints.anchor = anchor;
        this.tabAreaLayoutManager.setConstraints(c, this.constraints);
    }

    private void doInsertTab(Tab tab, Point p, int index) {
        if (tab != null && !this.draggableComponentBox.containsDraggableComponent(tab.getDraggableComponent())) {
            tab.setTabbedPanel(this);
            if (p != null) {
                this.draggableComponentBox.insertDraggableComponent(tab.getDraggableComponent(), SwingUtilities.convertPoint(this, p, this.draggableComponentBox));
            } else {
                this.draggableComponentBox.insertDraggableComponent(tab.getDraggableComponent(), index);
            }
            this.updateTabProperties(tab);
            this.checkIfOnlyOneTab(true);
        }
    }

    private Tab findTab(DraggableComponent draggableComponent) {
        return draggableComponent == null ? null : (Tab)draggableComponent.getComponent();
    }

    private void checkIfOnlyOneTab(boolean inc) {
        if (this.getTabCount() == 1) {
            this.draggableComponentBox.setScrollEnabled(false);
            this.updateScrollButtons();
        } else if (inc && this.getTabCount() == 2) {
            this.draggableComponentBox.setScrollEnabled(this.properties.getTabLayoutPolicy() == TabLayoutPolicy.SCROLLING);
            this.updateScrollButtons();
            this.updateTabDropDownList();
        }
    }

    private void setTabAreaComponentsButtonsVisible() {
        if (this.scrollButtonBox != null) {
            boolean visible = false;
            visible = !this.tabAreaOrientation.isHorizontal() ? this.draggableComponentBox.getInnerSize().getWidth() > (double)this.calcScrollWidth() : this.draggableComponentBox.getInnerSize().getHeight() > (double)this.calcScrollHeight();
            this.scrollButtonBox.setVisible(visible);
            if (this.dropDownList != null && this.listVisiblePolicy == TabDropDownListVisiblePolicy.TABS_NOT_VISIBLE) {
                this.dropDownList.setVisible(visible);
            }
            if (!visible) {
                this.scrollButtonBox.setButton1Enabled(false);
                this.scrollButtonBox.setButton2Enabled(true);
            }
        } else if (this.dropDownList != null && this.listVisiblePolicy == TabDropDownListVisiblePolicy.TABS_NOT_VISIBLE) {
            this.dropDownList.setVisible(false);
        }
        this.tabAreaComponentsPanel.setVisible(ComponentUtil.hasVisibleChildren(this.tabAreaComponentsPanel));
    }

    private int calcScrollWidth() {
        int insetsWidth;
        Insets componentsPanelInsets = this.tabAreaComponentsPanel.getInsets();
        boolean includeDropDownWidth = this.dropDownList != null && this.listVisiblePolicy == TabDropDownListVisiblePolicy.TABS_NOT_VISIBLE;
        boolean componentsVisible = includeDropDownWidth ? ComponentUtil.isOnlyVisibleComponents(new Component[]{this.scrollButtonBox, this.dropDownList}) : ComponentUtil.isOnlyVisibleComponent(this.scrollButtonBox);
        int n = insetsWidth = this.tabAreaComponentsPanel.isVisible() && componentsVisible ? componentsPanelInsets.left + componentsPanelInsets.right : 0;
        int componentsPanelWidth = this.tabAreaComponentsPanel.isVisible() ? (int)this.tabAreaComponentsPanel.getPreferredSize().getWidth() - insetsWidth - (this.scrollButtonBox.isVisible() ? this.scrollButtonBox.getWidth() + (includeDropDownWidth ? this.dropDownList.getWidth() : 0) : 0) : 0;
        Insets areaInsets = this.tabAreaContainer.getInsets();
        return this.tabAreaContainer.getWidth() - componentsPanelWidth - areaInsets.left - areaInsets.right;
    }

    private int calcScrollHeight() {
        int insetsHeight;
        Insets componentsPanelInsets = this.tabAreaComponentsPanel.getInsets();
        boolean includeDropDownHeight = this.listVisiblePolicy == TabDropDownListVisiblePolicy.TABS_NOT_VISIBLE;
        boolean componentsVisible = includeDropDownHeight ? ComponentUtil.isOnlyVisibleComponents(new Component[]{this.scrollButtonBox, this.dropDownList}) : ComponentUtil.isOnlyVisibleComponent(this.scrollButtonBox);
        int n = insetsHeight = this.tabAreaComponentsPanel.isVisible() && componentsVisible ? componentsPanelInsets.top + componentsPanelInsets.bottom : 0;
        int componentsPanelHeight = this.tabAreaComponentsPanel.isVisible() ? (int)this.tabAreaComponentsPanel.getPreferredSize().getHeight() - insetsHeight - (this.scrollButtonBox.isVisible() ? this.scrollButtonBox.getHeight() + (includeDropDownHeight ? this.dropDownList.getHeight() : 0) : 0) : 0;
        Insets areaInsets = this.tabAreaContainer.getInsets();
        return this.tabAreaContainer.getHeight() - componentsPanelHeight - areaInsets.top - areaInsets.bottom;
    }

    private void updateScrollButtons() {
        ScrollButtonBox oldScrollButtonBox = this.scrollButtonBox;
        this.scrollButtonBox = this.draggableComponentBox.getScrollButtonBox();
        if (oldScrollButtonBox != this.scrollButtonBox) {
            if (oldScrollButtonBox != null) {
                this.tabAreaComponentsPanel.remove(oldScrollButtonBox);
            }
            if (this.scrollButtonBox != null) {
                this.scrollButtonBox.setButtons(this.properties.getButtonProperties().getScrollUpButtonProperties().applyTo(this.properties.getButtonProperties().getScrollUpButtonProperties().getFactory().createButton(this)), this.properties.getButtonProperties().getScrollDownButtonProperties().applyTo(this.properties.getButtonProperties().getScrollDownButtonProperties().getFactory().createButton(this)), this.properties.getButtonProperties().getScrollLeftButtonProperties().applyTo(this.properties.getButtonProperties().getScrollLeftButtonProperties().getFactory().createButton(this)), this.properties.getButtonProperties().getScrollRightButtonProperties().applyTo(this.properties.getButtonProperties().getScrollRightButtonProperties().getFactory().createButton(this)));
                this.scrollButtonBox.setVisible(false);
                this.tabAreaComponentsPanel.add((Component)this.scrollButtonBox, 0);
            }
            this.tabAreaComponentsPanel.revalidate();
        }
    }

    private void fireTabMoved(Tab tab) {
        if (this.listeners != null) {
            TabEvent event = new TabEvent(this, tab);
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((TabListener)l[i]).tabMoved(event);
                ++i;
            }
        }
    }

    private void fireDraggedEvent(Tab tab, MouseEvent mouseEvent) {
        if (this.listeners != null) {
            TabDragEvent event = new TabDragEvent((Object)this, EventUtil.convert(mouseEvent, tab));
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((TabListener)l[i]).tabDragged(event);
                ++i;
            }
        }
    }

    private void fireDroppedEvent(Tab tab, MouseEvent mouseEvent) {
        if (this.listeners != null) {
            TabDragEvent event = new TabDragEvent((Object)this, EventUtil.convert(mouseEvent, tab));
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((TabListener)l[i]).tabDropped(event);
                ++i;
            }
        }
    }

    private void fireNotDroppedEvent(Tab tab) {
        if (this.listeners != null) {
            TabEvent event = new TabEvent(this, tab);
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((TabListener)l[i]).tabDragAborted(event);
                ++i;
            }
        }
    }

    private void fireSelectedEvent(Tab tab, Tab oldTab) {
        if (this.listeners != null) {
            TabStateChangedEvent event = new TabStateChangedEvent(this, this, oldTab, oldTab, tab);
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((TabListener)l[i]).tabDeselected(event);
                ++i;
            }
            event = new TabStateChangedEvent(this, this, tab, oldTab, tab);
            l = this.listeners.toArray();
            i = 0;
            while (i < l.length) {
                ((TabListener)l[i]).tabSelected(event);
                ++i;
            }
        }
    }

    private void fireHighlightedEvent(Tab tab, Tab oldTab) {
        if (this.listeners != null) {
            TabStateChangedEvent event = new TabStateChangedEvent(this, this, oldTab, oldTab, tab);
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((TabListener)l[i]).tabDehighlighted(event);
                ++i;
            }
            event = new TabStateChangedEvent(this, this, tab, oldTab, tab);
            l = this.listeners.toArray();
            i = 0;
            while (i < l.length) {
                ((TabListener)l[i]).tabHighlighted(event);
                ++i;
            }
        }
    }

    private void fireAddedEvent(Tab tab) {
        if (this.listeners != null) {
            TabEvent event = new TabEvent(this, tab);
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((TabListener)l[i]).tabAdded(event);
                ++i;
            }
        }
    }

    private void fireRemovedEvent(Tab tab) {
        if (this.listeners != null) {
            TabRemovedEvent event = new TabRemovedEvent(this, tab, this);
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((TabListener)l[i]).tabRemoved(event);
                ++i;
            }
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent event) {
        if (event.getID() == 504) {
            if (!this.mouseEntered) {
                this.mouseEntered = true;
                super.processMouseEvent(event);
            }
        } else if (event.getID() == 505) {
            if (!this.contains(event.getPoint())) {
                this.mouseEntered = false;
                super.processMouseEvent(event);
            }
        } else {
            super.processMouseEvent(event);
        }
    }

    void doProcessMouseEvent(MouseEvent event) {
        this.processMouseEvent(SwingUtilities.convertMouseEvent((Component)event.getSource(), event, this));
    }

    void doProcessMouseMotionEvent(MouseEvent event) {
        this.processMouseMotionEvent(SwingUtilities.convertMouseEvent((Component)event.getSource(), event, this));
    }

    private void updateShadow() {
        if (this.shadowRepaintChecker.isPaintingOk() && this.contentPanel != null && this.properties.getShadowEnabled()) {
            Point p = SwingUtilities.convertPoint(this.tabAreaContainer, new Point(0, 0), this);
            this.repaint(p.x, p.y, this.tabAreaContainer.getWidth() + this.shadowSize, this.tabAreaContainer.getHeight() + this.shadowSize);
        }
    }

    private void updatePanelOpaque() {
        if (!this.properties.getShadowEnabled() && this.properties.getTabAreaProperties().getShapedPanelProperties().getOpaque() && (this.contentPanel == null || this.properties.getContentPanelProperties().getShapedPanelProperties().getOpaque())) {
            BaseContainerUtil.setForcedOpaque(this.componentsPanel, true);
            this.setOpaque(true);
        } else {
            BaseContainerUtil.setForcedOpaque(this.componentsPanel, false);
            this.setOpaque(false);
        }
    }

    private class HoverablePanel
    extends HoverableShapedPanel {
        public HoverablePanel(LayoutManager l, HoverListener listener) {
            super(l, listener, TabbedPanel.this);
        }

        @Override
        protected void processMouseEvent(MouseEvent event) {
            super.processMouseEvent(event);
            TabbedPanel.this.doProcessMouseEvent(event);
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent event) {
            super.processMouseMotionEvent(event);
            TabbedPanel.this.doProcessMouseMotionEvent(event);
        }

        @Override
        public boolean acceptHover(ArrayList enterableHoverables) {
            return this.getHoverListener() == null ? false : TabbedHoverUtil.acceptTabbedPanelHover(TabbedPanel.this.properties.getHoverPolicy(), enterableHoverables, TabbedPanel.this, this);
        }
    }

    private class ShadowPanel
    extends HoverablePanel {
        ShadowPanel() {
            super(new BorderLayout(), TabbedPanel.this.properties.getHoverListener());
            this.setCursor(null);
        }

        @Override
        public boolean contains(int x, int y) {
            return TabbedPanel.this.properties.getShadowEnabled() ? this.doContains(x, y) : super.contains(x, y);
        }

        @Override
        public boolean inside(int x, int y) {
            return TabbedPanel.this.properties.getShadowEnabled() ? this.doContains(x, y) : super.inside(x, y);
        }

        private boolean doContains(int x, int y) {
            Dimension d = DimensionUtil.getInnerDimension(this.getSize(), this.getInsets());
            return x >= 0 && y >= 0 && (double)x < d.getWidth() && (double)y < d.getHeight();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (TabbedPanel.this.contentPanel == null || !TabbedPanel.this.properties.getShadowEnabled()) {
                return;
            }
            new ShadowPainter(this, TabbedPanel.this.componentsPanel, TabbedPanel.this.highlightedTab, TabbedPanel.this.contentPanel, TabbedPanel.this.tabAreaComponentsPanel, TabbedPanel.this.tabAreaContainer, TabbedPanel.this.draggableComponentBox, TabbedPanel.this.properties.getTabAreaOrientation(), TabbedPanel.this.properties.getPaintTabAreaShadow(), TabbedPanel.this.shadowSize, TabbedPanel.this.properties.getShadowBlendAreaSize(), TabbedPanel.this.properties.getShadowColor(), TabbedPanel.this.properties.getShadowStrength(), TabbedPanel.this.getTabIndex(TabbedPanel.this.getHighlightedTab()) == TabbedPanel.this.getTabCount() - 1).paint(g);
        }
    }
}

