/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.LineOutputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.MultipartDataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.SharedInputStream;
import javax.mail.internet.UniqueValue;

public class MimeMultipart
extends Multipart {
    private static boolean ignoreMissingEndBoundary = true;
    private static boolean ignoreMissingBoundaryParameter = true;
    private static boolean bmparse = true;
    protected DataSource ds = null;
    protected boolean parsed = true;
    private boolean complete = true;
    private String preamble = null;

    public MimeMultipart() {
        this("mixed");
    }

    public MimeMultipart(String string) {
        String string2 = UniqueValue.getUniqueBoundaryValue();
        ContentType contentType = new ContentType("multipart", string, null);
        contentType.setParameter("boundary", string2);
        this.contentType = contentType.toString();
    }

    public MimeMultipart(DataSource dataSource) throws MessagingException {
        if (dataSource instanceof MessageAware) {
            MessageContext messageContext = ((MessageAware)((Object)dataSource)).getMessageContext();
            this.setParent(messageContext.getPart());
        }
        if (dataSource instanceof MultipartDataSource) {
            this.setMultipartDataSource((MultipartDataSource)dataSource);
            return;
        }
        this.parsed = false;
        this.ds = dataSource;
        this.contentType = dataSource.getContentType();
    }

    public synchronized void setSubType(String string) throws MessagingException {
        ContentType contentType = new ContentType(this.contentType);
        contentType.setSubType(string);
        this.contentType = contentType.toString();
    }

    public synchronized int getCount() throws MessagingException {
        this.parse();
        return super.getCount();
    }

    public synchronized BodyPart getBodyPart(int n) throws MessagingException {
        this.parse();
        return super.getBodyPart(n);
    }

    public synchronized BodyPart getBodyPart(String string) throws MessagingException {
        this.parse();
        int n = this.getCount();
        int n2 = 0;
        while (n2 < n) {
            MimeBodyPart mimeBodyPart = (MimeBodyPart)this.getBodyPart(n2);
            String string2 = mimeBodyPart.getContentID();
            if (string2 != null && string2.equals(string)) {
                return mimeBodyPart;
            }
            ++n2;
        }
        return null;
    }

    public boolean removeBodyPart(BodyPart bodyPart) throws MessagingException {
        this.parse();
        return super.removeBodyPart(bodyPart);
    }

    public void removeBodyPart(int n) throws MessagingException {
        this.parse();
        super.removeBodyPart(n);
    }

    public synchronized void addBodyPart(BodyPart bodyPart) throws MessagingException {
        this.parse();
        super.addBodyPart(bodyPart);
    }

    public synchronized void addBodyPart(BodyPart bodyPart, int n) throws MessagingException {
        this.parse();
        super.addBodyPart(bodyPart, n);
    }

    public synchronized boolean isComplete() throws MessagingException {
        this.parse();
        return this.complete;
    }

    public synchronized String getPreamble() throws MessagingException {
        this.parse();
        return this.preamble;
    }

    public synchronized void setPreamble(String string) throws MessagingException {
        this.preamble = string;
    }

    protected void updateHeaders() throws MessagingException {
        int n = 0;
        while (n < this.parts.size()) {
            ((MimeBodyPart)this.parts.elementAt(n)).updateHeaders();
            ++n;
        }
    }

    public synchronized void writeTo(OutputStream outputStream) throws IOException, MessagingException {
        this.parse();
        String string = "--" + new ContentType(this.contentType).getParameter("boundary");
        LineOutputStream lineOutputStream = new LineOutputStream(outputStream);
        if (this.preamble != null) {
            byte[] byArray = ASCIIUtility.getBytes(this.preamble);
            lineOutputStream.write(byArray);
            if (byArray.length > 0 && byArray[byArray.length - 1] != 13 && byArray[byArray.length - 1] != 10) {
                lineOutputStream.writeln();
            }
        }
        int n = 0;
        while (n < this.parts.size()) {
            lineOutputStream.writeln(string);
            ((MimeBodyPart)this.parts.elementAt(n)).writeTo(outputStream);
            lineOutputStream.writeln();
            ++n;
        }
        lineOutputStream.writeln(string + "--");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void parse() throws MessagingException {
        if (this.parsed) {
            return;
        }
        if (bmparse) {
            this.parsebm();
            return;
        }
        InputStream inputStream = null;
        SharedInputStream sharedInputStream = null;
        long l = 0L;
        long l2 = 0L;
        try {
            inputStream = this.ds.getInputStream();
            if (!(inputStream instanceof ByteArrayInputStream || inputStream instanceof BufferedInputStream || inputStream instanceof SharedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
        }
        catch (Exception exception) {
            throw new MessagingException("No inputstream from datasource", exception);
        }
        if (inputStream instanceof SharedInputStream) {
            sharedInputStream = (SharedInputStream)((Object)inputStream);
        }
        ContentType contentType = new ContentType(this.contentType);
        String string = null;
        String string2 = contentType.getParameter("boundary");
        if (string2 != null) {
            string = "--" + string2;
        } else if (!ignoreMissingBoundaryParameter) {
            throw new MessagingException("Missing boundary parameter");
        }
        try {
            try {
                int n;
                String string3;
                LineInputStream lineInputStream = new LineInputStream(inputStream);
                StringBuffer stringBuffer = null;
                String string4 = null;
                while ((string3 = lineInputStream.readLine()) != null) {
                    int n2 = string3.length() - 1;
                    while (n2 >= 0 && ((n = (int)string3.charAt(n2)) == 32 || n == 9)) {
                        --n2;
                    }
                    string3 = string3.substring(0, n2 + 1);
                    if (string != null) {
                        if (string3.equals(string)) {
                            break;
                        }
                    } else if (string3.startsWith("--")) {
                        string = string3;
                        break;
                    }
                    if (string3.length() <= 0) continue;
                    if (string4 == null) {
                        try {
                            string4 = System.getProperty("line.separator", "\n");
                        }
                        catch (SecurityException securityException) {
                            string4 = "\n";
                        }
                    }
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(string3.length() + 2);
                    }
                    stringBuffer.append(string3).append(string4);
                }
                if (string3 == null) {
                    throw new MessagingException("Missing start boundary");
                }
                if (stringBuffer != null) {
                    this.preamble = stringBuffer.toString();
                }
                byte[] byArray = ASCIIUtility.getBytes(string);
                n = byArray.length;
                boolean bl = false;
                while (!bl) {
                    InternetHeaders internetHeaders = null;
                    if (sharedInputStream != null) {
                        l = sharedInputStream.getPosition();
                        while ((string3 = lineInputStream.readLine()) != null && string3.length() > 0) {
                        }
                        if (string3 == null) {
                            if (!ignoreMissingEndBoundary) {
                                throw new MessagingException("missing multipart end boundary");
                            }
                            this.complete = false;
                            break;
                        }
                    } else {
                        internetHeaders = this.createInternetHeaders(inputStream);
                    }
                    if (!inputStream.markSupported()) {
                        throw new MessagingException("Stream doesn't support mark");
                    }
                    ByteArrayOutputStream byteArrayOutputStream = null;
                    if (sharedInputStream == null) {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                    } else {
                        l2 = sharedInputStream.getPosition();
                    }
                    boolean bl2 = true;
                    int n3 = -1;
                    int n4 = -1;
                    block15: while (true) {
                        int n5;
                        if (bl2) {
                            inputStream.mark(n + 4 + 1000);
                            int n6 = 0;
                            while (n6 < n && inputStream.read() == (byArray[n6] & 0xFF)) {
                                ++n6;
                            }
                            if (n6 == n) {
                                int n7 = inputStream.read();
                                if (n7 == 45 && inputStream.read() == 45) {
                                    this.complete = true;
                                    bl = true;
                                    break;
                                }
                                while (true) {
                                    if (n7 != 32 && n7 != 9) {
                                        if (n7 != 10) break;
                                        break block15;
                                    }
                                    n7 = inputStream.read();
                                }
                                if (n7 == 13) {
                                    inputStream.mark(1);
                                    if (inputStream.read() == 10) break;
                                    inputStream.reset();
                                    break;
                                }
                            }
                            inputStream.reset();
                            if (byteArrayOutputStream != null && n3 != -1) {
                                byteArrayOutputStream.write(n3);
                                if (n4 != -1) {
                                    byteArrayOutputStream.write(n4);
                                }
                                n4 = -1;
                                n3 = -1;
                            }
                        }
                        if ((n5 = inputStream.read()) < 0) {
                            if (!ignoreMissingEndBoundary) {
                                throw new MessagingException("missing multipart end boundary");
                            }
                            this.complete = false;
                            bl = true;
                            break;
                        }
                        if (n5 == 13 || n5 == 10) {
                            bl2 = true;
                            if (sharedInputStream != null) {
                                l2 = sharedInputStream.getPosition() - 1L;
                            }
                            n3 = n5;
                            if (n5 != 13) continue;
                            inputStream.mark(1);
                            n5 = inputStream.read();
                            if (n5 == 10) {
                                n4 = n5;
                                continue;
                            }
                            inputStream.reset();
                            continue;
                        }
                        bl2 = false;
                        if (byteArrayOutputStream == null) continue;
                        byteArrayOutputStream.write(n5);
                    }
                    MimeBodyPart mimeBodyPart = sharedInputStream != null ? this.createMimeBodyPart(sharedInputStream.newStream(l, l2)) : this.createMimeBodyPart(internetHeaders, byteArrayOutputStream.toByteArray());
                    super.addBodyPart(mimeBodyPart);
                }
            }
            catch (IOException iOException) {
                throw new MessagingException("IO Error", iOException);
            }
            Object var26_28 = null;
        }
        catch (Throwable throwable) {
            Object var26_29 = null;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        inputStream.close();
        this.parsed = true;
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void parsebm() throws MessagingException {
        block64: {
            if (this.parsed) {
                return;
            }
            var1_1 = null;
            var2_2 = null;
            var3_3 = 0L;
            var5_4 = 0L;
            try {
                var1_1 = this.ds.getInputStream();
                if (!(var1_1 instanceof ByteArrayInputStream || var1_1 instanceof BufferedInputStream || var1_1 instanceof SharedInputStream)) {
                    var1_1 = new BufferedInputStream(var1_1);
                }
            }
            catch (Exception var7_5) {
                throw new MessagingException("No inputstream from datasource", var7_5);
            }
            if (var1_1 instanceof SharedInputStream) {
                var2_2 = (SharedInputStream)var1_1;
            }
            var7_6 = new ContentType(this.contentType);
            var8_7 = null;
            var9_8 = var7_6.getParameter("boundary");
            if (var9_8 != null) {
                var8_7 = "--" + var9_8;
            } else if (!MimeMultipart.ignoreMissingBoundaryParameter) {
                throw new MessagingException("Missing boundary parameter");
            }
            var10_9 = new LineInputStream(var1_1);
            var11_11 = null;
            var13_12 = null;
            while ((var12_13 = var10_9.readLine()) != null) {
                var14_14 = var12_13.length() - 1;
                while (var14_14 >= 0) {
                    var15_16 = var12_13.charAt(var14_14);
                    if (var15_16 != 32 && var15_16 != 9) break;
                    --var14_14;
                }
                var12_13 = var12_13.substring(0, var14_14 + 1);
                if (var8_7 != null) {
                    if (var12_13.equals(var8_7)) {
                        break;
                    }
                } else if (var12_13.startsWith("--")) {
                    var8_7 = var12_13;
                    break;
                }
                if (var12_13.length() <= 0) continue;
                if (var13_12 == null) {
                    try {
                        var13_12 = System.getProperty("line.separator", "\n");
                    }
                    catch (SecurityException var15_17) {
                        var13_12 = "\n";
                    }
                }
                if (var11_11 == null) {
                    var11_11 = new StringBuffer(var12_13.length() + 2);
                }
                var11_11.append(var12_13).append(var13_12);
            }
            if (var12_13 == null) {
                throw new MessagingException("Missing start boundary");
            }
            if (var11_11 != null) {
                this.preamble = var11_11.toString();
            }
            var14_15 = ASCIIUtility.getBytes(var8_7);
            var15_16 = var14_15.length;
            var16_18 = new int[256];
            var17_19 = 0;
            while (var17_19 < var15_16) {
                var16_18[var14_15[var17_19]] = var17_19 + 1;
                ++var17_19;
            }
            var18_20 = new int[var15_16];
            var19_21 = var15_16;
            while (var19_21 > 0) {
                block61: {
                    var20_22 = var15_16 - 1;
                    while (var20_22 >= var19_21) {
                        if (var14_15[var20_22] == var14_15[var20_22 - var19_21]) {
                            var18_20[var20_22 - 1] = var19_21;
                            --var20_22;
                            continue;
                        }
                        break block61;
                    }
                    while (var20_22 > 0) {
                        var18_20[--var20_22] = var19_21;
                    }
                }
                --var19_21;
            }
            var18_20[var15_16 - 1] = 1;
            var20_22 = 0;
            while (var20_22 == 0) {
                var21_23 = null;
                if (var2_2 != null) {
                    var3_3 = var2_2.getPosition();
                    while ((var12_13 = var10_9.readLine()) != null && var12_13.length() > 0) {
                    }
                    if (var12_13 == null) {
                        if (!MimeMultipart.ignoreMissingEndBoundary) {
                            throw new MessagingException("missing multipart end boundary");
                        }
                        this.complete = false;
                        break;
                    }
                } else {
                    var21_23 = this.createInternetHeaders(var1_1);
                }
                if (!var1_1.markSupported()) {
                    throw new MessagingException("Stream doesn't support mark");
                }
                var22_24 = null;
                if (var2_2 == null) {
                    var22_24 = new ByteArrayOutputStream();
                } else {
                    var5_4 = var2_2.getPosition();
                }
                var24_26 = new byte[var15_16];
                var25_27 = new byte[var15_16];
                var26_28 = 0;
                var27_29 = 0;
                var29_31 = true;
                while (true) {
                    block62: {
                        block63: {
                            var1_1.mark(var15_16 + 4 + 1000);
                            var28_30 = 0;
                            var26_28 = MimeMultipart.readFully(var1_1, var24_26, 0, var15_16);
                            if (var26_28 < var15_16) {
                                if (!MimeMultipart.ignoreMissingEndBoundary) {
                                    throw new MessagingException("missing multipart end boundary");
                                }
                                if (var2_2 != null) {
                                    var5_4 = var2_2.getPosition();
                                }
                                this.complete = false;
                                var20_22 = 1;
                                break;
                            }
                            var30_33 = var15_16 - 1;
                            while (var30_33 >= 0) {
                                if (var24_26[var30_33] != var14_15[var30_33]) break;
                                --var30_33;
                            }
                            if (var30_33 >= 0) break block62;
                            var28_30 = 0;
                            if (!(var29_31 || (var23_25 = var25_27[var27_29 - 1]) != 13 && var23_25 != 10)) {
                                var28_30 = 1;
                                if (var23_25 == 10 && var27_29 >= 2 && (var23_25 = var25_27[var27_29 - 2]) == 13) {
                                    var28_30 = 2;
                                }
                            }
                            if (!var29_31 && var28_30 <= 0) break block63;
                            if (var2_2 != null) {
                                var5_4 = var2_2.getPosition() - (long)var15_16 - (long)var28_30;
                            }
                            if ((var31_34 = var1_1.read()) != 45 || var1_1.read() != 45) ** GOTO lbl142
                            this.complete = true;
                            var20_22 = 1;
                            break;
lbl-1000:
                            // 1 sources

                            {
                                var31_34 = var1_1.read();
lbl142:
                                // 2 sources

                                ** while (var31_34 == 32 || var31_34 == 9)
                            }
lbl143:
                            // 1 sources

                            if (var31_34 == 10) break;
                            if (var31_34 == 13) {
                                var1_1.mark(1);
                                if (var1_1.read() == 10) break;
                                var1_1.reset();
                                break;
                            }
                        }
                        var30_33 = 0;
                    }
                    if ((var31_34 = Math.max(var30_33 + 1 - var16_18[var24_26[var30_33] & 127], var18_20[var30_33])) < 2) {
                        if (var2_2 == null && var27_29 > 1) {
                            var22_24.write(var25_27, 0, var27_29 - 1);
                        }
                        var1_1.reset();
                        this.skipFully(var1_1, 1L);
                        if (var27_29 >= 1) {
                            var25_27[0] = var25_27[var27_29 - 1];
                            var25_27[1] = var24_26[0];
                            var27_29 = 2;
                        } else {
                            var25_27[0] = var24_26[0];
                            var27_29 = 1;
                        }
                    } else {
                        if (var27_29 > 0 && var2_2 == null) {
                            var22_24.write(var25_27, 0, var27_29);
                        }
                        var27_29 = var31_34;
                        var1_1.reset();
                        this.skipFully(var1_1, var27_29);
                        var32_35 = var24_26;
                        var24_26 = var25_27;
                        var25_27 = var32_35;
                    }
                    var29_31 = false;
                }
                if (var2_2 != null) {
                    var30_32 = this.createMimeBodyPart(var2_2.newStream(var3_3, var5_4));
                } else {
                    if (var27_29 - var28_30 > 0) {
                        var22_24.write(var25_27, 0, var27_29 - var28_30);
                    }
                    if (!this.complete && var26_28 > 0) {
                        var22_24.write(var24_26, 0, var26_28);
                    }
                    var30_32 = this.createMimeBodyPart(var21_23, var22_24.toByteArray());
                }
                super.addBodyPart(var30_32);
            }
            var34_36 = null;
            try {
                var1_1.close();
            }
            catch (IOException var35_38) {}
            break block64;
            {
                catch (IOException var10_10) {
                    throw new MessagingException("IO Error", var10_10);
                }
            }
            catch (Throwable var33_40) {
                var34_37 = null;
                try {
                    var1_1.close();
                }
                catch (IOException var35_39) {
                    // empty catch block
                }
                throw var33_40;
            }
        }
        this.parsed = true;
    }

    private static int readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        while (n2 > 0) {
            int n4 = inputStream.read(byArray, n, n2);
            if (n4 <= 0) break;
            n += n4;
            n3 += n4;
            n2 -= n4;
        }
        return n3 > 0 ? n3 : -1;
    }

    private void skipFully(InputStream inputStream, long l) throws IOException {
        while (l > 0L) {
            long l2 = inputStream.skip(l);
            if (l2 <= 0L) {
                throw new EOFException("can't skip");
            }
            l -= l2;
        }
    }

    protected InternetHeaders createInternetHeaders(InputStream inputStream) throws MessagingException {
        return new InternetHeaders(inputStream);
    }

    protected MimeBodyPart createMimeBodyPart(InternetHeaders internetHeaders, byte[] byArray) throws MessagingException {
        return new MimeBodyPart(internetHeaders, byArray);
    }

    protected MimeBodyPart createMimeBodyPart(InputStream inputStream) throws MessagingException {
        return new MimeBodyPart(inputStream);
    }

    static {
        try {
            String string = System.getProperty("mail.mime.multipart.ignoremissingendboundary");
            ignoreMissingEndBoundary = string == null || !string.equalsIgnoreCase("false");
            string = System.getProperty("mail.mime.multipart.ignoremissingboundaryparameter");
            ignoreMissingBoundaryParameter = string == null || !string.equalsIgnoreCase("false");
            string = System.getProperty("mail.mime.multipart.bmparse");
            bmparse = string == null || !string.equalsIgnoreCase("false");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

