/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.table;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.table.SortableTableData;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;

public class TinyTableHeaderRenderer
extends DefaultTableCellRenderer
implements UIResource {
    private static final Icon arrowNo = new Arrow(true, -1);
    private static final Icon[][] arrows = new Icon[2][4];
    private int[] horizontalAlignments;

    public TinyTableHeaderRenderer() {
        this.setHorizontalAlignment(0);
        this.setHorizontalTextPosition(2);
    }

    public void setHorizontalAlignments(int[] nArray) {
        this.horizontalAlignments = nArray;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel == null || !"TinyLookAndFeel".equals(lookAndFeel.getName())) {
            JTableHeader jTableHeader;
            if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                this.setBackground(jTableHeader.getBackground());
                this.setForeground(jTableHeader.getForeground());
                this.setFont(jTableHeader.getFont());
            }
            this.setIcon(null);
            this.setText(object == null ? "" : object.toString());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
        boolean bl3 = false;
        Icon icon = arrowNo;
        int n3 = 1;
        int n4 = -1;
        boolean bl4 = false;
        if (jTable != null) {
            int n5;
            Object object2;
            JTableHeader jTableHeader = jTable.getTableHeader();
            if (jTableHeader != null) {
                object2 = jTableHeader.getClientProperty("rolloverColumn");
                if (object2 != null && (n5 = ((Integer)object2).intValue()) == n2) {
                    bl3 = true;
                }
                if ((object2 = jTableHeader.getClientProperty("sortedColumn")) != null) {
                    int[] nArray = (int[])object2;
                    n4 = -1;
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i] != n2) continue;
                        n4 = i;
                    }
                    if (n4 > -1) {
                        bl4 = true;
                        object2 = jTableHeader.getClientProperty("sortingDirection");
                        if (object2 != null) {
                            int[] nArray2 = (int[])object2;
                            n3 = nArray2[n4];
                        }
                    }
                }
                if (bl3) {
                    this.setBackground(Theme.tableHeaderRolloverBackColor[Theme.style].getColor());
                } else {
                    this.setBackground(jTableHeader.getBackground());
                }
                this.setForeground(jTableHeader.getForeground());
                this.setFont(jTableHeader.getFont());
            }
            if ((object2 = jTable.getModel()) instanceof SortableTableData) {
                if (bl4) {
                    n5 = Math.min(3, n4);
                    if (n3 == 1) {
                        if (arrows[0][n5] == null) {
                            TinyTableHeaderRenderer.arrows[0][n5] = new Arrow(false, n4);
                        }
                        icon = arrows[0][n5];
                    } else {
                        if (arrows[1][n5] == null) {
                            TinyTableHeaderRenderer.arrows[1][n5] = new Arrow(true, n4);
                        }
                        icon = arrows[1][n5];
                    }
                } else {
                    n5 = jTable.getColumnModel().getColumn(n2).getModelIndex();
                    if (!((SortableTableData)object2).isColumnSortable(n5)) {
                        icon = null;
                    }
                }
            } else {
                icon = null;
                this.setToolTipText(null);
            }
        }
        this.setIcon(icon);
        this.setText(object == null ? "" : object.toString());
        if (bl3) {
            this.setBorder(UIManager.getBorder("TableHeader.cellRolloverBorder"));
        } else {
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        }
        int n6 = jTable.getColumnModel().getColumn(n2).getModelIndex();
        if (this.horizontalAlignments != null && this.horizontalAlignments.length > n6) {
            this.setHorizontalAlignment(this.horizontalAlignments[n6]);
        }
        return this;
    }

    private static class Arrow
    implements Icon {
        private static final int height = 11;
        private boolean descending;
        private int priority;

        public Arrow(boolean bl, int n) {
            this.descending = bl;
            this.priority = Math.min(3, n);
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.priority == -1) {
                return;
            }
            int n3 = this.priority;
            int n4 = (6 + this.priority) / 2;
            graphics.translate(n + n3, n2 + n4);
            graphics.setColor(Theme.tableHeaderArrowColor[Theme.style].getColor());
            if (this.descending) {
                switch (this.priority) {
                    case 0: {
                        graphics.drawLine(4, 4, 4, 4);
                        graphics.drawLine(3, 3, 5, 3);
                        graphics.drawLine(2, 2, 6, 2);
                        graphics.drawLine(1, 1, 7, 1);
                        graphics.drawLine(0, 0, 8, 0);
                        break;
                    }
                    case 1: {
                        graphics.drawLine(3, 3, 3, 3);
                        graphics.drawLine(2, 2, 4, 2);
                        graphics.drawLine(1, 1, 5, 1);
                        graphics.drawLine(0, 0, 6, 0);
                        break;
                    }
                    case 2: {
                        graphics.drawLine(2, 2, 2, 2);
                        graphics.drawLine(1, 1, 3, 1);
                        graphics.drawLine(0, 0, 4, 0);
                        break;
                    }
                    default: {
                        graphics.drawLine(1, 1, 1, 1);
                        graphics.drawLine(0, 0, 2, 0);
                        break;
                    }
                }
            } else {
                switch (this.priority) {
                    case 0: {
                        graphics.drawLine(4, 0, 4, 0);
                        graphics.drawLine(3, 1, 5, 1);
                        graphics.drawLine(2, 2, 6, 2);
                        graphics.drawLine(1, 3, 7, 3);
                        graphics.drawLine(0, 4, 8, 4);
                        break;
                    }
                    case 1: {
                        graphics.drawLine(3, 0, 3, 0);
                        graphics.drawLine(2, 1, 4, 1);
                        graphics.drawLine(1, 2, 5, 2);
                        graphics.drawLine(0, 3, 6, 3);
                        break;
                    }
                    case 2: {
                        graphics.drawLine(2, 0, 2, 0);
                        graphics.drawLine(1, 1, 3, 1);
                        graphics.drawLine(0, 2, 4, 2);
                        break;
                    }
                    default: {
                        graphics.drawLine(1, 0, 1, 0);
                        graphics.drawLine(0, 1, 2, 1);
                    }
                }
            }
            graphics.translate(-(n + n3), -(n2 + n4));
        }

        public int getIconWidth() {
            return 9;
        }

        public int getIconHeight() {
            return 11;
        }
    }
}

