/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.controlpanel;

import de.muntjak.tinylookandfeel.controlpanel.ColorRoutines;
import de.muntjak.tinylookandfeel.controlpanel.ControlPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class SBChooser
extends JDialog {
    private static SBChooser myInstance;
    private static int sat;
    private static int bri;
    private Color reference;
    private Color outColor;
    private JSlider satSlider;
    private JSlider briSlider;
    private JTextField satField;
    private JTextField briField;
    private JTextField redField;
    private JTextField greenField;
    private JTextField blueField;
    private TwoColorField twoColorField;
    private ColorField referenceField;
    private boolean keyInput = false;
    private boolean valueIsAdjusting = false;

    public SBChooser(Frame frame) {
        super(frame, "Saturation/Lightness", true);
        this.setDefaultCloseOperation(1);
        this.setupUI(frame);
    }

    private void setupUI(Frame frame) {
        SliderAction sliderAction = new SliderAction();
        JPanel jPanel = new JPanel(new BorderLayout(12, 0));
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 0, 8));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 2, 4));
        JPanel jPanel4 = new JPanel(new BorderLayout(4, 0));
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel4.add((Component)new JLabel("Saturation"), "North");
        this.satSlider = new JSlider(-100, 100, sat);
        this.satSlider.addChangeListener(sliderAction);
        this.satSlider.setMajorTickSpacing(100);
        this.satSlider.setPaintTicks(true);
        jPanel4.add((Component)this.satSlider, "Center");
        this.satField = new JTextField("" + this.satSlider.getValue(), 4);
        this.satField.getDocument().addDocumentListener(new SatInputListener());
        this.satField.addKeyListener(new ArrowKeyAction(this.satField, -100, 100));
        this.satField.setHorizontalAlignment(0);
        jPanel5.add(this.satField);
        jPanel4.add((Component)jPanel5, "East");
        jPanel2.add(jPanel4);
        jPanel5 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel4 = new JPanel(new BorderLayout(4, 0));
        jPanel4.add((Component)new JLabel("Lightness"), "North");
        this.briSlider = new JSlider(-100, 100, bri);
        this.briSlider.addChangeListener(sliderAction);
        this.briSlider.setMajorTickSpacing(100);
        this.briSlider.setPaintTicks(true);
        jPanel4.add((Component)this.briSlider, "Center");
        this.briField = new JTextField("" + this.briSlider.getValue(), 4);
        this.briField.getDocument().addDocumentListener(new BriInputListener());
        this.briField.addKeyListener(new ArrowKeyAction(this.briField, -100, 100));
        this.briField.setHorizontalAlignment(0);
        jPanel5.add(this.briField);
        jPanel4.add((Component)jPanel5, "East");
        jPanel2.add(jPanel4);
        jPanel3.add(jPanel2);
        jPanel.add((Component)jPanel3, "Center");
        jPanel2 = new JPanel(new BorderLayout(0, 6));
        jPanel3 = new JPanel(new FlowLayout(0, 4, 4));
        this.twoColorField = new TwoColorField(this.reference);
        jPanel2.add((Component)this.twoColorField, "North");
        this.referenceField = new ColorField(this.reference);
        jPanel2.add((Component)this.referenceField, "Center");
        jPanel3.add(jPanel2);
        jPanel.add((Component)jPanel3, "East");
        jPanel3 = new JPanel(new FlowLayout(0, 3, 8));
        jPanel3.add(new JLabel("R:"));
        this.redField = new JTextField(4);
        this.redField.setHorizontalAlignment(0);
        this.redField.setEditable(false);
        jPanel3.add(this.redField);
        jPanel3.add(new JLabel("  G:"));
        this.greenField = new JTextField(4);
        this.greenField.setHorizontalAlignment(0);
        this.greenField.setEditable(false);
        jPanel3.add(this.greenField);
        jPanel3.add(new JLabel("  B:"));
        this.blueField = new JTextField(4);
        this.blueField.setHorizontalAlignment(0);
        this.blueField.setEditable(false);
        jPanel3.add(this.blueField);
        jPanel.add((Component)jPanel3, "South");
        this.getContentPane().add((Component)jPanel, "Center");
        jPanel3 = new JPanel(new FlowLayout(2, 12, 4));
        jPanel3.setBorder(new EtchedBorder());
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(new CancelAction());
        jPanel3.add(jButton);
        jButton = new JButton("OK");
        this.getRootPane().setDefaultButton(jButton);
        jButton.addActionListener(new OKAction());
        jPanel3.add(jButton);
        this.getContentPane().add((Component)jPanel3, "South");
        this.pack();
        Dimension dimension = this.getSize();
        this.setLocation(frame.getLocationOnScreen().x + (frame.getWidth() - this.getSize().width) / 2, frame.getLocationOnScreen().y + (frame.getHeight() - this.getSize().height) / 2);
    }

    public static Color showSBChooser(Frame frame, Color color, Color color2, int n, int n2) {
        if (myInstance == null) {
            myInstance = new SBChooser(frame);
        }
        myInstance.setColor(color, color2, n, n2);
        myInstance.setVisible(true);
        return SBChooser.myInstance.outColor;
    }

    public static Color showSBChooser(Frame frame, ControlPanel.SBField sBField) {
        if (myInstance == null) {
            myInstance = new SBChooser(frame);
        }
        myInstance.setColor(sBField);
        myInstance.setVisible(true);
        return SBChooser.myInstance.outColor;
    }

    public static void deleteInstance() {
        myInstance = null;
    }

    public void setColor(ControlPanel.SBField sBField) {
        this.reference = sBField.getColorReference().getReferenceColor();
        this.outColor = sBField.getBackground();
        sat = sBField.getColorReference().getSaturation();
        bri = sBField.getColorReference().getBrightness();
        this.valueIsAdjusting = true;
        this.satSlider.setValue(sat);
        this.briSlider.setValue(bri);
        this.valueIsAdjusting = false;
        this.referenceField.setBackground(this.reference);
        this.twoColorField.setLowerColor(this.outColor);
        this.adjustColor();
    }

    public void setColor(Color color, Color color2, int n, int n2) {
        this.reference = color;
        this.outColor = color2;
        sat = n;
        bri = n2;
        this.valueIsAdjusting = true;
        this.satSlider.setValue(sat);
        this.briSlider.setValue(bri);
        this.valueIsAdjusting = false;
        this.referenceField.setBackground(this.reference);
        this.twoColorField.setLowerColor(color2);
        this.adjustColor();
    }

    private void showColor(int n, int n2) {
        sat = n;
        bri = n2;
        this.adjustColor();
    }

    private void adjustColor() {
        this.outColor = SBChooser.getAdjustedColor(this.reference, sat, bri);
        this.twoColorField.setUpperColor(this.outColor);
    }

    public static Color getAdjustedColor(Color color, int n, int n2) {
        int n3;
        int n4;
        int n5;
        Color color2 = color;
        if (n2 < 0) {
            color2 = ColorRoutines.darken(color, -n2);
        } else if (n2 > 0) {
            color2 = ColorRoutines.lighten(color, n2);
        }
        Color color3 = ColorRoutines.getMaxSaturation(color2, ColorRoutines.getHue(color));
        if (n >= 0) {
            int n6 = color2.getRed() - color3.getRed();
            int n7 = color2.getGreen() - color3.getGreen();
            int n8 = color2.getBlue() - color3.getBlue();
            n5 = color2.getRed() - (int)Math.round((double)(n6 * n) / 100.0);
            n4 = color2.getGreen() - (int)Math.round((double)(n7 * n) / 100.0);
            n3 = color2.getBlue() - (int)Math.round((double)(n8 * n) / 100.0);
        } else {
            float f = ColorRoutines.getGreyValue(color2);
            float f2 = (float)color2.getRed() - f;
            float f3 = (float)color2.getGreen() - f;
            float f4 = (float)color2.getBlue() - f;
            n5 = (int)Math.round((double)color2.getRed() + (double)(f2 * (float)n) / 100.0);
            n4 = (int)Math.round((double)color2.getGreen() + (double)(f3 * (float)n) / 100.0);
            n3 = (int)Math.round((double)color2.getBlue() + (double)(f4 * (float)n) / 100.0);
        }
        return new Color(n5, n4, n3);
    }

    public static int getSat() {
        return sat;
    }

    public static int getBri() {
        return bri;
    }

    class CancelAction
    implements ActionListener {
        CancelAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SBChooser.this.outColor = null;
            SBChooser.this.setVisible(false);
        }
    }

    class OKAction
    implements ActionListener {
        OKAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SBChooser.this.setVisible(false);
        }
    }

    class ArrowKeyAction
    extends KeyAdapter
    implements ActionListener {
        private JTextField theField;
        private Timer keyTimer;
        private int step;
        private int min;
        private int max;

        ArrowKeyAction(JTextField jTextField, int n, int n2) {
            this.theField = jTextField;
            this.min = n;
            this.max = n2;
            this.keyTimer = new Timer(20, this);
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 38) {
                this.step = 1;
                if (keyEvent.getModifiers() == 1) {
                    this.step = 10;
                }
                this.changeVal();
                this.keyTimer.setInitialDelay(300);
                this.keyTimer.start();
            } else if (keyEvent.getKeyCode() == 40) {
                this.step = -1;
                if (keyEvent.getModifiers() == 1) {
                    this.step = -10;
                }
                this.changeVal();
                this.keyTimer.setInitialDelay(300);
                this.keyTimer.start();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.keyTimer.stop();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.changeVal();
        }

        private void changeVal() {
            int n = Integer.parseInt(this.theField.getText()) + this.step;
            if (n > this.max) {
                n = this.max;
            } else if (n < this.min) {
                n = this.min;
            }
            this.theField.setText("" + n);
        }
    }

    class BriInputListener
    implements DocumentListener {
        BriInputListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        private void update(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            try {
                String string = document.getText(0, document.getLength());
                try {
                    int n = Integer.parseInt(string);
                    SBChooser.this.keyInput = true;
                    SBChooser.this.briSlider.setValue(n);
                    SBChooser.this.keyInput = false;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    class SatInputListener
    implements DocumentListener {
        SatInputListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        private void update(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            try {
                String string = document.getText(0, document.getLength());
                try {
                    int n = Integer.parseInt(string);
                    SBChooser.this.keyInput = true;
                    SBChooser.this.satSlider.setValue(n);
                    SBChooser.this.keyInput = false;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    class SliderAction
    implements ChangeListener {
        SliderAction() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (!SBChooser.this.keyInput) {
                if (changeEvent.getSource().equals(SBChooser.this.satSlider)) {
                    SBChooser.this.satField.setText("" + SBChooser.this.satSlider.getValue());
                } else {
                    SBChooser.this.briField.setText("" + SBChooser.this.briSlider.getValue());
                }
            }
            if (SBChooser.this.valueIsAdjusting) {
                return;
            }
            SBChooser.this.showColor(SBChooser.this.satSlider.getValue(), SBChooser.this.briSlider.getValue());
        }
    }

    class ColorField
    extends JPanel {
        private Dimension size = new Dimension(60, 38);

        ColorField(Color color) {
            this.setBorder(new LineBorder(Color.GRAY, 1));
            this.setBackground(color);
        }

        public Dimension getPreferredSize() {
            return this.size;
        }
    }

    class TwoColorField
    extends JPanel {
        private Dimension size = new Dimension(60, 68);
        private Color upperColor;
        private Color lowerColor;

        TwoColorField(Color color) {
            this.setBorder(new LineBorder(Color.BLACK, 1));
            this.upperColor = SBChooser.this.outColor;
            this.lowerColor = color;
        }

        public Dimension getPreferredSize() {
            return this.size;
        }

        void setUpperColor(Color color) {
            this.upperColor = color;
            SBChooser.this.redField.setText("" + color.getRed());
            SBChooser.this.greenField.setText("" + color.getGreen());
            SBChooser.this.blueField.setText("" + color.getBlue());
            this.repaint(0L);
        }

        void setLowerColor(Color color) {
            this.lowerColor = color;
            this.repaint(0L);
        }

        public void paint(Graphics graphics) {
            super.paintBorder(graphics);
            graphics.setColor(this.upperColor);
            graphics.fillRect(1, 1, 58, 33);
            graphics.setColor(this.lowerColor);
            graphics.fillRect(1, 34, 58, 33);
        }
    }
}

