/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.controlpanel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.ColorRoutines;
import de.muntjak.tinylookandfeel.controlpanel.NumericTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;

public class PSColorChooser
extends JDialog {
    private Color inColor;
    private Color outColor;
    private static PSColorChooser myInstance;
    private ColorSelector colorSelector;
    private HueSelector hueSelector;
    private TwoColorField twoColorField;
    private NumericTextField redField;
    private NumericTextField greenField;
    private NumericTextField blueField;
    private NumericTextField satField;
    private NumericTextField briField;
    private NumericTextField hueField;
    private JButton ok;
    private boolean spinnerUpdate = false;
    private static Cursor cs_cursor;
    private static BufferedImage brightmask;
    private static GraphicsConfiguration conf;
    static /* synthetic */ Class class$de$muntjak$tinylookandfeel$controlpanel$PSColorChooser;

    private static Cursor loadCursor() {
        ImageIcon imageIcon = null;
        Cursor cursor = null;
        Dimension dimension = Toolkit.getDefaultToolkit().getBestCursorSize(16, 16);
        if (dimension.width == 32) {
            imageIcon = PSColorChooser.loadImageIcon("/de/muntjak/tinylookandfeel/icons/cs32.gif");
            cursor = Toolkit.getDefaultToolkit().createCustomCursor(imageIcon.getImage(), new Point(15, 15), "cs_cursor");
        } else if (dimension.width == 16) {
            imageIcon = PSColorChooser.loadImageIcon("/de/muntjak/tinylookandfeel/icons/cs16.gif");
            cursor = Toolkit.getDefaultToolkit().createCustomCursor(imageIcon.getImage(), new Point(7, 7), "cs_cursor");
        }
        return cursor;
    }

    private static BufferedImage loadBrightmask() {
        ImageIcon imageIcon = PSColorChooser.loadImageIcon("/de/muntjak/tinylookandfeel/icons/brightmask.png");
        int n = imageIcon.getIconWidth();
        int n2 = imageIcon.getIconHeight();
        BufferedImage bufferedImage = conf.createCompatibleImage(n, n2, 3);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(imageIcon.getImage(), 0, 0, n, n2, 0, 0, n, n2, null);
        return bufferedImage;
    }

    protected static ImageIcon loadImageIcon(String string) {
        return new ImageIcon((class$de$muntjak$tinylookandfeel$controlpanel$PSColorChooser == null ? (class$de$muntjak$tinylookandfeel$controlpanel$PSColorChooser = PSColorChooser.class$("de.muntjak.tinylookandfeel.controlpanel.PSColorChooser")) : class$de$muntjak$tinylookandfeel$controlpanel$PSColorChooser).getResource(string));
    }

    private PSColorChooser(Frame frame, Color color) {
        super(frame, "PSColorChooser", true);
        this.setDefaultCloseOperation(1);
        this.inColor = color;
        this.outColor = color;
        this.setupUI(frame, color);
    }

    public static Color showColorChooser(Frame frame, Color color) {
        if (myInstance == null) {
            myInstance = new PSColorChooser(frame, color);
        }
        myInstance.setColor(color);
        myInstance.setVisible(true);
        return PSColorChooser.myInstance.outColor;
    }

    public static void deleteInstance() {
        myInstance = null;
    }

    public void setColor(Color color) {
        this.spinnerUpdate = true;
        this.outColor = this.inColor = color;
        int n = ColorRoutines.getHue(color);
        int n2 = ColorRoutines.getSaturation(color);
        int n3 = ColorRoutines.getBrightness(color);
        this.satField.setValue(n2);
        this.briField.setValue(n3);
        this.hueField.setValue(n);
        this.redField.setValue(color.getRed());
        this.greenField.setValue(color.getGreen());
        this.blueField.setValue(color.getBlue());
        this.colorSelector.setColor(color);
        this.hueSelector.setHue(n);
        this.twoColorField.setUpperColor(color);
        this.twoColorField.setLowerColor(color);
        this.spinnerUpdate = false;
    }

    private void colorChanged(Color color) {
        this.spinnerUpdate = true;
        int n = ColorRoutines.getHue(color);
        int n2 = ColorRoutines.getSaturation(color);
        int n3 = ColorRoutines.getBrightness(color);
        this.satField.setValue(n2);
        this.briField.setValue(n3);
        this.hueField.setValue(n);
        this.redField.setValue(color.getRed());
        this.greenField.setValue(color.getGreen());
        this.blueField.setValue(color.getBlue());
        this.twoColorField.setUpperColor(color);
        this.spinnerUpdate = false;
    }

    private void hueChanged(int n) {
        this.spinnerUpdate = true;
        int n2 = this.satField.getValue();
        int n3 = this.briField.getValue();
        this.hueField.setValue(n);
        Color color = Color.getHSBColor((float)n / 360.0f, (float)n2 / 100.0f, (float)n3 / 100.0f);
        this.redField.setValue(color.getRed());
        this.greenField.setValue(color.getGreen());
        this.blueField.setValue(color.getBlue());
        this.twoColorField.setUpperColor(color);
        this.colorSelector.setColor(color);
        this.spinnerUpdate = false;
    }

    private void setupUI(Frame frame, Color color) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 6, 7));
        int n = ColorRoutines.getHue(color);
        this.colorSelector = new ColorSelector(color);
        jPanel3.add(this.colorSelector);
        jPanel.add((Component)jPanel3, "West");
        jPanel3 = new JPanel(new FlowLayout(0, 6, 3));
        this.hueSelector = new HueSelector(n);
        jPanel3.add(this.hueSelector);
        jPanel.add((Component)jPanel3, "Center");
        jPanel2.add((Component)jPanel, "Center");
        jPanel = new JPanel(new BorderLayout());
        jPanel3 = new JPanel(new FlowLayout(0, 6, 7));
        this.twoColorField = new TwoColorField(color);
        jPanel3.add(this.twoColorField);
        jPanel.add((Component)jPanel3, "North");
        jPanel3 = new JPanel(new FlowLayout(0, 6, 7));
        jPanel3.add(this.createNumericTextFields());
        jPanel.add((Component)jPanel3, "Center");
        jPanel2.add((Component)jPanel, "East");
        this.getContentPane().add((Component)jPanel2, "North");
        jPanel3 = new JPanel(new FlowLayout(2, 12, 4));
        jPanel3.setBorder(new EtchedBorder());
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(new CancelAction());
        jPanel3.add(jButton);
        jButton = new JButton("OK");
        jButton.addActionListener(new OKAction());
        this.getRootPane().setDefaultButton(jButton);
        jPanel3.add(jButton);
        this.getContentPane().add((Component)jPanel3, "South");
        this.pack();
        Dimension dimension = this.getSize();
        this.setLocation(frame.getLocationOnScreen().x + (frame.getWidth() - this.getSize().width) / 2, frame.getLocationOnScreen().y + (frame.getHeight() - this.getSize().height) / 2);
    }

    private JPanel createNumericTextFields() {
        RGBAction rGBAction = new RGBAction();
        HSBAction hSBAction = new HSBAction();
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 4, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)new JLabel("H:"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.hueField = new NumericTextField(3, 0, 0, 360);
        this.hueField.addActionListener(hSBAction);
        jPanel.add((Component)this.hueField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel("S:"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.satField = new NumericTextField(3, 0, 0, 100);
        this.satField.addActionListener(hSBAction);
        jPanel.add((Component)this.satField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel("B:"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.briField = new NumericTextField(3, 0, 0, 100);
        this.briField.addActionListener(hSBAction);
        jPanel.add((Component)this.briField, gridBagConstraints);
        gridBagConstraints.insets = new Insets(8, 0, 4, 2);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel("R:"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.redField = new NumericTextField(3, 0, 0, 255);
        this.redField.addActionListener(rGBAction);
        jPanel.add((Component)this.redField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 0, 4, 2);
        jPanel.add((Component)new JLabel("G:"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.greenField = new NumericTextField(3, 0, 0, 255);
        this.greenField.addActionListener(rGBAction);
        jPanel.add((Component)this.greenField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel("B:"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.blueField = new NumericTextField(3, 0, 0, 255);
        this.blueField.addActionListener(rGBAction);
        jPanel.add((Component)this.blueField, gridBagConstraints);
        return jPanel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        conf = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
        brightmask = PSColorChooser.loadBrightmask();
        cs_cursor = PSColorChooser.loadCursor();
    }

    class CancelAction
    implements ActionListener {
        CancelAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PSColorChooser.this.outColor = null;
            PSColorChooser.this.setVisible(false);
        }
    }

    class OKAction
    implements ActionListener {
        OKAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PSColorChooser.this.setVisible(false);
        }
    }

    class HSBAction
    implements ActionListener {
        HSBAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PSColorChooser.this.spinnerUpdate) {
                return;
            }
            int n = PSColorChooser.this.hueField.getValue();
            int n2 = PSColorChooser.this.satField.getValue();
            int n3 = PSColorChooser.this.briField.getValue();
            Color color = Color.getHSBColor((float)n / 360.0f, (float)n2 / 100.0f, (float)n3 / 100.0f);
            PSColorChooser.this.twoColorField.setUpperColor(color);
            PSColorChooser.this.spinnerUpdate = true;
            PSColorChooser.this.redField.setValue(color.getRed());
            PSColorChooser.this.greenField.setValue(color.getGreen());
            PSColorChooser.this.blueField.setValue(color.getBlue());
            PSColorChooser.this.spinnerUpdate = false;
            PSColorChooser.this.hueSelector.setHue(n);
            PSColorChooser.this.colorSelector.setColor(color);
        }
    }

    class RGBAction
    implements ActionListener {
        RGBAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PSColorChooser.this.spinnerUpdate) {
                return;
            }
            int n = PSColorChooser.this.redField.getValue();
            int n2 = PSColorChooser.this.greenField.getValue();
            int n3 = PSColorChooser.this.blueField.getValue();
            Color color = new Color(n, n2, n3);
            PSColorChooser.this.twoColorField.setUpperColor(color);
            PSColorChooser.this.spinnerUpdate = true;
            int n4 = ColorRoutines.getHue(color);
            PSColorChooser.this.hueField.setValue(n4);
            PSColorChooser.this.satField.setValue(ColorRoutines.getSaturation(color));
            PSColorChooser.this.briField.setValue(ColorRoutines.getBrightness(color));
            PSColorChooser.this.spinnerUpdate = false;
            PSColorChooser.this.hueSelector.setHue(n4);
            PSColorChooser.this.colorSelector.setColor(color);
        }
    }

    class HueSelector
    extends JPanel {
        private Color darkColor = new Color(128, 128, 128);
        private Dimension size = new Dimension(35, 266);
        private float hue;
        private int arrowY;
        private Vector listeners;

        HueSelector(int n) {
            this.hue = (float)((double)n / 360.0);
            this.addMouseListener(new Mousey());
            this.addMouseMotionListener(new MouseyDrag());
        }

        void setHue(int n) {
            this.hue = (float)((double)n / 360.0);
            this.repaint(0L);
        }

        public Dimension getPreferredSize() {
            return this.size;
        }

        public void paint(Graphics graphics) {
            graphics.setColor(Theme.backColor[Theme.style].getColor());
            graphics.fillRect(0, 0, 35, 266);
            this.drawArrows(graphics);
            graphics.setColor(this.darkColor);
            graphics.drawLine(6, 3, 27, 3);
            graphics.drawLine(6, 3, 6, 261);
            graphics.setColor(Color.WHITE);
            graphics.drawLine(6, 262, 28, 262);
            graphics.drawLine(28, 3, 28, 261);
            graphics.setColor(Color.BLACK);
            graphics.drawRect(7, 4, 20, 257);
            int n = 8;
            int n2 = 26;
            int n3 = 5;
            for (int i = 0; i < 256; ++i) {
                float f = (float)((double)(255 - i) / 255.0);
                graphics.setColor(Color.getHSBColor(f, 1.0f, 1.0f));
                graphics.drawLine(n, i + n3, n2, i + n3);
            }
        }

        private void drawArrows(Graphics graphics) {
            this.arrowY = 260 - (int)((double)this.hue * 255.0);
            graphics.setColor(Color.BLACK);
            graphics.drawLine(0, this.arrowY - 5, 0, this.arrowY + 5);
            graphics.drawLine(1, this.arrowY - 4, 1, this.arrowY - 4);
            graphics.drawLine(2, this.arrowY - 3, 2, this.arrowY - 3);
            graphics.drawLine(3, this.arrowY - 2, 3, this.arrowY - 2);
            graphics.drawLine(4, this.arrowY - 1, 4, this.arrowY - 1);
            graphics.drawLine(5, this.arrowY, 5, this.arrowY);
            graphics.drawLine(0, this.arrowY + 5, 0, this.arrowY + 5);
            graphics.drawLine(1, this.arrowY + 4, 1, this.arrowY + 4);
            graphics.drawLine(2, this.arrowY + 3, 2, this.arrowY + 3);
            graphics.drawLine(3, this.arrowY + 2, 3, this.arrowY + 2);
            graphics.drawLine(4, this.arrowY + 1, 4, this.arrowY + 1);
            graphics.drawLine(34, this.arrowY - 5, 34, this.arrowY + 5);
            graphics.drawLine(33, this.arrowY - 4, 33, this.arrowY - 4);
            graphics.drawLine(32, this.arrowY - 3, 32, this.arrowY - 3);
            graphics.drawLine(31, this.arrowY - 2, 31, this.arrowY - 2);
            graphics.drawLine(30, this.arrowY - 1, 30, this.arrowY - 1);
            graphics.drawLine(29, this.arrowY, 29, this.arrowY);
            graphics.drawLine(34, this.arrowY + 5, 34, this.arrowY + 5);
            graphics.drawLine(33, this.arrowY + 4, 33, this.arrowY + 4);
            graphics.drawLine(32, this.arrowY + 3, 32, this.arrowY + 3);
            graphics.drawLine(31, this.arrowY + 2, 31, this.arrowY + 2);
            graphics.drawLine(30, this.arrowY + 1, 30, this.arrowY + 1);
        }

        class MouseyDrag
        extends MouseMotionAdapter {
            MouseyDrag() {
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                int n = mouseEvent.getY() - 5;
                if (n < 0) {
                    n = 0;
                } else if (n > 255) {
                    n = 255;
                }
                HueSelector.this.hue = (float)((double)(255 - n) / 255.0);
                HueSelector.this.repaint();
                PSColorChooser.this.hueChanged((int)((double)HueSelector.this.hue * 360.0));
            }
        }

        class Mousey
        extends MouseAdapter {
            Mousey() {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getY() < 5 || mouseEvent.getY() > 260) {
                    return;
                }
                HueSelector.this.hue = (float)((double)(255 - (mouseEvent.getY() - 5)) / 255.0);
                HueSelector.this.repaint();
                PSColorChooser.this.hueChanged((int)((double)HueSelector.this.hue * 360.0));
            }
        }
    }

    class TwoColorField
    extends JPanel {
        private Dimension size = new Dimension(60, 68);
        private Color upperColor;
        private Color lowerColor;

        TwoColorField(Color color) {
            this.setBorder(new LineBorder(Color.BLACK, 1));
            this.upperColor = color;
            this.lowerColor = color;
        }

        public Dimension getPreferredSize() {
            return this.size;
        }

        void setUpperColor(Color color) {
            this.upperColor = color;
            PSColorChooser.this.outColor = color;
            this.repaint(0L);
        }

        void setLowerColor(Color color) {
            this.lowerColor = color;
            this.repaint(0L);
        }

        public void paint(Graphics graphics) {
            super.paintBorder(graphics);
            graphics.setColor(this.upperColor);
            graphics.fillRect(1, 1, 58, 33);
            graphics.setColor(this.lowerColor);
            graphics.fillRect(1, 34, 58, 33);
        }
    }

    class ColorSelector
    extends JPanel {
        private Dimension size = new Dimension(258, 258);
        private float hue;
        private int h;
        private int s;
        private int b;
        private int circleX;
        private int circleY;
        private Vector listeners;
        private Color theColor;
        private boolean mousePressed = false;

        ColorSelector(Color color) {
            this.h = ColorRoutines.getHue(color);
            this.s = ColorRoutines.getSaturation(color) * 255 / 100;
            this.b = ColorRoutines.getBrightness(color) * 255 / 100;
            this.hue = (float)((double)this.h / 360.0);
            this.theColor = color;
            this.setBorder(new LineBorder(Color.BLACK, 1));
            this.addMouseListener(new Mousey());
            this.addMouseMotionListener(new MouseyDrag());
            this.setCursor(cs_cursor);
        }

        void setColor(Color color) {
            this.h = PSColorChooser.this.hueField.getValue();
            this.s = PSColorChooser.this.satField.getValue() * 255 / 100;
            this.b = PSColorChooser.this.briField.getValue() * 255 / 100;
            this.hue = (float)((double)this.h / 360.0);
            this.repaint(0L);
        }

        public Dimension getPreferredSize() {
            return this.size;
        }

        public void paint(Graphics graphics) {
            super.paintBorder(graphics);
            if (this.mousePressed) {
                graphics.setClip(this.circleX, this.circleY, 11, 11);
            }
            for (int i = 0; i < 256; ++i) {
                float f = (float)((double)i / 255.0);
                Color color = Color.getHSBColor(this.hue, f, 1.0f);
                graphics.setColor(color);
                graphics.drawLine(i + 1, 1, i + 1, 256);
            }
            graphics.drawImage(brightmask, 1, 1, this);
            this.circleX = this.s - 4;
            this.circleY = 255 - this.b - 4;
            if (this.mousePressed) {
                graphics.setClip(this.circleX, this.circleY, 11, 11);
            }
            if (this.b < 160) {
                graphics.setColor(Color.WHITE);
            } else {
                graphics.setColor(Color.BLACK);
            }
            graphics.drawLine(this.circleX + 3, this.circleY, this.circleX + 7, this.circleY);
            graphics.drawLine(this.circleX + 3, this.circleY + 10, this.circleX + 7, this.circleY + 10);
            graphics.drawLine(this.circleX, this.circleY + 3, this.circleX, this.circleY + 7);
            graphics.drawLine(this.circleX + 10, this.circleY + 3, this.circleX + 10, this.circleY + 7);
            graphics.drawLine(this.circleX + 2, this.circleY + 1, this.circleX + 2, this.circleY + 1);
            graphics.drawLine(this.circleX + 8, this.circleY + 1, this.circleX + 8, this.circleY + 1);
            graphics.drawLine(this.circleX + 1, this.circleY + 2, this.circleX + 1, this.circleY + 2);
            graphics.drawLine(this.circleX + 9, this.circleY + 2, this.circleX + 9, this.circleY + 2);
            graphics.drawLine(this.circleX + 1, this.circleY + 8, this.circleX + 1, this.circleY + 8);
            graphics.drawLine(this.circleX + 9, this.circleY + 8, this.circleX + 9, this.circleY + 8);
            graphics.drawLine(this.circleX + 2, this.circleY + 9, this.circleX + 2, this.circleY + 9);
            graphics.drawLine(this.circleX + 8, this.circleY + 9, this.circleX + 8, this.circleY + 9);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        class MouseyDrag
        extends MouseMotionAdapter {
            MouseyDrag() {
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                ColorSelector.this.s = mouseEvent.getX() - 1;
                if (ColorSelector.this.s < 0) {
                    ColorSelector.this.s = 0;
                } else if (ColorSelector.this.s > 255) {
                    ColorSelector.this.s = 255;
                }
                int n = mouseEvent.getY() - 1;
                if (n < 0) {
                    n = 0;
                } else if (n > 255) {
                    n = 255;
                }
                ColorSelector.this.b = 255 - n;
                ColorSelector.this.paint(ColorSelector.this.getGraphics());
                ColorSelector.this.theColor = Color.getHSBColor(ColorSelector.this.hue, (float)((double)ColorSelector.this.s / 255.0), (float)((double)ColorSelector.this.b / 255.0));
                PSColorChooser.this.colorChanged(ColorSelector.this.theColor);
            }
        }

        class Mousey
        extends MouseAdapter {
            Mousey() {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getX() < 1 || mouseEvent.getX() > 256) {
                    return;
                }
                if (mouseEvent.getY() < 1 || mouseEvent.getY() > 256) {
                    return;
                }
                ColorSelector.this.s = mouseEvent.getX() - 1;
                if (ColorSelector.this.s < 0) {
                    ColorSelector.this.s = 0;
                } else if (ColorSelector.this.s > 255) {
                    ColorSelector.this.s = 255;
                }
                int n = mouseEvent.getY() - 1;
                if (n < 0) {
                    n = 0;
                } else if (n > 255) {
                    n = 255;
                }
                ColorSelector.this.mousePressed = true;
                ColorSelector.this.b = 255 - n;
                ColorSelector.this.paint(ColorSelector.this.getGraphics());
                ColorSelector.this.theColor = Color.getHSBColor(ColorSelector.this.hue, (float)((double)ColorSelector.this.s / 255.0), (float)((double)ColorSelector.this.b / 255.0));
                PSColorChooser.this.colorChanged(ColorSelector.this.theColor);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                ColorSelector.this.mousePressed = false;
            }
        }
    }
}

