/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.controlpanel;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class NumericTextField
extends JTextField {
    private Vector listeners;
    private ActionEvent actionEvent;
    private int min;
    private int max;
    private int columns;
    private boolean resistUpdate;

    public NumericTextField(int n, int n2, int n3, int n4) {
        super(n);
        this.columns = n;
        this.min = n3;
        this.max = n4;
        this.setHorizontalAlignment(4);
        this.setText("" + n2);
        this.addKeyListener(new ArrowKeyAction(this, n3, n4));
        this.actionEvent = new ActionEvent(this, 1001, "");
    }

    public int getValue() {
        if (this.getText().length() == 0) {
            return 0;
        }
        return Integer.parseInt(this.getText());
    }

    public void setValue(int n) {
        if (this.resistUpdate) {
            return;
        }
        this.setText(String.valueOf(n));
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (this.listeners.contains(actionListener)) {
            return;
        }
        this.listeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.listeners == null) {
            return;
        }
        if (!this.listeners.contains(actionListener)) {
            return;
        }
        this.listeners.remove(actionListener);
    }

    public void notifyActionListeners() {
        if (this.listeners == null) {
            return;
        }
        this.resistUpdate = true;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ActionListener)iterator.next()).actionPerformed(this.actionEvent);
        }
        this.resistUpdate = false;
    }

    protected Document createDefaultModel() {
        return new NumericDocument();
    }

    class KeyInputListener
    implements DocumentListener {
        KeyInputListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            NumericTextField.this.notifyActionListeners();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            NumericTextField.this.notifyActionListeners();
        }
    }

    class ArrowKeyAction
    extends KeyAdapter
    implements ActionListener {
        private JTextField theField;
        private Timer keyTimer;
        private int step;

        ArrowKeyAction(JTextField jTextField, int n, int n2) {
            this.theField = jTextField;
            this.keyTimer = new Timer(20, this);
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 38) {
                this.step = 1;
                if (keyEvent.getModifiers() == 1) {
                    this.step = 10;
                }
                this.changeVal();
                this.keyTimer.setInitialDelay(300);
                this.keyTimer.start();
            } else if (keyEvent.getKeyCode() == 40) {
                this.step = -1;
                if (keyEvent.getModifiers() == 1) {
                    this.step = -10;
                }
                this.changeVal();
                this.keyTimer.setInitialDelay(300);
                this.keyTimer.start();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.keyTimer.stop();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.changeVal();
        }

        private void changeVal() {
            int n = Integer.parseInt(this.theField.getText()) + this.step;
            if (n > NumericTextField.this.max) {
                n = NumericTextField.this.max;
            } else if (n < NumericTextField.this.min) {
                n = NumericTextField.this.min;
            }
            this.theField.setText("" + n);
        }
    }

    protected class NumericDocument
    extends PlainDocument {
        NumericDocument() {
            this.addDocumentListener(new KeyInputListener());
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null || string.length() == 0) {
                return;
            }
            if (this.getLength() + string.length() > NumericTextField.this.columns) {
                return;
            }
            if (!this.checkInput(string)) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            String string2 = this.getText(0, this.getLength());
            string2 = n == 0 ? string + string2 : (n >= string2.length() ? string2 + string : string2.substring(0, n) + string + string2.substring(n));
            int n2 = Integer.parseInt(string2);
            boolean bl = false;
            if (n2 < NumericTextField.this.min) {
                n2 = NumericTextField.this.min;
                bl = true;
            } else if (n2 > NumericTextField.this.max) {
                n2 = NumericTextField.this.max;
                bl = true;
            }
            if (bl) {
                this.remove(0, this.getLength());
                super.insertString(0, String.valueOf(n2), attributeSet);
            } else {
                super.insertString(n, string, attributeSet);
            }
        }

        private boolean checkInput(String string) {
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isDigit(string.charAt(i))) continue;
                return false;
            }
            return true;
        }
    }
}

