/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.controlpanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

public class NonSortableTableModel
extends AbstractTableModel {
    protected Vector data;
    private Record template;
    private Vector columnNames;
    private boolean sortable;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$javax$swing$Icon;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;

    public NonSortableTableModel() {
        this(false);
    }

    protected NonSortableTableModel(boolean bl) {
        this.sortable = bl;
        this.createData();
    }

    private void createData() {
        this.columnNames = new Vector();
        this.columnNames.add("C1");
        this.columnNames.add("C2");
        this.columnNames.add("C3");
        this.columnNames.add("C4");
        TableColorIcon.reset();
        this.template = null;
        this.data = new Vector();
        for (int i = 0; i < 50; ++i) {
            Record record = new Record(i + 1);
            this.data.add(record);
            if (this.template != null) continue;
            this.template = record;
        }
    }

    public int getColumnCount() {
        if (this.template == null) {
            return 0;
        }
        return this.template.getColumnCount();
    }

    public int getRowCount() {
        return this.data.size();
    }

    public Object getValueAt(int n, int n2) {
        Record record = (Record)this.data.get(n);
        return record.getValueAt(n2);
    }

    public Class getColumnClass(int n) {
        if (this.template == null) {
            return class$java$lang$Object == null ? (class$java$lang$Object = NonSortableTableModel.class$("java.lang.Object")) : class$java$lang$Object;
        }
        return this.template.getColumnClass(n);
    }

    public String getColumnName(int n) {
        return (String)this.columnNames.get(n);
    }

    public void addColumn(Class clazz, int n) {
        this.columnNames.add(n, "N" + (n + 1));
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            record.addColumn(clazz, n);
        }
        this.fireTableStructureChanged();
    }

    public void removeColumn(int n) {
        this.columnNames.remove(n);
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            record.removeColumn(n);
        }
        this.fireTableStructureChanged();
    }

    public void removeAllRows() {
        this.data.clear();
        this.fireTableDataChanged();
    }

    public void createNewData() {
        this.createData();
        this.fireTableStructureChanged();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class TableColorIcon
    implements Icon {
        private Color color = Color.getHSBColor((float)((double)hue / 360.0), 0.5f, 0.9f);
        private static int hue = 0;

        TableColorIcon() {
            hue += 18;
        }

        static void reset() {
            hue = 0;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(Color.DARK_GRAY);
            graphics.drawRect(n, n2, this.getIconWidth() - 1, this.getIconHeight() - 1);
            graphics.setColor(this.color);
            graphics.fillRect(n + 1, n2 + 1, this.getIconWidth() - 2, this.getIconHeight() - 2);
        }

        public int getIconWidth() {
            return 24;
        }

        public int getIconHeight() {
            return 12;
        }

        public int compareTo(Object object) {
            if (object == null) {
                return 1;
            }
            if (!(object instanceof TableColorIcon)) {
                return 1;
            }
            Color color = ((TableColorIcon)object).color;
            if (this.color.getRGB() == color.getRGB()) {
                return 0;
            }
            if (this.color.getRGB() > color.getRGB()) {
                return 1;
            }
            return -1;
        }
    }

    protected class Record {
        private Vector values = new Vector();
        private int oldRow;
        private int newRow;

        protected Record(int n) {
            Integer n2 = new Integer(n);
            Icon icon = this.createRandomIcon();
            String string = null;
            string = NonSortableTableModel.this.sortable ? (n == 1 ? "Sortable" : (n == 2 ? "Table" : (n == 3 ? "Data" : this.createRandomString()))) : (n == 1 ? "Non-" : (n == 2 ? "sortable" : (n == 3 ? "Table" : (n == 4 ? "Data" : this.createRandomString()))));
            Integer n3 = this.createRandomInteger();
            this.values.add(n2);
            this.values.add(icon);
            this.values.add(string);
            this.values.add(n3);
        }

        public Object getValueAt(int n) {
            if (n < 0 || n >= this.values.size()) {
                return null;
            }
            return this.values.get(n);
        }

        public Class getColumnClass(int n) {
            if (n < 0 || n >= this.values.size()) {
                return class$java$lang$Object == null ? (class$java$lang$Object = NonSortableTableModel.class$("java.lang.Object")) : class$java$lang$Object;
            }
            return this.values.get(n).getClass();
        }

        public void addColumn(Class clazz, int n) {
            if ((class$java$lang$Double == null ? (class$java$lang$Double = NonSortableTableModel.class$("java.lang.Double")) : class$java$lang$Double).equals(clazz)) {
                this.values.add(n, this.createRandomDouble());
            } else if ((class$javax$swing$Icon == null ? (class$javax$swing$Icon = NonSortableTableModel.class$("javax.swing.Icon")) : class$javax$swing$Icon).equals(clazz)) {
                this.values.add(n, this.createRandomIcon());
            } else if ((class$java$lang$Integer == null ? (class$java$lang$Integer = NonSortableTableModel.class$("java.lang.Integer")) : class$java$lang$Integer).equals(clazz)) {
                this.values.add(n, this.createRandomInteger());
            } else if ((class$java$lang$String == null ? (class$java$lang$String = NonSortableTableModel.class$("java.lang.String")) : class$java$lang$String).equals(clazz)) {
                this.values.add(n, this.createRandomString());
            }
        }

        public void removeColumn(int n) {
            this.values.remove(n);
        }

        public int getColumnCount() {
            return this.values.size();
        }

        private String createRandomString() {
            char[] cArray = new char[3];
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = this.createRandomChar();
            }
            return new String(cArray);
        }

        private char createRandomChar() {
            return (char)(65 + (char)(Math.random() * 3.0));
        }

        private Double createRandomDouble() {
            int n = (int)(Math.random() * 10000.0);
            return new Double((double)n / 100.0);
        }

        private Integer createRandomInteger() {
            return new Integer((int)(Math.random() * 20.0) + 1);
        }

        private Icon createRandomIcon() {
            return new TableColorIcon();
        }

        public int getNewRow() {
            return this.newRow;
        }

        public void setNewRow(int n) {
            this.newRow = n;
        }

        public int getOldRow() {
            return this.oldRow;
        }

        public void setOldRow(int n) {
            this.oldRow = n;
        }
    }
}

