/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.controlpanel;

import de.muntjak.tinylookandfeel.controlpanel.ControlPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class HSBChooser
extends JDialog {
    private static HSBChooser myInstance;
    private static int hue;
    private static int sat;
    private static int bri;
    private boolean result = false;
    private ControlPanel.HSBField hsbField;
    private JSlider hueSlider;
    private JSlider satSlider;
    private JSlider briSlider;
    private JTextField hueField;
    private JTextField satField;
    private JTextField briField;
    private JCheckBox preserveGrey;
    private boolean keyInput = false;
    private boolean valueIsAdjusting = false;

    public HSBChooser(Frame frame) {
        super(frame, "Hue/Saturation/Lightness", true);
        this.setDefaultCloseOperation(1);
        this.setupUI(frame);
    }

    private void setupUI(Frame frame) {
        SliderAction sliderAction = new SliderAction();
        JPanel jPanel = new JPanel(new BorderLayout(12, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1, 0, 8));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 2, 4));
        JPanel jPanel4 = new JPanel(new BorderLayout(4, 0));
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel4.add((Component)new JLabel("Hue"), "North");
        this.hueSlider = new JSlider(0, 360, hue);
        this.hueSlider.addChangeListener(sliderAction);
        this.hueSlider.setMajorTickSpacing(180);
        this.hueSlider.setPaintTicks(true);
        jPanel4.add((Component)this.hueSlider, "Center");
        this.hueField = new JTextField("" + this.hueSlider.getValue(), 4);
        this.hueField.getDocument().addDocumentListener(new HueInputListener());
        this.hueField.addKeyListener(new ArrowKeyAction(this.hueField, 0, 360));
        this.hueField.setHorizontalAlignment(0);
        jPanel5.add(this.hueField);
        jPanel4.add((Component)jPanel5, "East");
        jPanel2.add(jPanel4);
        jPanel5 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel4 = new JPanel(new BorderLayout(4, 0));
        jPanel4.add((Component)new JLabel("Saturation"), "North");
        this.satSlider = new JSlider(0, 100, sat);
        this.satSlider.addChangeListener(sliderAction);
        this.satSlider.setMajorTickSpacing(50);
        this.satSlider.setPaintTicks(true);
        jPanel4.add((Component)this.satSlider, "Center");
        this.satField = new JTextField("" + this.satSlider.getValue(), 4);
        this.satField.getDocument().addDocumentListener(new SatInputListener());
        this.satField.addKeyListener(new ArrowKeyAction(this.satField, 0, 100));
        this.satField.setHorizontalAlignment(0);
        jPanel5.add(this.satField);
        jPanel4.add((Component)jPanel5, "East");
        jPanel2.add(jPanel4);
        jPanel5 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel4 = new JPanel(new BorderLayout(4, 0));
        jPanel4.add((Component)new JLabel("Lightness"), "North");
        this.briSlider = new JSlider(-100, 100, bri);
        this.briSlider.addChangeListener(sliderAction);
        this.briSlider.setMajorTickSpacing(100);
        this.briSlider.setPaintTicks(true);
        jPanel4.add((Component)this.briSlider, "Center");
        this.briField = new JTextField("" + this.briSlider.getValue(), 4);
        this.briField.getDocument().addDocumentListener(new BriInputListener());
        this.briField.addKeyListener(new ArrowKeyAction(this.briField, -100, 100));
        this.briField.setHorizontalAlignment(0);
        jPanel5.add(this.briField);
        jPanel4.add((Component)jPanel5, "East");
        jPanel2.add(jPanel4);
        jPanel3.add(jPanel2);
        jPanel.add((Component)jPanel3, "Center");
        jPanel5 = new JPanel(new FlowLayout(0, 2, 6));
        this.preserveGrey = new JCheckBox("Preserve grey values", true);
        this.preserveGrey.addActionListener(new PreserveAction());
        jPanel5.add(this.preserveGrey);
        jPanel.add((Component)jPanel5, "South");
        this.getContentPane().add((Component)jPanel, "Center");
        jPanel3 = new JPanel(new FlowLayout(2, 8, 4));
        jPanel3.setBorder(new EtchedBorder());
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(new CancelAction());
        jPanel3.add(jButton);
        jButton = new JButton("OK");
        this.getRootPane().setDefaultButton(jButton);
        jButton.addActionListener(new OKAction());
        jPanel3.add(jButton);
        this.getContentPane().add((Component)jPanel3, "South");
        this.pack();
        Dimension dimension = this.getSize();
        this.setLocation(frame.getLocationOnScreen().x + (frame.getWidth() - this.getSize().width) / 2, frame.getLocationOnScreen().y + (frame.getHeight() - this.getSize().height) / 2);
    }

    public static boolean showColorizeDialog(Frame frame, ControlPanel.HSBField hSBField) {
        if (myInstance == null) {
            myInstance = new HSBChooser(frame);
        }
        HSBChooser.myInstance.hsbField = hSBField;
        HSBChooser.myInstance.result = false;
        myInstance.setParams(hSBField);
        myInstance.setVisible(true);
        return HSBChooser.myInstance.result;
    }

    public static void deleteInstance() {
        myInstance = null;
    }

    public static int getHue() {
        return hue;
    }

    public static int getSaturation() {
        return sat;
    }

    public static int getBrightness() {
        return bri;
    }

    public static boolean isPreserveGrey() {
        return HSBChooser.myInstance.preserveGrey.isSelected();
    }

    private void setParams(ControlPanel.HSBField hSBField) {
        hue = hSBField.getHue();
        sat = hSBField.getSaturation();
        bri = hSBField.getBrightness();
        this.valueIsAdjusting = true;
        this.hueSlider.setValue(hue);
        this.satSlider.setValue(sat);
        this.briSlider.setValue(bri);
        this.preserveGrey.setSelected(hSBField.isPreserveGrey());
        this.valueIsAdjusting = false;
        this.performAction();
    }

    private void performAction() {
        if (this.valueIsAdjusting) {
            return;
        }
        this.hsbField.setHue(hue);
        this.hsbField.setSaturation(sat);
        this.hsbField.setBrightness(bri);
        this.hsbField.setPreserveGrey(this.preserveGrey.isSelected());
        ActionEvent actionEvent = new ActionEvent(this.hsbField, 1001, "");
        this.hsbField.getAction().actionPerformed(actionEvent);
    }

    class CancelAction
    implements ActionListener {
        CancelAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HSBChooser.this.result = false;
            HSBChooser.this.setVisible(false);
        }
    }

    class OKAction
    implements ActionListener {
        OKAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HSBChooser.this.result = true;
            HSBChooser.this.setVisible(false);
        }
    }

    class PreserveAction
    implements ActionListener {
        PreserveAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HSBChooser.this.performAction();
        }
    }

    class ArrowKeyAction
    extends KeyAdapter
    implements ActionListener {
        private JTextField theField;
        private Timer keyTimer;
        private int step;
        private int min;
        private int max;

        ArrowKeyAction(JTextField jTextField, int n, int n2) {
            this.theField = jTextField;
            this.min = n;
            this.max = n2;
            this.keyTimer = new Timer(20, this);
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 38) {
                this.step = 1;
                if (keyEvent.getModifiers() == 1) {
                    this.step = 10;
                }
                this.changeVal();
                this.keyTimer.setInitialDelay(300);
                this.keyTimer.start();
            } else if (keyEvent.getKeyCode() == 40) {
                this.step = -1;
                if (keyEvent.getModifiers() == 1) {
                    this.step = -10;
                }
                this.changeVal();
                this.keyTimer.setInitialDelay(300);
                this.keyTimer.start();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.keyTimer.stop();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.changeVal();
        }

        private void changeVal() {
            int n = Integer.parseInt(this.theField.getText()) + this.step;
            if (n > this.max) {
                n = this.max;
            } else if (n < this.min) {
                n = this.min;
            }
            this.theField.setText("" + n);
        }
    }

    class BriInputListener
    implements DocumentListener {
        BriInputListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        private void update(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            try {
                String string = document.getText(0, document.getLength());
                try {
                    int n = Integer.parseInt(string);
                    HSBChooser.this.keyInput = true;
                    bri = n;
                    HSBChooser.this.briSlider.setValue(n);
                    HSBChooser.this.keyInput = false;
                    HSBChooser.this.performAction();
                }
                catch (NumberFormatException numberFormatException) {}
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    class SatInputListener
    implements DocumentListener {
        SatInputListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        private void update(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            try {
                String string = document.getText(0, document.getLength());
                try {
                    int n = Integer.parseInt(string);
                    HSBChooser.this.keyInput = true;
                    sat = n;
                    HSBChooser.this.satSlider.setValue(n);
                    HSBChooser.this.keyInput = false;
                    HSBChooser.this.performAction();
                }
                catch (NumberFormatException numberFormatException) {}
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    class HueInputListener
    implements DocumentListener {
        HueInputListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        private void update(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            try {
                String string = document.getText(0, document.getLength());
                try {
                    int n = Integer.parseInt(string);
                    HSBChooser.this.keyInput = true;
                    hue = n;
                    HSBChooser.this.hueSlider.setValue(n);
                    HSBChooser.this.keyInput = false;
                    HSBChooser.this.performAction();
                }
                catch (NumberFormatException numberFormatException) {}
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    class SliderAction
    implements ChangeListener {
        SliderAction() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (!HSBChooser.this.keyInput) {
                if (changeEvent.getSource().equals(HSBChooser.this.hueSlider)) {
                    hue = HSBChooser.this.hueSlider.getValue();
                    HSBChooser.this.hueField.setText("" + hue);
                } else if (changeEvent.getSource().equals(HSBChooser.this.briSlider)) {
                    bri = HSBChooser.this.briSlider.getValue();
                    HSBChooser.this.briField.setText("" + bri);
                } else if (changeEvent.getSource().equals(HSBChooser.this.satSlider)) {
                    sat = HSBChooser.this.satSlider.getValue();
                    HSBChooser.this.satField.setText("" + sat);
                }
                HSBChooser.this.performAction();
            }
        }
    }
}

