/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.controlpanel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.ColorReference;
import java.awt.Color;
import java.awt.Font;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.plaf.FontUIResource;

public class ColoredFont {
    private ColorReference[] ref;
    private FontUIResource font;
    private boolean isPlainFont;
    private boolean isBoldFont;

    public ColoredFont(String string, int n, int n2) {
        this.font = new FontUIResource(string, n, n2);
    }

    public ColoredFont() {
        this.font = new FontUIResource("sansserif", 0, 12);
        this.isPlainFont = true;
    }

    public ColoredFont(ColorReference[] colorReferenceArray) {
        this("sansserif", 0, 12, colorReferenceArray);
        this.isPlainFont = true;
    }

    public ColoredFont(String string, int n, int n2, ColorReference[] colorReferenceArray) {
        this.font = new FontUIResource(string, n, n2);
        this.ref = colorReferenceArray;
        if (colorReferenceArray[0] == null) {
            colorReferenceArray[0] = new ColorReference(new Color(0, 0, 0));
        }
        if (colorReferenceArray[1] == null) {
            colorReferenceArray[1] = new ColorReference(new Color(0, 0, 0));
        }
        if (colorReferenceArray[2] == null) {
            colorReferenceArray[2] = new ColorReference(new Color(0, 0, 0));
        }
        if (colorReferenceArray[3] == null) {
            colorReferenceArray[3] = new ColorReference(new Color(0, 0, 0));
        }
    }

    public void setPlainFont(boolean bl) {
        this.isPlainFont = bl;
        if (bl) {
            this.isBoldFont = false;
        }
    }

    public void setBoldFont(boolean bl) {
        this.isBoldFont = bl;
        if (bl) {
            this.isPlainFont = false;
        }
    }

    public boolean isPlainFont() {
        return this.isPlainFont;
    }

    public boolean isBoldFont() {
        return this.isBoldFont;
    }

    public void setFont(String string, int n, int n2) {
        this.font = new FontUIResource(string, n, n2);
    }

    public void setFont(Font font) {
        this.font = new FontUIResource(font);
    }

    public void setFont(FontUIResource fontUIResource) {
        this.font = fontUIResource;
    }

    public FontUIResource getFont() {
        if (this.isPlainFont) {
            return Theme.plainFont[Theme.style].font;
        }
        if (this.isBoldFont) {
            return Theme.boldFont[Theme.style].font;
        }
        return this.font;
    }

    public ColorReference[] getColorReference() {
        return this.ref;
    }

    public void setColorReference(ColorReference[] colorReferenceArray) {
        this.ref = colorReferenceArray;
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.font.getFamily());
        dataOutputStream.writeBoolean(this.font.isBold());
        dataOutputStream.writeInt(this.font.getSize());
        dataOutputStream.writeBoolean(this.isPlainFont);
        dataOutputStream.writeBoolean(this.isBoldFont);
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.font = new FontUIResource(dataInputStream.readUTF(), dataInputStream.readBoolean() ? 1 : 0, dataInputStream.readInt());
        this.isPlainFont = dataInputStream.readBoolean();
        this.isBoldFont = dataInputStream.readBoolean();
    }
}

