/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.controlpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class CheckForUpdatesDialog
extends JDialog {
    private static final String CHECK_UPDATES_URL = "http://www.muntjak.de/hans/java/tinylaf/checkforupdate.html";

    private CheckForUpdatesDialog(Frame frame) {
        super(frame, "Check for Updates", true);
        this.setupUI(frame);
    }

    static void showDialog(Frame frame) {
        new CheckForUpdatesDialog(frame);
    }

    private void setupUI(Frame frame) {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel jPanel = new JPanel(new BorderLayout(0, 12));
        JLabel jLabel = new JLabel("<html>When checking for updates, TinyLaF will connect to <b>muntjak.de</b><br>via HTTP. No personal data will be transmitted.");
        jLabel.setBorder(new EmptyBorder(8, 8, 0, 8));
        jPanel.add((Component)jLabel, "North");
        JButton jButton = new JButton("Check for updates now");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = CheckForUpdatesDialog.this.checkForUpdates();
                int n = string.indexOf("Exception was: ");
                if (n != -1) {
                    String string2 = string.substring(n + 15);
                    JOptionPane.showMessageDialog(CheckForUpdatesDialog.this, string, string2, -1);
                } else if (string.startsWith("No ")) {
                    JOptionPane.showMessageDialog(CheckForUpdatesDialog.this, string, "Update Information", -1);
                } else {
                    new UpdateDialog(CheckForUpdatesDialog.this, string);
                }
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 0, 8));
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)new JSeparator(), "South");
        this.getContentPane().add((Component)jPanel, "Center");
        jButton = new JButton("Close");
        this.getRootPane().setDefaultButton(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CheckForUpdatesDialog.this.dispose();
            }
        });
        jPanel2 = new JPanel(new FlowLayout(1, 0, 8));
        jPanel2.add(jButton);
        this.getContentPane().add((Component)jPanel2, "South");
        this.pack();
        Dimension dimension = this.getSize();
        this.setLocation(frame.getLocationOnScreen().x + (frame.getWidth() - this.getSize().width) / 2, frame.getLocationOnScreen().y + (frame.getHeight() - this.getSize().height) / 2);
        this.setVisible(true);
    }

    private String checkForUpdates() {
        String string = this.checkForUpdate();
        if (string.indexOf("Exception") != -1) {
            return string;
        }
        if (!string.startsWith("TinyLaF ") || !string.endsWith(")") || string.indexOf("(") == -1 || string.indexOf("/") == -1) {
            return "An exception occured while checking for updates.\n\nException was: Invalid response.";
        }
        String string2 = string.substring(8, string.indexOf("(") - 1);
        if (!"1.3.8".equals(string2)) {
            return string;
        }
        return "No updated version of TinyLaF available.";
    }

    private String checkForUpdate() {
        Object object;
        Object object2;
        Object object3;
        InputStream inputStream = null;
        try {
            object3 = new URL(CHECK_UPDATES_URL);
            try {
                object2 = (HttpURLConnection)((URL)object3).openConnection();
                ((URLConnection)object2).setRequestProperty("User-Agent", "TinyLaF");
                object = ((URLConnection)object2).getContent();
                if (!(object instanceof InputStream)) {
                    return "An exception occured while checking for updates.\n\nException was: Content is no InputStream";
                }
                inputStream = (InputStream)object;
            }
            catch (ConnectException connectException) {
                return "An exception occured while checking for updates.\n\nException was: " + connectException.getClass().getName();
            }
            catch (UnknownHostException unknownHostException) {
                return "An exception occured while checking for updates.\n\nException was: " + unknownHostException.getClass().getName();
            }
            catch (IOException iOException) {
                return "An exception occured while checking for updates.\n\nException was: " + iOException.getClass().getName();
            }
        }
        catch (MalformedURLException malformedURLException) {
            return "An exception occured while checking for updates.\n\nException was: " + malformedURLException.getClass().getName();
        }
        try {
            object3 = new BufferedReader(new InputStreamReader(inputStream));
            object2 = new StringBuffer();
            while ((object = ((BufferedReader)object3).readLine()) != null) {
                ((StringBuffer)object2).append((String)object);
            }
            ((BufferedReader)object3).close();
            return ((StringBuffer)object2).toString();
        }
        catch (IOException iOException) {
            return "An exception occured while checking for updates.\n\nException was: " + iOException.getClass().getName();
        }
    }

    private class UpdateDialog
    extends JDialog {
        UpdateDialog(Dialog dialog, String string) {
            super(CheckForUpdatesDialog.this, "Update Information", true);
            this.setDefaultCloseOperation(2);
            this.getContentPane().setLayout(new BorderLayout());
            String string2 = "<html>An updated version of TinyLaF is available:<br>" + string + "<br>" + "It can be downloaded at www.muntjak.de/hans/java/tinylaf/.";
            JPanel jPanel = new JPanel(new FlowLayout(1, 12, 8));
            jPanel.add(new JLabel(string2));
            this.getContentPane().add((Component)jPanel, "Center");
            jPanel = new JPanel(new FlowLayout(1, 8, 10));
            JButton jButton = new JButton("Copy Link");
            jButton.addActionListener(new ActionListener(this, CheckForUpdatesDialog.this){
                private final /* synthetic */ CheckForUpdatesDialog val$this$0;
                private final /* synthetic */ UpdateDialog this$1;
                {
                    this.this$1 = updateDialog;
                    this.val$this$0 = checkForUpdatesDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    if (clipboard == null) {
                        JOptionPane.showMessageDialog(this.this$1, "System Clipboard not available.", "Error", 0);
                    } else {
                        StringSelection stringSelection = new StringSelection("http://www.muntjak.de/hans/java/tinylaf/");
                        clipboard.setContents(stringSelection, stringSelection);
                    }
                }
            });
            jPanel.add(jButton);
            jButton = new JButton("Close");
            this.getRootPane().setDefaultButton(jButton);
            jButton.addActionListener(new ActionListener(this, CheckForUpdatesDialog.this){
                private final /* synthetic */ CheckForUpdatesDialog val$this$0;
                private final /* synthetic */ UpdateDialog this$1;
                {
                    this.this$1 = updateDialog;
                    this.val$this$0 = checkForUpdatesDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.dispose();
                }
            });
            jPanel.add(jButton);
            this.getContentPane().add((Component)jPanel, "South");
            this.pack();
            Point point = dialog.getLocationOnScreen();
            point.x += (dialog.getWidth() - this.getWidth()) / 2;
            point.y += (dialog.getHeight() - this.getHeight()) / 2;
            this.setLocation(point);
            this.setVisible(true);
        }
    }
}

