/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.borders;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.DrawRoutines;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class TinyToolButtonBorder
extends AbstractBorder {
    protected final Insets insets = new Insets(1, 1, 1, 1);

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyBorder(component, graphics, n, n2, n3, n4);
                break;
            }
            case 1: {
                this.drawWinBorder(component, graphics, n, n2, n3, n4);
                break;
            }
            case 2: {
                this.drawXpBorder(component, graphics, n, n2, n3, n4);
            }
        }
    }

    private void drawTinyBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    private void drawWinBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        AbstractButton abstractButton = (AbstractButton)component;
        graphics.translate(-n, -n2);
        graphics.setColor(Theme.toolBorderLightColor[Theme.style].getColor());
        if (abstractButton.isSelected() || abstractButton.getModel().isPressed() && abstractButton.getModel().isRollover()) {
            graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
            graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 1);
        } else {
            graphics.drawLine(0, 0, n3 - 1, 0);
            graphics.drawLine(0, 1, 0, n4 - 1);
        }
        graphics.setColor(Theme.toolBorderDarkColor[Theme.style].getColor());
        if (abstractButton.isSelected() || abstractButton.getModel().isPressed() && abstractButton.getModel().isRollover()) {
            graphics.drawLine(0, 0, n3 - 1, 0);
            graphics.drawLine(0, 1, 0, n4 - 1);
        } else {
            graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
            graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 1);
        }
        graphics.translate(n, n2);
    }

    private void drawXpBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        boolean bl;
        AbstractButton abstractButton = (AbstractButton)component;
        ColorUIResource colorUIResource = null;
        boolean bl2 = Boolean.TRUE.equals(abstractButton.getClientProperty("JFileChooser.isFileChooserButton"));
        boolean bl3 = bl = abstractButton.getModel().isRollover() || abstractButton.getModel().isArmed();
        if (abstractButton.getModel().isPressed()) {
            if (bl) {
                colorUIResource = Theme.toolBorderPressedColor[Theme.style].getColor();
            } else if (abstractButton.isSelected()) {
                colorUIResource = Theme.toolBorderSelectedColor[Theme.style].getColor();
            } else {
                if (bl2) {
                    return;
                }
                colorUIResource = Theme.toolBorderColor[Theme.style].getColor();
            }
        } else if (bl) {
            colorUIResource = abstractButton.isSelected() ? Theme.toolBorderSelectedColor[Theme.style].getColor() : Theme.toolBorderRolloverColor[Theme.style].getColor();
        } else if (abstractButton.isSelected()) {
            colorUIResource = Theme.toolBorderSelectedColor[Theme.style].getColor();
        } else {
            if (bl2) {
                return;
            }
            colorUIResource = Theme.toolBorderColor[Theme.style].getColor();
        }
        DrawRoutines.drawRoundedBorder(graphics, colorUIResource, n, n2, n3, n4);
    }

    public Insets getBorderInsets(Component component) {
        if (!(component instanceof AbstractButton)) {
            return this.insets;
        }
        AbstractButton abstractButton = (AbstractButton)component;
        if (abstractButton.getMargin() == null || abstractButton.getMargin() instanceof UIResource) {
            return new Insets(Theme.toolMarginTop[Theme.style], Theme.toolMarginLeft[Theme.style], Theme.toolMarginBottom[Theme.style], Theme.toolMarginRight[Theme.style]);
        }
        Insets insets = abstractButton.getMargin();
        return new Insets(insets.top + 1, insets.left + 1, insets.bottom + 1, insets.right + 1);
    }
}

