/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.borders;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.controlpanel.ColorRoutines;
import de.muntjak.tinylookandfeel.controlpanel.SBChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class TinyFrameBorder
extends AbstractBorder
implements UIResource {
    private static HashMap cache = new HashMap();
    public static Color buttonUpperColor;
    public static Color buttonLowerColor;
    private static TinyFrameBorder onlyInstance;
    private static Robot robot;
    private static boolean robotsSupported;
    private Window window;
    private int titleHeight;
    private boolean isActive;

    public static TinyFrameBorder getInstance() {
        if (onlyInstance == null) {
            onlyInstance = new TinyFrameBorder();
            if (robot == null && robotsSupported) {
                try {
                    robot = new Robot();
                }
                catch (Exception exception) {
                    robotsSupported = false;
                }
            }
        }
        return onlyInstance;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        this.window = SwingUtilities.getWindowAncestor(component);
        this.isActive = this.window.isActive();
        this.titleHeight = this.window instanceof JFrame ? Theme.frameTitleHeight[Theme.derivedStyle[Theme.style]] : Theme.frameInternalTitleHeight[Theme.derivedStyle[Theme.style]];
        if (this.isActive) {
            graphics.setColor(Theme.frameBorderColor[Theme.style].getColor());
        } else {
            graphics.setColor(Theme.frameBorderDisabledColor[Theme.style].getColor());
        }
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyBorder(graphics, n, n2, n3, n4);
                break;
            }
            case 1: {
                this.drawWinBorder(graphics, n, n2, n3, n4);
                break;
            }
            case 2: {
                this.drawXpBorder(graphics, n, n2, n3, n4);
            }
        }
        ColorUIResource colorUIResource = null;
        colorUIResource = this.isActive ? Theme.frameCaptionColor[Theme.style].getColor() : Theme.frameCaptionDisabledColor[Theme.style].getColor();
        graphics.setColor(colorUIResource);
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyCaption(graphics, n, n2, n3, n4, colorUIResource);
                break;
            }
            case 1: {
                this.drawWinCaption(graphics, n, n2, n3, n4, colorUIResource);
                break;
            }
            case 2: {
                if (TinyLookAndFeel.controlPanelInstantiated) {
                    this.drawXpCaptionNoCache(graphics, n, n2, n3, n4, colorUIResource);
                    break;
                }
                this.drawXpCaption(graphics, n, n2, n3, n4, colorUIResource);
            }
        }
    }

    private void drawTinyBorder(Graphics graphics, int n, int n2, int n3, int n4) {
    }

    private void drawWinBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawLine(n, n2, n + n3 - 2, n2);
        graphics.drawLine(n, n2 + 1, n, n2 + n4 - 2);
        graphics.drawRect(n + 2, n2 + 2, n3 - 5, n4 - 5);
        graphics.drawRect(n + 3, n2 + 3, n3 - 7, n4 - 7);
        graphics.setColor(Color.WHITE);
        graphics.drawLine(n + 1, n2 + 1, n + n3 - 3, n2 + 1);
        graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + n4 - 3);
        graphics.setColor(Theme.frameDarkColor[Theme.style].getColor());
        graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
        graphics.setColor(Theme.frameLightColor[Theme.style].getColor());
        graphics.drawLine(n + 1, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
        graphics.drawLine(n3 - 2, n2 + 1, n + n3 - 2, n2 + n4 - 2);
    }

    private void drawXpBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawLine(n, n2 + 6, n, n2 + n4 - 1);
        graphics.drawLine(n + 2, n2 + this.titleHeight, n + 2, n2 + n4 - 3);
        graphics.drawLine(n + n3 - 1, n2 + 6, n + n3 - 1, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 3, n2 + this.titleHeight, n + n3 - 3, n2 + n4 - 3);
        graphics.drawLine(n + 2, n2 + n4 - 3, n + n3 - 3, n2 + n4 - 3);
        graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        if (robot != null) {
            int n5 = this.window.getLocationOnScreen().x - 4;
            int n6 = this.window.getLocationOnScreen().y;
            Rectangle rectangle = new Rectangle(n5, n6, 4, 4);
            graphics.drawImage(robot.createScreenCapture(rectangle), n, n2, null);
            n5 = this.window.getLocationOnScreen().x + this.window.getWidth() + 1;
            rectangle = new Rectangle(n5, n6, 4, 4);
            graphics.drawImage(robot.createScreenCapture(rectangle), n + n3 - 4, n2, null);
        } else {
            graphics.setColor(Theme.backColor[Theme.style].getColor());
            graphics.fillRect(0, 0, n3, 3);
        }
        if (this.isActive) {
            graphics.setColor(Theme.frameCaptionColor[Theme.style].getColor());
        } else {
            graphics.setColor(Theme.frameCaptionDisabledColor[Theme.style].getColor());
        }
        graphics.drawLine(n + 1, n2 + this.titleHeight, n + 1, n2 + n4 - 2);
        graphics.drawLine(n + n3 - 2, n2 + this.titleHeight, n + n3 - 2, n2 + n4 - 2);
        graphics.drawLine(n + 1, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
        ColorUIResource colorUIResource = null;
        colorUIResource = this.isActive ? Theme.frameBorderColor[Theme.style].getColor() : Theme.frameBorderDisabledColor[Theme.style].getColor();
        graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource, 82));
        graphics.drawLine(n, n2 + 3, n, n2 + 3);
        graphics.drawLine(n + n3 - 1, n2 + 3, n + n3 - 1, n2 + 3);
        graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource, 156));
        graphics.drawLine(n, n2 + 4, n, n2 + 4);
        graphics.drawLine(n + n3 - 1, n2 + 4, n + n3 - 1, n2 + 4);
        graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource, 215));
        graphics.drawLine(n, n2 + 5, n, n2 + 5);
        graphics.drawLine(n + n3 - 1, n2 + 5, n + n3 - 1, n2 + 5);
    }

    private void drawTinyCaption(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
    }

    private void drawWinCaption(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
        int n5 = n2 + this.titleHeight - 2;
        int n6 = n3 - 8;
        int n7 = 56;
        int n8 = 78;
        if (!this.isActive) {
            n7 = 0;
            n8 = 50;
        }
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        Color color2 = color;
        for (int i = 0; i < n6; ++i) {
            graphics.setColor(color2);
            graphics.drawLine(n + 4 + i, n2 + 4, n + 4 + i, n5);
            n9 = n7 * i / n6;
            n10 = n8 * i / n6;
            if (n9 == n11 && n10 == n12) continue;
            n11 = n9;
            n12 = n10;
            color2 = SBChooser.getAdjustedColor(color, n9, n10);
        }
        graphics.setColor(Theme.frameBorderColor[Theme.style].getColor());
        graphics.drawLine(n + 4, n2 + this.titleHeight - 1, n + n3 - 5, n2 + this.titleHeight - 1);
    }

    private void drawXpCaption(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
        if (this.titleHeight == Theme.frameInternalTitleHeight[Theme.derivedStyle[Theme.style]]) {
            this.drawXpInternalCaption(graphics, n, n2, n3, n4, color);
            return;
        }
        int n5 = Theme.frameSpreadDarkDisabled[Theme.style];
        int n6 = Theme.frameSpreadLightDisabled[Theme.style];
        int n7 = n2;
        ColorUIResource colorUIResource = null;
        if (this.isActive) {
            colorUIResource = Theme.frameBorderColor[Theme.style].getColor();
            n5 = Theme.frameSpreadDark[Theme.style];
            n6 = Theme.frameSpreadLight[Theme.style];
        } else {
            colorUIResource = Theme.frameBorderDisabledColor[Theme.style].getColor();
        }
        graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource, 82));
        graphics.drawLine(n + 3, n7, n + 3, n7);
        graphics.drawLine(n + n3 - 4, n7, n + n3 - 4, n7);
        graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource, 156));
        graphics.drawLine(n + 4, n7, n + 4, n7);
        graphics.drawLine(n + n3 - 5, n7, n + n3 - 5, n7);
        graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource, 215));
        graphics.drawLine(n + 5, n7, n + 5, n7);
        graphics.drawLine(n + n3 - 6, n7, n + n3 - 6, n7);
        Color color2 = ColorRoutines.darken(color, 4 * n5);
        graphics.setColor(color2);
        graphics.drawLine(n + 3, ++n7, n + 5, n7);
        graphics.drawLine(n + n3 - 6, n7, n + n3 - 4, n7);
        graphics.setColor(ColorRoutines.getAlphaColor(color2, 139));
        graphics.drawLine(n + 2, n7, n + 2, n7);
        graphics.drawLine(n + n3 - 3, n7, n + n3 - 3, n7);
        graphics.setColor(ColorRoutines.getAlphaColor(color2, 23));
        graphics.drawLine(n + 1, n7, n + 1, n7);
        graphics.drawLine(n + n3 - 2, n7, n + n3 - 2, n7);
        graphics.setColor(ColorRoutines.lighten(color, 10 * n6));
        graphics.drawLine(n + 4, ++n7, n + 5, n7);
        graphics.drawLine(n + n3 - 6, n7, n + n3 - 5, n7);
        graphics.setColor(color);
        graphics.drawLine(n + 3, n7, n + 3, n7);
        graphics.drawLine(n + n3 - 4, n7, n + n3 - 4, n7);
        color2 = ColorRoutines.darken(color, 6 * n5);
        graphics.setColor(color2);
        graphics.drawLine(n + 2, n7, n + 2, n7);
        graphics.drawLine(n + n3 - 3, n7, n + n3 - 3, n7);
        graphics.setColor(ColorRoutines.getAlphaColor(color2, 139));
        graphics.drawLine(n + 1, n7, n + 1, n7);
        graphics.drawLine(n + n3 - 2, n7, n + n3 - 2, n7);
        graphics.setColor(color);
        graphics.drawLine(n + 2, ++n7, n + 2, n7);
        graphics.drawLine(n + n3 - 3, n7, n + n3 - 3, n7);
        graphics.setColor(ColorRoutines.darken(color, 6 * n5));
        graphics.drawLine(n + 1, n7, n + 1, n7);
        graphics.drawLine(n + n3 - 2, n7, n + n3 - 2, n7);
        graphics.setColor(ColorRoutines.lighten(color, 10 * n6));
        graphics.drawLine(n + 3, n7, n + 3, n7);
        graphics.drawLine(n + n3 - 4, n7, n + n3 - 4, n7);
        graphics.setColor(ColorRoutines.lighten(color, 7 * n6));
        graphics.drawLine(n + 4, n7, n + 4, n7);
        graphics.drawLine(n + n3 - 5, n7, n + n3 - 5, n7);
        graphics.setColor(ColorRoutines.lighten(color, 3 * n6));
        graphics.drawLine(n + 5, n7, n + 5, n7);
        graphics.drawLine(n + n3 - 6, n7, n + n3 - 6, n7);
        graphics.setColor(color);
        graphics.drawLine(n + 6, n7, n + 6, n7);
        graphics.drawLine(n + n3 - 7, n7, n + n3 - 7, n7);
        graphics.setColor(ColorRoutines.darken(color, 2 * n5));
        graphics.drawLine(n + 5, ++n7, n + 6, n7);
        graphics.drawLine(n + n + n3 - 7, n7, n + n3 - 6, n7);
        graphics.setColor(ColorRoutines.darken(color, 6 * n5));
        graphics.drawLine(n + 1, n7, n + 1, n7);
        graphics.drawLine(n + n3 - 2, n7, n + n3 - 2, n7);
        graphics.setColor(ColorRoutines.lighten(color, 10 * n6));
        graphics.drawLine(n + 2, n7, n + 2, n7);
        graphics.drawLine(n + n3 - 3, n7, n + n3 - 3, n7);
        graphics.setColor(ColorRoutines.lighten(color, 5 * n6));
        graphics.drawLine(n + 3, n7, n + 3, n7);
        graphics.drawLine(n + n3 - 4, n7, n + n3 - 4, n7);
        graphics.setColor(color);
        graphics.drawLine(n + 4, n7, n + 4, n7);
        graphics.drawLine(n + n3 - 5, n7, n + n3 - 5, n7);
        graphics.setColor(ColorRoutines.darken(color, 4 * n5));
        graphics.drawLine(n + 1, ++n7, n + 1, n7);
        graphics.drawLine(n + n3 - 2, n7, n + n3 - 2, n7);
        CaptionKey captionKey = new CaptionKey(this.isActive, this.titleHeight);
        Object v = cache.get(captionKey);
        if (v != null) {
            graphics.drawImage((Image)v, n + 6, n2, n + n3 - 6, n2 + 5, 0, 0, 1, 5, this.window);
            graphics.drawImage((Image)v, n + 1, n2 + 5, n + n3 - 1, n2 + this.titleHeight, 0, 5, 1, this.titleHeight, this.window);
            buttonUpperColor = ColorRoutines.darken(color, 4 * n5);
            buttonLowerColor = ColorRoutines.lighten(color, 10 * n6);
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(1, this.titleHeight, 2);
        Graphics graphics2 = ((Image)bufferedImage).getGraphics();
        graphics2.setColor(colorUIResource);
        graphics2.drawLine(0, 0, 1, 0);
        graphics2.setColor(ColorRoutines.darken(color, 4 * n5));
        graphics2.drawLine(0, 1, 1, 1);
        graphics2.setColor(ColorRoutines.lighten(color, 10 * n6));
        graphics2.drawLine(0, 2, 1, 2);
        graphics2.setColor(color);
        graphics2.drawLine(0, 3, 1, 3);
        graphics2.setColor(ColorRoutines.darken(color, 2 * n5));
        graphics2.drawLine(0, 4, 1, 4);
        buttonUpperColor = ColorRoutines.darken(color, 4 * n5);
        graphics2.setColor(buttonUpperColor);
        graphics2.drawLine(0, 5, 1, 5);
        graphics2.setColor(ColorRoutines.darken(color, 4 * n5));
        graphics2.drawLine(0, 6, 1, 6);
        graphics2.drawLine(0, 7, 1, 7);
        graphics2.setColor(ColorRoutines.darken(color, 3 * n5));
        graphics2.drawLine(0, 8, 1, 8);
        graphics2.drawLine(0, 9, 1, 9);
        graphics2.drawLine(0, 10, 1, 10);
        graphics2.drawLine(0, 11, 1, 11);
        graphics2.setColor(ColorRoutines.darken(color, 2 * n5));
        graphics2.drawLine(0, 12, 1, 12);
        graphics2.drawLine(0, 13, 1, 13);
        graphics2.drawLine(0, 14, 1, 14);
        graphics2.setColor(ColorRoutines.darken(color, n5));
        graphics2.drawLine(0, 15, 1, 15);
        graphics2.drawLine(0, 16, 1, 16);
        graphics2.setColor(color);
        graphics2.drawLine(0, 17, 1, 17);
        graphics2.drawLine(0, 18, 1, 18);
        graphics2.setColor(ColorRoutines.lighten(color, 2 * n6));
        graphics2.drawLine(0, 19, 1, 19);
        graphics2.setColor(ColorRoutines.lighten(color, 4 * n6));
        graphics2.drawLine(0, 20, 1, 20);
        graphics2.setColor(ColorRoutines.lighten(color, 5 * n6));
        graphics2.drawLine(0, 21, 1, 21);
        graphics2.setColor(ColorRoutines.lighten(color, 6 * n6));
        graphics2.drawLine(0, 22, 1, 22);
        graphics2.setColor(ColorRoutines.lighten(color, 8 * n6));
        graphics2.drawLine(0, 23, 1, 23);
        graphics2.setColor(ColorRoutines.lighten(color, 9 * n6));
        graphics2.drawLine(0, 24, 1, 24);
        graphics2.setColor(ColorRoutines.lighten(color, 10 * n6));
        graphics2.drawLine(0, 25, 1, 25);
        graphics2.setColor(ColorRoutines.lighten(color, 4 * n6));
        graphics2.drawLine(0, 26, 1, 26);
        graphics2.setColor(ColorRoutines.darken(color, 2 * n5));
        graphics2.drawLine(0, 27, 1, 27);
        if (this.isActive) {
            graphics2.setColor(Theme.frameLightColor[Theme.style].getColor());
        } else {
            graphics2.setColor(Theme.frameLightDisabledColor[Theme.style].getColor());
        }
        graphics2.drawLine(0, 28, 1, 28);
        graphics2.dispose();
        graphics.drawImage(bufferedImage, n + 6, n2, n + n3 - 6, n2 + 5, 0, 0, 1, 5, this.window);
        graphics.drawImage(bufferedImage, n + 1, n2 + 5, n + n3 - 1, n2 + this.titleHeight, 0, 5, 1, this.titleHeight, this.window);
        cache.put(captionKey, bufferedImage);
    }

    private void drawXpCaptionNoCache(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
        if (this.titleHeight == Theme.frameInternalTitleHeight[Theme.derivedStyle[Theme.style]]) {
            this.drawXpInternalCaptionNoCache(graphics, n, n2, n3, n4, color);
            return;
        }
        int n5 = n2;
        int n6 = Theme.frameSpreadDarkDisabled[Theme.style];
        int n7 = Theme.frameSpreadLightDisabled[Theme.style];
        ColorUIResource colorUIResource = null;
        if (this.isActive) {
            colorUIResource = Theme.frameBorderColor[Theme.style].getColor();
            n6 = Theme.frameSpreadDark[Theme.style];
            n7 = Theme.frameSpreadLight[Theme.style];
        } else {
            colorUIResource = Theme.frameBorderDisabledColor[Theme.style].getColor();
        }
        graphics.setColor(colorUIResource);
        graphics.drawLine(n + 6, n5, n + n3 - 7, n5);
        graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource, 82));
        graphics.drawLine(n + 3, n5, n + 3, n5);
        graphics.drawLine(n + n3 - 4, n5, n + n3 - 4, n5);
        graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource, 156));
        graphics.drawLine(n + 4, n5, n + 4, n5);
        graphics.drawLine(n + n3 - 5, n5, n + n3 - 5, n5);
        graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource, 215));
        graphics.drawLine(n + 5, n5, n + 5, n5);
        graphics.drawLine(n + n3 - 6, n5, n + n3 - 6, n5);
        Color color2 = ColorRoutines.darken(color, 4 * n6);
        graphics.setColor(color2);
        graphics.drawLine(n + 3, ++n5, n + n3 - 4, n5);
        graphics.setColor(ColorRoutines.getAlphaColor(color2, 139));
        graphics.drawLine(n + 2, n5, n + 2, n5);
        graphics.drawLine(n + n3 - 3, n5, n + n3 - 3, n5);
        graphics.setColor(ColorRoutines.getAlphaColor(color2, 23));
        graphics.drawLine(n + 1, n5, n + 1, n5);
        graphics.drawLine(n + n3 - 2, n5, n + n3 - 2, n5);
        graphics.setColor(ColorRoutines.lighten(color, 10 * n7));
        graphics.drawLine(n + 4, ++n5, n + n3 - 5, n5);
        graphics.setColor(color);
        graphics.drawLine(n + 3, n5, n + 3, n5);
        graphics.drawLine(n + n3 - 4, n5, n + n3 - 4, n5);
        color2 = ColorRoutines.darken(color, 6 * n6);
        graphics.setColor(color2);
        graphics.drawLine(n + 2, n5, n + 2, n5);
        graphics.drawLine(n + n3 - 3, n5, n + n3 - 3, n5);
        graphics.setColor(ColorRoutines.getAlphaColor(color2, 139));
        graphics.drawLine(n + 1, n5, n + 1, n5);
        graphics.drawLine(n + n3 - 2, n5, n + n3 - 2, n5);
        graphics.setColor(color);
        graphics.drawLine(n + 7, ++n5, n + n3 - 8, n5);
        graphics.setColor(color);
        graphics.drawLine(n + 2, n5, n + 2, n5);
        graphics.drawLine(n + n3 - 3, n5, n + n3 - 3, n5);
        graphics.setColor(ColorRoutines.darken(color, 6 * n6));
        graphics.drawLine(n + 1, n5, n + 1, n5);
        graphics.drawLine(n + n3 - 2, n5, n + n3 - 2, n5);
        graphics.setColor(ColorRoutines.lighten(color, 10 * n7));
        graphics.drawLine(n + 3, n5, n + 3, n5);
        graphics.drawLine(n + n3 - 4, n5, n + n3 - 4, n5);
        graphics.setColor(ColorRoutines.lighten(color, 7 * n7));
        graphics.drawLine(n + 4, n5, n + 4, n5);
        graphics.drawLine(n + n3 - 5, n5, n + n3 - 5, n5);
        graphics.setColor(ColorRoutines.lighten(color, 3 * n7));
        graphics.drawLine(n + 5, n5, n + 5, n5);
        graphics.drawLine(n + n3 - 6, n5, n + n3 - 6, n5);
        graphics.setColor(color);
        graphics.drawLine(n + 6, n5, n + 6, n5);
        graphics.drawLine(n + n3 - 7, n5, n + n3 - 7, n5);
        graphics.setColor(ColorRoutines.darken(color, 2 * n6));
        graphics.drawLine(n + 5, ++n5, n + n3 - 6, n5);
        graphics.setColor(ColorRoutines.darken(color, 6 * n6));
        graphics.drawLine(n + 1, n5, n + 1, n5);
        graphics.drawLine(n + n3 - 2, n5, n + n3 - 2, n5);
        graphics.setColor(ColorRoutines.lighten(color, 10 * n7));
        graphics.drawLine(n + 2, n5, n + 2, n5);
        graphics.drawLine(n + n3 - 3, n5, n + n3 - 3, n5);
        graphics.setColor(ColorRoutines.lighten(color, 5 * n7));
        graphics.drawLine(n + 3, n5, n + 3, n5);
        graphics.drawLine(n + n3 - 4, n5, n + n3 - 4, n5);
        graphics.setColor(color);
        graphics.drawLine(n + 4, n5, n + 4, n5);
        graphics.drawLine(n + n3 - 5, n5, n + n3 - 5, n5);
        buttonUpperColor = ColorRoutines.darken(color, 4 * n6);
        graphics.setColor(buttonUpperColor);
        graphics.drawLine(n + 2, ++n5, n + n3 - 3, n5);
        graphics.setColor(ColorRoutines.darken(color, 4 * n6));
        graphics.drawLine(n + 1, n5, n + 1, n5);
        graphics.drawLine(n + n3 - 2, n5, n + n3 - 2, n5);
        graphics.setColor(ColorRoutines.darken(color, 4 * n6));
        graphics.fillRect(n + 1, ++n5, n3 - 2, 2);
        graphics.setColor(ColorRoutines.darken(color, 3 * n6));
        graphics.fillRect(n + 1, n5 += 2, n3 - 2, 4);
        graphics.setColor(ColorRoutines.darken(color, 2 * n6));
        graphics.fillRect(n + 1, n5 += 4, n3 - 2, 3);
        graphics.setColor(ColorRoutines.darken(color, 1 * n6));
        graphics.fillRect(n + 1, n5 += 3, n3 - 2, 2);
        graphics.setColor(color);
        graphics.fillRect(n + 1, n5 += 2, n3 - 2, 2);
        graphics.setColor(ColorRoutines.lighten(color, 2 * n7));
        graphics.drawLine(n + 1, n5 += 2, n + n3 - 2, n5);
        graphics.setColor(ColorRoutines.lighten(color, 4 * n7));
        graphics.drawLine(n + 1, ++n5, n + n3 - 2, n5);
        graphics.setColor(ColorRoutines.lighten(color, 5 * n7));
        graphics.drawLine(n + 1, ++n5, n + n3 - 2, n5);
        graphics.setColor(ColorRoutines.lighten(color, 6 * n7));
        graphics.drawLine(n + 1, ++n5, n + n3 - 2, n5);
        graphics.setColor(ColorRoutines.lighten(color, 8 * n7));
        graphics.drawLine(n + 1, ++n5, n + n3 - 2, n5);
        graphics.setColor(ColorRoutines.lighten(color, 9 * n7));
        graphics.drawLine(n + 1, ++n5, n + n3 - 2, n5);
        buttonLowerColor = ColorRoutines.lighten(color, 10 * n7);
        graphics.setColor(buttonLowerColor);
        graphics.drawLine(n + 1, ++n5, n + n3 - 2, n5);
        graphics.setColor(ColorRoutines.lighten(color, 4 * n7));
        graphics.drawLine(n + 1, ++n5, n + n3 - 2, n5);
        graphics.setColor(ColorRoutines.darken(color, 2 * n6));
        graphics.drawLine(n + 1, ++n5, n + n3 - 2, n5);
        ++n5;
        if (this.isActive) {
            graphics.setColor(Theme.frameLightColor[Theme.style].getColor());
        } else {
            graphics.setColor(Theme.frameLightDisabledColor[Theme.style].getColor());
        }
        graphics.drawLine(n + 1, n5, n + n3 - 2, n5);
    }

    private void drawXpInternalCaption(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
        int n5 = Theme.frameSpreadDarkDisabled[Theme.style];
        int n6 = Theme.frameSpreadLightDisabled[Theme.style];
        int n7 = n2;
        ColorUIResource colorUIResource = null;
        if (this.isActive) {
            colorUIResource = Theme.frameBorderColor[Theme.style].getColor();
            n5 = Theme.frameSpreadDark[Theme.style];
            n6 = Theme.frameSpreadLight[Theme.style];
        } else {
            colorUIResource = Theme.frameBorderDisabledColor[Theme.style].getColor();
        }
        graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource, 82));
        graphics.drawLine(n + 3, n7, n + 3, n7);
        graphics.drawLine(n + n3 - 4, n7, n + n3 - 4, n7);
        graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource, 156));
        graphics.drawLine(n + 4, n7, n + 4, n7);
        graphics.drawLine(n + n3 - 5, n7, n + n3 - 5, n7);
        graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource, 215));
        graphics.drawLine(n + 5, n7, n + 5, n7);
        graphics.drawLine(n + n3 - 6, n7, n + n3 - 6, n7);
        Color color2 = ColorRoutines.darken(color, 4 * n5);
        graphics.setColor(color2);
        graphics.drawLine(n + 3, ++n7, n + 5, n7);
        graphics.drawLine(n + n3 - 6, n7, n + n3 - 4, n7);
        graphics.setColor(ColorRoutines.getAlphaColor(color2, 139));
        graphics.drawLine(n + 2, n7, n + 2, n7);
        graphics.drawLine(n + n3 - 3, n7, n + n3 - 3, n7);
        graphics.setColor(ColorRoutines.getAlphaColor(color2, 23));
        graphics.drawLine(n + 1, n7, n + 1, n7);
        graphics.drawLine(n + n3 - 2, n7, n + n3 - 2, n7);
        graphics.setColor(ColorRoutines.lighten(color, 10 * n6));
        graphics.drawLine(n + 4, ++n7, n + 5, n7);
        graphics.drawLine(n + n3 - 6, n7, n + n3 - 5, n7);
        graphics.setColor(color);
        graphics.drawLine(n + 3, n7, n + 3, n7);
        graphics.drawLine(n + n3 - 4, n7, n + n3 - 4, n7);
        color2 = ColorRoutines.darken(color, 6 * n5);
        graphics.setColor(color2);
        graphics.drawLine(n + 2, n7, n + 2, n7);
        graphics.drawLine(n + n3 - 3, n7, n + n3 - 3, n7);
        graphics.setColor(ColorRoutines.getAlphaColor(color2, 139));
        graphics.drawLine(n + 1, n7, n + 1, n7);
        graphics.drawLine(n + n3 - 2, n7, n + n3 - 2, n7);
        graphics.setColor(color);
        graphics.drawLine(n + 2, ++n7, n + 2, n7);
        graphics.drawLine(n + n3 - 3, n7, n + n3 - 3, n7);
        graphics.setColor(ColorRoutines.darken(color, 6 * n5));
        graphics.drawLine(n + 1, n7, n + 1, n7);
        graphics.drawLine(n + n3 - 2, n7, n + n3 - 2, n7);
        graphics.setColor(ColorRoutines.lighten(color, 10 * n6));
        graphics.drawLine(n + 3, n7, n + 3, n7);
        graphics.drawLine(n + n3 - 4, n7, n + n3 - 4, n7);
        graphics.setColor(ColorRoutines.lighten(color, 7 * n6));
        graphics.drawLine(n + 4, n7, n + 4, n7);
        graphics.drawLine(n + n3 - 5, n7, n + n3 - 5, n7);
        graphics.setColor(ColorRoutines.lighten(color, 3 * n6));
        graphics.drawLine(n + 5, n7, n + 5, n7);
        graphics.drawLine(n + n3 - 6, n7, n + n3 - 6, n7);
        graphics.setColor(color);
        graphics.drawLine(n + 6, n7, n + 6, n7);
        graphics.drawLine(n + n3 - 7, n7, n + n3 - 7, n7);
        graphics.setColor(ColorRoutines.darken(color, 2 * n5));
        graphics.drawLine(n + 5, ++n7, n + 6, n7);
        graphics.drawLine(n + n + n3 - 7, n7, n + n3 - 6, n7);
        graphics.setColor(ColorRoutines.darken(color, 6 * n5));
        graphics.drawLine(n + 1, n7, n + 1, n7);
        graphics.drawLine(n + n3 - 2, n7, n + n3 - 2, n7);
        graphics.setColor(ColorRoutines.lighten(color, 10 * n6));
        graphics.drawLine(n + 2, n7, n + 2, n7);
        graphics.drawLine(n + n3 - 3, n7, n + n3 - 3, n7);
        graphics.setColor(ColorRoutines.lighten(color, 5 * n6));
        graphics.drawLine(n + 3, n7, n + 3, n7);
        graphics.drawLine(n + n3 - 4, n7, n + n3 - 4, n7);
        graphics.setColor(color);
        graphics.drawLine(n + 4, n7, n + 4, n7);
        graphics.drawLine(n + n3 - 5, n7, n + n3 - 5, n7);
        graphics.setColor(ColorRoutines.darken(color, 4 * n5));
        graphics.drawLine(n + 1, ++n7, n + 1, n7);
        graphics.drawLine(n + n3 - 2, n7, n + n3 - 2, n7);
        CaptionKey captionKey = new CaptionKey(this.isActive, this.titleHeight);
        Object v = cache.get(captionKey);
        if (v != null) {
            graphics.drawImage((Image)v, n + 6, n2, n + n3 - 6, n2 + 5, 0, 0, 1, 5, this.window);
            graphics.drawImage((Image)v, n + 1, n2 + 5, n + n3 - 1, n2 + this.titleHeight, 0, 5, 1, this.titleHeight, this.window);
            buttonUpperColor = ColorRoutines.darken(color, 4 * n5);
            buttonLowerColor = ColorRoutines.lighten(color, 10 * n6);
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(1, this.titleHeight, 2);
        Graphics graphics2 = ((Image)bufferedImage).getGraphics();
        graphics2.setColor(colorUIResource);
        graphics2.drawLine(0, 0, 1, 0);
        graphics2.setColor(ColorRoutines.darken(color, 4 * n5));
        graphics2.drawLine(0, 1, 1, 1);
        graphics2.setColor(ColorRoutines.lighten(color, 10 * n6));
        graphics2.drawLine(0, 2, 1, 2);
        graphics2.setColor(color);
        graphics2.drawLine(0, 3, 1, 3);
        graphics2.setColor(ColorRoutines.darken(color, 2 * n5));
        graphics2.drawLine(0, 4, 1, 4);
        graphics2.setColor(ColorRoutines.darken(color, 4 * n5));
        graphics2.drawLine(0, 5, 1, 5);
        graphics2.setColor(ColorRoutines.darken(color, 4 * n5));
        graphics2.drawLine(0, 6, 1, 6);
        graphics2.setColor(ColorRoutines.darken(color, 3 * n5));
        graphics2.drawLine(0, 7, 1, 7);
        graphics2.drawLine(0, 8, 1, 8);
        graphics2.drawLine(0, 9, 1, 9);
        graphics2.setColor(ColorRoutines.darken(color, 2 * n5));
        graphics2.drawLine(0, 10, 1, 10);
        graphics2.drawLine(0, 11, 1, 11);
        graphics2.setColor(ColorRoutines.darken(color, n5));
        graphics2.drawLine(0, 12, 1, 12);
        graphics2.setColor(color);
        graphics2.drawLine(0, 13, 1, 13);
        graphics2.drawLine(0, 14, 1, 14);
        graphics2.setColor(ColorRoutines.lighten(color, 2 * n6));
        graphics2.drawLine(0, 15, 1, 15);
        graphics2.setColor(ColorRoutines.lighten(color, 4 * n6));
        graphics2.drawLine(0, 16, 1, 16);
        graphics2.setColor(ColorRoutines.lighten(color, 5 * n6));
        graphics2.drawLine(0, 17, 1, 17);
        graphics2.setColor(ColorRoutines.lighten(color, 6 * n6));
        graphics2.drawLine(0, 18, 1, 18);
        graphics2.setColor(ColorRoutines.lighten(color, 8 * n6));
        graphics2.drawLine(0, 19, 1, 19);
        graphics2.setColor(ColorRoutines.lighten(color, 9 * n6));
        graphics2.drawLine(0, 20, 1, 20);
        graphics2.setColor(ColorRoutines.lighten(color, 10 * n6));
        graphics2.drawLine(0, 21, 1, 21);
        graphics2.setColor(ColorRoutines.lighten(color, 4 * n6));
        graphics2.drawLine(0, 22, 1, 22);
        graphics2.setColor(ColorRoutines.darken(color, 2 * n5));
        graphics2.drawLine(0, 23, 1, 23);
        if (this.isActive) {
            graphics2.setColor(Theme.frameLightColor[Theme.style].getColor());
        } else {
            graphics2.setColor(Theme.frameLightDisabledColor[Theme.style].getColor());
        }
        graphics2.drawLine(0, 24, 1, 24);
        graphics2.dispose();
        graphics.drawImage(bufferedImage, n + 6, n2, n + n3 - 6, n2 + 5, 0, 0, 1, 5, this.window);
        graphics.drawImage(bufferedImage, n + 1, n2 + 5, n + n3 - 1, n2 + this.titleHeight, 0, 5, 1, this.titleHeight, this.window);
        cache.put(captionKey, bufferedImage);
    }

    private void drawXpInternalCaptionNoCache(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
        int n5 = n2;
        int n6 = Theme.frameSpreadDarkDisabled[Theme.style];
        int n7 = Theme.frameSpreadLightDisabled[Theme.style];
        ColorUIResource colorUIResource = null;
        if (this.isActive) {
            colorUIResource = Theme.frameBorderColor[Theme.style].getColor();
            n6 = Theme.frameSpreadDark[Theme.style];
            n7 = Theme.frameSpreadLight[Theme.style];
        } else {
            colorUIResource = Theme.frameBorderDisabledColor[Theme.style].getColor();
        }
        graphics.setColor(colorUIResource);
        graphics.drawLine(n + 6, n5, n + n3 - 7, n5);
        graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource, 82));
        graphics.drawLine(n + 3, n5, n + 3, n5);
        graphics.drawLine(n + n3 - 4, n5, n + n3 - 4, n5);
        graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource, 156));
        graphics.drawLine(n + 4, n5, n + 4, n5);
        graphics.drawLine(n + n3 - 5, n5, n + n3 - 5, n5);
        graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource, 215));
        graphics.drawLine(n + 5, n5, n + 5, n5);
        graphics.drawLine(n + n3 - 6, n5, n + n3 - 6, n5);
        Color color2 = ColorRoutines.darken(color, 4 * n6);
        graphics.setColor(color2);
        graphics.drawLine(n + 3, ++n5, n + n3 - 4, n5);
        graphics.setColor(ColorRoutines.getAlphaColor(color2, 139));
        graphics.drawLine(n + 2, n5, n + 2, n5);
        graphics.drawLine(n + n3 - 3, n5, n + n3 - 3, n5);
        graphics.setColor(ColorRoutines.getAlphaColor(color2, 23));
        graphics.drawLine(n + 1, n5, n + 1, n5);
        graphics.drawLine(n + n3 - 2, n5, n + n3 - 2, n5);
        graphics.setColor(ColorRoutines.lighten(color, 10 * n7));
        graphics.drawLine(n + 4, ++n5, n + n3 - 5, n5);
        graphics.setColor(color);
        graphics.drawLine(n + 3, n5, n + 3, n5);
        graphics.drawLine(n + n3 - 4, n5, n + n3 - 4, n5);
        color2 = ColorRoutines.darken(color, 6 * n6);
        graphics.setColor(color2);
        graphics.drawLine(n + 2, n5, n + 2, n5);
        graphics.drawLine(n + n3 - 3, n5, n + n3 - 3, n5);
        graphics.setColor(ColorRoutines.getAlphaColor(color2, 139));
        graphics.drawLine(n + 1, n5, n + 1, n5);
        graphics.drawLine(n + n3 - 2, n5, n + n3 - 2, n5);
        graphics.setColor(color);
        graphics.drawLine(n + 7, ++n5, n + n3 - 8, n5);
        graphics.setColor(color);
        graphics.drawLine(n + 2, n5, n + 2, n5);
        graphics.drawLine(n + n3 - 3, n5, n + n3 - 3, n5);
        graphics.setColor(ColorRoutines.darken(color, 6 * n6));
        graphics.drawLine(n + 1, n5, n + 1, n5);
        graphics.drawLine(n + n3 - 2, n5, n + n3 - 2, n5);
        graphics.setColor(ColorRoutines.lighten(color, 10 * n7));
        graphics.drawLine(n + 3, n5, n + 3, n5);
        graphics.drawLine(n + n3 - 4, n5, n + n3 - 4, n5);
        graphics.setColor(ColorRoutines.lighten(color, 7 * n7));
        graphics.drawLine(n + 4, n5, n + 4, n5);
        graphics.drawLine(n + n3 - 5, n5, n + n3 - 5, n5);
        graphics.setColor(ColorRoutines.lighten(color, 3 * n7));
        graphics.drawLine(n + 5, n5, n + 5, n5);
        graphics.drawLine(n + n3 - 6, n5, n + n3 - 6, n5);
        graphics.setColor(color);
        graphics.drawLine(n + 6, n5, n + 6, n5);
        graphics.drawLine(n + n3 - 7, n5, n + n3 - 7, n5);
        graphics.setColor(ColorRoutines.darken(color, 2 * n6));
        graphics.drawLine(n + 5, ++n5, n + n3 - 6, n5);
        graphics.setColor(ColorRoutines.darken(color, 6 * n6));
        graphics.drawLine(n + 1, n5, n + 1, n5);
        graphics.drawLine(n + n3 - 2, n5, n + n3 - 2, n5);
        graphics.setColor(ColorRoutines.lighten(color, 10 * n7));
        graphics.drawLine(n + 2, n5, n + 2, n5);
        graphics.drawLine(n + n3 - 3, n5, n + n3 - 3, n5);
        graphics.setColor(ColorRoutines.lighten(color, 5 * n7));
        graphics.drawLine(n + 3, n5, n + 3, n5);
        graphics.drawLine(n + n3 - 4, n5, n + n3 - 4, n5);
        graphics.setColor(color);
        graphics.drawLine(n + 4, n5, n + 4, n5);
        graphics.drawLine(n + n3 - 5, n5, n + n3 - 5, n5);
        graphics.setColor(ColorRoutines.darken(color, 4 * n6));
        graphics.drawLine(n + 2, ++n5, n + n3 - 3, n5);
        graphics.setColor(ColorRoutines.darken(color, 4 * n6));
        graphics.drawLine(n + 1, n5, n + 1, n5);
        graphics.drawLine(n + n3 - 2, n5, n + n3 - 2, n5);
        graphics.setColor(ColorRoutines.darken(color, 4 * n6));
        graphics.fillRect(n + 1, ++n5, n3 - 2, 1);
        graphics.setColor(ColorRoutines.darken(color, 3 * n6));
        graphics.fillRect(n + 1, ++n5, n3 - 2, 3);
        graphics.setColor(ColorRoutines.darken(color, 2 * n6));
        graphics.fillRect(n + 1, n5 += 3, n3 - 2, 2);
        graphics.setColor(ColorRoutines.darken(color, 1 * n6));
        graphics.fillRect(n + 1, n5 += 2, n3 - 2, 1);
        graphics.setColor(color);
        graphics.fillRect(n + 1, ++n5, n3 - 2, 2);
        graphics.setColor(ColorRoutines.lighten(color, 2 * n7));
        graphics.drawLine(n + 1, n5 += 2, n + n3 - 2, n5);
        graphics.setColor(ColorRoutines.lighten(color, 4 * n7));
        graphics.drawLine(n + 1, ++n5, n + n3 - 2, n5);
        graphics.setColor(ColorRoutines.lighten(color, 5 * n7));
        graphics.drawLine(n + 1, ++n5, n + n3 - 2, n5);
        graphics.setColor(ColorRoutines.lighten(color, 6 * n7));
        graphics.drawLine(n + 1, ++n5, n + n3 - 2, n5);
        graphics.setColor(ColorRoutines.lighten(color, 8 * n7));
        graphics.drawLine(n + 1, ++n5, n + n3 - 2, n5);
        graphics.setColor(ColorRoutines.lighten(color, 9 * n7));
        graphics.drawLine(n + 1, ++n5, n + n3 - 2, n5);
        graphics.setColor(ColorRoutines.lighten(color, 10 * n7));
        graphics.drawLine(n + 1, ++n5, n + n3 - 2, n5);
        graphics.setColor(ColorRoutines.lighten(color, 4 * n7));
        graphics.drawLine(n + 1, ++n5, n + n3 - 2, n5);
        graphics.setColor(ColorRoutines.darken(color, 2 * n6));
        graphics.drawLine(n + 1, ++n5, n + n3 - 2, n5);
        ++n5;
        if (this.isActive) {
            graphics.setColor(Theme.frameLightColor[Theme.style].getColor());
        } else {
            graphics.setColor(Theme.frameLightDisabledColor[Theme.style].getColor());
        }
        graphics.drawLine(n + 1, n5, n + n3 - 2, n5);
    }

    public Insets getBorderInsets(Component component) {
        Frame frame;
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window != null && window instanceof Frame && (frame = (Frame)window).getExtendedState() == (frame.getExtendedState() | 6)) {
            return new Insets(0, 0, 0, 0);
        }
        return new Insets(0, Theme.frameBorderWidth[Theme.derivedStyle[Theme.style]], Theme.frameBorderWidth[Theme.derivedStyle[Theme.style]], Theme.frameBorderWidth[Theme.derivedStyle[Theme.style]]);
    }

    static {
        robotsSupported = true;
    }

    static class CaptionKey {
        private boolean isActive;
        private int titleHeight;

        CaptionKey(boolean bl, int n) {
            this.isActive = bl;
            this.titleHeight = n;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof CaptionKey)) {
                return false;
            }
            CaptionKey captionKey = (CaptionKey)object;
            return this.isActive == captionKey.isActive && this.titleHeight == captionKey.titleHeight;
        }

        public int hashCode() {
            return (this.isActive ? 1 : 2) * this.titleHeight;
        }
    }
}

