/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.borders;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.DrawRoutines;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;

public class TinyButtonBorder
extends AbstractBorder
implements UIResource {
    protected final Insets borderInsets = new Insets(2, 2, 2, 2);

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyBorder(component, graphics, n, n2, n3, n4);
                break;
            }
            case 1: {
                this.drawWinBorder(component, graphics, n, n2, n3, n4);
                break;
            }
            case 2: {
                this.drawXpBorder(component, graphics, n, n2, n3, n4);
            }
        }
    }

    private void drawTinyBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    private void drawWinBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        boolean bl;
        AbstractButton abstractButton = (AbstractButton)component;
        boolean bl2 = bl = component instanceof JButton && ((JButton)component).isDefaultButton();
        if (abstractButton.getModel().isPressed() || abstractButton instanceof JToggleButton && abstractButton.isSelected()) {
            graphics.setColor(Color.BLACK);
            graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            graphics.setColor(Theme.buttonDarkColor[Theme.style].getColor());
            graphics.drawRect(1, 1, n3 - 3, n4 - 3);
            return;
        }
        if (bl && abstractButton.isEnabled()) {
            graphics.setColor(Theme.buttonDefaultColor[Theme.style].getColor());
            graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            ++n;
            ++n2;
            --n3;
            --n4;
        }
        if (!abstractButton.isEnabled()) {
            graphics.setColor(Theme.buttonLightDisabledColor[Theme.style].getColor());
        } else {
            graphics.setColor(Theme.buttonLightColor[Theme.style].getColor());
        }
        graphics.drawLine(n, n2, n3 - 2, n2);
        graphics.drawLine(n, n2 + 1, n, n4 - 2);
        if (!abstractButton.isEnabled()) {
            graphics.setColor(Theme.buttonBorderDisabledColor[Theme.style].getColor());
        } else {
            graphics.setColor(Theme.buttonBorderColor[Theme.style].getColor());
        }
        graphics.drawLine(n, n4 - 1, n3 - 1, n4 - 1);
        graphics.drawLine(n3 - 1, n2, n3 - 1, n4 - 1);
        if (!abstractButton.isEnabled()) {
            graphics.setColor(Theme.buttonDarkDisabledColor[Theme.style].getColor());
        } else {
            graphics.setColor(Theme.buttonDarkColor[Theme.style].getColor());
        }
        graphics.drawLine(n + 1, n4 - 2, n3 - 2, n4 - 2);
        graphics.drawLine(n3 - 2, n2 + 1, n3 - 2, n4 - 2);
    }

    private void drawXpBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        AbstractButton abstractButton = (AbstractButton)component;
        boolean bl = component instanceof JButton && ((JButton)component).isDefaultButton();
        boolean bl2 = Boolean.TRUE.equals(abstractButton.getClientProperty("isComboBoxButton"));
        if (bl2) {
            if (!abstractButton.isEnabled()) {
                DrawRoutines.drawRoundedBorder(graphics, Theme.comboBorderDisabledColor[Theme.style].getColor(), n, n2, n3, n4);
            } else {
                DrawRoutines.drawRoundedBorder(graphics, Theme.comboBorderColor[Theme.style].getColor(), n, n2, n3, n4);
                if (abstractButton.getModel().isPressed()) {
                    return;
                }
                if (abstractButton.getModel().isRollover() && Theme.comboRollover[Theme.style]) {
                    DrawRoutines.drawRolloverBorder(graphics, Theme.buttonRolloverColor[Theme.style].getColor(), n, n2, n3, n4);
                }
            }
        } else {
            boolean bl3;
            boolean bl4 = Boolean.TRUE.equals(abstractButton.getClientProperty("isSpinnerButton"));
            boolean bl5 = bl3 = bl4 && Theme.spinnerRollover[Theme.style] || !bl4 && Theme.buttonRollover[Theme.style];
            if (!abstractButton.isEnabled()) {
                DrawRoutines.drawRoundedBorder(graphics, Theme.buttonBorderDisabledColor[Theme.style].getColor(), n, n2, n3, n4);
            } else {
                DrawRoutines.drawRoundedBorder(graphics, Theme.buttonBorderColor[Theme.style].getColor(), n, n2, n3, n4);
                if (abstractButton.getModel().isPressed()) {
                    return;
                }
                if (abstractButton.getModel().isRollover() && bl3) {
                    DrawRoutines.drawRolloverBorder(graphics, Theme.buttonRolloverColor[Theme.style].getColor(), n, n2, n3, n4);
                } else if (bl || Theme.buttonFocusBorder[Theme.style] && abstractButton.isFocusOwner()) {
                    DrawRoutines.drawRolloverBorder(graphics, Theme.buttonDefaultColor[Theme.style].getColor(), n, n2, n3, n4);
                }
            }
        }
    }

    public Insets getBorderInsets(Component component) {
        return this.borderInsets;
    }
}

