/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.controlpanel.TinyTableModel;
import de.muntjak.tinylookandfeel.table.SortableTableData;
import de.muntjak.tinylookandfeel.table.TinyTableHeaderRenderer;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

public class TinyTableHeaderUI
extends BasicTableHeaderUI {
    public static final String ROLLOVER_COLUMN_KEY = "rolloverColumn";
    public static final String SORTED_COLUMN_KEY = "sortedColumn";
    public static final String SORTING_DIRECTION_KEY = "sortingDirection";
    private static final int ADD_COLUMN = 0;
    private static final int REMOVE_COLUMN = 1;
    private static final int REPLACE_COLUMN = 2;
    private static final int MINIMUM_DRAG_DISTANCE = 5;
    private static final HashMap sortingCache = new HashMap();
    protected SortableTableHandler handler;
    protected TinyTableHeaderRenderer headerRenderer;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public static ComponentUI createUI(JComponent header) {
        return new TinyTableHeaderUI();
    }

    protected void installListeners() {
        super.installListeners();
        this.headerRenderer = new TinyTableHeaderRenderer();
        this.header.setDefaultRenderer(this.headerRenderer);
        this.handler = new SortableTableHandler();
        this.header.addMouseListener(this.handler);
        this.header.addMouseMotionListener(this.handler);
        this.header.getColumnModel().addColumnModelListener(this.handler);
        SortingInformation sortingInfo = (SortingInformation)sortingCache.get(this.header);
        if (sortingInfo != null) {
            this.handler.restoreSortingInformation(this.header, sortingInfo);
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.handler.removeSortingInformation();
        this.header.removeMouseListener(this.handler);
        this.header.removeMouseMotionListener(this.handler);
        this.header.getColumnModel().removeColumnModelListener(this.handler);
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        d.height = Math.max(16, d.height);
        return d;
    }

    public void sortColumns(int[] columns, int[] sortingDirections, JTable table) {
        if (this.handler == null) {
            return;
        }
        this.handler.sortColumns(columns, sortingDirections, table);
    }

    public void setHorizontalAlignments(int[] alignments) {
        if (this.headerRenderer == null) {
            return;
        }
        this.headerRenderer.setHorizontalAlignments(alignments);
    }

    private class SortableTableHandler
    implements MouseListener,
    MouseMotionListener,
    TableColumnModelListener {
        private int rolloverColumn = -1;
        private int pressedColumn = -1;
        private Vector sortedViewColumns = new Vector();
        private Vector sortedModelColumns = new Vector();
        private Vector sortingDirections = new Vector();
        private boolean mouseInside = false;
        private boolean mouseDragged = false;
        private boolean inDrag = false;
        private Point pressedPoint;

        private SortableTableHandler() {
        }

        void sortColumns(int[] columns, int[] directions, JTable table) {
            if (columns == null) {
                throw new IllegalArgumentException("columns argument may not be null");
            }
            if (directions == null) {
                throw new IllegalArgumentException("directions argument may not be null");
            }
            if (columns.length != directions.length) {
                throw new IllegalArgumentException("columns argument and directions argument must be of equal length");
            }
            if (columns.length > table.getColumnCount()) {
                throw new IllegalArgumentException("Length of columns argument is greater than number of table columns");
            }
            JTableHeader header = table.getTableHeader();
            SortableTableData model = this.getTableModel(header);
            if (model == null) {
                return;
            }
            this.sortedViewColumns.clear();
            this.sortedModelColumns.clear();
            this.sortingDirections.clear();
            int i = 0;
            while (i < columns.length) {
                this.sortedViewColumns.add(new Integer(columns[i]));
                this.sortedModelColumns.add(new Integer(this.getModelColumn(header, columns[i])));
                this.sortingDirections.add(new Integer(directions[i]));
                ++i;
            }
            header.putClientProperty(TinyTableHeaderUI.SORTED_COLUMN_KEY, this.vectorToIntArray(this.sortedViewColumns));
            header.putClientProperty(TinyTableHeaderUI.SORTING_DIRECTION_KEY, this.vectorToIntArray(this.sortingDirections));
            model.sortColumns(this.vectorToIntArray(this.sortedModelColumns), this.vectorToIntArray(this.sortingDirections), table);
            header.repaint();
        }

        public void mouseEntered(MouseEvent e) {
            this.mouseInside = true;
            if (this.mouseDragged) {
                return;
            }
            SortableTableData model = this.getTableModel(e.getSource());
            if (model == null) {
                return;
            }
            JTableHeader header = (JTableHeader)e.getSource();
            int viewColumn = header.columnAtPoint(e.getPoint());
            int modelColumn = this.getModelColumnAt(e);
            if (!model.isColumnSortable(modelColumn)) {
                if (this.rolloverColumn != -1) {
                    this.rolloverColumn = -1;
                    header.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, null);
                }
            } else {
                this.rolloverColumn = viewColumn;
                header.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, new Integer(this.rolloverColumn));
            }
            header.repaint();
        }

        public void mouseExited(MouseEvent e) {
            this.mouseInside = false;
            JTableHeader header = (JTableHeader)e.getSource();
            if (this.inDrag && header.getReorderingAllowed()) {
                return;
            }
            SortableTableData model = this.getTableModel(e.getSource());
            if (model == null) {
                return;
            }
            if (this.rolloverColumn != -1) {
                this.rolloverColumn = -1;
                header.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, null);
                header.repaint();
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.inDrag = false;
            if (e.isPopupTrigger()) {
                return;
            }
            if (!this.mouseInside) {
                this.mouseDragged = false;
                return;
            }
            SortableTableData model = this.getTableModel(e.getSource());
            if (model == null) {
                this.mouseDragged = false;
                return;
            }
            JTableHeader header = (JTableHeader)e.getSource();
            int viewColumn = header.columnAtPoint(e.getPoint());
            if (viewColumn == -1) {
                this.mouseDragged = false;
                return;
            }
            int modelColumn = this.getModelColumnAt(e);
            if (!model.isColumnSortable(modelColumn)) {
                if (this.rolloverColumn != -1) {
                    this.rolloverColumn = -1;
                    header.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, null);
                }
            } else {
                this.rolloverColumn = viewColumn;
                header.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, new Integer(this.rolloverColumn));
            }
            if (this.mouseDragged) {
                this.mouseDragged = false;
                return;
            }
            if (!model.isColumnSortable(modelColumn)) {
                return;
            }
            if (this.pressedColumn != viewColumn) {
                return;
            }
            Integer vc = new Integer(viewColumn);
            if (this.sortedViewColumns.contains(vc)) {
                int index = this.sortedViewColumns.indexOf(vc);
                if (e.isAltDown()) {
                    this.sortedViewColumns.remove(index);
                    this.sortedModelColumns.remove(index);
                    this.sortingDirections.remove(index);
                } else if (e.isControlDown() && model.supportsMultiColumnSort() || this.sortedModelColumns.size() == 1) {
                    int sortingDirection = (Integer)this.sortingDirections.get(index);
                    sortingDirection = sortingDirection != 2 ? 2 : 1;
                    this.sortingDirections.remove(index);
                    this.sortingDirections.add(index, new Integer(sortingDirection));
                } else {
                    int sortingDirection = (Integer)this.sortingDirections.get(index);
                    sortingDirection = sortingDirection != 2 ? 2 : 1;
                    this.sortedViewColumns.clear();
                    this.sortedModelColumns.clear();
                    this.sortingDirections.clear();
                    this.sortedViewColumns.add(vc);
                    this.sortedModelColumns.add(new Integer(this.getModelColumn(e, viewColumn)));
                    this.sortingDirections.add(new Integer(sortingDirection));
                }
            } else {
                if (e.isAltDown()) {
                    return;
                }
                if (e.isControlDown() && model.supportsMultiColumnSort()) {
                    this.sortedViewColumns.add(vc);
                    this.sortedModelColumns.add(new Integer(this.getModelColumn(e, viewColumn)));
                    this.sortingDirections.add(new Integer(1));
                } else {
                    this.sortedViewColumns.clear();
                    this.sortedModelColumns.clear();
                    this.sortingDirections.clear();
                    this.sortedViewColumns.add(vc);
                    this.sortedModelColumns.add(new Integer(this.getModelColumn(e, viewColumn)));
                    this.sortingDirections.add(new Integer(1));
                }
            }
            header.putClientProperty(TinyTableHeaderUI.SORTED_COLUMN_KEY, this.vectorToIntArray(this.sortedViewColumns));
            header.putClientProperty(TinyTableHeaderUI.SORTING_DIRECTION_KEY, this.vectorToIntArray(this.sortingDirections));
            model.sortColumns(this.vectorToIntArray(this.sortedModelColumns), this.vectorToIntArray(this.sortingDirections), header.getTable());
            header.repaint();
        }

        private int[] vectorToIntArray(Vector v) {
            int[] ret = new int[v.size()];
            int i = 0;
            while (i < ret.length) {
                ret[i] = (Integer)v.get(i);
                ++i;
            }
            return ret;
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                return;
            }
            JTableHeader header = (JTableHeader)e.getSource();
            this.pressedPoint = e.getPoint();
            this.pressedColumn = header.columnAtPoint(this.pressedPoint);
            this.mouseDragged = false;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            int modelColumn;
            SortableTableData model = this.getTableModel(e.getSource());
            if (model == null) {
                return;
            }
            this.inDrag = true;
            JTableHeader header = (JTableHeader)e.getSource();
            if (header.getResizingColumn() != null && !this.mouseDragged) {
                this.mouseDragged = true;
            }
            if (!header.getReorderingAllowed() && !model.isColumnSortable(modelColumn = this.getModelColumnAt(e))) {
                header.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, null);
                header.repaint();
                return;
            }
            if (!this.mouseDragged && this.isMouseDragged(e.getPoint(), this.pressedPoint)) {
                this.mouseDragged = true;
            }
            if (!this.mouseInside) {
                header.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, null);
            } else {
                int viewColumn;
                if (!header.getReorderingAllowed() && (viewColumn = header.columnAtPoint(e.getPoint())) != this.rolloverColumn) {
                    this.rolloverColumn = viewColumn;
                }
                if (this.rolloverColumn != -1) {
                    header.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, new Integer(this.rolloverColumn));
                }
            }
            header.repaint();
        }

        public void mouseMoved(MouseEvent e) {
            if (!this.mouseInside) {
                return;
            }
            JTableHeader header = (JTableHeader)e.getSource();
            int viewColumn = header.columnAtPoint(e.getPoint());
            if (viewColumn == -1) {
                return;
            }
            SortableTableData model = this.getTableModel(e.getSource());
            if (model == null) {
                return;
            }
            int modelColumn = this.getModelColumnAt(e);
            if (!model.isColumnSortable(modelColumn)) {
                if (this.rolloverColumn != -1) {
                    this.rolloverColumn = -1;
                    header.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, null);
                    header.repaint();
                }
                return;
            }
            if (viewColumn != this.rolloverColumn) {
                this.rolloverColumn = viewColumn;
                header.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, new Integer(this.rolloverColumn));
                header.repaint();
            }
        }

        public void columnAdded(TableColumnModelEvent e) {
            this.removeSorting();
        }

        public void columnMoved(TableColumnModelEvent e) {
            if (e.getFromIndex() == e.getToIndex()) {
                return;
            }
            if (TinyTableHeaderUI.this.header == null) {
                return;
            }
            if (this.rolloverColumn == e.getFromIndex()) {
                this.rolloverColumn = e.getToIndex();
                if (this.mouseInside) {
                    TinyTableHeaderUI.this.header.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, new Integer(this.rolloverColumn));
                }
            }
            int[] sc = this.vectorToIntArray(this.sortedViewColumns);
            boolean changed = false;
            int i = 0;
            while (i < sc.length) {
                if (sc[i] == e.getFromIndex()) {
                    sc[i] = e.getToIndex();
                    changed = true;
                } else if (sc[i] == e.getToIndex()) {
                    sc[i] = e.getFromIndex();
                    changed = true;
                }
                ++i;
            }
            if (changed) {
                this.sortedViewColumns.clear();
                i = 0;
                while (i < sc.length) {
                    this.sortedViewColumns.add(new Integer(sc[i]));
                    ++i;
                }
                TinyTableHeaderUI.this.header.putClientProperty(TinyTableHeaderUI.SORTED_COLUMN_KEY, this.vectorToIntArray(this.sortedViewColumns));
            }
        }

        public void columnRemoved(TableColumnModelEvent e) {
            this.removeSorting();
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }

        private void removeSorting() {
            if (TinyTableHeaderUI.this.header == null) {
                return;
            }
            if (this.rolloverColumn != -1) {
                this.rolloverColumn = -1;
                TinyTableHeaderUI.this.header.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, new Integer(this.rolloverColumn));
            }
            this.sortedModelColumns.clear();
            this.sortedViewColumns.clear();
            this.sortingDirections.clear();
            TinyTableHeaderUI.this.header.putClientProperty(TinyTableHeaderUI.SORTING_DIRECTION_KEY, null);
            TinyTableHeaderUI.this.header.putClientProperty(TinyTableHeaderUI.SORTED_COLUMN_KEY, null);
            TinyTableHeaderUI.this.header.repaint();
        }

        void removeSortingInformation() {
            if (TinyTableHeaderUI.this.header == null) {
                return;
            }
            SortableTableData model = this.getTableModel(TinyTableHeaderUI.this.header);
            if (model == null) {
                return;
            }
            sortingCache.put(TinyTableHeaderUI.this.header, new SortingInformation(this.sortedViewColumns, this.sortedModelColumns, this.sortingDirections));
            model.sortColumns(new int[0], new int[0], TinyTableHeaderUI.this.header.getTable());
            TinyTableHeaderUI.this.header.repaint();
        }

        void restoreSortingInformation(JTableHeader header, SortingInformation sortingInfo) {
            if (header == null) {
                return;
            }
            SortableTableData model = this.getTableModel(header);
            if (model == null) {
                return;
            }
            this.sortedViewColumns = sortingInfo.sortedViewColumns;
            this.sortedModelColumns = sortingInfo.sortedModelColumns;
            this.sortingDirections = sortingInfo.sortingDirections;
            model.sortColumns(this.vectorToIntArray(this.sortedModelColumns), this.vectorToIntArray(this.sortingDirections), header.getTable());
            header.repaint();
        }

        private SortableTableData getTableModel(Object source) {
            return this.getTableModel((JTableHeader)source);
        }

        private SortableTableData getTableModel(JTableHeader header) {
            JTable table = header.getTable();
            if (table == null) {
                return null;
            }
            TableModel model = table.getModel();
            if (!(model instanceof SortableTableData)) {
                return null;
            }
            return (SortableTableData)((Object)model);
        }

        private int getModelColumnAt(MouseEvent e) {
            JTableHeader header = (JTableHeader)e.getSource();
            int viewColumn = header.columnAtPoint(e.getPoint());
            if (viewColumn == -1) {
                return -1;
            }
            return header.getColumnModel().getColumn(viewColumn).getModelIndex();
        }

        private int getModelColumn(MouseEvent e, int viewColumn) {
            if (viewColumn == -1) {
                return -1;
            }
            JTableHeader header = (JTableHeader)e.getSource();
            return this.getModelColumn(header, viewColumn);
        }

        private int getModelColumn(JTableHeader header, int viewColumn) {
            return header.getColumnModel().getColumn(viewColumn).getModelIndex();
        }

        private boolean isMouseDragged(Point p1, Point p2) {
            return Math.abs(p1.x - p2.x) >= 5;
        }

        private void showHeaderPopup(MouseEvent e) {
            SortableTableData model = this.getTableModel(e.getSource());
            if (model == null) {
                return;
            }
            JTableHeader header = (JTableHeader)e.getSource();
            int viewColumn = header.columnAtPoint(e.getPoint());
            JPopupMenu menu = new JPopupMenu();
            JMenu sub = new JMenu("Add");
            JMenuItem item = new JMenuItem("Double Column");
            item.addActionListener(new ActionListener(this, model, viewColumn){
                final /* synthetic */ SortableTableHandler this$1;
                private final /* synthetic */ SortableTableData val$model;
                private final /* synthetic */ int val$viewColumn;
                {
                    this.this$1 = sortableTableHandler;
                    this.val$model = sortableTableData;
                    this.val$viewColumn = n;
                }

                public void actionPerformed(ActionEvent e) {
                    TinyTableModel tinyTableModel = (TinyTableModel)this.val$model;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("java.lang.Double");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    tinyTableModel.addColumn(clazz, this.val$viewColumn);
                }
            });
            sub.add(item);
            item = new JMenuItem("Icon Column");
            item.addActionListener(new ActionListener(this, model, viewColumn){
                final /* synthetic */ SortableTableHandler this$1;
                private final /* synthetic */ SortableTableData val$model;
                private final /* synthetic */ int val$viewColumn;
                {
                    this.this$1 = sortableTableHandler;
                    this.val$model = sortableTableData;
                    this.val$viewColumn = n;
                }

                public void actionPerformed(ActionEvent e) {
                    TinyTableModel tinyTableModel = (TinyTableModel)this.val$model;
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("javax.swing.Icon");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    tinyTableModel.addColumn(clazz, this.val$viewColumn);
                }
            });
            sub.add(item);
            item = new JMenuItem("Integer Column");
            item.addActionListener(new ActionListener(this, model, viewColumn){
                final /* synthetic */ SortableTableHandler this$1;
                private final /* synthetic */ SortableTableData val$model;
                private final /* synthetic */ int val$viewColumn;
                {
                    this.this$1 = sortableTableHandler;
                    this.val$model = sortableTableData;
                    this.val$viewColumn = n;
                }

                public void actionPerformed(ActionEvent e) {
                    TinyTableModel tinyTableModel = (TinyTableModel)this.val$model;
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = class$2 = Class.forName("java.lang.Integer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    tinyTableModel.addColumn(clazz, this.val$viewColumn);
                }
            });
            sub.add(item);
            item = new JMenuItem("String Column");
            item.addActionListener(new ActionListener(this, model, viewColumn){
                final /* synthetic */ SortableTableHandler this$1;
                private final /* synthetic */ SortableTableData val$model;
                private final /* synthetic */ int val$viewColumn;
                {
                    this.this$1 = sortableTableHandler;
                    this.val$model = sortableTableData;
                    this.val$viewColumn = n;
                }

                public void actionPerformed(ActionEvent e) {
                    TinyTableModel tinyTableModel = (TinyTableModel)this.val$model;
                    Class<?> clazz = class$3;
                    if (clazz == null) {
                        try {
                            clazz = class$3 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    tinyTableModel.addColumn(clazz, this.val$viewColumn);
                }
            });
            sub.add(item);
            menu.add(sub);
            menu.addSeparator();
            item = new JMenuItem("Remove Column");
            item.addActionListener(new ActionListener(this, model, viewColumn){
                final /* synthetic */ SortableTableHandler this$1;
                private final /* synthetic */ SortableTableData val$model;
                private final /* synthetic */ int val$viewColumn;
                {
                    this.this$1 = sortableTableHandler;
                    this.val$model = sortableTableData;
                    this.val$viewColumn = n;
                }

                public void actionPerformed(ActionEvent e) {
                    ((TinyTableModel)this.val$model).removeColumn(this.val$viewColumn);
                }
            });
            if (((TinyTableModel)model).getColumnCount() < 2) {
                item.setEnabled(false);
            }
            menu.add(item);
            menu.addSeparator();
            item = new JMenuItem("Remove all Rows");
            item.addActionListener(new ActionListener(this, model){
                final /* synthetic */ SortableTableHandler this$1;
                private final /* synthetic */ SortableTableData val$model;
                {
                    this.this$1 = sortableTableHandler;
                    this.val$model = sortableTableData;
                }

                public void actionPerformed(ActionEvent e) {
                    ((TinyTableModel)this.val$model).removeAllRows();
                }
            });
            if (((TinyTableModel)model).getRowCount() == 0) {
                item.setEnabled(false);
            }
            menu.add(item);
            menu.addSeparator();
            item = new JMenuItem("Create new Data");
            item.addActionListener(new ActionListener(this, model){
                final /* synthetic */ SortableTableHandler this$1;
                private final /* synthetic */ SortableTableData val$model;
                {
                    this.this$1 = sortableTableHandler;
                    this.val$model = sortableTableData;
                }

                public void actionPerformed(ActionEvent e) {
                    ((TinyTableModel)this.val$model).createNewData();
                }
            });
            if (((TinyTableModel)model).getRowCount() > 0) {
                item.setEnabled(false);
            }
            menu.add(item);
            menu.show(header, e.getX(), 0);
        }
    }

    private class SortingInformation {
        private Vector sortedViewColumns;
        private Vector sortedModelColumns;
        private Vector sortingDirections;

        SortingInformation(Vector sortedViewColumns, Vector sortedModelColumns, Vector sortingDirections) {
            this.sortedViewColumns = sortedViewColumns;
            this.sortedModelColumns = sortedModelColumns;
            this.sortingDirections = sortingDirections;
        }
    }
}

