/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.controlpanel.ColorRoutines;
import de.muntjak.tinylookandfeel.controlpanel.DrawRoutines;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public class TinyTabbedPaneUI
extends BasicTabbedPaneUI {
    int rollover = -1;

    public static ComponentUI createUI(JComponent c) {
        return new TinyTabbedPaneUI();
    }

    protected void installListeners() {
        super.installListeners();
        this.tabPane.addMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
    }

    protected MouseListener createMouseListener() {
        return new TinyMouseHandler();
    }

    protected void installDefaults() {
        super.installDefaults();
    }

    private boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getTabLayoutPolicy() == 1;
    }

    private void checkRollOver(int tabIndex) {
        if (this.rollover >= this.tabPane.getTabCount()) {
            this.rollover = -1;
        }
        if (tabIndex == this.rollover) {
            return;
        }
        if (this.rollover != -1) {
            this.tabPane.repaint(this.getTabBounds(this.tabPane, this.rollover));
            if (tabIndex == -1) {
                this.rollover = -1;
            }
        }
        if (tabIndex >= 0 && this.tabPane.isEnabledAt(tabIndex)) {
            this.rollover = tabIndex;
            this.tabPane.repaint(this.getTabBounds(this.tabPane, tabIndex));
        }
    }

    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return super.createLayoutManager();
        }
        return new TinyTabbedPaneLayout();
    }

    private int getTabAtLocation(int x, int y) {
        if (TinyLookAndFeel.is1dot4()) {
            this.ensureCurrentLayout();
            int tabCount = this.tabPane.getTabCount();
            int i = 0;
            while (i < tabCount) {
                if (this.rects[i].contains(x, y)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        return this.tabForCoordinate(this.tabPane, x, y);
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            BasicTabbedPaneUI.TabbedPaneLayout layout = (BasicTabbedPaneUI.TabbedPaneLayout)this.tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        boolean isEnabled = this.tabPane.isEnabledAt(tabIndex);
        if (!this.tabPane.isEnabled()) {
            isEnabled = false;
        }
        if (isSelected && !Theme.ignoreSelectedBg[Theme.style]) {
            if (isEnabled) {
                g.setColor(Theme.tabSelectedColor[Theme.style].getColor());
            } else {
                g.setColor(Theme.tabDisabledSelectedColor[Theme.style].getColor());
            }
        } else if (isEnabled) {
            g.setColor(this.tabPane.getBackgroundAt(tabIndex));
        } else {
            g.setColor(Theme.tabDisabledColor[Theme.style].getColor());
        }
        switch (tabPlacement) {
            case 2: {
                g.fillRect(x + 1, y + 1, w - 1, h - 3);
                break;
            }
            case 4: {
                g.fillRect(x -= 2, y + 1, w - 1, h - 3);
                break;
            }
            case 3: {
                g.fillRect(x + 1, y -= 2, w - 3, h - 1);
                break;
            }
            default: {
                g.fillRect(x + 1, y + 1, w - 3, h - 1);
            }
        }
    }

    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        if (!Theme.tabFocus[Theme.style]) {
            return;
        }
        Rectangle tabRect = rects[tabIndex];
        if (this.tabPane.hasFocus() && isSelected) {
            int h;
            int w;
            int y;
            int x;
            g.setColor(Theme.tabFontColor[Theme.style].getColor());
            switch (tabPlacement) {
                case 2: {
                    x = tabRect.x + 3;
                    y = tabRect.y + 3;
                    w = tabRect.width - 5;
                    h = tabRect.height - 7;
                    break;
                }
                case 4: {
                    x = tabRect.x;
                    y = tabRect.y + 3;
                    w = tabRect.width - 5;
                    h = tabRect.height - 7;
                    break;
                }
                case 3: {
                    x = tabRect.x + 3;
                    y = tabRect.y;
                    w = tabRect.width - 7;
                    h = tabRect.height - 5;
                    break;
                }
                default: {
                    x = tabRect.x + 3;
                    y = tabRect.y + 3;
                    w = tabRect.width - 7;
                    h = tabRect.height - 5;
                }
            }
            BasicGraphicsUtils.drawDashedRect(g, x, y, w, h);
        }
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        boolean isEnabled = this.tabPane.isEnabledAt(tabIndex);
        if (!this.tabPane.isEnabled()) {
            isEnabled = false;
        }
        boolean isRollover = this.rollover == tabIndex;
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyTabBorder(g, tabPlacement, x, y, w, h, isSelected, isEnabled, isRollover);
                break;
            }
            case 1: {
                this.drawWinTabBorder(g, tabPlacement, x, y, w, h, isSelected, isEnabled, isRollover);
                break;
            }
            case 2: {
                this.drawXpTabBorder(g, tabPlacement, x, y, w, h, isSelected, isEnabled, isRollover);
            }
        }
    }

    private void drawTinyTabBorder(Graphics g, int tabPlacement, int x, int y, int w, int h, boolean isSelected, boolean isEnabled, boolean isRollover) {
    }

    private void drawWinTabBorder(Graphics g, int tabPlacement, int x, int y, int w, int h, boolean isSelected, boolean isEnabled, boolean isRollover) {
        g.setColor(Theme.tabLightColor[Theme.style].getColor());
        switch (tabPlacement) {
            case 2: {
                g.drawLine(x + 2, y, x + w - 1, y);
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                g.drawLine(x, y + 2, x, y + h - 3);
                g.setColor(Theme.tabDarkColor[Theme.style].getColor());
                g.drawLine(x + 2, y + h - 2, x + w - 1, y + h - 2);
                g.setColor(Theme.tabBorderColor[Theme.style].getColor());
                g.drawLine(x + 2, y + h - 1, x + w - 1, y + h - 1);
                g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                break;
            }
            case 4: {
                g.drawLine(x + w - 3, y, x, y);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 3);
                g.setColor(Theme.tabDarkColor[Theme.style].getColor());
                g.drawLine(x + w - 3, y + h - 2, x, y + h - 2);
                g.setColor(Theme.tabBorderColor[Theme.style].getColor());
                g.drawLine(x + w - 3, y + h - 1, x, y + h - 1);
                g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                break;
            }
            case 3: {
                g.drawLine(x + 2, y + h - 1, x + w - 3, y + h - 1);
                g.drawLine(x, y + h - 3, x, y);
                g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                g.setColor(Theme.tabDarkColor[Theme.style].getColor());
                g.drawLine(x + w - 2, y + h - 3, x + w - 2, y);
                g.setColor(Theme.tabBorderColor[Theme.style].getColor());
                g.drawLine(x + w - 1, y + h - 3, x + w - 1, y);
                g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                break;
            }
            default: {
                g.drawLine(x + 2, y, x + w - 3, y);
                g.drawLine(x, y + 2, x, y + h - 1);
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                g.setColor(Theme.tabDarkColor[Theme.style].getColor());
                g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 1);
                g.setColor(Theme.tabBorderColor[Theme.style].getColor());
                g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 1);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
            }
        }
    }

    private void drawXpTabBorder(Graphics g, int tabPlacement, int x, int y, int w, int h, boolean isSelected, boolean isEnabled, boolean isRollover) {
        if (!isEnabled) {
            DrawRoutines.drawXpTabBorder(g, Theme.tabBorderColor[Theme.style].getColor(), x, y, w, h, tabPlacement);
        } else if (isSelected) {
            DrawRoutines.drawSelectedXpTabBorder(g, Theme.tabBorderColor[Theme.style].getColor(), x, y, w, h, tabPlacement);
        } else if (isRollover && Theme.tabRollover[Theme.style]) {
            DrawRoutines.drawSelectedXpTabBorder(g, Theme.tabBorderColor[Theme.style].getColor(), x, y, w, h, tabPlacement);
        } else {
            DrawRoutines.drawXpTabBorder(g, Theme.tabBorderColor[Theme.style].getColor(), x, y, w, h, tabPlacement);
        }
    }

    public void update(Graphics g, JComponent c) {
        Insets insets = this.tabPane.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = this.tabPane.getWidth() - insets.right - insets.left;
        int h = this.tabPane.getHeight() - insets.top - insets.bottom;
        if (c.isOpaque()) {
            g.setColor(Theme.backColor[Theme.style].getColor());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        int tabPlacement = this.tabPane.getTabPlacement();
        switch (tabPlacement) {
            case 2: {
                w -= (x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                h -= (y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyContentBorder(g, x, y, w, h);
                break;
            }
            case 1: {
                this.drawWinContentBorder(g, x, y, w, h);
                break;
            }
            case 2: {
                this.drawXpContentBorder(g, x, y, w, h);
            }
        }
        super.paint(g, c);
    }

    private void drawTinyContentBorder(Graphics g, int x, int y, int w, int h) {
    }

    private void drawWinContentBorder(Graphics g, int x, int y, int w, int h) {
        g.setColor(Theme.tabPaneLightColor[Theme.style].getColor());
        g.drawLine(x + 1, y, x + w - 2, y);
        g.drawLine(x, y, x, y + h - 2);
        g.setColor(Theme.tabPaneDarkColor[Theme.style].getColor());
        g.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
        g.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 2);
        g.setColor(Theme.tabPaneBorderColor[Theme.style].getColor());
        g.drawLine(x, y + h - 1, x + w - 2, y + h - 1);
        g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
    }

    private void drawXpContentBorder(Graphics g, int x, int y, int w, int h) {
        g.setColor(Theme.tabPaneBorderColor[Theme.style].getColor());
        g.drawRect(x, y, w - 3, h - 3);
        g.setColor(ColorRoutines.darken(Theme.backColor[Theme.style].getColor(), 15));
        g.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 2);
        g.drawLine(x + 1, y + h - 2, x + w - 3, y + h - 2);
    }

    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = this.rects[tabIndex];
        int nudge = 0;
        switch (tabPlacement) {
            case 2: {
                nudge = isSelected ? -1 : 1;
                break;
            }
            case 4: {
                nudge = isSelected ? 1 : -1;
                break;
            }
            default: {
                nudge = 0;
            }
        }
        return nudge;
    }

    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = this.rects[tabIndex];
        int nudge = 0;
        switch (tabPlacement) {
            case 3: {
                nudge = isSelected ? 1 : -1;
                break;
            }
            case 2: 
            case 4: {
                nudge = tabRect.height % 2;
                break;
            }
            default: {
                nudge = isSelected ? -1 : 1;
            }
        }
        return nudge;
    }

    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        if (Theme.derivedStyle[Theme.style] == 1) {
            super.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
            return;
        }
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                g.setColor(this.tabPane.getForegroundAt(tabIndex));
            } else {
                g.setColor(Theme.tabDisabledTextColor[Theme.style].getColor());
            }
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
        }
    }

    public class TinyMouseHandler
    implements MouseListener,
    MouseMotionListener {
        public void mousePressed(MouseEvent e) {
            if (!TinyTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int tabIndex = TinyTabbedPaneUI.this.getTabAtLocation(e.getX(), e.getY());
            if (tabIndex >= 0 && TinyTabbedPaneUI.this.tabPane.isEnabledAt(tabIndex)) {
                if (tabIndex != TinyTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    TinyTabbedPaneUI.this.tabPane.setSelectedIndex(tabIndex);
                } else if (TinyTabbedPaneUI.this.tabPane.isRequestFocusEnabled()) {
                    TinyTabbedPaneUI.this.tabPane.requestFocus();
                }
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            if (TinyTabbedPaneUI.this.rollover >= TinyTabbedPaneUI.this.tabPane.getTabCount()) {
                TinyTabbedPaneUI.this.rollover = -1;
            }
            if (TinyTabbedPaneUI.this.rollover != -1) {
                TinyTabbedPaneUI.this.tabPane.repaint(TinyTabbedPaneUI.this.getTabBounds(TinyTabbedPaneUI.this.tabPane, TinyTabbedPaneUI.this.rollover));
                TinyTabbedPaneUI.this.rollover = -1;
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            if (TinyTabbedPaneUI.this.tabPane == null) {
                return;
            }
            if (!TinyTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            if (TinyLookAndFeel.is1dot4() && TinyTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                return;
            }
            TinyTabbedPaneUI.this.checkRollOver(TinyTabbedPaneUI.this.getTabAtLocation(e.getX(), e.getY()));
        }
    }

    protected class TinyTabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        protected TinyTabbedPaneLayout() {
            super(TinyTabbedPaneUI.this);
        }

        protected void rotateTabRuns(int tabPlacement, int selectedRun) {
            if (!Theme.fixedTabs[Theme.style]) {
                super.rotateTabRuns(tabPlacement, selectedRun);
            }
        }
    }
}

