/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.MenuItemIconFactory;
import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyDefaultTheme;
import de.muntjak.tinylookandfeel.TinyMenuUI;
import de.muntjak.tinylookandfeel.borders.TinyButtonBorder;
import de.muntjak.tinylookandfeel.borders.TinyFrameBorder;
import de.muntjak.tinylookandfeel.borders.TinyInternalFrameBorder;
import de.muntjak.tinylookandfeel.borders.TinyPopupMenuBorder;
import de.muntjak.tinylookandfeel.borders.TinyProgressBarBorder;
import de.muntjak.tinylookandfeel.borders.TinyScrollPaneBorder;
import de.muntjak.tinylookandfeel.borders.TinyTableHeaderBorder;
import de.muntjak.tinylookandfeel.borders.TinyTableHeaderRolloverBorder;
import de.muntjak.tinylookandfeel.borders.TinyTableScrollPaneBorder;
import de.muntjak.tinylookandfeel.borders.TinyTextFieldBorder;
import de.muntjak.tinylookandfeel.borders.TinyToolBarBorder;
import de.muntjak.tinylookandfeel.borders.TinyToolTipBorder;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class TinyLookAndFeel
extends MetalLookAndFeel {
    public static boolean controlPanelInstantiated = false;
    static final int MINIMUM_FRAME_WIDTH = 104;
    static final int MINIMUM_INTERNAL_FRAME_WIDTH = 32;
    private static int is1dot4 = -1;
    public static final String VERSION_STRING = "1.3.8";
    public static final String DATE_STRING = "2007-6-17";
    protected static TinyDefaultTheme defaultTheme;
    private static boolean isInstalled;
    private static boolean themeHasBeenSet;
    static /* synthetic */ Class class$0;

    static {
        isInstalled = false;
        themeHasBeenSet = false;
    }

    public void initialize() {
        super.initialize();
        if (!isInstalled) {
            isInstalled = true;
            if (is1dot4 == -1) {
                String version = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return System.getProperty("java.version");
                    }
                });
                is1dot4 = version != null ? (version.startsWith("1.0") || version.startsWith("1.1") || version.startsWith("1.2") || version.startsWith("1.3") || version.startsWith("1.4") ? 0 : 1) : 1;
            }
            UIManager.installLookAndFeel(new UIManager.LookAndFeelInfo("TinyLookAndFeel", "de.muntjak.tinylookandfeel.TinyLookAndFeel"));
        }
        if (!"false".equals(System.getProperty("altClosesMenu"))) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(TinyMenuUI.altProcessor);
        }
    }

    public static boolean is1dot4() {
        return is1dot4 == 0;
    }

    public void uninitialize() {
        super.uninitialize();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(TinyMenuUI.altProcessor);
    }

    private void searchDefaultTheme() {
        if (controlPanelInstantiated) {
            return;
        }
        String loadedFrom = null;
        URL defaultURL = null;
        if (Theme.loadTheme(defaultURL, 3)) {
            Theme.style = 3;
            loadedFrom = defaultURL.toExternalForm();
        } else {
            defaultURL = Thread.currentThread().getContextClassLoader().getResource("Default.theme");
            if (Theme.loadTheme(defaultURL, 3)) {
                Theme.style = 3;
                loadedFrom = defaultURL.toExternalForm();
            } else {
                try {
                    defaultURL = new File(System.getProperty("user.home"), "Default.theme").toURI().toURL();
                    if (Theme.loadTheme(defaultURL, 3)) {
                        Theme.style = 3;
                        loadedFrom = defaultURL.toExternalForm();
                    } else {
                        defaultURL = new File(System.getProperty("user.dir"), "Default.theme").toURI().toURL();
                        if (Theme.loadTheme(defaultURL, 3)) {
                            Theme.style = 3;
                            loadedFrom = defaultURL.toExternalForm();
                        }
                    }
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
            }
        }
        String info = "TinyLaF v1.3.8\n";
        if (loadedFrom == null) {
            System.out.println(String.valueOf(info) + "'Default.theme' not found - using YQ default theme.");
        } else {
            System.out.println(String.valueOf(info) + "Theme: " + loadedFrom);
        }
    }

    public String getID() {
        return "TinyLookAndFeel";
    }

    public String getName() {
        return "TinyLookAndFeel";
    }

    public String getDescription() {
        return "TinyLookAndFeel";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public final boolean isSupportedLookAndFeel() {
        return true;
    }

    public boolean getSupportsWindowDecorations() {
        return true;
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        table.putDefaults(new Object[]{"ButtonUI", "de.muntjak.tinylookandfeel.TinyButtonUI", "CheckBoxUI", "de.muntjak.tinylookandfeel.TinyCheckBoxUI", "TextFieldUI", "de.muntjak.tinylookandfeel.TinyTextFieldUI", "TextAreaUI", "de.muntjak.tinylookandfeel.TinyTextAreaUI", "PasswordFieldUI", "de.muntjak.tinylookandfeel.TinyPasswordFieldUI", "EditorPaneUI", "de.muntjak.tinylookandfeel.TinyEditorPaneUI", "TextPaneUI", "de.muntjak.tinylookandfeel.TinyTextPaneUI", "SliderUI", "de.muntjak.tinylookandfeel.TinySliderUI", "SpinnerUI", "de.muntjak.tinylookandfeel.TinySpinnerUI", "ToolBarUI", "de.muntjak.tinylookandfeel.TinyToolBarUI", "ToolBarSeparatorUI", "de.muntjak.tinylookandfeel.TinyToolBarSeparatorUI", "MenuBarUI", "de.muntjak.tinylookandfeel.TinyMenuBarUI", "MenuUI", "de.muntjak.tinylookandfeel.TinyMenuUI", "MenuItemUI", "de.muntjak.tinylookandfeel.TinyMenuItemUI", "CheckBoxMenuItemUI", "de.muntjak.tinylookandfeel.TinyCheckBoxMenuItemUI", "RadioButtonMenuItemUI", "de.muntjak.tinylookandfeel.TinyRadioButtonMenuItemUI", "ScrollBarUI", "de.muntjak.tinylookandfeel.TinyScrollBarUI", "TabbedPaneUI", "de.muntjak.tinylookandfeel.TinyTabbedPaneUI", "ToggleButtonUI", "de.muntjak.tinylookandfeel.TinyButtonUI", "ScrollPaneUI", "de.muntjak.tinylookandfeel.TinyScrollPaneUI", "ProgressBarUI", "de.muntjak.tinylookandfeel.TinyProgressBarUI", "InternalFrameUI", "de.muntjak.tinylookandfeel.TinyInternalFrameUI", "RadioButtonUI", "de.muntjak.tinylookandfeel.TinyRadioButtonUI", "ComboBoxUI", "de.muntjak.tinylookandfeel.TinyComboBoxUI", "PopupMenuSeparatorUI", "de.muntjak.tinylookandfeel.TinyPopupMenuSeparatorUI", "SeparatorUI", "de.muntjak.tinylookandfeel.TinySeparatorUI", "SplitPaneUI", "de.muntjak.tinylookandfeel.TinySplitPaneUI", "FileChooserUI", "de.muntjak.tinylookandfeel.TinyFileChooserUI", "ListUI", "de.muntjak.tinylookandfeel.TinyListUI", "TreeUI", "de.muntjak.tinylookandfeel.TinyTreeUI", "LabelUI", "de.muntjak.tinylookandfeel.TinyLabelUI", "TableUI", "de.muntjak.tinylookandfeel.TinyTableUI", "TableHeaderUI", "de.muntjak.tinylookandfeel.TinyTableHeaderUI", "ToolTipUI", "de.muntjak.tinylookandfeel.TinyToolTipUI", "RootPaneUI", "de.muntjak.tinylookandfeel.TinyRootPaneUI", "DesktopPaneUI", "de.muntjak.tinylookandfeel.TinyDesktopPaneUI"});
    }

    protected void createDefaultTheme() {
        defaultTheme = new TinyDefaultTheme();
        TinyLookAndFeel.setCurrentTheme(defaultTheme);
    }

    public static void setCurrentTheme(MetalTheme theme) {
        MetalLookAndFeel.setCurrentTheme(theme);
        themeHasBeenSet = true;
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        AbstractBorder border = new EmptyBorder(0, 0, 0, 0);
        table.put("Button.border", new BorderUIResource.CompoundBorderUIResource(new TinyButtonBorder(), new BasicBorders.MarginBorder()));
        table.put("FormattedTextField.border", new TinyTextFieldBorder());
        table.put("TextField.border", new TinyTextFieldBorder());
        table.put("PasswordField.border", new TinyTextFieldBorder());
        table.put("ComboBox.border", border);
        table.put("Table.scrollPaneBorder", new TinyTableScrollPaneBorder());
        table.put("TableHeader.cellBorder", new TinyTableHeaderBorder());
        table.put("TableHeader.cellRolloverBorder", new TinyTableHeaderRolloverBorder());
        table.put("Spinner.border", new TinyTextFieldBorder(new Insets(2, 2, 2, 2)));
        table.put("ProgressBar.border", new TinyProgressBarBorder());
        table.put("ToolBar.border", new TinyToolBarBorder());
        table.put("ToolTip.border", new BorderUIResource(new TinyToolTipBorder(true)));
        table.put("ToolTip.borderInactive", new BorderUIResource(new TinyToolTipBorder(false)));
        border = new TinyInternalFrameBorder();
        table.put("InternalFrame.border", border);
        table.put("InternalFrame.paletteBorder", border);
        table.put("InternalFrame.optionDialogBorder", border);
        border = new EmptyBorder(2, 4, 2, 4);
        table.put("Menu.border", border);
        table.put("MenuItem.border", border);
        table.put("CheckBoxMenuItem.border", border);
        table.put("RadioButtonMenuItem.border", border);
        table.put("PopupMenu.border", new TinyPopupMenuBorder());
        table.put("ScrollPane.border", new TinyScrollPaneBorder());
        table.put("Slider.trackWidth", new Integer(4));
        table.put("CheckBox.border", new BasicBorders.MarginBorder());
        table.put("RadioButton.border", new BasicBorders.MarginBorder());
        table.put("RadioButton.margin", new InsetsUIResource(2, 2, 2, 2));
        table.put("CheckBox.margin", new InsetsUIResource(2, 2, 2, 2));
        table.put("SplitPane.dividerSize", new Integer(7));
        table.put("InternalFrame.normalTitleFont", new Font("dialog", 1, 13));
        if (System.getProperty("os.name").toLowerCase().startsWith("linux")) {
            table.put("FileChooser.readOnly", Boolean.TRUE);
        }
        table.put("TabbedPane.tabInsets", new Insets(1, 6, 4, 6));
        table.put("TabbedPane.selectedTabPadInsets", new Insets(2, 2, 1, 2));
        table.put("TabbedPane.unselected", new ColorUIResource(0, 0, 0));
        table.put("TabbedPane.tabAreaInsets", new Insets(6, 2, 0, 0));
        table.put("TabbedPane.contentBorderInsets", new Insets(1, 1, 3, 3));
        table.put("PopupMenu.foreground", new Color(255, 0, 0));
        table.put("RootPane.colorChooserDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.errorDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.fileChooserDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.frameBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.informationDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.plainDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.questionDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.warningDialogBorder", TinyFrameBorder.getInstance());
        table.put("CheckBoxMenuItem.checkIcon", MenuItemIconFactory.getCheckBoxMenuItemIcon());
        table.put("RadioButtonMenuItem.checkIcon", MenuItemIconFactory.getRadioButtonMenuItemIcon());
        table.put("Menu.arrowIcon", MenuItemIconFactory.getMenuArrowIcon());
        table.put("InternalFrame.frameTitleHeight", new Integer(25));
        table.put("InternalFrame.paletteTitleHeight", new Integer(16));
        table.put("InternalFrame.icon", TinyLookAndFeel.loadIcon("InternalFrameIcon.png", this));
        table.put("Tree.expandedIcon", TinyLookAndFeel.loadIcon("TreeMinusIcon.png", this));
        table.put("Tree.collapsedIcon", TinyLookAndFeel.loadIcon("TreePlusIcon.png", this));
        table.put("Tree.openIcon", TinyLookAndFeel.loadIcon("TreeFolderOpenedIcon.png", this));
        table.put("Tree.closedIcon", TinyLookAndFeel.loadIcon("TreeFolderClosedIcon.png", this));
        table.put("Tree.leafIcon", TinyLookAndFeel.loadIcon("TreeLeafIcon.png", this));
        table.put("FileView.directoryIcon", TinyLookAndFeel.loadIcon("DirectoryIcon.png", this));
        table.put("FileView.computerIcon", TinyLookAndFeel.loadIcon("ComputerIcon.png", this));
        table.put("FileView.fileIcon", TinyLookAndFeel.loadIcon("FileIcon.png", this));
        table.put("FileView.floppyDriveIcon", TinyLookAndFeel.loadIcon("FloppyIcon.png", this));
        table.put("FileView.hardDriveIcon", TinyLookAndFeel.loadIcon("HarddiskIcon.png", this));
        table.put("FileChooser.detailsViewIcon", TinyLookAndFeel.loadIcon("FileDetailsIcon.png", this));
        table.put("FileChooser.homeFolderIcon", TinyLookAndFeel.loadIcon("HomeFolderIcon.png", this));
        table.put("FileChooser.listViewIcon", TinyLookAndFeel.loadIcon("FileListIcon.png", this));
        table.put("FileChooser.newFolderIcon", TinyLookAndFeel.loadIcon("NewFolderIcon.png", this));
        table.put("FileChooser.upFolderIcon", TinyLookAndFeel.loadIcon("ParentDirectoryIcon.png", this));
        table.put("OptionPane.errorIcon", TinyLookAndFeel.loadIcon("ErrorIcon.png", this));
        table.put("OptionPane.informationIcon", TinyLookAndFeel.loadIcon("InformationIcon.png", this));
        table.put("OptionPane.warningIcon", TinyLookAndFeel.loadIcon("WarningIcon.png", this));
        table.put("OptionPane.questionIcon", TinyLookAndFeel.loadIcon("QuestionIcon.png", this));
    }

    public static Icon getUncolorizedSystemIcon(int index) {
        switch (index) {
            case 0: {
                return TinyLookAndFeel.loadIcon("InternalFrameIcon.png", null);
            }
            case 1: {
                return TinyLookAndFeel.loadIcon("TreeFolderClosedIcon.png", null);
            }
            case 2: {
                return TinyLookAndFeel.loadIcon("TreeFolderOpenedIcon.png", null);
            }
            case 3: {
                return TinyLookAndFeel.loadIcon("TreeLeafIcon.png", null);
            }
            case 4: {
                return TinyLookAndFeel.loadIcon("TreeMinusIcon.png", null);
            }
            case 5: {
                return TinyLookAndFeel.loadIcon("TreePlusIcon.png", null);
            }
            case 6: {
                return TinyLookAndFeel.loadIcon("ComputerIcon.png", null);
            }
            case 7: {
                return TinyLookAndFeel.loadIcon("FloppyIcon.png", null);
            }
            case 8: {
                return TinyLookAndFeel.loadIcon("HarddiskIcon.png", null);
            }
            case 9: {
                return TinyLookAndFeel.loadIcon("DirectoryIcon.png", null);
            }
            case 10: {
                return TinyLookAndFeel.loadIcon("FileIcon.png", null);
            }
            case 11: {
                return TinyLookAndFeel.loadIcon("ParentDirectoryIcon.png", null);
            }
            case 12: {
                return TinyLookAndFeel.loadIcon("HomeFolderIcon.png", null);
            }
            case 13: {
                return TinyLookAndFeel.loadIcon("NewFolderIcon.png", null);
            }
            case 14: {
                return TinyLookAndFeel.loadIcon("FileListIcon.png", null);
            }
            case 15: {
                return TinyLookAndFeel.loadIcon("FileDetailsIcon.png", null);
            }
            case 16: {
                return TinyLookAndFeel.loadIcon("InformationIcon.png", null);
            }
            case 17: {
                return TinyLookAndFeel.loadIcon("QuestionIcon.png", null);
            }
            case 18: {
                return TinyLookAndFeel.loadIcon("WarningIcon.png", null);
            }
        }
        return TinyLookAndFeel.loadIcon("ErrorIcon.png", null);
    }

    public static String getSystemIconName(int index) {
        switch (index) {
            case 0: {
                return "InternalFrame.icon";
            }
            case 1: {
                return "Tree.closedIcon";
            }
            case 2: {
                return "Tree.openIcon";
            }
            case 3: {
                return "Tree.leafIcon";
            }
            case 4: {
                return "Tree.expandedIcon";
            }
            case 5: {
                return "Tree.collapsedIcon";
            }
            case 6: {
                return "FileView.computerIcon";
            }
            case 7: {
                return "FileView.floppyDriveIcon";
            }
            case 8: {
                return "FileView.hardDriveIcon";
            }
            case 9: {
                return "FileView.directoryIcon";
            }
            case 10: {
                return "FileView.fileIcon";
            }
            case 11: {
                return "FileChooser.upFolderIcon";
            }
            case 12: {
                return "FileChooser.homeFolderIcon";
            }
            case 13: {
                return "FileChooser.newFolderIcon";
            }
            case 14: {
                return "FileChooser.listViewIcon";
            }
            case 15: {
                return "FileChooser.detailsViewIcon";
            }
            case 16: {
                return "OptionPane.informationIcon";
            }
            case 17: {
                return "OptionPane.questionIcon";
            }
            case 18: {
                return "OptionPane.warningIcon";
            }
        }
        return "OptionPane.errorIcon";
    }

    public static ImageIcon loadIcon(String fileName, Object invoker) {
        URL url = Thread.currentThread().getContextClassLoader().getResource("de/muntjak/tinylookandfeel/icons/" + fileName);
        if (url == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.muntjak.tinylookandfeel.TinyLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((url = clazz.getResource("/de/muntjak/tinylookandfeel/icons/" + fileName)) == null) {
                System.err.println("TinyLaF: Icon directory could not be resolved.");
                return null;
            }
        }
        return new ImageIcon(url);
    }
}

