/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.basic.BasicFileChooserUI;
import sun.awt.shell.ShellFolder;

public class TinyDirectoryModel
extends BasicDirectoryModel {
    private JFileChooser filechooser = null;
    private Vector fileCache = new Vector(50);
    private LoadFilesThread loadThread = null;
    private Vector files = null;
    private Vector directories = null;
    private int fetchID = 0;
    private PropertyChangeSupport changeSupport;
    private boolean busy = false;

    public TinyDirectoryModel(JFileChooser fc) {
        super(fc);
        this.filechooser = fc;
        this.validateFileCache();
    }

    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop == "directoryChanged" || prop == "fileViewChanged" || prop == "fileFilterChanged" || prop == "FileHidingChanged" || prop == "fileSelectionChanged") {
            this.validateFileCache();
        } else if ("UI".equals(prop)) {
            BasicFileChooserUI ui;
            BasicDirectoryModel model;
            Object old = e.getOldValue();
            if (old instanceof BasicFileChooserUI && (model = (ui = (BasicFileChooserUI)old).getModel()) != null) {
                model.invalidateFileCache();
            }
        } else if ("JFileChooserDialogIsClosingProperty".equals(prop)) {
            this.invalidateFileCache();
        }
    }

    public void invalidateFileCache() {
        if (this.loadThread != null) {
            this.loadThread.interrupt();
            this.loadThread.cancelRunnables();
            this.loadThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDirectories() {
        Vector vector = this.fileCache;
        synchronized (vector) {
            if (this.directories != null) {
                return this.directories;
            }
            Vector fls = this.getFiles();
            return this.directories;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getFiles() {
        Vector vector = this.fileCache;
        synchronized (vector) {
            if (this.files != null) {
                return this.files;
            }
            this.files = new Vector();
            this.directories = new Vector();
            this.directories.addElement(this.filechooser.getFileSystemView().createFileObject(this.filechooser.getCurrentDirectory(), ".."));
            int i = 0;
            while (i < this.getSize()) {
                File f = (File)this.fileCache.get(i);
                if (this.filechooser.isTraversable(f)) {
                    this.directories.add(f);
                } else {
                    this.files.add(f);
                }
                ++i;
            }
            return this.files;
        }
    }

    public void validateFileCache() {
        if (this.filechooser == null) {
            return;
        }
        File currentDirectory = this.filechooser.getCurrentDirectory();
        if (currentDirectory == null) {
            return;
        }
        if (this.loadThread != null) {
            this.loadThread.interrupt();
            this.loadThread.cancelRunnables();
        }
        this.setBusy(true, ++this.fetchID);
        this.loadThread = new LoadFilesThread(currentDirectory, this.fetchID);
        this.loadThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameFile(File oldFile, File newFile) {
        Vector vector = this.fileCache;
        synchronized (vector) {
            block4: {
                if (!oldFile.renameTo(newFile)) break block4;
                this.validateFileCache();
                return true;
            }
            return false;
        }
    }

    public void fireContentsChanged() {
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public int getSize() {
        return this.fileCache.size();
    }

    public boolean contains(Object o) {
        return this.fileCache.contains(o);
    }

    public int indexOf(Object o) {
        return this.fileCache.indexOf(o);
    }

    public Object getElementAt(int index) {
        return this.fileCache.get(index);
    }

    public Vector getFileCache() {
        return this.fileCache;
    }

    public void intervalAdded(ListDataEvent e) {
    }

    public void intervalRemoved(ListDataEvent e) {
    }

    protected void sort(Vector v) {
        ShellFolder.sortFiles((List)v);
    }

    protected boolean lt(File a, File b) {
        int diff = a.getName().toLowerCase().compareTo(b.getName().toLowerCase());
        if (diff != 0) {
            return diff < 0;
        }
        return a.getName().compareTo(b.getName()) < 0;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    private synchronized void setBusy(final boolean busy, int fid) {
        if (fid == this.fetchID) {
            boolean oldValue = this.busy;
            this.busy = busy;
            if (this.changeSupport != null && busy != oldValue) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TinyDirectoryModel.this.firePropertyChange("busy", !busy, busy);
                    }
                });
            }
        }
    }

    class DoChangeContents
    implements Runnable {
        private List addFiles;
        private List remFiles;
        private boolean doFire = true;
        private int fid;
        private int addStart = 0;
        private int remStart = 0;
        private int change;

        public DoChangeContents(List addFiles, int addStart, List remFiles, int remStart, int fid) {
            this.addFiles = addFiles;
            this.addStart = addStart;
            this.remFiles = remFiles;
            this.remStart = remStart;
            this.fid = fid;
        }

        synchronized void cancel() {
            this.doFire = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            if (TinyDirectoryModel.this.fetchID == this.fid && this.doFire) {
                int remSize = this.remFiles == null ? 0 : this.remFiles.size();
                int addSize = this.addFiles == null ? 0 : this.addFiles.size();
                Vector vector = TinyDirectoryModel.this.fileCache;
                synchronized (vector) {
                    if (remSize > 0) {
                        TinyDirectoryModel.this.fileCache.removeAll(this.remFiles);
                    }
                    if (addSize > 0) {
                        TinyDirectoryModel.this.fileCache.addAll(this.addStart, this.addFiles);
                    }
                    TinyDirectoryModel.this.files = null;
                    TinyDirectoryModel.this.directories = null;
                }
                if (remSize > 0 && addSize == 0) {
                    TinyDirectoryModel.this.fireIntervalRemoved(TinyDirectoryModel.this, this.remStart, this.remStart + remSize - 1);
                } else if (addSize > 0 && remSize == 0 && TinyDirectoryModel.this.fileCache.size() > addSize) {
                    TinyDirectoryModel.this.fireIntervalAdded(TinyDirectoryModel.this, this.addStart, this.addStart + addSize - 1);
                } else {
                    TinyDirectoryModel.this.fireContentsChanged();
                }
            }
        }
    }

    class LoadFilesThread
    extends Thread {
        File currentDirectory = null;
        int fid;
        Vector runnables = new Vector(10);

        public LoadFilesThread(File currentDirectory, int fid) {
            super("Basic L&F File Loading Thread");
            this.currentDirectory = currentDirectory;
            this.fid = fid;
        }

        private void invokeLater(Runnable runnable) {
            this.runnables.addElement(runnable);
            SwingUtilities.invokeLater(runnable);
        }

        public void run() {
            this.run0();
            TinyDirectoryModel.this.setBusy(false, this.fid);
        }

        public void run0() {
            FileSystemView fileSystem = TinyDirectoryModel.this.filechooser.getFileSystemView();
            Vector<File> acceptsList = new Vector<File>();
            try {
                File[] list = fileSystem.getFiles(this.currentDirectory, TinyDirectoryModel.this.filechooser.isFileHidingEnabled());
                if (this.isInterrupted()) {
                    return;
                }
                int i = 0;
                while (i < list.length) {
                    if (TinyDirectoryModel.this.filechooser.accept(list[i])) {
                        acceptsList.addElement(list[i]);
                    }
                    ++i;
                }
            }
            catch (NullPointerException list) {
                // empty catch block
            }
            if (this.isInterrupted()) {
                return;
            }
            try {
                TinyDirectoryModel.this.sort(acceptsList);
            }
            catch (NullPointerException list) {
                // empty catch block
            }
            Vector<File> newDirectories = new Vector<File>(50);
            Vector<File> newFiles = new Vector<File>();
            int i = 0;
            while (i < acceptsList.size()) {
                File f = (File)acceptsList.elementAt(i);
                boolean isTraversable = false;
                try {
                    isTraversable = TinyDirectoryModel.this.filechooser.isTraversable(f);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (isTraversable) {
                    newDirectories.addElement(f);
                } else if (!isTraversable && TinyDirectoryModel.this.filechooser.isFileSelectionEnabled()) {
                    newFiles.addElement(f);
                }
                if (this.isInterrupted()) {
                    return;
                }
                ++i;
            }
            Vector<File> newFileCache = new Vector<File>(newDirectories);
            newFileCache.addAll(newFiles);
            int newSize = newFileCache.size();
            int oldSize = TinyDirectoryModel.this.fileCache.size();
            if (newSize > oldSize) {
                int start = oldSize;
                int end = newSize;
                int i2 = 0;
                block8: while (i2 < oldSize) {
                    if (!newFileCache.get(i2).equals(TinyDirectoryModel.this.fileCache.get(i2))) {
                        start = i2;
                        int j = i2;
                        while (j < newSize) {
                            if (newFileCache.get(j).equals(TinyDirectoryModel.this.fileCache.get(i2))) {
                                end = j;
                                break block8;
                            }
                            ++j;
                        }
                        break;
                    }
                    ++i2;
                }
                if (start >= 0 && end > start && newFileCache.subList(end, newSize).equals(TinyDirectoryModel.this.fileCache.subList(start, oldSize))) {
                    if (this.isInterrupted()) {
                        return;
                    }
                    this.invokeLater(new DoChangeContents(newFileCache.subList(start, end), start, null, 0, this.fid));
                    newFileCache = null;
                }
            } else if (newSize < oldSize) {
                int start = -1;
                int end = -1;
                int i3 = 0;
                while (i3 < newSize) {
                    if (!newFileCache.get(i3).equals(TinyDirectoryModel.this.fileCache.get(i3))) {
                        start = i3;
                        end = i3 + oldSize - newSize;
                        break;
                    }
                    ++i3;
                }
                if (start >= 0 && end > start && TinyDirectoryModel.this.fileCache.subList(end, oldSize).equals(newFileCache.subList(start, newSize))) {
                    if (this.isInterrupted()) {
                        return;
                    }
                    this.invokeLater(new DoChangeContents(null, 0, new Vector(TinyDirectoryModel.this.fileCache.subList(start, end)), start, this.fid));
                    newFileCache = null;
                }
            }
            if (newFileCache != null && !TinyDirectoryModel.this.fileCache.equals(newFileCache)) {
                if (this.isInterrupted()) {
                    this.cancelRunnables(this.runnables);
                }
                this.invokeLater(new DoChangeContents(newFileCache, 0, TinyDirectoryModel.this.fileCache, 0, this.fid));
            }
        }

        public void cancelRunnables(Vector runnables) {
            int i = 0;
            while (i < runnables.size()) {
                ((DoChangeContents)runnables.elementAt(i)).cancel();
                ++i;
            }
        }

        public void cancelRunnables() {
            this.cancelRunnables(this.runnables);
        }
    }
}

