/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.quartz.simpl;

import com.fr.third.org.quartz.SchedulerConfigException;
import com.fr.third.org.quartz.spi.ThreadPool;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleThreadPool
implements ThreadPool {
    private int count = -1;
    private int prio = 5;
    private boolean isShutdown = false;
    private boolean handoffPending = false;
    private boolean inheritLoader = false;
    private boolean inheritGroup = true;
    private boolean makeThreadsDaemons = false;
    private ThreadGroup threadGroup;
    private final Object nextRunnableLock = new Object();
    private List workers;
    private LinkedList availWorkers = new LinkedList();
    private LinkedList busyWorkers = new LinkedList();
    private String threadNamePrefix = "SimpleThreadPoolWorker";
    private final Log log = LogFactory.getLog(this.getClass());

    public SimpleThreadPool() {
    }

    public SimpleThreadPool(int threadCount, int threadPriority) {
        this.setThreadCount(threadCount);
        this.setThreadPriority(threadPriority);
    }

    public Log getLog() {
        return this.log;
    }

    public int getPoolSize() {
        return this.getThreadCount();
    }

    public void setThreadCount(int count) {
        this.count = count;
    }

    public int getThreadCount() {
        return this.count;
    }

    public void setThreadPriority(int prio) {
        this.prio = prio;
    }

    public int getThreadPriority() {
        return this.prio;
    }

    public void setThreadNamePrefix(String prfx) {
        this.threadNamePrefix = prfx;
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public boolean isThreadsInheritContextClassLoaderOfInitializingThread() {
        return this.inheritLoader;
    }

    public void setThreadsInheritContextClassLoaderOfInitializingThread(boolean inheritLoader) {
        this.inheritLoader = inheritLoader;
    }

    public boolean isThreadsInheritGroupOfInitializingThread() {
        return this.inheritGroup;
    }

    public void setThreadsInheritGroupOfInitializingThread(boolean inheritGroup) {
        this.inheritGroup = inheritGroup;
    }

    public boolean isMakeThreadsDaemons() {
        return this.makeThreadsDaemons;
    }

    public void setMakeThreadsDaemons(boolean makeThreadsDaemons) {
        this.makeThreadsDaemons = makeThreadsDaemons;
    }

    public void initialize() throws SchedulerConfigException {
        if (this.count <= 0) {
            throw new SchedulerConfigException("Thread count must be > 0");
        }
        if (this.prio <= 0 || this.prio > 9) {
            throw new SchedulerConfigException("Thread priority must be > 0 and <= 9");
        }
        if (this.isThreadsInheritGroupOfInitializingThread()) {
            this.threadGroup = Thread.currentThread().getThreadGroup();
        } else {
            ThreadGroup parent = this.threadGroup = Thread.currentThread().getThreadGroup();
            while (!parent.getName().equals("main")) {
                this.threadGroup = parent;
                parent = this.threadGroup.getParent();
            }
            this.threadGroup = new ThreadGroup(parent, "SimpleThreadPool");
            if (this.isMakeThreadsDaemons()) {
                this.threadGroup.setDaemon(true);
            }
        }
        if (this.isThreadsInheritContextClassLoaderOfInitializingThread()) {
            this.getLog().info("Job execution threads will use class loader of thread: " + Thread.currentThread().getName());
        }
        Iterator workerThreads = this.createWorkerThreads(this.count).iterator();
        while (workerThreads.hasNext()) {
            WorkerThread wt = (WorkerThread)workerThreads.next();
            wt.start();
            this.availWorkers.add(wt);
        }
    }

    protected List createWorkerThreads(int count) {
        this.workers = new LinkedList();
        int i = 1;
        while (i <= count) {
            WorkerThread wt = new WorkerThread(this, this.threadGroup, String.valueOf(this.getThreadNamePrefix()) + "-" + i, this.getThreadPriority(), this.isMakeThreadsDaemons());
            if (this.isThreadsInheritContextClassLoaderOfInitializingThread()) {
                wt.setContextClassLoader(Thread.currentThread().getContextClassLoader());
            }
            this.workers.add(wt);
            ++i;
        }
        return this.workers;
    }

    public void shutdown() {
        this.shutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean waitForJobsToComplete) {
        Object object = this.nextRunnableLock;
        synchronized (object) {
            WorkerThread wt2;
            this.isShutdown = true;
            Iterator workerThreads = this.workers.iterator();
            while (workerThreads.hasNext()) {
                wt2 = (WorkerThread)workerThreads.next();
                wt2.shutdown();
                this.availWorkers.remove(wt2);
            }
            this.nextRunnableLock.notifyAll();
            if (waitForJobsToComplete) {
                while (this.handoffPending) {
                    try {
                        this.nextRunnableLock.wait(100L);
                    }
                    catch (Throwable wt2) {
                        // empty catch block
                    }
                }
                while (this.busyWorkers.size() > 0) {
                    wt2 = (WorkerThread)this.busyWorkers.getFirst();
                    try {
                        this.getLog().debug("Waiting for thread " + wt2.getName() + " to shut down");
                        this.nextRunnableLock.wait(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.getLog().debug("shutdown complete");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runInThread(Runnable runnable) {
        if (runnable == null) {
            return false;
        }
        Object object = this.nextRunnableLock;
        synchronized (object) {
            this.handoffPending = true;
            while (this.availWorkers.size() < 1 && !this.isShutdown) {
                try {
                    this.nextRunnableLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.isShutdown) {
                WorkerThread wt = (WorkerThread)this.availWorkers.removeFirst();
                this.busyWorkers.add(wt);
                wt.run(runnable);
            } else {
                WorkerThread wt = new WorkerThread(this, this.threadGroup, "WorkerThread-LastJob", this.prio, this.isMakeThreadsDaemons(), runnable);
                this.busyWorkers.add(wt);
                this.workers.add(wt);
                wt.start();
            }
            this.nextRunnableLock.notifyAll();
            this.handoffPending = false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int blockForAvailableThreads() {
        Object object = this.nextRunnableLock;
        synchronized (object) {
            while (true) {
                if (this.availWorkers.size() >= 1 && !this.handoffPending || this.isShutdown) {
                    return this.availWorkers.size();
                }
                try {
                    this.nextRunnableLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeAvailable(WorkerThread wt) {
        Object object = this.nextRunnableLock;
        synchronized (object) {
            if (!this.isShutdown) {
                this.availWorkers.add(wt);
            }
            this.busyWorkers.remove(wt);
            this.nextRunnableLock.notifyAll();
        }
    }

    class WorkerThread
    extends Thread {
        private boolean run = true;
        private SimpleThreadPool tp;
        private Runnable runnable = null;

        WorkerThread(SimpleThreadPool tp, ThreadGroup threadGroup, String name, int prio, boolean isDaemon) {
            this(tp, threadGroup, name, prio, isDaemon, null);
        }

        WorkerThread(SimpleThreadPool tp, ThreadGroup threadGroup, String name, int prio, boolean isDaemon, Runnable runnable) {
            super(threadGroup, name);
            this.tp = tp;
            this.runnable = runnable;
            this.setPriority(prio);
            this.setDaemon(isDaemon);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown() {
            WorkerThread workerThread = this;
            synchronized (workerThread) {
                this.run = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Runnable newRunnable) {
            WorkerThread workerThread = this;
            synchronized (workerThread) {
                if (this.runnable != null) {
                    throw new IllegalStateException("Already running a Runnable!");
                }
                this.runnable = newRunnable;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            ran = false;
            runOnce = false;
            shouldRun = false;
            var4_4 = this;
            synchronized (var4_4) {
                runOnce = this.runnable != null;
                shouldRun = this.run;
                // MONITOREXIT @DISABLED, blocks:[0, 17] lbl9 : MonitorExitStatement: MONITOREXIT : var4_4
                if (true) ** GOTO lbl134
            }
            do {
                block62: {
                    try {
                        var4_4 = this;
                        synchronized (var4_4) {
                            while (this.runnable == null && this.run) {
                                this.wait(500L);
                            }
                        }
                        if (this.runnable != null) {
                            ran = true;
                            this.runnable.run();
                        }
                    }
                    catch (InterruptedException unblock) {
                        try {
                            SimpleThreadPool.this.getLog().error("worker threat got 'interrupt'ed.", unblock);
                        }
                        catch (Exception var5_9) {
                            // empty catch block
                        }
                        var7_11 = this;
                        synchronized (var7_11) {
                            this.runnable = null;
                        }
                        if (this.getPriority() != this.tp.getThreadPriority()) {
                            this.setPriority(this.tp.getThreadPriority());
                        }
                        if (runOnce) {
                            var7_11 = this;
                            synchronized (var7_11) {
                                this.run = false;
                                break block62;
                            }
                        }
                        if (ran) {
                            ran = false;
                            SimpleThreadPool.this.makeAvailable(this);
                        }
                        break block62;
                    }
                    catch (Exception exceptionInRunnable) {
                        try {
                            try {
                                SimpleThreadPool.this.getLog().error("Error while executing the Runnable: ", exceptionInRunnable);
                            }
                            catch (Exception var5_10) {
                                // empty catch block
                            }
                            var7_11 = this;
                        }
                        catch (Throwable var6_12) {
                            var7_11 = this;
                            synchronized (var7_11) {
                                this.runnable = null;
                            }
                            if (this.getPriority() != this.tp.getThreadPriority()) {
                                this.setPriority(this.tp.getThreadPriority());
                            }
                            if (runOnce) {
                                var7_11 = this;
                                synchronized (var7_11) {
                                    this.run = false;
                                }
                            } else if (ran) {
                                ran = false;
                                SimpleThreadPool.this.makeAvailable(this);
                            }
                            throw var6_12;
                        }
                        synchronized (var7_11) {
                            this.runnable = null;
                        }
                        if (this.getPriority() != this.tp.getThreadPriority()) {
                            this.setPriority(this.tp.getThreadPriority());
                        }
                        if (runOnce) {
                            var7_11 = this;
                            synchronized (var7_11) {
                                this.run = false;
                                break block62;
                            }
                        }
                        if (ran) {
                            ran = false;
                            SimpleThreadPool.this.makeAvailable(this);
                        }
                        break block62;
                    }
                    var7_11 = this;
                    synchronized (var7_11) {
                        this.runnable = null;
                    }
                    if (this.getPriority() != this.tp.getThreadPriority()) {
                        this.setPriority(this.tp.getThreadPriority());
                    }
                    if (runOnce) {
                        var7_11 = this;
                        synchronized (var7_11) {
                            this.run = false;
                        }
                    } else if (ran) {
                        ran = false;
                        SimpleThreadPool.this.makeAvailable(this);
                    }
                }
                var4_4 = this;
                synchronized (var4_4) {
                    shouldRun = this.run;
                }
lbl134:
                // 2 sources

            } while (shouldRun);
            try {
                SimpleThreadPool.this.getLog().debug("WorkerThread is shutting down");
            }
            catch (Exception var4_7) {
                // empty catch block
            }
        }
    }
}

