/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.quartz.plugins.management;

import com.fr.third.org.quartz.Scheduler;
import com.fr.third.org.quartz.SchedulerException;
import com.fr.third.org.quartz.spi.SchedulerPlugin;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ShutdownHookPlugin
implements SchedulerPlugin {
    private String name;
    private Scheduler scheduler;
    private boolean cleanShutdown = true;
    private final Log log = LogFactory.getLog(this.getClass());

    public boolean isCleanShutdown() {
        return this.cleanShutdown;
    }

    public void setCleanShutdown(boolean b) {
        this.cleanShutdown = b;
    }

    protected Log getLog() {
        return this.log;
    }

    public void initialize(String name, final Scheduler scheduler) throws SchedulerException {
        this.name = name;
        this.scheduler = scheduler;
        this.getLog().info("Registering Quartz shutdown hook.");
        Thread t = new Thread("Quartz Shutdown-Hook " + scheduler.getSchedulerName()){

            public void run() {
                ShutdownHookPlugin.this.getLog().info("Shutting down Quartz...");
                try {
                    scheduler.shutdown(ShutdownHookPlugin.this.isCleanShutdown());
                }
                catch (SchedulerException e) {
                    ShutdownHookPlugin.this.getLog().info("Error shutting down Quartz: " + e.getMessage(), e);
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(t);
    }

    public void start() {
    }

    public void shutdown() {
    }
}

