/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.quartz.plugins;

import com.fr.third.org.quartz.Scheduler;
import com.fr.third.org.quartz.SchedulerException;
import com.fr.third.org.quartz.ee.jta.UserTransactionHelper;
import com.fr.third.org.quartz.spi.SchedulerPlugin;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SchedulerPluginWithUserTransactionSupport
implements SchedulerPlugin {
    private String name;
    private Scheduler scheduler;
    private final Log log = LogFactory.getLog(this.getClass());
    private boolean wrapInUserTransaction = false;

    protected void start(UserTransaction userTransaction) {
    }

    protected void shutdown(UserTransaction userTransaction) {
    }

    protected Log getLog() {
        return this.log;
    }

    protected String getName() {
        return this.name;
    }

    protected Scheduler getScheduler() {
        return this.scheduler;
    }

    public void initialize(String name, Scheduler scheduler) throws SchedulerException {
        this.name = name;
        this.scheduler = scheduler;
    }

    public boolean getWrapInUserTransaction() {
        return this.wrapInUserTransaction;
    }

    public void setWrapInUserTransaction(boolean wrapInUserTransaction) {
        this.wrapInUserTransaction = wrapInUserTransaction;
    }

    public void start() {
        UserTransaction userTransaction = this.startUserTransaction();
        try {
            this.start(userTransaction);
        }
        finally {
            this.resolveUserTransaction(userTransaction);
        }
    }

    public void shutdown() {
        UserTransaction userTransaction = this.startUserTransaction();
        try {
            this.shutdown(userTransaction);
        }
        finally {
            this.resolveUserTransaction(userTransaction);
        }
    }

    private UserTransaction startUserTransaction() {
        if (!this.wrapInUserTransaction) {
            return null;
        }
        UserTransaction userTransaction = null;
        try {
            userTransaction = UserTransactionHelper.lookupUserTransaction();
            userTransaction.begin();
        }
        catch (Throwable t) {
            UserTransactionHelper.returnUserTransaction(userTransaction);
            userTransaction = null;
            this.getLog().error("Failed to start UserTransaction for plugin: " + this.getName(), t);
        }
        return userTransaction;
    }

    private void resolveUserTransaction(UserTransaction userTransaction) {
        block7: {
            if (userTransaction != null) {
                try {
                    try {
                        if (userTransaction.getStatus() == 1) {
                            userTransaction.rollback();
                            break block7;
                        }
                        userTransaction.commit();
                    }
                    catch (Throwable t) {
                        this.getLog().error("Failed to resolve UserTransaction for plugin: " + this.getName(), t);
                        UserTransactionHelper.returnUserTransaction(userTransaction);
                    }
                }
                finally {
                    UserTransactionHelper.returnUserTransaction(userTransaction);
                }
            }
        }
    }
}

