/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.quartz.jobs.ee.jmx;

import com.fr.third.org.quartz.Job;
import com.fr.third.org.quartz.JobDataMap;
import com.fr.third.org.quartz.JobExecutionContext;
import com.fr.third.org.quartz.JobExecutionException;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMXInvokerJob
implements Job {
    private final Log log = LogFactory.getLog(this.getClass());
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            Object[] params = null;
            String[] types = null;
            String objName = null;
            String objMethod = null;
            JobDataMap jobDataMap = context.getMergedJobDataMap();
            String[] keys = jobDataMap.getKeys();
            int i = 0;
            while (i < keys.length) {
                String value = jobDataMap.getString(keys[i]);
                if ("JMX_OBJECTNAME".equalsIgnoreCase(keys[i])) {
                    objName = value;
                } else if ("JMX_METHOD".equalsIgnoreCase(keys[i])) {
                    objMethod = value;
                } else if ("JMX_PARAMDEFS".equalsIgnoreCase(keys[i])) {
                    String[] paramdefs = this.split(value, ",");
                    params = new Object[paramdefs.length];
                    types = new String[paramdefs.length];
                    int k = 0;
                    while (k < paramdefs.length) {
                        String[] parts = this.split(paramdefs[k], ":");
                        if (parts.length < 2) {
                            throw new Exception("Invalid parameter definition: required parts missing " + paramdefs[k]);
                        }
                        switch (parts[0].charAt(0)) {
                            case 'i': {
                                params[k] = new Integer(jobDataMap.getString(parts[1]));
                                types[k] = Integer.TYPE.getName();
                                break;
                            }
                            case 'I': {
                                params[k] = new Integer(jobDataMap.getString(parts[1]));
                                Class<?> clazz = class$0;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("java.lang.Integer");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                types[k] = clazz.getName();
                                break;
                            }
                            case 'l': {
                                params[k] = new Long(jobDataMap.getString(parts[1]));
                                types[k] = Long.TYPE.getName();
                                break;
                            }
                            case 'L': {
                                params[k] = new Long(jobDataMap.getString(parts[1]));
                                Class<?> clazz = class$1;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("java.lang.Long");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                types[k] = clazz.getName();
                                break;
                            }
                            case 'f': {
                                params[k] = new Float(jobDataMap.getString(parts[1]));
                                types[k] = Float.TYPE.getName();
                                break;
                            }
                            case 'F': {
                                params[k] = new Float(jobDataMap.getString(parts[1]));
                                Class<?> clazz = class$2;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("java.lang.Float");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                types[k] = clazz.getName();
                                break;
                            }
                            case 'd': {
                                params[k] = new Double(jobDataMap.getString(parts[1]));
                                types[k] = Double.TYPE.getName();
                                break;
                            }
                            case 'D': {
                                params[k] = new Double(jobDataMap.getString(parts[1]));
                                Class<?> clazz = class$3;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("java.lang.Double");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                types[k] = clazz.getName();
                                break;
                            }
                            case 's': {
                                params[k] = jobDataMap.getString(parts[1]);
                                Class<?> clazz = class$4;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("java.lang.String");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                types[k] = clazz.getName();
                                break;
                            }
                            case 'b': {
                                params[k] = new Boolean(jobDataMap.getString(parts[1]));
                                types[k] = Boolean.TYPE.getName();
                                break;
                            }
                            case 'B': {
                                params[k] = new Boolean(jobDataMap.getString(parts[1]));
                                Class<?> clazz = class$5;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("java.lang.Boolean");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                types[k] = clazz.getName();
                            }
                        }
                        ++k;
                    }
                }
                ++i;
            }
            if (objName == null || objMethod == null) {
                throw new Exception("Required parameters missing");
            }
            context.setResult(this.invoke(objName, objMethod, params, types));
        }
        catch (Exception e) {
            String m = "Caught a " + e.getClass().getName() + " exception : " + e.getMessage();
            this.getLog().error(m, e);
            throw new JobExecutionException(m, (Throwable)e, false);
        }
    }

    private String[] split(String str, String splitStr) {
        LinkedList<String> l = new LinkedList<String>();
        StringTokenizer strTok = new StringTokenizer(str, splitStr);
        while (strTok.hasMoreTokens()) {
            String tok = strTok.nextToken();
            l.add(tok);
        }
        return l.toArray(new String[l.size()]);
    }

    private Object invoke(String objectName, String method, Object[] params, String[] types) throws Exception {
        MBeanServer server = (MBeanServer)MBeanServerFactory.findMBeanServer(null).get(0);
        ObjectName mbean = new ObjectName(objectName);
        if (server == null) {
            throw new Exception("Can't find mbean server");
        }
        this.getLog().info("invoking " + method);
        return server.invoke(mbean, method, params, types);
    }

    protected Log getLog() {
        return this.log;
    }
}

