/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.quartz.impl.jdbcjobstore;

import com.fr.third.org.quartz.impl.jdbcjobstore.DBSemaphore;
import com.fr.third.org.quartz.impl.jdbcjobstore.LockException;
import com.fr.third.org.quartz.impl.jdbcjobstore.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class StdRowLockSemaphore
extends DBSemaphore {
    public static final String SELECT_FOR_LOCK = "SELECT * FROM {0}LOCKS WHERE LOCK_NAME = ? FOR UPDATE";

    public StdRowLockSemaphore() {
        super("QRTZ_", null, SELECT_FOR_LOCK);
    }

    public StdRowLockSemaphore(String tablePrefix, String selectWithLockSQL) {
        super(tablePrefix, selectWithLockSQL, SELECT_FOR_LOCK);
    }

    protected void executeSQL(Connection conn, String lockName, String expandedSQL) throws LockException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            try {
                ps = conn.prepareStatement(expandedSQL);
                ps.setString(1, lockName);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug("Lock '" + lockName + "' is being obtained: " + Thread.currentThread().getName());
                }
                if (!(rs = ps.executeQuery()).next()) {
                    throw new SQLException(Util.rtp("No row exists in table {0}LOCKS for lock named: " + lockName, this.getTablePrefix()));
                }
            }
            catch (SQLException sqle) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug("Lock '" + lockName + "' was not obtained by: " + Thread.currentThread().getName());
                }
                throw new LockException("Failure obtaining db row lock: " + sqle.getMessage(), sqle);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected String getSelectWithLockSQL() {
        return this.getSQL();
    }

    public void setSelectWithLockSQL(String selectWithLockSQL) {
        this.setSQL(selectWithLockSQL);
    }
}

