/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.quartz.impl;

import com.fr.third.org.quartz.JobListener;
import com.fr.third.org.quartz.Scheduler;
import com.fr.third.org.quartz.SchedulerConfigException;
import com.fr.third.org.quartz.SchedulerException;
import com.fr.third.org.quartz.SchedulerFactory;
import com.fr.third.org.quartz.TriggerListener;
import com.fr.third.org.quartz.core.JobRunShellFactory;
import com.fr.third.org.quartz.core.QuartzScheduler;
import com.fr.third.org.quartz.core.QuartzSchedulerResources;
import com.fr.third.org.quartz.core.SchedulingContext;
import com.fr.third.org.quartz.ee.jta.JTAJobRunShellFactory;
import com.fr.third.org.quartz.ee.jta.UserTransactionHelper;
import com.fr.third.org.quartz.impl.RemoteMBeanScheduler;
import com.fr.third.org.quartz.impl.RemoteScheduler;
import com.fr.third.org.quartz.impl.SchedulerRepository;
import com.fr.third.org.quartz.impl.StdJobRunShellFactory;
import com.fr.third.org.quartz.impl.StdScheduler;
import com.fr.third.org.quartz.impl.jdbcjobstore.JobStoreSupport;
import com.fr.third.org.quartz.impl.jdbcjobstore.Semaphore;
import com.fr.third.org.quartz.impl.jdbcjobstore.TablePrefixAware;
import com.fr.third.org.quartz.simpl.SimpleThreadPool;
import com.fr.third.org.quartz.spi.ClassLoadHelper;
import com.fr.third.org.quartz.spi.InstanceIdGenerator;
import com.fr.third.org.quartz.spi.JobFactory;
import com.fr.third.org.quartz.spi.JobStore;
import com.fr.third.org.quartz.spi.SchedulerPlugin;
import com.fr.third.org.quartz.spi.ThreadPool;
import com.fr.third.org.quartz.utils.ConnectionProvider;
import com.fr.third.org.quartz.utils.DBConnectionManager;
import com.fr.third.org.quartz.utils.JNDIConnectionProvider;
import com.fr.third.org.quartz.utils.PoolingConnectionProvider;
import com.fr.third.org.quartz.utils.PropertiesParser;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StdSchedulerFactory
implements SchedulerFactory {
    public static final String PROPERTIES_FILE = "com.fr.third.org.quartz.properties";
    public static final String PROP_SCHED_INSTANCE_NAME = "com.fr.third.org.quartz.scheduler.instanceName";
    public static final String PROP_SCHED_INSTANCE_ID = "com.fr.third.org.quartz.scheduler.instanceId";
    public static final String PROP_SCHED_INSTANCE_ID_GENERATOR_PREFIX = "com.fr.third.org.quartz.scheduler.instanceIdGenerator";
    public static final String PROP_SCHED_INSTANCE_ID_GENERATOR_CLASS = "com.fr.third.org.quartz.scheduler.instanceIdGenerator.class";
    public static final String PROP_SCHED_THREAD_NAME = "com.fr.third.org.quartz.scheduler.threadName";
    public static final String PROP_SCHED_JMX_EXPORT = "com.fr.third.org.quartz.scheduler.jmx.export";
    public static final String PROP_SCHED_JMX_PROXY = "com.fr.third.org.quartz.scheduler.jmx.proxy";
    public static final String PROP_SCHED_JMX_PROXY_CLASS = "com.fr.third.org.quartz.scheduler.jmx.proxy.class";
    public static final String PROP_SCHED_JMX_OBJECT_NAME = "com.fr.third.org.quartz.scheduler.jmx.objectName";
    public static final String PROP_SCHED_RMI_EXPORT = "com.fr.third.org.quartz.scheduler.rmi.export";
    public static final String PROP_SCHED_RMI_PROXY = "com.fr.third.org.quartz.scheduler.rmi.proxy";
    public static final String PROP_SCHED_RMI_HOST = "com.fr.third.org.quartz.scheduler.rmi.registryHost";
    public static final String PROP_SCHED_RMI_PORT = "com.fr.third.org.quartz.scheduler.rmi.registryPort";
    public static final String PROP_SCHED_RMI_SERVER_PORT = "com.fr.third.org.quartz.scheduler.rmi.serverPort";
    public static final String PROP_SCHED_RMI_CREATE_REGISTRY = "com.fr.third.org.quartz.scheduler.rmi.createRegistry";
    public static final String PROP_SCHED_RMI_BIND_NAME = "com.fr.third.org.quartz.scheduler.rmi.bindName";
    public static final String PROP_SCHED_WRAP_JOB_IN_USER_TX = "com.fr.third.org.quartz.scheduler.wrapJobExecutionInUserTransaction";
    public static final String PROP_SCHED_USER_TX_URL = "com.fr.third.org.quartz.scheduler.userTransactionURL";
    public static final String PROP_SCHED_IDLE_WAIT_TIME = "com.fr.third.org.quartz.scheduler.idleWaitTime";
    public static final String PROP_SCHED_DB_FAILURE_RETRY_INTERVAL = "com.fr.third.org.quartz.scheduler.dbFailureRetryInterval";
    public static final String PROP_SCHED_MAKE_SCHEDULER_THREAD_DAEMON = "com.fr.third.org.quartz.scheduler.makeSchedulerThreadDaemon";
    public static final String PROP_SCHED_SCHEDULER_THREADS_INHERIT_CONTEXT_CLASS_LOADER_OF_INITIALIZING_THREAD = "com.fr.third.org.quartz.scheduler.threadsInheritContextClassLoaderOfInitializer";
    public static final String PROP_SCHED_CLASS_LOAD_HELPER_CLASS = "com.fr.third.org.quartz.scheduler.classLoadHelper.class";
    public static final String PROP_SCHED_JOB_FACTORY_CLASS = "com.fr.third.org.quartz.scheduler.jobFactory.class";
    public static final String PROP_SCHED_JOB_FACTORY_PREFIX = "com.fr.third.org.quartz.scheduler.jobFactory";
    public static final String PROP_SCHED_CONTEXT_PREFIX = "com.fr.third.org.quartz.context.key";
    public static final String PROP_THREAD_POOL_PREFIX = "com.fr.third.org.quartz.threadPool";
    public static final String PROP_THREAD_POOL_CLASS = "com.fr.third.org.quartz.threadPool.class";
    public static final String PROP_JOB_STORE_PREFIX = "com.fr.third.org.quartz.jobStore";
    public static final String PROP_JOB_STORE_LOCK_HANDLER_PREFIX = "com.fr.third.org.quartz.jobStore.lockHandler";
    public static final String PROP_JOB_STORE_LOCK_HANDLER_CLASS = "com.fr.third.org.quartz.jobStore.lockHandler.class";
    public static final String PROP_TABLE_PREFIX = "tablePrefix";
    public static final String PROP_JOB_STORE_CLASS = "com.fr.third.org.quartz.jobStore.class";
    public static final String PROP_JOB_STORE_USE_PROP = "com.fr.third.org.quartz.jobStore.useProperties";
    public static final String PROP_DATASOURCE_PREFIX = "com.fr.third.org.quartz.dataSource";
    public static final String PROP_CONNECTION_PROVIDER_CLASS = "connectionProvider.class";
    public static final String PROP_DATASOURCE_DRIVER = "driver";
    public static final String PROP_DATASOURCE_URL = "URL";
    public static final String PROP_DATASOURCE_USER = "user";
    public static final String PROP_DATASOURCE_PASSWORD = "password";
    public static final String PROP_DATASOURCE_MAX_CONNECTIONS = "maxConnections";
    public static final String PROP_DATASOURCE_VALIDATION_QUERY = "validationQuery";
    public static final String PROP_DATASOURCE_JNDI_URL = "jndiURL";
    public static final String PROP_DATASOURCE_JNDI_ALWAYS_LOOKUP = "jndiAlwaysLookup";
    public static final String PROP_DATASOURCE_JNDI_INITIAL = "java.naming.factory.initial";
    public static final String PROP_DATASOURCE_JNDI_PROVDER = "java.naming.provider.url";
    public static final String PROP_DATASOURCE_JNDI_PRINCIPAL = "java.naming.security.principal";
    public static final String PROP_DATASOURCE_JNDI_CREDENTIALS = "java.naming.security.credentials";
    public static final String PROP_PLUGIN_PREFIX = "com.fr.third.org.quartz.plugin";
    public static final String PROP_PLUGIN_CLASS = "class";
    public static final String PROP_JOB_LISTENER_PREFIX = "com.fr.third.org.quartz.jobListener";
    public static final String PROP_TRIGGER_LISTENER_PREFIX = "com.fr.third.org.quartz.triggerListener";
    public static final String PROP_LISTENER_CLASS = "class";
    public static final String DEFAULT_INSTANCE_ID = "NON_CLUSTERED";
    public static final String AUTO_GENERATE_INSTANCE_ID = "AUTO";
    private SchedulerException initException = null;
    private String propSrc = null;
    private PropertiesParser cfg;
    private final Log log = LogFactory.getLog(this.getClass());
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public StdSchedulerFactory() {
    }

    public StdSchedulerFactory(Properties props) throws SchedulerException {
        this.initialize(props);
    }

    public StdSchedulerFactory(String fileName) throws SchedulerException {
        this.initialize(fileName);
    }

    public Log getLog() {
        return this.log;
    }

    public void initialize() throws SchedulerException {
        Properties props;
        block22: {
            if (this.cfg != null) {
                return;
            }
            if (this.initException != null) {
                throw this.initException;
            }
            String requestedFile = System.getProperty(PROPERTIES_FILE);
            String propFileName = requestedFile != null ? requestedFile : "quartz.properties";
            File propFile = new File(propFileName);
            props = new Properties();
            InputStream in = null;
            try {
                if (propFile.exists()) {
                    try {
                        this.propSrc = requestedFile != null ? "specified file: '" + requestedFile + "'" : "default file in current working dir: 'quartz.properties'";
                        in = new BufferedInputStream(new FileInputStream(propFileName));
                        props.load(in);
                        break block22;
                    }
                    catch (IOException ioe) {
                        this.initException = new SchedulerException("Properties file: '" + propFileName + "' could not be read.", ioe);
                        throw this.initException;
                    }
                }
                if (requestedFile != null) {
                    in = Thread.currentThread().getContextClassLoader().getResourceAsStream(requestedFile);
                    if (in == null) {
                        this.initException = new SchedulerException("Properties file: '" + requestedFile + "' could not be found.");
                        throw this.initException;
                    }
                    this.propSrc = "specified file: '" + requestedFile + "' in the class resource path.";
                    in = new BufferedInputStream(in);
                    try {
                        props.load(in);
                        break block22;
                    }
                    catch (IOException ioe) {
                        this.initException = new SchedulerException("Properties file: '" + requestedFile + "' could not be read.", ioe);
                        throw this.initException;
                    }
                }
                this.propSrc = "default resource file in Quartz package: 'quartz.properties'";
                in = this.getClass().getClassLoader().getResourceAsStream("quartz.properties");
                if (in == null) {
                    in = this.getClass().getClassLoader().getResourceAsStream("/quartz.properties");
                }
                if (in == null) {
                    in = this.getClass().getClassLoader().getResourceAsStream("com/fr/third/org/quartz/quartz.properties");
                }
                if (in == null) {
                    this.initException = new SchedulerException("Default quartz.properties not found in class path");
                    throw this.initException;
                }
                try {
                    props.load(in);
                }
                catch (IOException ioe) {
                    this.initException = new SchedulerException("Resource properties file: 'com/fr/third/org/quartz/quartz.properties' could not be read from the classpath.", ioe);
                    throw this.initException;
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.initialize(this.overrideWithSysProps(props));
    }

    private Properties overrideWithSysProps(Properties props) {
        Properties sysProps = null;
        try {
            sysProps = System.getProperties();
        }
        catch (AccessControlException e) {
            this.getLog().warn("Skipping overriding quartz properties with System properties during initialization because of an AccessControlException.  This is likely due to not having read/write access for java.util.PropertyPermission as required by java.lang.System.getProperties().  To resolve this warning, either add this permission to your policy file or use a non-default version of initialize().", e);
        }
        if (sysProps != null) {
            props.putAll((Map<?, ?>)sysProps);
        }
        return props;
    }

    public void initialize(String filename) throws SchedulerException {
        if (this.cfg != null) {
            return;
        }
        if (this.initException != null) {
            throw this.initException;
        }
        InputStream is = null;
        Properties props = new Properties();
        is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
        try {
            try {
                if (is != null) {
                    is = new BufferedInputStream(is);
                    this.propSrc = "the specified file : '" + filename + "' from the class resource path.";
                } else {
                    is = new BufferedInputStream(new FileInputStream(filename));
                    this.propSrc = "the specified file : '" + filename + "'";
                }
                props.load(is);
            }
            catch (IOException ioe) {
                this.initException = new SchedulerException("Properties file: '" + filename + "' could not be read.", ioe);
                throw this.initException;
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.initialize(props);
    }

    public void initialize(InputStream propertiesStream) throws SchedulerException {
        if (this.cfg != null) {
            return;
        }
        if (this.initException != null) {
            throw this.initException;
        }
        Properties props = new Properties();
        if (propertiesStream != null) {
            try {
                props.load(propertiesStream);
                this.propSrc = "an externally opened InputStream.";
            }
            catch (IOException e) {
                this.initException = new SchedulerException("Error loading property data from InputStream", e);
                throw this.initException;
            }
        } else {
            this.initException = new SchedulerException("Error loading property data from InputStream - InputStream is null.");
            throw this.initException;
        }
        this.initialize(props);
    }

    public void initialize(Properties props) throws SchedulerException {
        if (this.propSrc == null) {
            this.propSrc = "an externally provided properties instance.";
        }
        this.cfg = new PropertiesParser(props);
    }

    private Scheduler instantiate() throws SchedulerException {
        String jsClass;
        String tpClass;
        if (this.cfg == null) {
            this.initialize();
        }
        if (this.initException != null) {
            throw this.initException;
        }
        JobStore js = null;
        ThreadPool tp = null;
        QuartzScheduler qs = null;
        SchedulingContext schedCtxt = null;
        DBConnectionManager dbMgr = null;
        String instanceIdGeneratorClass = null;
        Properties tProps = null;
        String userTXLocation = null;
        boolean wrapJobInTx = false;
        boolean autoId = false;
        long idleWaitTime = -1L;
        long dbFailureRetry = -1L;
        SchedulerRepository schedRep = SchedulerRepository.getInstance();
        String schedName = this.cfg.getStringProperty(PROP_SCHED_INSTANCE_NAME, "QuartzScheduler");
        String threadName = this.cfg.getStringProperty(PROP_SCHED_THREAD_NAME, String.valueOf(schedName) + "_QuartzSchedulerThread");
        String schedInstId = this.cfg.getStringProperty(PROP_SCHED_INSTANCE_ID, DEFAULT_INSTANCE_ID);
        if (schedInstId.equals(AUTO_GENERATE_INSTANCE_ID)) {
            autoId = true;
            instanceIdGeneratorClass = this.cfg.getStringProperty(PROP_SCHED_INSTANCE_ID_GENERATOR_CLASS, "com.fr.third.org.quartz.simpl.SimpleInstanceIdGenerator");
        }
        if ((userTXLocation = this.cfg.getStringProperty(PROP_SCHED_USER_TX_URL, userTXLocation)) != null && userTXLocation.trim().length() == 0) {
            userTXLocation = null;
        }
        String classLoadHelperClass = this.cfg.getStringProperty(PROP_SCHED_CLASS_LOAD_HELPER_CLASS, "com.fr.third.org.quartz.simpl.CascadingClassLoadHelper");
        wrapJobInTx = this.cfg.getBooleanProperty(PROP_SCHED_WRAP_JOB_IN_USER_TX, wrapJobInTx);
        String jobFactoryClass = this.cfg.getStringProperty(PROP_SCHED_JOB_FACTORY_CLASS, null);
        idleWaitTime = this.cfg.getLongProperty(PROP_SCHED_IDLE_WAIT_TIME, idleWaitTime);
        dbFailureRetry = this.cfg.getLongProperty(PROP_SCHED_DB_FAILURE_RETRY_INTERVAL, dbFailureRetry);
        boolean makeSchedulerThreadDaemon = this.cfg.getBooleanProperty(PROP_SCHED_MAKE_SCHEDULER_THREAD_DAEMON);
        boolean threadsInheritInitalizersClassLoader = this.cfg.getBooleanProperty(PROP_SCHED_SCHEDULER_THREADS_INHERIT_CONTEXT_CLASS_LOADER_OF_INITIALIZING_THREAD);
        boolean jmxExport = this.cfg.getBooleanProperty(PROP_SCHED_JMX_EXPORT);
        boolean jmxProxy = this.cfg.getBooleanProperty(PROP_SCHED_JMX_PROXY);
        String jmxProxyClass = this.cfg.getStringProperty(PROP_SCHED_JMX_PROXY_CLASS);
        String jmxObjectName = this.cfg.getStringProperty(PROP_SCHED_JMX_OBJECT_NAME);
        boolean rmiExport = this.cfg.getBooleanProperty(PROP_SCHED_RMI_EXPORT, false);
        boolean rmiProxy = this.cfg.getBooleanProperty(PROP_SCHED_RMI_PROXY, false);
        String rmiHost = this.cfg.getStringProperty(PROP_SCHED_RMI_HOST, "localhost");
        int rmiPort = this.cfg.getIntProperty(PROP_SCHED_RMI_PORT, 1099);
        int rmiServerPort = this.cfg.getIntProperty(PROP_SCHED_RMI_SERVER_PORT, -1);
        String rmiCreateRegistry = this.cfg.getStringProperty(PROP_SCHED_RMI_CREATE_REGISTRY, "never");
        String rmiBindName = this.cfg.getStringProperty(PROP_SCHED_RMI_BIND_NAME);
        if (jmxProxy && rmiProxy) {
            throw new SchedulerConfigException("Cannot proxy both RMI and JMX.");
        }
        Properties schedCtxtProps = this.cfg.getPropertyGroup(PROP_SCHED_CONTEXT_PREFIX, true);
        if (rmiProxy) {
            if (autoId) {
                schedInstId = DEFAULT_INSTANCE_ID;
            }
            schedCtxt = new SchedulingContext();
            schedCtxt.setInstanceId(schedInstId);
            String uid = rmiBindName == null ? QuartzSchedulerResources.getUniqueIdentifier(schedName, schedInstId) : rmiBindName;
            RemoteScheduler remoteScheduler = new RemoteScheduler(schedCtxt, uid, rmiHost, rmiPort);
            schedRep.bind(remoteScheduler);
            return remoteScheduler;
        }
        ClassLoadHelper loadHelper = null;
        try {
            loadHelper = (ClassLoadHelper)this.loadClass(classLoadHelperClass).newInstance();
        }
        catch (Exception e) {
            throw new SchedulerConfigException("Unable to instantiate class load helper class: " + e.getMessage(), e);
        }
        loadHelper.initialize();
        if (jmxProxy) {
            if (autoId) {
                schedInstId = DEFAULT_INSTANCE_ID;
            }
            if (jmxProxyClass == null) {
                throw new SchedulerConfigException("No JMX Proxy Scheduler class provided");
            }
            RemoteMBeanScheduler jmxScheduler = null;
            try {
                jmxScheduler = (RemoteMBeanScheduler)loadHelper.loadClass(jmxProxyClass).newInstance();
            }
            catch (Exception e) {
                throw new SchedulerConfigException("Unable to instantiate RemoteMBeanScheduler class.", e);
            }
            schedCtxt = new SchedulingContext();
            schedCtxt.setInstanceId(schedInstId);
            if (jmxObjectName == null) {
                jmxObjectName = QuartzSchedulerResources.generateJMXObjectName(schedName, schedInstId);
            }
            jmxScheduler.setSchedulingContext(schedCtxt);
            jmxScheduler.setSchedulerObjectName(jmxObjectName);
            tProps = this.cfg.getPropertyGroup(PROP_SCHED_JMX_PROXY, true);
            try {
                this.setBeanProps(jmxScheduler, tProps);
            }
            catch (Exception e) {
                this.initException = new SchedulerException("RemoteMBeanScheduler class '" + jmxProxyClass + "' props could not be configured.", e);
                this.initException.setErrorCode(50);
                throw this.initException;
            }
            jmxScheduler.initialize();
            schedRep.bind(jmxScheduler);
            return jmxScheduler;
        }
        JobFactory jobFactory = null;
        if (jobFactoryClass != null) {
            try {
                jobFactory = (JobFactory)loadHelper.loadClass(jobFactoryClass).newInstance();
            }
            catch (Exception e) {
                throw new SchedulerConfigException("Unable to instantiate JobFactory class: " + e.getMessage(), e);
            }
            tProps = this.cfg.getPropertyGroup(PROP_SCHED_JOB_FACTORY_PREFIX, true);
            try {
                this.setBeanProps(jobFactory, tProps);
            }
            catch (Exception e) {
                this.initException = new SchedulerException("JobFactory class '" + jobFactoryClass + "' props could not be configured.", e);
                this.initException.setErrorCode(50);
                throw this.initException;
            }
        }
        InstanceIdGenerator instanceIdGenerator = null;
        if (instanceIdGeneratorClass != null) {
            try {
                instanceIdGenerator = (InstanceIdGenerator)loadHelper.loadClass(instanceIdGeneratorClass).newInstance();
            }
            catch (Exception e) {
                throw new SchedulerConfigException("Unable to instantiate InstanceIdGenerator class: " + e.getMessage(), e);
            }
            tProps = this.cfg.getPropertyGroup(PROP_SCHED_INSTANCE_ID_GENERATOR_PREFIX, true);
            try {
                this.setBeanProps(instanceIdGenerator, tProps);
            }
            catch (Exception e) {
                this.initException = new SchedulerException("InstanceIdGenerator class '" + instanceIdGeneratorClass + "' props could not be configured.", e);
                this.initException.setErrorCode(50);
                throw this.initException;
            }
        }
        if ((tpClass = this.cfg.getStringProperty(PROP_THREAD_POOL_CLASS, null)) == null) {
            this.initException = new SchedulerException("ThreadPool class not specified. ", 50);
            throw this.initException;
        }
        try {
            tp = (ThreadPool)loadHelper.loadClass(tpClass).newInstance();
        }
        catch (Exception e) {
            this.initException = new SchedulerException("ThreadPool class '" + tpClass + "' could not be instantiated.", e);
            this.initException.setErrorCode(50);
            throw this.initException;
        }
        tProps = this.cfg.getPropertyGroup(PROP_THREAD_POOL_PREFIX, true);
        try {
            this.setBeanProps(tp, tProps);
        }
        catch (Exception e) {
            this.initException = new SchedulerException("ThreadPool class '" + tpClass + "' props could not be configured.", e);
            this.initException.setErrorCode(50);
            throw this.initException;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.fr.third.org.quartz.simpl.RAMJobStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((jsClass = this.cfg.getStringProperty(PROP_JOB_STORE_CLASS, clazz.getName())) == null) {
            this.initException = new SchedulerException("JobStore class not specified. ", 50);
            throw this.initException;
        }
        try {
            js = (JobStore)loadHelper.loadClass(jsClass).newInstance();
        }
        catch (Exception e) {
            this.initException = new SchedulerException("JobStore class '" + jsClass + "' could not be instantiated.", e);
            this.initException.setErrorCode(50);
            throw this.initException;
        }
        tProps = this.cfg.getPropertyGroup(PROP_JOB_STORE_PREFIX, true, new String[]{PROP_JOB_STORE_LOCK_HANDLER_PREFIX});
        try {
            this.setBeanProps(js, tProps);
        }
        catch (Exception e) {
            this.initException = new SchedulerException("JobStore class '" + jsClass + "' props could not be configured.", e);
            this.initException.setErrorCode(50);
            throw this.initException;
        }
        if (js instanceof JobStoreSupport) {
            ((JobStoreSupport)js).setInstanceId(schedInstId);
            ((JobStoreSupport)js).setInstanceName(schedName);
            String lockHandlerClass = this.cfg.getStringProperty(PROP_JOB_STORE_LOCK_HANDLER_CLASS);
            if (lockHandlerClass != null) {
                try {
                    Semaphore lockHandler = (Semaphore)loadHelper.loadClass(lockHandlerClass).newInstance();
                    tProps = this.cfg.getPropertyGroup(PROP_JOB_STORE_LOCK_HANDLER_PREFIX, true);
                    if (lockHandler instanceof TablePrefixAware) {
                        tProps.setProperty(PROP_TABLE_PREFIX, ((JobStoreSupport)js).getTablePrefix());
                    }
                    try {
                        this.setBeanProps(lockHandler, tProps);
                    }
                    catch (Exception e) {
                        this.initException = new SchedulerException("JobStore LockHandler class '" + lockHandlerClass + "' props could not be configured.", e);
                        this.initException.setErrorCode(50);
                        throw this.initException;
                    }
                    ((JobStoreSupport)js).setLockHandler(lockHandler);
                    this.getLog().info("Using custom data access locking (synchronization): " + lockHandlerClass);
                }
                catch (Exception e) {
                    this.initException = new SchedulerException("JobStore LockHandler class '" + lockHandlerClass + "' could not be instantiated.", e);
                    this.initException.setErrorCode(50);
                    throw this.initException;
                }
            }
        }
        String[] dsNames = this.cfg.getPropertyGroups(PROP_DATASOURCE_PREFIX);
        int i = 0;
        while (i < dsNames.length) {
            PropertiesParser pp = new PropertiesParser(this.cfg.getPropertyGroup("com.fr.third.org.quartz.dataSource." + dsNames[i], true));
            String cpClass = pp.getStringProperty(PROP_CONNECTION_PROVIDER_CLASS, null);
            if (cpClass != null) {
                ConnectionProvider cp = null;
                try {
                    cp = (ConnectionProvider)loadHelper.loadClass(cpClass).newInstance();
                }
                catch (Exception e) {
                    this.initException = new SchedulerException("ConnectionProvider class '" + cpClass + "' could not be instantiated.", e);
                    this.initException.setErrorCode(50);
                    throw this.initException;
                }
                try {
                    pp.getUnderlyingProperties().remove(PROP_CONNECTION_PROVIDER_CLASS);
                    this.setBeanProps(cp, pp.getUnderlyingProperties());
                }
                catch (Exception e) {
                    this.initException = new SchedulerException("ConnectionProvider class '" + cpClass + "' props could not be configured.", e);
                    this.initException.setErrorCode(50);
                    throw this.initException;
                }
                dbMgr = DBConnectionManager.getInstance();
                dbMgr.addConnectionProvider(dsNames[i], cp);
            } else {
                ConnectionProvider cp;
                String dsJndi = pp.getStringProperty(PROP_DATASOURCE_JNDI_URL, null);
                if (dsJndi != null) {
                    boolean dsAlwaysLookup = pp.getBooleanProperty(PROP_DATASOURCE_JNDI_ALWAYS_LOOKUP);
                    String dsJndiInitial = pp.getStringProperty(PROP_DATASOURCE_JNDI_INITIAL);
                    String dsJndiProvider = pp.getStringProperty(PROP_DATASOURCE_JNDI_PROVDER);
                    String dsJndiPrincipal = pp.getStringProperty(PROP_DATASOURCE_JNDI_PRINCIPAL);
                    String dsJndiCredentials = pp.getStringProperty(PROP_DATASOURCE_JNDI_CREDENTIALS);
                    Properties props = null;
                    if (dsJndiInitial != null || dsJndiProvider != null || dsJndiPrincipal != null || dsJndiCredentials != null) {
                        props = new Properties();
                        if (dsJndiInitial != null) {
                            props.put(PROP_DATASOURCE_JNDI_INITIAL, dsJndiInitial);
                        }
                        if (dsJndiProvider != null) {
                            props.put(PROP_DATASOURCE_JNDI_PROVDER, dsJndiProvider);
                        }
                        if (dsJndiPrincipal != null) {
                            props.put(PROP_DATASOURCE_JNDI_PRINCIPAL, dsJndiPrincipal);
                        }
                        if (dsJndiCredentials != null) {
                            props.put(PROP_DATASOURCE_JNDI_CREDENTIALS, dsJndiCredentials);
                        }
                    }
                    cp = new JNDIConnectionProvider(dsJndi, props, dsAlwaysLookup);
                    dbMgr = DBConnectionManager.getInstance();
                    dbMgr.addConnectionProvider(dsNames[i], cp);
                } else {
                    String dsDriver = pp.getStringProperty(PROP_DATASOURCE_DRIVER);
                    String dsURL = pp.getStringProperty(PROP_DATASOURCE_URL);
                    String dsUser = pp.getStringProperty(PROP_DATASOURCE_USER, "");
                    String dsPass = pp.getStringProperty(PROP_DATASOURCE_PASSWORD, "");
                    int dsCnt = pp.getIntProperty(PROP_DATASOURCE_MAX_CONNECTIONS, 10);
                    String dsValidation = pp.getStringProperty(PROP_DATASOURCE_VALIDATION_QUERY);
                    if (dsDriver == null) {
                        this.initException = new SchedulerException("Driver not specified for DataSource: " + dsNames[i]);
                        throw this.initException;
                    }
                    if (dsURL == null) {
                        this.initException = new SchedulerException("DB URL not specified for DataSource: " + dsNames[i]);
                        throw this.initException;
                    }
                    try {
                        cp = new PoolingConnectionProvider(dsDriver, dsURL, dsUser, dsPass, dsCnt, dsValidation);
                        dbMgr = DBConnectionManager.getInstance();
                        dbMgr.addConnectionProvider(dsNames[i], cp);
                    }
                    catch (SQLException sqle) {
                        this.initException = new SchedulerException("Could not initialize DataSource: " + dsNames[i], sqle);
                        throw this.initException;
                    }
                }
            }
            ++i;
        }
        String[] pluginNames = this.cfg.getPropertyGroups(PROP_PLUGIN_PREFIX);
        SchedulerPlugin[] plugins = new SchedulerPlugin[pluginNames.length];
        int i2 = 0;
        while (i2 < pluginNames.length) {
            Properties pp = this.cfg.getPropertyGroup("com.fr.third.org.quartz.plugin." + pluginNames[i2], true);
            String plugInClass = pp.getProperty("class", null);
            if (plugInClass == null) {
                this.initException = new SchedulerException("SchedulerPlugin class not specified for plugin '" + pluginNames[i2] + "'", 50);
                throw this.initException;
            }
            SchedulerPlugin plugin = null;
            try {
                plugin = (SchedulerPlugin)loadHelper.loadClass(plugInClass).newInstance();
            }
            catch (Exception e) {
                this.initException = new SchedulerException("SchedulerPlugin class '" + plugInClass + "' could not be instantiated.", e);
                this.initException.setErrorCode(50);
                throw this.initException;
            }
            try {
                this.setBeanProps(plugin, pp);
            }
            catch (Exception e) {
                this.initException = new SchedulerException("JobStore SchedulerPlugin '" + plugInClass + "' props could not be configured.", e);
                this.initException.setErrorCode(50);
                throw this.initException;
            }
            plugins[i2] = plugin;
            ++i2;
        }
        Class[] classArray = new Class[1];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Class[] strArg = classArray;
        String[] jobListenerNames = this.cfg.getPropertyGroups(PROP_JOB_LISTENER_PREFIX);
        JobListener[] jobListeners = new JobListener[jobListenerNames.length];
        int i3 = 0;
        while (i3 < jobListenerNames.length) {
            Properties lp = this.cfg.getPropertyGroup("com.fr.third.org.quartz.jobListener." + jobListenerNames[i3], true);
            String listenerClass = lp.getProperty("class", null);
            if (listenerClass == null) {
                this.initException = new SchedulerException("JobListener class not specified for listener '" + jobListenerNames[i3] + "'", 50);
                throw this.initException;
            }
            JobListener listener = null;
            try {
                listener = (JobListener)loadHelper.loadClass(listenerClass).newInstance();
            }
            catch (Exception e) {
                this.initException = new SchedulerException("JobListener class '" + listenerClass + "' could not be instantiated.", e);
                this.initException.setErrorCode(50);
                throw this.initException;
            }
            try {
                Method nameSetter = listener.getClass().getMethod("setName", strArg);
                if (nameSetter != null) {
                    nameSetter.invoke((Object)listener, jobListenerNames[i3]);
                }
                this.setBeanProps(listener, lp);
            }
            catch (Exception e) {
                this.initException = new SchedulerException("JobListener '" + listenerClass + "' props could not be configured.", e);
                this.initException.setErrorCode(50);
                throw this.initException;
            }
            jobListeners[i3] = listener;
            ++i3;
        }
        String[] triggerListenerNames = this.cfg.getPropertyGroups(PROP_TRIGGER_LISTENER_PREFIX);
        TriggerListener[] triggerListeners = new TriggerListener[triggerListenerNames.length];
        int i4 = 0;
        while (i4 < triggerListenerNames.length) {
            Properties lp = this.cfg.getPropertyGroup("com.fr.third.org.quartz.triggerListener." + triggerListenerNames[i4], true);
            String listenerClass = lp.getProperty("class", null);
            if (listenerClass == null) {
                this.initException = new SchedulerException("TriggerListener class not specified for listener '" + triggerListenerNames[i4] + "'", 50);
                throw this.initException;
            }
            TriggerListener listener = null;
            try {
                listener = (TriggerListener)loadHelper.loadClass(listenerClass).newInstance();
            }
            catch (Exception e) {
                this.initException = new SchedulerException("TriggerListener class '" + listenerClass + "' could not be instantiated.", e);
                this.initException.setErrorCode(50);
                throw this.initException;
            }
            try {
                Method nameSetter = listener.getClass().getMethod("setName", strArg);
                if (nameSetter != null) {
                    nameSetter.invoke((Object)listener, triggerListenerNames[i4]);
                }
                this.setBeanProps(listener, lp);
            }
            catch (Exception e) {
                this.initException = new SchedulerException("TriggerListener '" + listenerClass + "' props could not be configured.", e);
                this.initException.setErrorCode(50);
                throw this.initException;
            }
            triggerListeners[i4] = listener;
            ++i4;
        }
        JobRunShellFactory jrsf = null;
        if (userTXLocation != null) {
            UserTransactionHelper.setUserTxLocation(userTXLocation);
        }
        jrsf = wrapJobInTx ? new JTAJobRunShellFactory() : new StdJobRunShellFactory();
        if (autoId) {
            try {
                schedInstId = DEFAULT_INSTANCE_ID;
                if (js instanceof JobStoreSupport && ((JobStoreSupport)js).isClustered()) {
                    schedInstId = instanceIdGenerator.generateInstanceId();
                }
            }
            catch (Exception e) {
                this.getLog().error("Couldn't generate instance Id!", e);
                throw new IllegalStateException("Cannot run without an instance id.");
            }
        }
        if (js instanceof JobStoreSupport) {
            JobStoreSupport jjs = (JobStoreSupport)js;
            jjs.setInstanceId(schedInstId);
            jjs.setDbRetryInterval(dbFailureRetry);
            if (threadsInheritInitalizersClassLoader) {
                jjs.setThreadsInheritInitializersClassLoadContext(threadsInheritInitalizersClassLoader);
            }
        }
        QuartzSchedulerResources rsrcs = new QuartzSchedulerResources();
        rsrcs.setName(schedName);
        rsrcs.setThreadName(threadName);
        rsrcs.setInstanceId(schedInstId);
        rsrcs.setJobRunShellFactory(jrsf);
        rsrcs.setMakeSchedulerThreadDaemon(makeSchedulerThreadDaemon);
        rsrcs.setThreadsInheritInitializersClassLoadContext(threadsInheritInitalizersClassLoader);
        rsrcs.setJMXExport(jmxExport);
        rsrcs.setJMXObjectName(jmxObjectName);
        if (rmiExport) {
            rsrcs.setRMIRegistryHost(rmiHost);
            rsrcs.setRMIRegistryPort(rmiPort);
            rsrcs.setRMIServerPort(rmiServerPort);
            rsrcs.setRMICreateRegistryStrategy(rmiCreateRegistry);
            rsrcs.setRMIBindName(rmiBindName);
        }
        rsrcs.setThreadPool(tp);
        if (tp instanceof SimpleThreadPool) {
            ((SimpleThreadPool)tp).setThreadNamePrefix(String.valueOf(schedName) + "_Worker");
            if (threadsInheritInitalizersClassLoader) {
                ((SimpleThreadPool)tp).setThreadsInheritContextClassLoaderOfInitializingThread(threadsInheritInitalizersClassLoader);
            }
        }
        tp.initialize();
        rsrcs.setJobStore(js);
        int i5 = 0;
        while (i5 < plugins.length) {
            rsrcs.addSchedulerPlugin(plugins[i5]);
            ++i5;
        }
        schedCtxt = new SchedulingContext();
        schedCtxt.setInstanceId(rsrcs.getInstanceId());
        qs = new QuartzScheduler(rsrcs, schedCtxt, idleWaitTime, dbFailureRetry);
        Scheduler scheduler = this.instantiate(rsrcs, qs);
        if (jobFactory != null) {
            qs.setJobFactory(jobFactory);
        }
        int i6 = 0;
        while (i6 < plugins.length) {
            plugins[i6].initialize(pluginNames[i6], scheduler);
            ++i6;
        }
        i6 = 0;
        while (i6 < jobListeners.length) {
            qs.addGlobalJobListener(jobListeners[i6]);
            ++i6;
        }
        i6 = 0;
        while (i6 < triggerListeners.length) {
            qs.addGlobalTriggerListener(triggerListeners[i6]);
            ++i6;
        }
        Iterator<Object> itr = schedCtxtProps.keySet().iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            String val = schedCtxtProps.getProperty(key);
            scheduler.getContext().put(key, val);
        }
        js.initialize(loadHelper, qs.getSchedulerSignaler());
        jrsf.initialize(scheduler, schedCtxt);
        this.getLog().info("Quartz scheduler '" + scheduler.getSchedulerName() + "' initialized from " + this.propSrc);
        this.getLog().info("Quartz scheduler version: " + qs.getVersion());
        qs.addNoGCObject(schedRep);
        if (dbMgr != null) {
            qs.addNoGCObject(dbMgr);
        }
        schedRep.bind(scheduler);
        return scheduler;
    }

    protected Scheduler instantiate(QuartzSchedulerResources rsrcs, QuartzScheduler qs) {
        SchedulingContext schedCtxt = new SchedulingContext();
        schedCtxt.setInstanceId(rsrcs.getInstanceId());
        StdScheduler scheduler = new StdScheduler(qs, schedCtxt);
        return scheduler;
    }

    private void setBeanProps(Object obj, Properties props) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, IntrospectionException, SchedulerConfigException {
        props.remove("class");
        BeanInfo bi = Introspector.getBeanInfo(obj.getClass());
        PropertyDescriptor[] propDescs = bi.getPropertyDescriptors();
        PropertiesParser pp = new PropertiesParser(props);
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            String c = name.substring(0, 1).toUpperCase(Locale.US);
            String methName = "set" + c + name.substring(1);
            Method setMeth = this.getSetMethod(methName, propDescs);
            try {
                if (setMeth == null) {
                    throw new NoSuchMethodException("No setter for property '" + name + "'");
                }
                Class<?>[] params = setMeth.getParameterTypes();
                if (params.length != 1) {
                    throw new NoSuchMethodException("No 1-argument setter for property '" + name + "'");
                }
                if (params[0].equals(Integer.TYPE)) {
                    setMeth.invoke(obj, new Integer(pp.getIntProperty(name)));
                    continue;
                }
                if (params[0].equals(Long.TYPE)) {
                    setMeth.invoke(obj, new Long(pp.getLongProperty(name)));
                    continue;
                }
                if (params[0].equals(Float.TYPE)) {
                    setMeth.invoke(obj, new Float(pp.getFloatProperty(name)));
                    continue;
                }
                if (params[0].equals(Double.TYPE)) {
                    setMeth.invoke(obj, new Double(pp.getDoubleProperty(name)));
                    continue;
                }
                if (params[0].equals(Boolean.TYPE)) {
                    setMeth.invoke(obj, new Boolean(pp.getBooleanProperty(name)));
                    continue;
                }
                Class<?> clazz = params[0];
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(clazz2)) {
                    setMeth.invoke(obj, pp.getStringProperty(name));
                    continue;
                }
                throw new NoSuchMethodException("No primitive-type setter for property '" + name + "'");
            }
            catch (NumberFormatException nfe) {
                throw new SchedulerConfigException("Could not parse property '" + name + "' into correct data type: " + nfe.toString());
            }
        }
    }

    private Method getSetMethod(String name, PropertyDescriptor[] props) {
        int i = 0;
        while (i < props.length) {
            Method wMeth = props[i].getWriteMethod();
            if (wMeth != null && wMeth.getName().equals(name)) {
                return wMeth;
            }
            ++i;
        }
        return null;
    }

    private Class loadClass(String className) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return this.getClass().getClassLoader().loadClass(className);
        }
    }

    private String getSchedulerName() {
        return this.cfg.getStringProperty(PROP_SCHED_INSTANCE_NAME, "QuartzScheduler");
    }

    private String getSchedulerInstId() {
        return this.cfg.getStringProperty(PROP_SCHED_INSTANCE_ID, DEFAULT_INSTANCE_ID);
    }

    public Scheduler getScheduler() throws SchedulerException {
        SchedulerRepository schedRep;
        Scheduler sched;
        if (this.cfg == null) {
            this.initialize();
        }
        if ((sched = (schedRep = SchedulerRepository.getInstance()).lookup(this.getSchedulerName())) != null) {
            if (sched.isShutdown()) {
                schedRep.remove(this.getSchedulerName());
            } else {
                return sched;
            }
        }
        sched = this.instantiate();
        return sched;
    }

    public static Scheduler getDefaultScheduler() throws SchedulerException {
        StdSchedulerFactory fact = new StdSchedulerFactory();
        return fact.getScheduler();
    }

    public Scheduler getScheduler(String schedName) throws SchedulerException {
        return SchedulerRepository.getInstance().lookup(schedName);
    }

    public Collection getAllSchedulers() throws SchedulerException {
        return SchedulerRepository.getInstance().lookupAll();
    }
}

