/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.quartz.ee.jta;

import com.fr.third.org.quartz.Scheduler;
import com.fr.third.org.quartz.SchedulerException;
import com.fr.third.org.quartz.core.JobRunShell;
import com.fr.third.org.quartz.core.JobRunShellFactory;
import com.fr.third.org.quartz.core.SchedulingContext;
import com.fr.third.org.quartz.ee.jta.UserTransactionHelper;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

public class JTAJobRunShell
extends JobRunShell {
    private UserTransaction ut;

    public JTAJobRunShell(JobRunShellFactory jobRunShellFactory, Scheduler scheduler, SchedulingContext schdCtxt) {
        super(jobRunShellFactory, scheduler, schdCtxt);
    }

    protected void begin() throws SchedulerException {
        this.cleanupUserTransaction();
        boolean beganSuccessfully = false;
        try {
            try {
                this.getLog().debug("Looking up UserTransaction.");
                this.ut = UserTransactionHelper.lookupUserTransaction();
                this.getLog().debug("Beginning UserTransaction.");
                this.ut.begin();
                beganSuccessfully = true;
            }
            catch (SchedulerException se) {
                throw se;
            }
            catch (Exception nse) {
                throw new SchedulerException("JTAJobRunShell could not start UserTransaction.", nse);
            }
        }
        finally {
            if (!beganSuccessfully) {
                this.cleanupUserTransaction();
            }
        }
    }

    protected void complete(boolean successfulExecution) throws SchedulerException {
        block12: {
            if (this.ut == null) {
                return;
            }
            try {
                try {
                    if (this.ut.getStatus() == 1) {
                        this.getLog().debug("UserTransaction marked for rollback only.");
                        successfulExecution = false;
                    }
                }
                catch (SystemException e) {
                    throw new SchedulerException("JTAJobRunShell could not read UserTransaction status.", e);
                }
                if (successfulExecution) {
                    try {
                        this.getLog().debug("Committing UserTransaction.");
                        this.ut.commit();
                        break block12;
                    }
                    catch (Exception nse) {
                        throw new SchedulerException("JTAJobRunShell could not commit UserTransaction.", nse);
                    }
                }
                try {
                    this.getLog().debug("Rolling-back UserTransaction.");
                    this.ut.rollback();
                }
                catch (Exception nse) {
                    throw new SchedulerException("JTAJobRunShell could not rollback UserTransaction.", nse);
                }
            }
            finally {
                this.cleanupUserTransaction();
            }
        }
    }

    public void passivate() {
        this.cleanupUserTransaction();
        super.passivate();
    }

    private void cleanupUserTransaction() {
        if (this.ut != null) {
            UserTransactionHelper.returnUserTransaction(this.ut);
            this.ut = null;
        }
    }
}

