/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.util;

import java.io.UnsupportedEncodingException;
import java.text.FieldPosition;
import java.text.NumberFormat;

public class StringUtil {
    private static final String ENCODING = "ISO-8859-1";

    private StringUtil() {
    }

    public static String getFromUnicodeLE(byte[] byArray, int n, int n2) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (n < 0 || n >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException("Illegal offset");
        }
        if (n2 < 0 || (byArray.length - n) / 2 < n2) {
            throw new IllegalArgumentException("Illegal length");
        }
        try {
            return new String(byArray, n, n2 * 2, "UTF-16LE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError();
        }
    }

    public static String getFromUnicodeLE(byte[] byArray) {
        if (byArray.length == 0) {
            return "";
        }
        return StringUtil.getFromUnicodeLE(byArray, 0, byArray.length / 2);
    }

    public static String getFromUnicodeBE(byte[] byArray, int n, int n2) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (n < 0 || n >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException("Illegal offset");
        }
        if (n2 < 0 || (byArray.length - n) / 2 < n2) {
            throw new IllegalArgumentException("Illegal length");
        }
        try {
            return new String(byArray, n, n2 * 2, "UTF-16BE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError();
        }
    }

    public static String getFromUnicodeBE(byte[] byArray) {
        if (byArray.length == 0) {
            return "";
        }
        return StringUtil.getFromUnicodeBE(byArray, 0, byArray.length / 2);
    }

    public static String getFromCompressedUnicode(byte[] byArray, int n, int n2) {
        try {
            int n3 = Math.min(n2, byArray.length - n);
            return new String(byArray, n, n3, ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError();
        }
    }

    public static void putCompressedUnicode(String string, byte[] byArray, int n) {
        try {
            byte[] byArray2 = string.getBytes(ENCODING);
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError();
        }
    }

    public static void putUnicodeLE(String string, byte[] byArray, int n) {
        try {
            byte[] byArray2 = string.getBytes("UTF-16LE");
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError();
        }
    }

    public static void putUnicodeBE(String string, byte[] byArray, int n) {
        try {
            byte[] byArray2 = string.getBytes("UTF-16BE");
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError();
        }
    }

    public static String format(String string, Object[] objectArray) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '%') {
                if (n >= objectArray.length) {
                    stringBuffer.append("?missing data?");
                    continue;
                }
                if (objectArray[n] instanceof Number && i + 1 < string.length()) {
                    i += StringUtil.matchOptionalFormatting((Number)objectArray[n++], string.substring(i + 1), stringBuffer);
                    continue;
                }
                stringBuffer.append(objectArray[n++].toString());
                continue;
            }
            if (string.charAt(i) == '\\' && i + 1 < string.length() && string.charAt(i + 1) == '%') {
                stringBuffer.append('%');
                ++i;
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private static int matchOptionalFormatting(Number number, String string, StringBuffer stringBuffer) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (0 < string.length() && Character.isDigit(string.charAt(0))) {
            numberFormat.setMinimumIntegerDigits(Integer.parseInt(string.charAt(0) + ""));
            if (2 < string.length() && string.charAt(1) == '.' && Character.isDigit(string.charAt(2))) {
                numberFormat.setMaximumFractionDigits(Integer.parseInt(string.charAt(2) + ""));
                numberFormat.format(number, stringBuffer, new FieldPosition(0));
                return 3;
            }
            numberFormat.format(number, stringBuffer, new FieldPosition(0));
            return 1;
        }
        if (0 < string.length() && string.charAt(0) == '.' && 1 < string.length() && Character.isDigit(string.charAt(1))) {
            numberFormat.setMaximumFractionDigits(Integer.parseInt(string.charAt(1) + ""));
            numberFormat.format(number, stringBuffer, new FieldPosition(0));
            return 2;
        }
        numberFormat.format(number, stringBuffer, new FieldPosition(0));
        return 1;
    }

    public static String getPreferredEncoding() {
        return ENCODING;
    }

    public static boolean hasMultibyte(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= '\u00ff') continue;
            return true;
        }
        return false;
    }

    public static boolean isUnicodeString(String string) {
        try {
            return !string.equals(new String(string.getBytes(ENCODING), ENCODING));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return true;
        }
    }
}

