/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.util;

import com.fr.third.org.apache.poi.util.LittleEndianConsts;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class LittleEndian
implements LittleEndianConsts {
    private LittleEndian() {
    }

    public static short getShort(byte[] byArray, int n) {
        return (short)LittleEndian.getNumber(byArray, n, 2);
    }

    public static int getUShort(byte[] byArray, int n) {
        int n2 = (int)LittleEndian.getNumber(byArray, n, 2);
        int n3 = n2 < 0 ? 65536 + n2 : n2;
        return n3;
    }

    public static short[] getSimpleShortArray(byte[] byArray, int n, int n2) {
        short[] sArray = new short[n2];
        for (int i = 0; i < n2; ++i) {
            sArray[i] = LittleEndian.getShort(byArray, n + 2 + i * 2);
        }
        return sArray;
    }

    public static short[] getShortArray(byte[] byArray, int n) {
        int n2 = (int)LittleEndian.getNumber(byArray, n, 2);
        short[] sArray = LittleEndian.getSimpleShortArray(byArray, n, n2);
        return sArray;
    }

    public static short getShort(byte[] byArray) {
        return LittleEndian.getShort(byArray, 0);
    }

    public static int getUShort(byte[] byArray) {
        return LittleEndian.getUShort(byArray, 0);
    }

    public static int getInt(byte[] byArray, int n) {
        return (int)LittleEndian.getNumber(byArray, n, 4);
    }

    public static int getInt(byte[] byArray) {
        return LittleEndian.getInt(byArray, 0);
    }

    public static long getUInt(byte[] byArray, int n) {
        int n2 = (int)LittleEndian.getNumber(byArray, n, 4);
        long l = n2 < 0 ? 0x100000000L + (long)n2 : (long)n2;
        return l;
    }

    public static long getUInt(byte[] byArray) {
        return LittleEndian.getUInt(byArray, 0);
    }

    public static long getLong(byte[] byArray, int n) {
        return LittleEndian.getNumber(byArray, n, 8);
    }

    public static long getLong(byte[] byArray) {
        return LittleEndian.getLong(byArray, 0);
    }

    public static double getDouble(byte[] byArray, int n) {
        return Double.longBitsToDouble(LittleEndian.getNumber(byArray, n, 8));
    }

    public static double getDouble(byte[] byArray) {
        return LittleEndian.getDouble(byArray, 0);
    }

    public static void putShort(byte[] byArray, int n, short s) {
        LittleEndian.putNumber(byArray, n, s, 2);
    }

    public static void putByte(byte[] byArray, int n, int n2) {
        LittleEndian.putNumber(byArray, n, n2, 1);
    }

    public static void putShortArray(byte[] byArray, int n, short[] sArray) {
        LittleEndian.putNumber(byArray, n, sArray.length, 2);
        for (int i = 0; i < sArray.length; ++i) {
            LittleEndian.putNumber(byArray, n + 2 + i * 2, sArray[i], 2);
        }
    }

    public static void putUShort(byte[] byArray, int n, int n2) {
        LittleEndian.putNumber(byArray, n, n2, 2);
    }

    public static void putShort(byte[] byArray, short s) {
        LittleEndian.putShort(byArray, 0, s);
    }

    public static void putInt(byte[] byArray, int n, int n2) {
        LittleEndian.putNumber(byArray, n, n2, 4);
    }

    public static void putInt(byte[] byArray, int n) {
        LittleEndian.putInt(byArray, 0, n);
    }

    public static void putLong(byte[] byArray, int n, long l) {
        LittleEndian.putNumber(byArray, n, l, 8);
    }

    public static void putLong(byte[] byArray, long l) {
        LittleEndian.putLong(byArray, 0, l);
    }

    public static void putDouble(byte[] byArray, int n, double d) {
        if (Double.isNaN(d)) {
            LittleEndian.putNumber(byArray, n, -276939487313920L, 8);
        } else {
            LittleEndian.putNumber(byArray, n, Double.doubleToLongBits(d), 8);
        }
    }

    public static void putDouble(byte[] byArray, double d) {
        LittleEndian.putDouble(byArray, 0, d);
    }

    public static short readShort(InputStream inputStream) throws IOException, BufferUnderrunException {
        return LittleEndian.getShort(LittleEndian.readFromStream(inputStream, 2));
    }

    public static int readInt(InputStream inputStream) throws IOException, BufferUnderrunException {
        return LittleEndian.getInt(LittleEndian.readFromStream(inputStream, 4));
    }

    public static long readLong(InputStream inputStream) throws IOException, BufferUnderrunException {
        return LittleEndian.getLong(LittleEndian.readFromStream(inputStream, 8));
    }

    public static byte[] readFromStream(InputStream inputStream, int n) throws IOException, BufferUnderrunException {
        byte[] byArray = new byte[n];
        int n2 = inputStream.read(byArray);
        if (n2 == -1) {
            Arrays.fill(byArray, (byte)0);
        } else if (n2 != n) {
            throw new BufferUnderrunException();
        }
        return byArray;
    }

    private static long getNumber(byte[] byArray, int n, int n2) {
        long l = 0L;
        for (int i = n + n2 - 1; i >= n; --i) {
            l <<= 8;
            l |= (long)(0xFF & byArray[i]);
        }
        return l;
    }

    private static void putNumber(byte[] byArray, int n, long l, int n2) {
        int n3 = n2 + n;
        long l2 = l;
        for (int i = n; i < n3; ++i) {
            byArray[i] = (byte)(l2 & 0xFFL);
            l2 >>= 8;
        }
    }

    public static int ubyteToInt(byte n) {
        return (n & 0x80) == 0 ? n : (n & 0x7F) + 128;
    }

    public static int getUnsignedByte(byte[] byArray, int n) {
        return (int)LittleEndian.getNumber(byArray, n, 1);
    }

    public static int getUnsignedByte(byte[] byArray) {
        return LittleEndian.getUnsignedByte(byArray, 0);
    }

    public static byte[] getByteArray(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public static long getULong(byte[] byArray, int n) {
        int n2 = (int)LittleEndian.getNumber(byArray, n, 8);
        long l = n2 < 0 ? 0x100000000L + (long)n2 : (long)n2;
        return l;
    }

    public static class BufferUnderrunException
    extends IOException {
        BufferUnderrunException() {
            super("buffer underrun");
        }
    }
}

