/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;

public class HexDump {
    public static final String EOL = System.getProperty("line.separator");
    private static final char[] _hexcodes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int[] _shifts = new int[]{60, 56, 52, 48, 44, 40, 36, 32, 28, 24, 20, 16, 12, 8, 4, 0};

    private HexDump() {
    }

    public static synchronized void dump(byte[] byArray, long l, OutputStream outputStream, int n, int n2) throws IOException, ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (byArray.length == 0) {
            outputStream.write(("No Data" + System.getProperty("line.separator")).getBytes());
            outputStream.flush();
            return;
        }
        if (n < 0 || n >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException("illegal index: " + n + " into array of length " + byArray.length);
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("cannot write to nullstream");
        }
        long l2 = l + (long)n;
        StringBuffer stringBuffer = new StringBuffer(74);
        int n3 = Math.min(byArray.length, n + n2);
        for (int i = n; i < n3; i += 16) {
            int n4;
            int n5 = n3 - i;
            if (n5 > 16) {
                n5 = 16;
            }
            stringBuffer.append(HexDump.dump(l2)).append(' ');
            for (n4 = 0; n4 < 16; ++n4) {
                if (n4 < n5) {
                    stringBuffer.append(HexDump.dump(byArray[n4 + i]));
                } else {
                    stringBuffer.append("  ");
                }
                stringBuffer.append(' ');
            }
            for (n4 = 0; n4 < n5; ++n4) {
                if (byArray[n4 + i] >= 32 && byArray[n4 + i] < 127) {
                    stringBuffer.append((char)byArray[n4 + i]);
                    continue;
                }
                stringBuffer.append('.');
            }
            stringBuffer.append(EOL);
            outputStream.write(stringBuffer.toString().getBytes());
            outputStream.flush();
            stringBuffer.setLength(0);
            l2 += (long)n5;
        }
    }

    public static synchronized void dump(byte[] byArray, long l, OutputStream outputStream, int n) throws IOException, ArrayIndexOutOfBoundsException, IllegalArgumentException {
        HexDump.dump(byArray, l, outputStream, n, byArray.length - n);
    }

    public static String dump(byte[] byArray, long l, int n) {
        if (n < 0 || n >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException("illegal index: " + n + " into array of length " + byArray.length);
        }
        long l2 = l + (long)n;
        StringBuffer stringBuffer = new StringBuffer(74);
        for (int i = n; i < byArray.length; i += 16) {
            int n2;
            int n3 = byArray.length - i;
            if (n3 > 16) {
                n3 = 16;
            }
            stringBuffer.append(HexDump.dump(l2)).append(' ');
            for (n2 = 0; n2 < 16; ++n2) {
                if (n2 < n3) {
                    stringBuffer.append(HexDump.dump(byArray[n2 + i]));
                } else {
                    stringBuffer.append("  ");
                }
                stringBuffer.append(' ');
            }
            for (n2 = 0; n2 < n3; ++n2) {
                if (byArray[n2 + i] >= 32 && byArray[n2 + i] < 127) {
                    stringBuffer.append((char)byArray[n2 + i]);
                    continue;
                }
                stringBuffer.append('.');
            }
            stringBuffer.append(EOL);
            l2 += (long)n3;
        }
        return stringBuffer.toString();
    }

    private static String dump(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.setLength(0);
        for (int i = 0; i < 8; ++i) {
            stringBuffer.append(_hexcodes[(int)(l >> _shifts[i + _shifts.length - 8]) & 0xF]);
        }
        return stringBuffer.toString();
    }

    private static String dump(byte by) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.setLength(0);
        for (int i = 0; i < 2; ++i) {
            stringBuffer.append(_hexcodes[by >> _shifts[i + 6] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public static String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(HexDump.toHex(byArray[i]));
            stringBuffer.append(", ");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static String toHex(short[] sArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        for (int i = 0; i < sArray.length; ++i) {
            stringBuffer.append(HexDump.toHex(sArray[i]));
            stringBuffer.append(", ");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static String toHex(byte[] byArray, int n) {
        int n2 = (int)Math.round(Math.log(byArray.length) / Math.log(10.0) + 0.5);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(": ");
        DecimalFormat decimalFormat = new DecimalFormat(stringBuffer.toString());
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(decimalFormat.format(0L));
        int n3 = -1;
        for (int i = 0; i < byArray.length; ++i) {
            if (++n3 == n) {
                stringBuffer2.append('\n');
                stringBuffer2.append(decimalFormat.format(i));
                n3 = 0;
            }
            stringBuffer2.append(HexDump.toHex(byArray[i]));
            stringBuffer2.append(", ");
        }
        return stringBuffer2.toString();
    }

    public static String toHex(short s) {
        return HexDump.toHex(s, 4);
    }

    public static String toHex(byte by) {
        return HexDump.toHex(by, 2);
    }

    public static String toHex(int n) {
        return HexDump.toHex(n, 8);
    }

    public static String toHex(long l) {
        return HexDump.toHex(l, 16);
    }

    private static String toHex(long l, int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(_hexcodes[(int)(l >> _shifts[i + (16 - n)] & 0xFL)]);
        }
        return stringBuffer.toString();
    }

    public static void dump(InputStream inputStream, PrintStream printStream, int n, int n2) throws IOException {
        int n3;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (n2 == -1) {
            n3 = inputStream.read();
            while (n3 != -1) {
                byteArrayOutputStream.write(n3);
                n3 = inputStream.read();
            }
        } else {
            int n4;
            n3 = n2;
            while (n3-- > 0 && (n4 = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n4);
            }
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        HexDump.dump(byArray, 0L, printStream, n, byArray.length);
    }

    public static void main(String[] stringArray) throws Exception {
        File file = new File(stringArray[0]);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        byte[] byArray = new byte[(int)file.length()];
        ((InputStream)bufferedInputStream).read(byArray);
        System.out.println(HexDump.dump(byArray, 0L, 0));
        ((InputStream)bufferedInputStream).close();
    }
}

