/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.util;

public class DoubleList {
    private double[] _array;
    private int _limit;
    private static final int _default_size = 128;

    public DoubleList() {
        this(128);
    }

    public DoubleList(DoubleList doubleList) {
        this(doubleList._array.length);
        System.arraycopy(doubleList._array, 0, this._array, 0, this._array.length);
        this._limit = doubleList._limit;
    }

    public DoubleList(int n) {
        this._array = new double[n];
        this._limit = 0;
    }

    public void add(int n, double d) {
        if (n > this._limit) {
            throw new IndexOutOfBoundsException();
        }
        if (n == this._limit) {
            this.add(d);
        } else {
            if (this._limit == this._array.length) {
                this.growArray(this._limit * 2);
            }
            System.arraycopy(this._array, n, this._array, n + 1, this._limit - n);
            this._array[n] = d;
            ++this._limit;
        }
    }

    public boolean add(double d) {
        if (this._limit == this._array.length) {
            this.growArray(this._limit * 2);
        }
        this._array[this._limit++] = d;
        return true;
    }

    public boolean addAll(DoubleList doubleList) {
        if (doubleList._limit != 0) {
            if (this._limit + doubleList._limit > this._array.length) {
                this.growArray(this._limit + doubleList._limit);
            }
            System.arraycopy(doubleList._array, 0, this._array, this._limit, doubleList._limit);
            this._limit += doubleList._limit;
        }
        return true;
    }

    public boolean addAll(int n, DoubleList doubleList) {
        if (n > this._limit) {
            throw new IndexOutOfBoundsException();
        }
        if (doubleList._limit != 0) {
            if (this._limit + doubleList._limit > this._array.length) {
                this.growArray(this._limit + doubleList._limit);
            }
            System.arraycopy(this._array, n, this._array, n + doubleList._limit, this._limit - n);
            System.arraycopy(doubleList._array, 0, this._array, n, doubleList._limit);
            this._limit += doubleList._limit;
        }
        return true;
    }

    public void clear() {
        this._limit = 0;
    }

    public boolean contains(double d) {
        boolean bl = false;
        for (int i = 0; !bl && i < this._limit; ++i) {
            if (this._array[i] != d) continue;
            bl = true;
        }
        return bl;
    }

    public boolean containsAll(DoubleList doubleList) {
        boolean bl = true;
        if (this != doubleList) {
            for (int i = 0; bl && i < doubleList._limit; ++i) {
                if (this.contains(doubleList._array[i])) continue;
                bl = false;
            }
        }
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && object != null && object.getClass() == this.getClass()) {
            DoubleList doubleList = (DoubleList)object;
            if (doubleList._limit == this._limit) {
                bl = true;
                for (int i = 0; bl && i < this._limit; ++i) {
                    bl = this._array[i] == doubleList._array[i];
                }
            }
        }
        return bl;
    }

    public double get(int n) {
        if (n >= this._limit) {
            throw new IndexOutOfBoundsException();
        }
        return this._array[n];
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this._limit; ++i) {
            n = 31 * n + (int)this._array[i];
        }
        return n;
    }

    public int indexOf(double d) {
        int n;
        for (n = 0; n < this._limit && d != this._array[n]; ++n) {
        }
        if (n == this._limit) {
            n = -1;
        }
        return n;
    }

    public boolean isEmpty() {
        return this._limit == 0;
    }

    public int lastIndexOf(double d) {
        int n;
        for (n = this._limit - 1; n >= 0 && d != this._array[n]; --n) {
        }
        return n;
    }

    public double remove(int n) {
        if (n >= this._limit) {
            throw new IndexOutOfBoundsException();
        }
        double d = this._array[n];
        System.arraycopy(this._array, n + 1, this._array, n, this._limit - n);
        --this._limit;
        return d;
    }

    public boolean removeValue(double d) {
        boolean bl = false;
        for (int i = 0; !bl && i < this._limit; ++i) {
            if (d != this._array[i]) continue;
            System.arraycopy(this._array, i + 1, this._array, i, this._limit - i);
            --this._limit;
            bl = true;
        }
        return bl;
    }

    public boolean removeAll(DoubleList doubleList) {
        boolean bl = false;
        for (int i = 0; i < doubleList._limit; ++i) {
            if (!this.removeValue(doubleList._array[i])) continue;
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(DoubleList doubleList) {
        boolean bl = false;
        int n = 0;
        while (n < this._limit) {
            if (!doubleList.contains(this._array[n])) {
                this.remove(n);
                bl = true;
                continue;
            }
            ++n;
        }
        return bl;
    }

    public double set(int n, double d) {
        if (n >= this._limit) {
            throw new IndexOutOfBoundsException();
        }
        double d2 = this._array[n];
        this._array[n] = d;
        return d2;
    }

    public int size() {
        return this._limit;
    }

    public double[] toArray() {
        double[] dArray = new double[this._limit];
        System.arraycopy(this._array, 0, dArray, 0, this._limit);
        return dArray;
    }

    public double[] toArray(double[] dArray) {
        double[] dArray2;
        if (dArray.length == this._limit) {
            System.arraycopy(this._array, 0, dArray, 0, this._limit);
            dArray2 = dArray;
        } else {
            dArray2 = this.toArray();
        }
        return dArray2;
    }

    private void growArray(int n) {
        int n2 = n == this._array.length ? n + 1 : n;
        double[] dArray = new double[n2];
        System.arraycopy(this._array, 0, dArray, 0, this._limit);
        this._array = dArray;
    }
}

