/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.util;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class BinaryTree
extends AbstractMap {
    private Node[] _root = new Node[]{null, null};
    private int _size = 0;
    private int _modifications = 0;
    private Set[] _key_set = new Set[]{null, null};
    private Set[] _entry_set = new Set[]{null, null};
    private Collection[] _value_collection = new Collection[]{null, null};
    private static final int _KEY = 0;
    private static final int _VALUE = 1;
    private static final int _INDEX_SUM = 1;
    private static final int _MINIMUM_INDEX = 0;
    private static final int _INDEX_COUNT = 2;
    private static final String[] _data_name = new String[]{"key", "value"};

    public BinaryTree() {
    }

    public BinaryTree(Map map) throws ClassCastException, NullPointerException, IllegalArgumentException {
        this.putAll(map);
    }

    public Object getKeyForValue(Object object) throws ClassCastException, NullPointerException {
        return this.doGet((Comparable)object, 1);
    }

    public Object removeValue(Object object) {
        return this.doRemove((Comparable)object, 1);
    }

    public Set entrySetByValue() {
        if (this._entry_set[1] == null) {
            this._entry_set[1] = new AbstractSet(){

                public Iterator iterator() {
                    return new BinaryTreeIterator(this, 1){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected Object doGetNext() {
                            return this._last_returned_node;
                        }
                    };
                }

                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object k = entry.getKey();
                    Node node = BinaryTree.this.lookup((Comparable)entry.getValue(), 1);
                    return node != null && node.getData(0).equals(k);
                }

                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object k = entry.getKey();
                    Node node = BinaryTree.this.lookup((Comparable)entry.getValue(), 1);
                    if (node != null && node.getData(0).equals(k)) {
                        BinaryTree.this.doRedBlackDelete(node);
                        return true;
                    }
                    return false;
                }

                public int size() {
                    return BinaryTree.this.size();
                }

                public void clear() {
                    BinaryTree.this.clear();
                }

                static /* synthetic */ BinaryTree access$000(1 var0) {
                    return var0.BinaryTree.this;
                }
            };
        }
        return this._entry_set[1];
    }

    public Set keySetByValue() {
        if (this._key_set[1] == null) {
            this._key_set[1] = new AbstractSet(){

                public Iterator iterator() {
                    return new BinaryTreeIterator(this, 1){
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected Object doGetNext() {
                            return Node.access$200(this._last_returned_node, 0);
                        }
                    };
                }

                public int size() {
                    return BinaryTree.this.size();
                }

                public boolean contains(Object object) {
                    return BinaryTree.this.containsKey(object);
                }

                public boolean remove(Object object) {
                    int n = BinaryTree.this._size;
                    BinaryTree.this.remove(object);
                    return BinaryTree.this._size != n;
                }

                public void clear() {
                    BinaryTree.this.clear();
                }

                static /* synthetic */ BinaryTree access$400(3 var0) {
                    return var0.BinaryTree.this;
                }
            };
        }
        return this._key_set[1];
    }

    public Collection valuesByValue() {
        if (this._value_collection[1] == null) {
            this._value_collection[1] = new AbstractCollection(){

                public Iterator iterator() {
                    return new BinaryTreeIterator(this, 1){
                        private final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected Object doGetNext() {
                            return Node.access$200(this._last_returned_node, 1);
                        }
                    };
                }

                public int size() {
                    return BinaryTree.this.size();
                }

                public boolean contains(Object object) {
                    return BinaryTree.this.containsValue(object);
                }

                public boolean remove(Object object) {
                    int n = BinaryTree.this._size;
                    BinaryTree.this.removeValue(object);
                    return BinaryTree.this._size != n;
                }

                public boolean removeAll(Collection collection) {
                    boolean bl = false;
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        if (BinaryTree.this.removeValue(iterator.next()) == null) continue;
                        bl = true;
                    }
                    return bl;
                }

                public void clear() {
                    BinaryTree.this.clear();
                }

                static /* synthetic */ BinaryTree access$600(5 var0) {
                    return var0.BinaryTree.this;
                }
            };
        }
        return this._value_collection[1];
    }

    private Object doRemove(Comparable comparable, int n) {
        Node node = this.lookup(comparable, n);
        Comparable comparable2 = null;
        if (node != null) {
            comparable2 = node.getData(this.oppositeIndex(n));
            this.doRedBlackDelete(node);
        }
        return comparable2;
    }

    private Object doGet(Comparable comparable, int n) {
        BinaryTree.checkNonNullComparable(comparable, n);
        Node node = this.lookup(comparable, n);
        return node == null ? null : node.getData(this.oppositeIndex(n));
    }

    private int oppositeIndex(int n) {
        return 1 - n;
    }

    private Node lookup(Comparable comparable, int n) {
        Node node = null;
        Node node2 = this._root[n];
        while (node2 != null) {
            int n2 = BinaryTree.compare(comparable, node2.getData(n));
            if (n2 == 0) {
                node = node2;
                break;
            }
            node2 = n2 < 0 ? node2.getLeft(n) : node2.getRight(n);
        }
        return node;
    }

    private static int compare(Comparable comparable, Comparable comparable2) {
        return comparable.compareTo(comparable2);
    }

    private static Node leastNode(Node node, int n) {
        Node node2 = node;
        if (node2 != null) {
            while (node2.getLeft(n) != null) {
                node2 = node2.getLeft(n);
            }
        }
        return node2;
    }

    private Node nextGreater(Node node, int n) {
        Node node2 = null;
        if (node == null) {
            node2 = null;
        } else if (node.getRight(n) != null) {
            node2 = BinaryTree.leastNode(node.getRight(n), n);
        } else {
            Node node3 = node.getParent(n);
            Node node4 = node;
            while (node3 != null && node4 == node3.getRight(n)) {
                node4 = node3;
                node3 = node3.getParent(n);
            }
            node2 = node3;
        }
        return node2;
    }

    private static void copyColor(Node node, Node node2, int n) {
        if (node2 != null) {
            if (node == null) {
                node2.setBlack(n);
            } else {
                node2.copyColor(node, n);
            }
        }
    }

    private static boolean isRed(Node node, int n) {
        return node == null ? false : node.isRed(n);
    }

    private static boolean isBlack(Node node, int n) {
        return node == null ? true : node.isBlack(n);
    }

    private static void makeRed(Node node, int n) {
        if (node != null) {
            node.setRed(n);
        }
    }

    private static void makeBlack(Node node, int n) {
        if (node != null) {
            node.setBlack(n);
        }
    }

    private static Node getGrandParent(Node node, int n) {
        return BinaryTree.getParent(BinaryTree.getParent(node, n), n);
    }

    private static Node getParent(Node node, int n) {
        return node == null ? null : node.getParent(n);
    }

    private static Node getRightChild(Node node, int n) {
        return node == null ? null : node.getRight(n);
    }

    private static Node getLeftChild(Node node, int n) {
        return node == null ? null : node.getLeft(n);
    }

    private static boolean isLeftChild(Node node, int n) {
        return node == null ? true : (node.getParent(n) == null ? false : node == node.getParent(n).getLeft(n));
    }

    private static boolean isRightChild(Node node, int n) {
        return node == null ? true : (node.getParent(n) == null ? false : node == node.getParent(n).getRight(n));
    }

    private void rotateLeft(Node node, int n) {
        Node node2 = node.getRight(n);
        node.setRight(node2.getLeft(n), n);
        if (node2.getLeft(n) != null) {
            node2.getLeft(n).setParent(node, n);
        }
        node2.setParent(node.getParent(n), n);
        if (node.getParent(n) == null) {
            this._root[n] = node2;
        } else if (node.getParent(n).getLeft(n) == node) {
            node.getParent(n).setLeft(node2, n);
        } else {
            node.getParent(n).setRight(node2, n);
        }
        node2.setLeft(node, n);
        node.setParent(node2, n);
    }

    private void rotateRight(Node node, int n) {
        Node node2 = node.getLeft(n);
        node.setLeft(node2.getRight(n), n);
        if (node2.getRight(n) != null) {
            node2.getRight(n).setParent(node, n);
        }
        node2.setParent(node.getParent(n), n);
        if (node.getParent(n) == null) {
            this._root[n] = node2;
        } else if (node.getParent(n).getRight(n) == node) {
            node.getParent(n).setRight(node2, n);
        } else {
            node.getParent(n).setLeft(node2, n);
        }
        node2.setRight(node, n);
        node.setParent(node2, n);
    }

    private void doRedBlackInsert(Node node, int n) {
        Node node2 = node;
        BinaryTree.makeRed(node2, n);
        while (node2 != null && node2 != this._root[n] && BinaryTree.isRed(node2.getParent(n), n)) {
            Node node3;
            if (BinaryTree.isLeftChild(BinaryTree.getParent(node2, n), n)) {
                node3 = BinaryTree.getRightChild(BinaryTree.getGrandParent(node2, n), n);
                if (BinaryTree.isRed(node3, n)) {
                    BinaryTree.makeBlack(BinaryTree.getParent(node2, n), n);
                    BinaryTree.makeBlack(node3, n);
                    BinaryTree.makeRed(BinaryTree.getGrandParent(node2, n), n);
                    node2 = BinaryTree.getGrandParent(node2, n);
                    continue;
                }
                if (BinaryTree.isRightChild(node2, n)) {
                    node2 = BinaryTree.getParent(node2, n);
                    this.rotateLeft(node2, n);
                }
                BinaryTree.makeBlack(BinaryTree.getParent(node2, n), n);
                BinaryTree.makeRed(BinaryTree.getGrandParent(node2, n), n);
                if (BinaryTree.getGrandParent(node2, n) == null) continue;
                this.rotateRight(BinaryTree.getGrandParent(node2, n), n);
                continue;
            }
            node3 = BinaryTree.getLeftChild(BinaryTree.getGrandParent(node2, n), n);
            if (BinaryTree.isRed(node3, n)) {
                BinaryTree.makeBlack(BinaryTree.getParent(node2, n), n);
                BinaryTree.makeBlack(node3, n);
                BinaryTree.makeRed(BinaryTree.getGrandParent(node2, n), n);
                node2 = BinaryTree.getGrandParent(node2, n);
                continue;
            }
            if (BinaryTree.isLeftChild(node2, n)) {
                node2 = BinaryTree.getParent(node2, n);
                this.rotateRight(node2, n);
            }
            BinaryTree.makeBlack(BinaryTree.getParent(node2, n), n);
            BinaryTree.makeRed(BinaryTree.getGrandParent(node2, n), n);
            if (BinaryTree.getGrandParent(node2, n) == null) continue;
            this.rotateLeft(BinaryTree.getGrandParent(node2, n), n);
        }
        BinaryTree.makeBlack(this._root[n], n);
    }

    private void doRedBlackDelete(Node node) {
        for (int i = 0; i < 2; ++i) {
            Node node2;
            if (node.getLeft(i) != null && node.getRight(i) != null) {
                this.swapPosition(this.nextGreater(node, i), node, i);
            }
            Node node3 = node2 = node.getLeft(i) != null ? node.getLeft(i) : node.getRight(i);
            if (node2 != null) {
                node2.setParent(node.getParent(i), i);
                if (node.getParent(i) == null) {
                    this._root[i] = node2;
                } else if (node == node.getParent(i).getLeft(i)) {
                    node.getParent(i).setLeft(node2, i);
                } else {
                    node.getParent(i).setRight(node2, i);
                }
                node.setLeft(null, i);
                node.setRight(null, i);
                node.setParent(null, i);
                if (!BinaryTree.isBlack(node, i)) continue;
                this.doRedBlackDeleteFixup(node2, i);
                continue;
            }
            if (node.getParent(i) == null) {
                this._root[i] = null;
                continue;
            }
            if (BinaryTree.isBlack(node, i)) {
                this.doRedBlackDeleteFixup(node, i);
            }
            if (node.getParent(i) == null) continue;
            if (node == node.getParent(i).getLeft(i)) {
                node.getParent(i).setLeft(null, i);
            } else {
                node.getParent(i).setRight(null, i);
            }
            node.setParent(null, i);
        }
        this.shrink();
    }

    private void doRedBlackDeleteFixup(Node node, int n) {
        Node node2 = node;
        while (node2 != this._root[n] && BinaryTree.isBlack(node2, n)) {
            Node node3;
            if (BinaryTree.isLeftChild(node2, n)) {
                node3 = BinaryTree.getRightChild(BinaryTree.getParent(node2, n), n);
                if (BinaryTree.isRed(node3, n)) {
                    BinaryTree.makeBlack(node3, n);
                    BinaryTree.makeRed(BinaryTree.getParent(node2, n), n);
                    this.rotateLeft(BinaryTree.getParent(node2, n), n);
                    node3 = BinaryTree.getRightChild(BinaryTree.getParent(node2, n), n);
                }
                if (BinaryTree.isBlack(BinaryTree.getLeftChild(node3, n), n) && BinaryTree.isBlack(BinaryTree.getRightChild(node3, n), n)) {
                    BinaryTree.makeRed(node3, n);
                    node2 = BinaryTree.getParent(node2, n);
                    continue;
                }
                if (BinaryTree.isBlack(BinaryTree.getRightChild(node3, n), n)) {
                    BinaryTree.makeBlack(BinaryTree.getLeftChild(node3, n), n);
                    BinaryTree.makeRed(node3, n);
                    this.rotateRight(node3, n);
                    node3 = BinaryTree.getRightChild(BinaryTree.getParent(node2, n), n);
                }
                BinaryTree.copyColor(BinaryTree.getParent(node2, n), node3, n);
                BinaryTree.makeBlack(BinaryTree.getParent(node2, n), n);
                BinaryTree.makeBlack(BinaryTree.getRightChild(node3, n), n);
                this.rotateLeft(BinaryTree.getParent(node2, n), n);
                node2 = this._root[n];
                continue;
            }
            node3 = BinaryTree.getLeftChild(BinaryTree.getParent(node2, n), n);
            if (BinaryTree.isRed(node3, n)) {
                BinaryTree.makeBlack(node3, n);
                BinaryTree.makeRed(BinaryTree.getParent(node2, n), n);
                this.rotateRight(BinaryTree.getParent(node2, n), n);
                node3 = BinaryTree.getLeftChild(BinaryTree.getParent(node2, n), n);
            }
            if (BinaryTree.isBlack(BinaryTree.getRightChild(node3, n), n) && BinaryTree.isBlack(BinaryTree.getLeftChild(node3, n), n)) {
                BinaryTree.makeRed(node3, n);
                node2 = BinaryTree.getParent(node2, n);
                continue;
            }
            if (BinaryTree.isBlack(BinaryTree.getLeftChild(node3, n), n)) {
                BinaryTree.makeBlack(BinaryTree.getRightChild(node3, n), n);
                BinaryTree.makeRed(node3, n);
                this.rotateLeft(node3, n);
                node3 = BinaryTree.getLeftChild(BinaryTree.getParent(node2, n), n);
            }
            BinaryTree.copyColor(BinaryTree.getParent(node2, n), node3, n);
            BinaryTree.makeBlack(BinaryTree.getParent(node2, n), n);
            BinaryTree.makeBlack(BinaryTree.getLeftChild(node3, n), n);
            this.rotateRight(BinaryTree.getParent(node2, n), n);
            node2 = this._root[n];
        }
        BinaryTree.makeBlack(node2, n);
    }

    private void swapPosition(Node node, Node node2, int n) {
        boolean bl;
        Node node3 = node.getParent(n);
        Node node4 = node.getLeft(n);
        Node node5 = node.getRight(n);
        Node node6 = node2.getParent(n);
        Node node7 = node2.getLeft(n);
        Node node8 = node2.getRight(n);
        boolean bl2 = node.getParent(n) != null && node == node.getParent(n).getLeft(n);
        boolean bl3 = bl = node2.getParent(n) != null && node2 == node2.getParent(n).getLeft(n);
        if (node == node6) {
            node.setParent(node2, n);
            if (bl) {
                node2.setLeft(node, n);
                node2.setRight(node5, n);
            } else {
                node2.setRight(node, n);
                node2.setLeft(node4, n);
            }
        } else {
            node.setParent(node6, n);
            if (node6 != null) {
                if (bl) {
                    node6.setLeft(node, n);
                } else {
                    node6.setRight(node, n);
                }
            }
            node2.setLeft(node4, n);
            node2.setRight(node5, n);
        }
        if (node2 == node3) {
            node2.setParent(node, n);
            if (bl2) {
                node.setLeft(node2, n);
                node.setRight(node8, n);
            } else {
                node.setRight(node2, n);
                node.setLeft(node7, n);
            }
        } else {
            node2.setParent(node3, n);
            if (node3 != null) {
                if (bl2) {
                    node3.setLeft(node2, n);
                } else {
                    node3.setRight(node2, n);
                }
            }
            node.setLeft(node7, n);
            node.setRight(node8, n);
        }
        if (node.getLeft(n) != null) {
            node.getLeft(n).setParent(node, n);
        }
        if (node.getRight(n) != null) {
            node.getRight(n).setParent(node, n);
        }
        if (node2.getLeft(n) != null) {
            node2.getLeft(n).setParent(node2, n);
        }
        if (node2.getRight(n) != null) {
            node2.getRight(n).setParent(node2, n);
        }
        node.swapColors(node2, n);
        if (this._root[n] == node) {
            this._root[n] = node2;
        } else if (this._root[n] == node2) {
            this._root[n] = node;
        }
    }

    private static void checkNonNullComparable(Object object, int n) {
        if (object == null) {
            throw new NullPointerException(_data_name[n] + " cannot be null");
        }
        if (!(object instanceof Comparable)) {
            throw new ClassCastException(_data_name[n] + " must be Comparable");
        }
    }

    private static void checkKey(Object object) {
        BinaryTree.checkNonNullComparable(object, 0);
    }

    private static void checkValue(Object object) {
        BinaryTree.checkNonNullComparable(object, 1);
    }

    private static void checkKeyAndValue(Object object, Object object2) {
        BinaryTree.checkKey(object);
        BinaryTree.checkValue(object2);
    }

    private void modify() {
        ++this._modifications;
    }

    private void grow() {
        this.modify();
        ++this._size;
    }

    private void shrink() {
        this.modify();
        --this._size;
    }

    private void insertValue(Node node) throws IllegalArgumentException {
        block4: {
            Node node2 = this._root[1];
            while (true) {
                int n;
                if ((n = BinaryTree.compare(node.getData(1), node2.getData(1))) == 0) {
                    throw new IllegalArgumentException("Cannot store a duplicate value (\"" + node.getData(1) + "\") in this Map");
                }
                if (n < 0) {
                    if (node2.getLeft(1) != null) {
                        node2 = node2.getLeft(1);
                        continue;
                    }
                    node2.setLeft(node, 1);
                    node.setParent(node2, 1);
                    this.doRedBlackInsert(node, 1);
                    break block4;
                }
                if (node2.getRight(1) == null) break;
                node2 = node2.getRight(1);
            }
            node2.setRight(node, 1);
            node.setParent(node2, 1);
            this.doRedBlackInsert(node, 1);
        }
    }

    public int size() {
        return this._size;
    }

    public boolean containsKey(Object object) throws ClassCastException, NullPointerException {
        BinaryTree.checkKey(object);
        return this.lookup((Comparable)object, 0) != null;
    }

    public boolean containsValue(Object object) {
        BinaryTree.checkValue(object);
        return this.lookup((Comparable)object, 1) != null;
    }

    public Object get(Object object) throws ClassCastException, NullPointerException {
        return this.doGet((Comparable)object, 0);
    }

    public Object put(Object object, Object object2) throws ClassCastException, NullPointerException, IllegalArgumentException {
        block6: {
            BinaryTree.checkKeyAndValue(object, object2);
            Node node = this._root[0];
            if (node == null) {
                Node node2;
                this._root[0] = node2 = new Node((Comparable)object, (Comparable)object2);
                this._root[1] = node2;
                this.grow();
            } else {
                while (true) {
                    int n;
                    if ((n = BinaryTree.compare((Comparable)object, node.getData(0))) == 0) {
                        throw new IllegalArgumentException("Cannot store a duplicate key (\"" + object + "\") in this Map");
                    }
                    if (n < 0) {
                        if (node.getLeft(0) != null) {
                            node = node.getLeft(0);
                            continue;
                        }
                        Node node3 = new Node((Comparable)object, (Comparable)object2);
                        this.insertValue(node3);
                        node.setLeft(node3, 0);
                        node3.setParent(node, 0);
                        this.doRedBlackInsert(node3, 0);
                        this.grow();
                        break block6;
                    }
                    if (node.getRight(0) == null) break;
                    node = node.getRight(0);
                }
                Node node4 = new Node((Comparable)object, (Comparable)object2);
                this.insertValue(node4);
                node.setRight(node4, 0);
                node4.setParent(node, 0);
                this.doRedBlackInsert(node4, 0);
                this.grow();
            }
        }
        return null;
    }

    public Object remove(Object object) {
        return this.doRemove((Comparable)object, 0);
    }

    public void clear() {
        this.modify();
        this._size = 0;
        this._root[0] = null;
        this._root[1] = null;
    }

    public Set keySet() {
        if (this._key_set[0] == null) {
            this._key_set[0] = new AbstractSet(){

                public Iterator iterator() {
                    return new BinaryTreeIterator(this, 0){
                        private final /* synthetic */ 7 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected Object doGetNext() {
                            return Node.access$200(this._last_returned_node, 0);
                        }
                    };
                }

                public int size() {
                    return BinaryTree.this.size();
                }

                public boolean contains(Object object) {
                    return BinaryTree.this.containsKey(object);
                }

                public boolean remove(Object object) {
                    int n = BinaryTree.this._size;
                    BinaryTree.this.remove(object);
                    return BinaryTree.this._size != n;
                }

                public void clear() {
                    BinaryTree.this.clear();
                }

                static /* synthetic */ BinaryTree access$1900(7 var0) {
                    return var0.BinaryTree.this;
                }
            };
        }
        return this._key_set[0];
    }

    public Collection values() {
        if (this._value_collection[0] == null) {
            this._value_collection[0] = new AbstractCollection(){

                public Iterator iterator() {
                    return new BinaryTreeIterator(this, 0){
                        private final /* synthetic */ 9 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected Object doGetNext() {
                            return Node.access$200(this._last_returned_node, 1);
                        }
                    };
                }

                public int size() {
                    return BinaryTree.this.size();
                }

                public boolean contains(Object object) {
                    return BinaryTree.this.containsValue(object);
                }

                public boolean remove(Object object) {
                    int n = BinaryTree.this._size;
                    BinaryTree.this.removeValue(object);
                    return BinaryTree.this._size != n;
                }

                public boolean removeAll(Collection collection) {
                    boolean bl = false;
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        if (BinaryTree.this.removeValue(iterator.next()) == null) continue;
                        bl = true;
                    }
                    return bl;
                }

                public void clear() {
                    BinaryTree.this.clear();
                }

                static /* synthetic */ BinaryTree access$2000(9 var0) {
                    return var0.BinaryTree.this;
                }
            };
        }
        return this._value_collection[0];
    }

    public Set entrySet() {
        if (this._entry_set[0] == null) {
            this._entry_set[0] = new AbstractSet(){

                public Iterator iterator() {
                    return new BinaryTreeIterator(this, 0){
                        private final /* synthetic */ 11 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected Object doGetNext() {
                            return this._last_returned_node;
                        }
                    };
                }

                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object v = entry.getValue();
                    Node node = BinaryTree.this.lookup((Comparable)entry.getKey(), 0);
                    return node != null && node.getData(1).equals(v);
                }

                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object v = entry.getValue();
                    Node node = BinaryTree.this.lookup((Comparable)entry.getKey(), 0);
                    if (node != null && node.getData(1).equals(v)) {
                        BinaryTree.this.doRedBlackDelete(node);
                        return true;
                    }
                    return false;
                }

                public int size() {
                    return BinaryTree.this.size();
                }

                public void clear() {
                    BinaryTree.this.clear();
                }

                static /* synthetic */ BinaryTree access$2100(11 var0) {
                    return var0.BinaryTree.this;
                }
            };
        }
        return this._entry_set[0];
    }

    private static final class Node
    implements Map.Entry {
        private Comparable[] _data;
        private Node[] _left;
        private Node[] _right;
        private Node[] _parent;
        private boolean[] _black;
        private int _hashcode;
        private boolean _calculated_hashcode;

        Node(Comparable comparable, Comparable comparable2) {
            this._data = new Comparable[]{comparable, comparable2};
            this._left = new Node[]{null, null};
            this._right = new Node[]{null, null};
            this._parent = new Node[]{null, null};
            this._black = new boolean[]{true, true};
            this._calculated_hashcode = false;
        }

        private Comparable getData(int n) {
            return this._data[n];
        }

        private void setLeft(Node node, int n) {
            this._left[n] = node;
        }

        private Node getLeft(int n) {
            return this._left[n];
        }

        private void setRight(Node node, int n) {
            this._right[n] = node;
        }

        private Node getRight(int n) {
            return this._right[n];
        }

        private void setParent(Node node, int n) {
            this._parent[n] = node;
        }

        private Node getParent(int n) {
            return this._parent[n];
        }

        private void swapColors(Node node, int n) {
            int n2 = n;
            this._black[n2] = this._black[n2] ^ node._black[n];
            int n3 = n;
            node._black[n3] = node._black[n3] ^ this._black[n];
            int n4 = n;
            this._black[n4] = this._black[n4] ^ node._black[n];
        }

        private boolean isBlack(int n) {
            return this._black[n];
        }

        private boolean isRed(int n) {
            return !this._black[n];
        }

        private void setBlack(int n) {
            this._black[n] = true;
        }

        private void setRed(int n) {
            this._black[n] = false;
        }

        private void copyColor(Node node, int n) {
            this._black[n] = node._black[n];
        }

        public Object getKey() {
            return this._data[0];
        }

        public Object getValue() {
            return this._data[1];
        }

        public Object setValue(Object object) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Map.Entry.setValue is not supported");
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this._data[0].equals(entry.getKey()) && this._data[1].equals(entry.getValue());
        }

        public int hashCode() {
            if (!this._calculated_hashcode) {
                this._hashcode = this._data[0].hashCode() ^ this._data[1].hashCode();
                this._calculated_hashcode = true;
            }
            return this._hashcode;
        }
    }

    private abstract class BinaryTreeIterator
    implements Iterator {
        private int _expected_modifications;
        protected Node _last_returned_node;
        private Node _next_node;
        private int _type;

        BinaryTreeIterator(int n) {
            this._type = n;
            this._expected_modifications = BinaryTree.this._modifications;
            this._last_returned_node = null;
            this._next_node = BinaryTree.leastNode(BinaryTree.this._root[this._type], this._type);
        }

        protected abstract Object doGetNext();

        public final boolean hasNext() {
            return this._next_node != null;
        }

        public final Object next() throws NoSuchElementException, ConcurrentModificationException {
            if (this._next_node == null) {
                throw new NoSuchElementException();
            }
            if (BinaryTree.this._modifications != this._expected_modifications) {
                throw new ConcurrentModificationException();
            }
            this._last_returned_node = this._next_node;
            this._next_node = BinaryTree.this.nextGreater(this._next_node, this._type);
            return this.doGetNext();
        }

        public final void remove() throws IllegalStateException, ConcurrentModificationException {
            if (this._last_returned_node == null) {
                throw new IllegalStateException();
            }
            if (BinaryTree.this._modifications != this._expected_modifications) {
                throw new ConcurrentModificationException();
            }
            BinaryTree.this.doRedBlackDelete(this._last_returned_node);
            ++this._expected_modifications;
            this._last_returned_node = null;
        }
    }
}

