/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.poifs.storage;

import com.fr.third.org.apache.poi.poifs.storage.BlockWritable;
import com.fr.third.org.apache.poi.poifs.storage.ListManagedBlock;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SmallDocumentBlock
implements BlockWritable,
ListManagedBlock {
    private byte[] _data = new byte[64];
    private static final byte _default_fill = -1;
    private static final int _block_size = 64;
    private static final int _blocks_per_big_block = 8;

    private SmallDocumentBlock(byte[] byArray, int n) {
        this();
        System.arraycopy(byArray, n * 64, this._data, 0, 64);
    }

    private SmallDocumentBlock() {
    }

    public static SmallDocumentBlock[] convert(byte[] byArray, int n) {
        SmallDocumentBlock[] smallDocumentBlockArray = new SmallDocumentBlock[(n + 64 - 1) / 64];
        int n2 = 0;
        for (int i = 0; i < smallDocumentBlockArray.length; ++i) {
            smallDocumentBlockArray[i] = new SmallDocumentBlock();
            if (n2 < byArray.length) {
                int n3 = Math.min(64, byArray.length - n2);
                System.arraycopy(byArray, n2, smallDocumentBlockArray[i]._data, 0, n3);
                if (n3 != 64) {
                    Arrays.fill(smallDocumentBlockArray[i]._data, n3, 64, (byte)-1);
                }
            } else {
                Arrays.fill(smallDocumentBlockArray[i]._data, (byte)-1);
            }
            n2 += 64;
        }
        return smallDocumentBlockArray;
    }

    public static int fill(List list) {
        int n;
        int n2 = (n + 8 - 1) / 8;
        int n3 = n2 * 8;
        for (n = list.size(); n < n3; ++n) {
            list.add(SmallDocumentBlock.makeEmptySmallDocumentBlock());
        }
        return n2;
    }

    public static SmallDocumentBlock[] convert(BlockWritable[] blockWritableArray, int n) throws IOException, ArrayIndexOutOfBoundsException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < blockWritableArray.length; ++i) {
            blockWritableArray[i].writeBlocks(byteArrayOutputStream);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        SmallDocumentBlock[] smallDocumentBlockArray = new SmallDocumentBlock[SmallDocumentBlock.convertToBlockCount(n)];
        for (int i = 0; i < smallDocumentBlockArray.length; ++i) {
            smallDocumentBlockArray[i] = new SmallDocumentBlock(byArray, i);
        }
        return smallDocumentBlockArray;
    }

    public static List extract(ListManagedBlock[] listManagedBlockArray) throws IOException {
        ArrayList<SmallDocumentBlock> arrayList = new ArrayList<SmallDocumentBlock>();
        for (int i = 0; i < listManagedBlockArray.length; ++i) {
            byte[] byArray = listManagedBlockArray[i].getData();
            for (int j = 0; j < 8; ++j) {
                arrayList.add(new SmallDocumentBlock(byArray, j));
            }
        }
        return arrayList;
    }

    public static void read(BlockWritable[] blockWritableArray, byte[] byArray, int n) {
        int n2 = n / 64;
        int n3 = n % 64;
        int n4 = (n + byArray.length - 1) / 64;
        if (n2 == n4) {
            System.arraycopy(((SmallDocumentBlock)blockWritableArray[n2])._data, n3, byArray, 0, byArray.length);
        } else {
            int n5 = 0;
            System.arraycopy(((SmallDocumentBlock)blockWritableArray[n2])._data, n3, byArray, n5, 64 - n3);
            n5 += 64 - n3;
            for (int i = n2 + 1; i < n4; ++i) {
                System.arraycopy(((SmallDocumentBlock)blockWritableArray[i])._data, 0, byArray, n5, 64);
                n5 += 64;
            }
            System.arraycopy(((SmallDocumentBlock)blockWritableArray[n4])._data, 0, byArray, n5, byArray.length - n5);
        }
    }

    public static int calcSize(int n) {
        return n * 64;
    }

    private static SmallDocumentBlock makeEmptySmallDocumentBlock() {
        SmallDocumentBlock smallDocumentBlock = new SmallDocumentBlock();
        Arrays.fill(smallDocumentBlock._data, (byte)-1);
        return smallDocumentBlock;
    }

    private static int convertToBlockCount(int n) {
        return (n + 64 - 1) / 64;
    }

    public void writeBlocks(OutputStream outputStream) throws IOException {
        outputStream.write(this._data);
    }

    public byte[] getData() throws IOException {
        return this._data;
    }
}

