/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.poifs.storage;

import com.fr.third.org.apache.poi.poifs.filesystem.BATManaged;
import com.fr.third.org.apache.poi.poifs.filesystem.POIFSDocument;
import com.fr.third.org.apache.poi.poifs.property.RootProperty;
import com.fr.third.org.apache.poi.poifs.storage.BlockAllocationTableWriter;
import com.fr.third.org.apache.poi.poifs.storage.BlockWritable;
import com.fr.third.org.apache.poi.poifs.storage.SmallDocumentBlock;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SmallBlockTableWriter
implements BlockWritable,
BATManaged {
    private BlockAllocationTableWriter _sbat = new BlockAllocationTableWriter();
    private List _small_blocks = new ArrayList();
    private int _big_block_count;
    private RootProperty _root;

    public SmallBlockTableWriter(List list, RootProperty rootProperty) {
        this._root = rootProperty;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            POIFSDocument pOIFSDocument = (POIFSDocument)iterator.next();
            BlockWritable[] blockWritableArray = pOIFSDocument.getSmallBlocks();
            if (blockWritableArray.length != 0) {
                pOIFSDocument.setStartBlock(this._sbat.allocateSpace(blockWritableArray.length));
                for (int i = 0; i < blockWritableArray.length; ++i) {
                    this._small_blocks.add(blockWritableArray[i]);
                }
                continue;
            }
            pOIFSDocument.setStartBlock(-2);
        }
        this._sbat.simpleCreateBlocks();
        this._root.setSize(this._small_blocks.size());
        this._big_block_count = SmallDocumentBlock.fill(this._small_blocks);
    }

    public int getSBATBlockCount() {
        return (this._big_block_count + 15) / 16;
    }

    public BlockAllocationTableWriter getSBAT() {
        return this._sbat;
    }

    public int countBlocks() {
        return this._big_block_count;
    }

    public void setStartBlock(int n) {
        this._root.setStartBlock(n);
    }

    public void writeBlocks(OutputStream outputStream) throws IOException {
        Iterator iterator = this._small_blocks.iterator();
        while (iterator.hasNext()) {
            ((BlockWritable)iterator.next()).writeBlocks(outputStream);
        }
    }
}

