/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.poifs.storage;

import com.fr.third.org.apache.poi.poifs.storage.BATBlock;
import com.fr.third.org.apache.poi.poifs.storage.BigBlock;
import com.fr.third.org.apache.poi.poifs.storage.HeaderBlockConstants;
import com.fr.third.org.apache.poi.util.IntegerField;
import com.fr.third.org.apache.poi.util.LongField;
import com.fr.third.org.apache.poi.util.ShortField;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class HeaderBlockWriter
extends BigBlock
implements HeaderBlockConstants {
    private static final byte _default_value = -1;
    private IntegerField _bat_count;
    private IntegerField _property_start;
    private IntegerField _sbat_start;
    private IntegerField _sbat_block_count;
    private IntegerField _xbat_start;
    private IntegerField _xbat_count;
    private byte[] _data = new byte[512];

    public HeaderBlockWriter() {
        Arrays.fill(this._data, (byte)-1);
        new LongField(0, -2226271756974174256L, this._data);
        new IntegerField(8, 0, this._data);
        new IntegerField(12, 0, this._data);
        new IntegerField(16, 0, this._data);
        new IntegerField(20, 0, this._data);
        new ShortField(24, 59, this._data);
        new ShortField(26, 3, this._data);
        new ShortField(28, -2, this._data);
        new ShortField(30, 9, this._data);
        new IntegerField(32, 6, this._data);
        new IntegerField(36, 0, this._data);
        new IntegerField(40, 0, this._data);
        this._bat_count = new IntegerField(44, 0, this._data);
        this._property_start = new IntegerField(48, -2, this._data);
        new IntegerField(52, 0, this._data);
        new IntegerField(56, 4096, this._data);
        this._sbat_start = new IntegerField(60, -2, this._data);
        this._sbat_block_count = new IntegerField(64, 0, this._data);
        this._xbat_start = new IntegerField(68, -2, this._data);
        this._xbat_count = new IntegerField(72, 0, this._data);
    }

    public BATBlock[] setBATBlocks(int n, int n2) {
        BATBlock[] bATBlockArray;
        int n3;
        this._bat_count.set(n, this._data);
        int n4 = Math.min(n, 109);
        int n5 = 76;
        for (n3 = 0; n3 < n4; ++n3) {
            new IntegerField(n5, n2 + n3, this._data);
            n5 += 4;
        }
        if (n > 109) {
            n3 = n - 109;
            int[] nArray = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray[i] = n2 + i + 109;
            }
            bATBlockArray = BATBlock.createXBATBlocks(nArray, n2 + n);
            this._xbat_start.set(n2 + n, this._data);
        } else {
            bATBlockArray = BATBlock.createXBATBlocks(new int[0], 0);
            this._xbat_start.set(-2, this._data);
        }
        this._xbat_count.set(bATBlockArray.length, this._data);
        return bATBlockArray;
    }

    public void setPropertyStart(int n) {
        this._property_start.set(n, this._data);
    }

    public void setSBATStart(int n) {
        this._sbat_start.set(n, this._data);
    }

    public void setSBATBlockCount(int n) {
        this._sbat_block_count.set(n, this._data);
    }

    static int calculateXBATStorageRequirements(int n) {
        return n > 109 ? BATBlock.calculateXBATStorageRequirements(n - 109) : 0;
    }

    void writeData(OutputStream outputStream) throws IOException {
        this.doWriteData(outputStream, this._data);
    }
}

