/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.poifs.storage;

import com.fr.third.org.apache.poi.poifs.common.POIFSConstants;
import com.fr.third.org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import com.fr.third.org.apache.poi.poifs.storage.HeaderBlockConstants;
import com.fr.third.org.apache.poi.util.IOUtils;
import com.fr.third.org.apache.poi.util.IntegerField;
import com.fr.third.org.apache.poi.util.LittleEndian;
import com.fr.third.org.apache.poi.util.LongField;
import java.io.IOException;
import java.io.InputStream;

public class HeaderBlockReader
implements HeaderBlockConstants {
    private int bigBlockSize = 512;
    private IntegerField _bat_count;
    private IntegerField _property_start;
    private IntegerField _sbat_start;
    private IntegerField _xbat_start;
    private IntegerField _xbat_count;
    private byte[] _data;

    public HeaderBlockReader(InputStream inputStream) throws IOException {
        LongField longField;
        byte[] byArray = new byte[32];
        int n = IOUtils.readFully(inputStream, byArray);
        if (n != 32) {
            this.alertShortRead(n);
        }
        if (byArray[30] == 12) {
            this.bigBlockSize = 4096;
        }
        this._data = new byte[this.bigBlockSize];
        System.arraycopy(byArray, 0, this._data, 0, byArray.length);
        int n2 = IOUtils.readFully(inputStream, this._data, byArray.length, this._data.length - byArray.length);
        if (n2 + n != this.bigBlockSize) {
            this.alertShortRead(n2);
        }
        if ((longField = new LongField(0, this._data)).get() != -2226271756974174256L) {
            byte[] byArray2 = POIFSConstants.OOXML_FILE_HEADER;
            if (this._data[0] == byArray2[0] && this._data[1] == byArray2[1] && this._data[2] == byArray2[2] && this._data[3] == byArray2[3]) {
                throw new OfficeXmlFileException("The supplied data appears to be in the Office 2007+ XML. POI only supports OLE2 Office documents");
            }
            throw new IOException("Invalid header signature; read " + longField.get() + ", expected " + -2226271756974174256L);
        }
        this._bat_count = new IntegerField(44, this._data);
        this._property_start = new IntegerField(48, this._data);
        this._sbat_start = new IntegerField(60, this._data);
        this._xbat_start = new IntegerField(68, this._data);
        this._xbat_count = new IntegerField(72, this._data);
    }

    private void alertShortRead(int n) throws IOException {
        if (n == -1) {
            n = 0;
        }
        String string = " byte" + (n == 1 ? "" : "s");
        throw new IOException("Unable to read entire header; " + n + string + " read; expected " + this.bigBlockSize + " bytes");
    }

    public int getPropertyStart() {
        return this._property_start.get();
    }

    public int getSBATStart() {
        return this._sbat_start.get();
    }

    public int getBATCount() {
        return this._bat_count.get();
    }

    public int[] getBATArray() {
        int[] nArray = new int[109];
        int n = 76;
        for (int i = 0; i < 109; ++i) {
            nArray[i] = LittleEndian.getInt(this._data, n);
            n += 4;
        }
        return nArray;
    }

    public int getXBATCount() {
        return this._xbat_count.get();
    }

    public int getXBATIndex() {
        return this._xbat_start.get();
    }

    public int getBigBlockSize() {
        return this.bigBlockSize;
    }
}

