/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.poifs.property;

import com.fr.third.org.apache.poi.poifs.filesystem.BATManaged;
import com.fr.third.org.apache.poi.poifs.property.DirectoryProperty;
import com.fr.third.org.apache.poi.poifs.property.Property;
import com.fr.third.org.apache.poi.poifs.property.PropertyFactory;
import com.fr.third.org.apache.poi.poifs.property.RootProperty;
import com.fr.third.org.apache.poi.poifs.storage.BlockWritable;
import com.fr.third.org.apache.poi.poifs.storage.PropertyBlock;
import com.fr.third.org.apache.poi.poifs.storage.RawDataBlockList;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class PropertyTable
implements BATManaged,
BlockWritable {
    private int _start_block = -2;
    private List _properties;
    private BlockWritable[] _blocks;

    public PropertyTable() {
        this._properties = new ArrayList();
        this.addProperty(new RootProperty());
        this._blocks = null;
    }

    public PropertyTable(int n, RawDataBlockList rawDataBlockList) throws IOException {
        this._blocks = null;
        this._properties = PropertyFactory.convertToProperties(rawDataBlockList.fetchBlocks(n));
        this.populatePropertyTree((DirectoryProperty)this._properties.get(0));
    }

    public void addProperty(Property property) {
        this._properties.add(property);
    }

    public void removeProperty(Property property) {
        this._properties.remove(property);
    }

    public RootProperty getRoot() {
        return (RootProperty)this._properties.get(0);
    }

    public void preWrite() {
        int n;
        Property[] propertyArray = this._properties.toArray(new Property[0]);
        for (n = 0; n < propertyArray.length; ++n) {
            propertyArray[n].setIndex(n);
        }
        this._blocks = PropertyBlock.createPropertyBlockArray(this._properties);
        for (n = 0; n < propertyArray.length; ++n) {
            propertyArray[n].preWrite();
        }
    }

    public int getStartBlock() {
        return this._start_block;
    }

    private void populatePropertyTree(DirectoryProperty directoryProperty) throws IOException {
        int n = directoryProperty.getChildIndex();
        if (!Property.isValidIndex(n)) {
            return;
        }
        Stack stack = new Stack();
        stack.push(this._properties.get(n));
        while (!stack.empty()) {
            Property property = (Property)stack.pop();
            directoryProperty.addChild(property);
            if (property.isDirectory()) {
                this.populatePropertyTree((DirectoryProperty)property);
            }
            if (Property.isValidIndex(n = property.getPreviousChildIndex())) {
                stack.push(this._properties.get(n));
            }
            if (!Property.isValidIndex(n = property.getNextChildIndex())) continue;
            stack.push(this._properties.get(n));
        }
    }

    public int countBlocks() {
        return this._blocks == null ? 0 : this._blocks.length;
    }

    public void setStartBlock(int n) {
        this._start_block = n;
    }

    public void writeBlocks(OutputStream outputStream) throws IOException {
        if (this._blocks != null) {
            for (int i = 0; i < this._blocks.length; ++i) {
                this._blocks[i].writeBlocks(outputStream);
            }
        }
    }
}

