/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.poifs.filesystem;

import com.fr.third.org.apache.poi.poifs.dev.POIFSViewable;
import com.fr.third.org.apache.poi.poifs.filesystem.BATManaged;
import com.fr.third.org.apache.poi.poifs.filesystem.DirectoryEntry;
import com.fr.third.org.apache.poi.poifs.filesystem.DirectoryNode;
import com.fr.third.org.apache.poi.poifs.filesystem.DocumentEntry;
import com.fr.third.org.apache.poi.poifs.filesystem.DocumentInputStream;
import com.fr.third.org.apache.poi.poifs.filesystem.DocumentNode;
import com.fr.third.org.apache.poi.poifs.filesystem.EntryNode;
import com.fr.third.org.apache.poi.poifs.filesystem.POIFSDocument;
import com.fr.third.org.apache.poi.poifs.filesystem.POIFSWriterListener;
import com.fr.third.org.apache.poi.poifs.property.DirectoryProperty;
import com.fr.third.org.apache.poi.poifs.property.Property;
import com.fr.third.org.apache.poi.poifs.property.PropertyTable;
import com.fr.third.org.apache.poi.poifs.storage.BATBlock;
import com.fr.third.org.apache.poi.poifs.storage.BlockAllocationTableReader;
import com.fr.third.org.apache.poi.poifs.storage.BlockAllocationTableWriter;
import com.fr.third.org.apache.poi.poifs.storage.BlockList;
import com.fr.third.org.apache.poi.poifs.storage.BlockWritable;
import com.fr.third.org.apache.poi.poifs.storage.HeaderBlockReader;
import com.fr.third.org.apache.poi.poifs.storage.HeaderBlockWriter;
import com.fr.third.org.apache.poi.poifs.storage.RawDataBlockList;
import com.fr.third.org.apache.poi.poifs.storage.SmallBlockTableReader;
import com.fr.third.org.apache.poi.poifs.storage.SmallBlockTableWriter;
import com.fr.third.org.apache.poi.util.IOUtils;
import com.fr.third.org.apache.poi.util.LongField;
import com.fr.third.org.apache.poi.util.POILogFactory;
import com.fr.third.org.apache.poi.util.POILogger;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class POIFSFileSystem
implements POIFSViewable {
    private static final POILogger _logger = POILogFactory.getLogger(class$com$fr$third$org$apache$poi$poifs$filesystem$POIFSFileSystem == null ? (class$com$fr$third$org$apache$poi$poifs$filesystem$POIFSFileSystem = POIFSFileSystem.class$("com.fr.third.org.apache.poi.poifs.filesystem.POIFSFileSystem")) : class$com$fr$third$org$apache$poi$poifs$filesystem$POIFSFileSystem);
    private PropertyTable _property_table = new PropertyTable();
    private List _documents = new ArrayList();
    private DirectoryNode _root = null;
    private int bigBlockSize = 512;
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$poifs$filesystem$POIFSFileSystem;

    public static InputStream createNonClosingInputStream(InputStream inputStream) {
        return new CloseIgnoringInputStream(inputStream);
    }

    public POIFSFileSystem() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POIFSFileSystem(InputStream inputStream) throws IOException {
        this();
        RawDataBlockList rawDataBlockList;
        HeaderBlockReader headerBlockReader;
        boolean bl = false;
        try {
            headerBlockReader = new HeaderBlockReader(inputStream);
            this.bigBlockSize = headerBlockReader.getBigBlockSize();
            rawDataBlockList = new RawDataBlockList(inputStream, this.bigBlockSize);
            bl = true;
        }
        finally {
            this.closeInputStream(inputStream, bl);
        }
        new BlockAllocationTableReader(headerBlockReader.getBATCount(), headerBlockReader.getBATArray(), headerBlockReader.getXBATCount(), headerBlockReader.getXBATIndex(), rawDataBlockList);
        PropertyTable propertyTable = new PropertyTable(headerBlockReader.getPropertyStart(), rawDataBlockList);
        this.processProperties(SmallBlockTableReader.getSmallDocumentBlocks(rawDataBlockList, propertyTable.getRoot(), headerBlockReader.getSBATStart()), rawDataBlockList, propertyTable.getRoot().getChildren(), null);
    }

    private void closeInputStream(InputStream inputStream, boolean bl) {
        if (inputStream.markSupported() && !(inputStream instanceof ByteArrayInputStream)) {
            String string = "POIFS is closing the supplied input stream of type (" + inputStream.getClass().getName() + ") which supports mark/reset.  " + "This will be a problem for the caller if the stream will still be used.  " + "If that is the case the caller should wrap the input stream to avoid this close logic.  " + "This warning is only temporary and will not be present in future versions of POI.";
            _logger.log(5, string);
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            if (bl) {
                throw new RuntimeException(iOException);
            }
            iOException.printStackTrace();
        }
    }

    public static boolean hasPOIFSHeader(InputStream inputStream) throws IOException {
        inputStream.mark(8);
        byte[] byArray = new byte[8];
        IOUtils.readFully(inputStream, byArray);
        LongField longField = new LongField(0, byArray);
        if (inputStream instanceof PushbackInputStream) {
            PushbackInputStream pushbackInputStream = (PushbackInputStream)inputStream;
            pushbackInputStream.unread(byArray);
        } else {
            inputStream.reset();
        }
        return longField.get() == -2226271756974174256L;
    }

    public DocumentEntry createDocument(InputStream inputStream, String string) throws IOException {
        return this.getRoot().createDocument(string, inputStream);
    }

    public DocumentEntry createDocument(String string, int n, POIFSWriterListener pOIFSWriterListener) throws IOException {
        return this.getRoot().createDocument(string, n, pOIFSWriterListener);
    }

    public DirectoryEntry createDirectory(String string) throws IOException {
        return this.getRoot().createDirectory(string);
    }

    public void writeFilesystem(OutputStream outputStream) throws IOException {
        this._property_table.preWrite();
        SmallBlockTableWriter smallBlockTableWriter = new SmallBlockTableWriter(this._documents, this._property_table.getRoot());
        BlockAllocationTableWriter blockAllocationTableWriter = new BlockAllocationTableWriter();
        ArrayList<BATManaged> arrayList = new ArrayList<BATManaged>();
        arrayList.addAll(this._documents);
        arrayList.add(this._property_table);
        arrayList.add(smallBlockTableWriter);
        arrayList.add(smallBlockTableWriter.getSBAT());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            BATManaged bATManaged = (BATManaged)iterator.next();
            int n = bATManaged.countBlocks();
            if (n == 0) continue;
            bATManaged.setStartBlock(blockAllocationTableWriter.allocateSpace(n));
        }
        int n = blockAllocationTableWriter.createBlocks();
        HeaderBlockWriter headerBlockWriter = new HeaderBlockWriter();
        BATBlock[] bATBlockArray = headerBlockWriter.setBATBlocks(blockAllocationTableWriter.countBlocks(), n);
        headerBlockWriter.setPropertyStart(this._property_table.getStartBlock());
        headerBlockWriter.setSBATStart(smallBlockTableWriter.getSBAT().getStartBlock());
        headerBlockWriter.setSBATBlockCount(smallBlockTableWriter.getSBATBlockCount());
        ArrayList<BlockWritable> arrayList2 = new ArrayList<BlockWritable>();
        arrayList2.add(headerBlockWriter);
        arrayList2.addAll(this._documents);
        arrayList2.add(this._property_table);
        arrayList2.add(smallBlockTableWriter);
        arrayList2.add(smallBlockTableWriter.getSBAT());
        arrayList2.add(blockAllocationTableWriter);
        for (int i = 0; i < bATBlockArray.length; ++i) {
            arrayList2.add(bATBlockArray[i]);
        }
        iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            BlockWritable blockWritable = (BlockWritable)iterator.next();
            blockWritable.writeBlocks(outputStream);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 2) {
            System.err.println("two arguments required: input filename and output filename");
            System.exit(1);
        }
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1]);
        new POIFSFileSystem(fileInputStream).writeFilesystem(fileOutputStream);
        fileInputStream.close();
        fileOutputStream.close();
    }

    public DirectoryNode getRoot() {
        if (this._root == null) {
            this._root = new DirectoryNode(this._property_table.getRoot(), this, null);
        }
        return this._root;
    }

    public DocumentInputStream createDocumentInputStream(String string) throws IOException {
        return this.getRoot().createDocumentInputStream(string);
    }

    void addDocument(POIFSDocument pOIFSDocument) {
        this._documents.add(pOIFSDocument);
        this._property_table.addProperty(pOIFSDocument.getDocumentProperty());
    }

    void addDirectory(DirectoryProperty directoryProperty) {
        this._property_table.addProperty(directoryProperty);
    }

    void remove(EntryNode entryNode) {
        this._property_table.removeProperty(entryNode.getProperty());
        if (entryNode.isDocumentEntry()) {
            this._documents.remove(((DocumentNode)entryNode).getDocument());
        }
    }

    private void processProperties(BlockList blockList, BlockList blockList2, Iterator iterator, DirectoryNode directoryNode) throws IOException {
        while (iterator.hasNext()) {
            DirectoryNode directoryNode2;
            Property property = (Property)iterator.next();
            String string = property.getName();
            DirectoryNode directoryNode3 = directoryNode2 = directoryNode == null ? this.getRoot() : directoryNode;
            if (property.isDirectory()) {
                DirectoryNode directoryNode4 = (DirectoryNode)directoryNode2.createDirectory(string);
                directoryNode4.setStorageClsid(property.getStorageClsid());
                this.processProperties(blockList, blockList2, ((DirectoryProperty)property).getChildren(), directoryNode4);
                continue;
            }
            int n = property.getStartBlock();
            int n2 = property.getSize();
            POIFSDocument pOIFSDocument = null;
            pOIFSDocument = property.shouldUseSmallBlocks() ? new POIFSDocument(string, blockList.fetchBlocks(n), n2) : new POIFSDocument(string, blockList2.fetchBlocks(n), n2);
            directoryNode2.createDocument(pOIFSDocument);
        }
    }

    public Object[] getViewableArray() {
        if (this.preferArray()) {
            return this.getRoot().getViewableArray();
        }
        return new Object[0];
    }

    public Iterator getViewableIterator() {
        if (!this.preferArray()) {
            return this.getRoot().getViewableIterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public boolean preferArray() {
        return this.getRoot().preferArray();
    }

    public String getShortDescription() {
        return "POIFS FileSystem";
    }

    public int getBigBlockSize() {
        return this.bigBlockSize;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class CloseIgnoringInputStream
    extends InputStream {
        private final InputStream _is;

        public CloseIgnoringInputStream(InputStream inputStream) {
            this._is = inputStream;
        }

        public int read() throws IOException {
            return this._is.read();
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this._is.read(byArray, n, n2);
        }

        public void close() {
        }
    }
}

