/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.poifs.filesystem;

import com.fr.third.org.apache.poi.poifs.filesystem.DirectoryEntry;
import com.fr.third.org.apache.poi.poifs.filesystem.DirectoryNode;
import com.fr.third.org.apache.poi.poifs.filesystem.Entry;
import com.fr.third.org.apache.poi.poifs.property.Property;

public abstract class EntryNode
implements Entry {
    private Property _property;
    private DirectoryNode _parent;

    protected EntryNode(Property property, DirectoryNode directoryNode) {
        this._property = property;
        this._parent = directoryNode;
    }

    protected Property getProperty() {
        return this._property;
    }

    protected boolean isRoot() {
        return this._parent == null;
    }

    protected abstract boolean isDeleteOK();

    public String getName() {
        return this._property.getName();
    }

    public boolean isDirectoryEntry() {
        return false;
    }

    public boolean isDocumentEntry() {
        return false;
    }

    public DirectoryEntry getParent() {
        return this._parent;
    }

    public boolean delete() {
        boolean bl = false;
        if (!this.isRoot() && this.isDeleteOK()) {
            bl = this._parent.deleteEntry(this);
        }
        return bl;
    }

    public boolean renameTo(String string) {
        boolean bl = false;
        if (!this.isRoot()) {
            bl = this._parent.changeName(this.getName(), string);
        }
        return bl;
    }
}

