/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.poifs.filesystem;

import com.fr.third.org.apache.poi.poifs.filesystem.DocumentEntry;
import com.fr.third.org.apache.poi.poifs.filesystem.DocumentNode;
import com.fr.third.org.apache.poi.poifs.filesystem.POIFSDocument;
import java.io.IOException;
import java.io.InputStream;

public class DocumentInputStream
extends InputStream {
    private int _current_offset = 0;
    private int _marked_offset = 0;
    private int _document_size;
    private boolean _closed;
    private POIFSDocument _document;
    private byte[] _tiny_buffer;
    private static final int EOD = -1;

    public DocumentInputStream(DocumentEntry documentEntry) throws IOException {
        this._document_size = documentEntry.getSize();
        this._closed = false;
        this._tiny_buffer = null;
        if (!(documentEntry instanceof DocumentNode)) {
            throw new IOException("Cannot open internal document storage");
        }
        this._document = ((DocumentNode)documentEntry).getDocument();
    }

    public DocumentInputStream(POIFSDocument pOIFSDocument) throws IOException {
        this._document_size = pOIFSDocument.getSize();
        this._closed = false;
        this._tiny_buffer = null;
        this._document = pOIFSDocument;
    }

    public int available() throws IOException {
        this.dieIfClosed();
        return this._document_size - this._current_offset;
    }

    public void close() throws IOException {
        this._closed = true;
    }

    public void mark(int n) {
        this._marked_offset = this._current_offset;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        this.dieIfClosed();
        if (this.atEOD()) {
            return -1;
        }
        if (this._tiny_buffer == null) {
            this._tiny_buffer = new byte[1];
        }
        this._document.read(this._tiny_buffer, this._current_offset++);
        return this._tiny_buffer[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException, NullPointerException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException, NullPointerException, IndexOutOfBoundsException {
        this.dieIfClosed();
        if (byArray == null) {
            throw new NullPointerException("buffer is null");
        }
        if (n < 0 || n2 < 0 || byArray.length < n + n2) {
            throw new IndexOutOfBoundsException("can't read past buffer boundaries");
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.atEOD()) {
            return -1;
        }
        int n3 = Math.min(this.available(), n2);
        if (n == 0 && n3 == byArray.length) {
            this._document.read(byArray, this._current_offset);
        } else {
            byte[] byArray2 = new byte[n3];
            this._document.read(byArray2, this._current_offset);
            System.arraycopy(byArray2, 0, byArray, n, n3);
        }
        this._current_offset += n3;
        return n3;
    }

    public void reset() {
        this._current_offset = this._marked_offset;
    }

    public long skip(long l) throws IOException {
        this.dieIfClosed();
        if (l < 0L) {
            return 0L;
        }
        int n = this._current_offset + (int)l;
        if (n < this._current_offset) {
            n = this._document_size;
        } else if (n > this._document_size) {
            n = this._document_size;
        }
        long l2 = n - this._current_offset;
        this._current_offset = n;
        return l2;
    }

    private void dieIfClosed() throws IOException {
        if (this._closed) {
            throw new IOException("cannot perform requested operation on a closed stream");
        }
    }

    private boolean atEOD() {
        return this._current_offset == this._document_size;
    }
}

