/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.poifs.filesystem;

import com.fr.third.org.apache.poi.hpsf.ClassID;
import com.fr.third.org.apache.poi.poifs.dev.POIFSViewable;
import com.fr.third.org.apache.poi.poifs.filesystem.DirectoryEntry;
import com.fr.third.org.apache.poi.poifs.filesystem.DocumentEntry;
import com.fr.third.org.apache.poi.poifs.filesystem.DocumentInputStream;
import com.fr.third.org.apache.poi.poifs.filesystem.DocumentNode;
import com.fr.third.org.apache.poi.poifs.filesystem.Entry;
import com.fr.third.org.apache.poi.poifs.filesystem.EntryNode;
import com.fr.third.org.apache.poi.poifs.filesystem.POIFSDocument;
import com.fr.third.org.apache.poi.poifs.filesystem.POIFSDocumentPath;
import com.fr.third.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import com.fr.third.org.apache.poi.poifs.filesystem.POIFSWriterListener;
import com.fr.third.org.apache.poi.poifs.property.DirectoryProperty;
import com.fr.third.org.apache.poi.poifs.property.DocumentProperty;
import com.fr.third.org.apache.poi.poifs.property.Property;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class DirectoryNode
extends EntryNode
implements DirectoryEntry,
POIFSViewable {
    private Map _entries;
    private POIFSFileSystem _filesystem;
    private POIFSDocumentPath _path;

    DirectoryNode(DirectoryProperty directoryProperty, POIFSFileSystem pOIFSFileSystem, DirectoryNode directoryNode) {
        super(directoryProperty, directoryNode);
        this._path = directoryNode == null ? new POIFSDocumentPath() : new POIFSDocumentPath(directoryNode._path, new String[]{directoryProperty.getName()});
        this._filesystem = pOIFSFileSystem;
        this._entries = new HashMap();
        Iterator iterator = directoryProperty.getChildren();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            EntryNode entryNode = null;
            entryNode = property.isDirectory() ? new DirectoryNode((DirectoryProperty)property, this._filesystem, this) : new DocumentNode((DocumentProperty)property, this);
            this._entries.put(entryNode.getName(), entryNode);
        }
    }

    public POIFSDocumentPath getPath() {
        return this._path;
    }

    public DocumentInputStream createDocumentInputStream(String string) throws IOException {
        Entry entry = this.getEntry(string);
        if (!entry.isDocumentEntry()) {
            throw new IOException("Entry '" + string + "' is not a DocumentEntry");
        }
        return new DocumentInputStream((DocumentEntry)entry);
    }

    DocumentEntry createDocument(POIFSDocument pOIFSDocument) throws IOException {
        DocumentProperty documentProperty = pOIFSDocument.getDocumentProperty();
        DocumentNode documentNode = new DocumentNode(documentProperty, this);
        ((DirectoryProperty)this.getProperty()).addChild(documentProperty);
        this._filesystem.addDocument(pOIFSDocument);
        this._entries.put(documentProperty.getName(), documentNode);
        return documentNode;
    }

    boolean changeName(String string, String string2) {
        boolean bl = false;
        EntryNode entryNode = (EntryNode)this._entries.get(string);
        if (entryNode != null && (bl = ((DirectoryProperty)this.getProperty()).changeName(entryNode.getProperty(), string2))) {
            this._entries.remove(string);
            this._entries.put(entryNode.getProperty().getName(), entryNode);
        }
        return bl;
    }

    boolean deleteEntry(EntryNode entryNode) {
        boolean bl = ((DirectoryProperty)this.getProperty()).deleteChild(entryNode.getProperty());
        if (bl) {
            this._entries.remove(entryNode.getName());
            this._filesystem.remove(entryNode);
        }
        return bl;
    }

    public Iterator getEntries() {
        return this._entries.values().iterator();
    }

    public boolean isEmpty() {
        return this._entries.isEmpty();
    }

    public int getEntryCount() {
        return this._entries.size();
    }

    public Entry getEntry(String string) throws FileNotFoundException {
        Entry entry = null;
        if (string != null) {
            entry = (Entry)this._entries.get(string);
        }
        if (entry == null) {
            throw new FileNotFoundException("no such entry: \"" + string + "\"");
        }
        return entry;
    }

    public DocumentEntry createDocument(String string, InputStream inputStream) throws IOException {
        return this.createDocument(new POIFSDocument(string, inputStream));
    }

    public DocumentEntry createDocument(String string, int n, POIFSWriterListener pOIFSWriterListener) throws IOException {
        return this.createDocument(new POIFSDocument(string, n, this._path, pOIFSWriterListener));
    }

    public DirectoryEntry createDirectory(String string) throws IOException {
        DirectoryProperty directoryProperty = new DirectoryProperty(string);
        DirectoryNode directoryNode = new DirectoryNode(directoryProperty, this._filesystem, this);
        ((DirectoryProperty)this.getProperty()).addChild(directoryProperty);
        this._filesystem.addDirectory(directoryProperty);
        this._entries.put(string, directoryNode);
        return directoryNode;
    }

    public ClassID getStorageClsid() {
        return this.getProperty().getStorageClsid();
    }

    public void setStorageClsid(ClassID classID) {
        this.getProperty().setStorageClsid(classID);
    }

    public boolean isDirectoryEntry() {
        return true;
    }

    protected boolean isDeleteOK() {
        return this.isEmpty();
    }

    public Object[] getViewableArray() {
        return new Object[0];
    }

    public Iterator getViewableIterator() {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        arrayList.add(this.getProperty());
        TreeMap treeMap = new TreeMap(this._entries);
        Iterator iterator = treeMap.values().iterator();
        while (iterator.hasNext()) {
            arrayList.add((Property)iterator.next());
        }
        return arrayList.iterator();
    }

    public boolean preferArray() {
        return false;
    }

    public String getShortDescription() {
        return this.getName();
    }
}

